/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.util.DN;

public final class RDN
implements Serializable {
    static final long serialVersionUID = 7895454691174650321L;
    private String[] m_type = null;
    private String[] m_value = null;
    private boolean m_ismultivalued = false;
    private static Hashtable m_attributehash = new Hashtable();
    public static final String[] _cesAttributes = new String[]{"adminurl", "altserver", "automountinformation", "bootfile", "bootparameter", "cirbindcredentials", "generation", "homedirectory", "internationalisdnnumber", "labeleduri", "membercertificatedescription", "membernisnetgroup", "memberuid", "memberurl", "nismapentry", "nisnetgrouptriple", "nsaddressbooksyncurl", "presentationaddress", "ref", "replicaentryfilter", "searchguide", "subtreeaci", "vlvfilter", "vlvname", "x121address"};
    public static final String CES_SYNTAX = "1.3.6.1.4.1.1466.115.121.1.26";

    static {
        int n = 0;
        while (n < _cesAttributes.length) {
            RDN.registerAttributeSyntax(_cesAttributes[n], CES_SYNTAX);
            ++n;
        }
    }

    public RDN(String string) {
        String string2 = RDN.neutralizeEscapes(string);
        if (string2 == null) {
            return;
        }
        int n = string2.indexOf("=");
        if (n <= 0) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(string.substring(0, n).trim());
        int n2 = string2.indexOf(43, n);
        while (n2 != -1) {
            this.m_ismultivalued = true;
            vector.addElement(string.substring(n + 1, n2).trim());
            n = string2.indexOf("=", n2 + 1);
            if (n == -1) {
                return;
            }
            vector2.addElement(string.substring(n2 + 1, n).trim());
            n2 = string2.indexOf(43, n);
        }
        vector.addElement(string.substring(n + 1).trim());
        this.m_type = new String[vector2.size()];
        this.m_value = new String[vector.size()];
        int n3 = 0;
        while (n3 < vector2.size()) {
            this.m_type[n3] = (String)vector2.elementAt(n3);
            if (!this.isValidType(this.m_type[n3])) {
                this.m_value = null;
                this.m_type = null;
                return;
            }
            this.m_value[n3] = (String)vector.elementAt(n3);
            if (!this.isValidValue(this.m_value[n3])) {
                this.m_value = null;
                this.m_type = null;
                return;
            }
            ++n3;
        }
    }

    public boolean equals(RDN rDN) {
        String[] stringArray = (String[])this.getTypes().clone();
        String[] stringArray2 = (String[])this.getValues().clone();
        String[] stringArray3 = (String[])rDN.getTypes().clone();
        String[] stringArray4 = (String[])rDN.getValues().clone();
        if (stringArray.length != stringArray3.length) {
            return false;
        }
        this.sortTypesAndValues(stringArray, stringArray2);
        this.sortTypesAndValues(stringArray3, stringArray4);
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equalsIgnoreCase(stringArray3[n])) {
                return false;
            }
            if (CES_SYNTAX.equals(RDN.getAttributeSyntax(stringArray[n])) ? !stringArray2[n].equals(stringArray4[n]) : !stringArray2[n].equalsIgnoreCase(stringArray4[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String[] explodeRDN(boolean bl) {
        if (this.m_type == null) {
            return null;
        }
        String[] stringArray = new String[]{bl ? this.getValue() : this.toString()};
        return stringArray;
    }

    public static String getAttributeSyntax(String string) {
        return (String)m_attributehash.get(string.toLowerCase());
    }

    public static String[] getAttributesForSyntax(String string) {
        Enumeration enumeration = m_attributehash.keys();
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string.equals((String)m_attributehash.get(string2))) continue;
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = new String((String)vector.elementAt(n));
            ++n;
        }
        return stringArray;
    }

    public String getType() {
        if (this.m_type != null && this.m_type.length > 0) {
            return this.m_type[0];
        }
        return null;
    }

    public String[] getTypes() {
        return this.m_type;
    }

    public String getValue() {
        if (this.m_value != null && this.m_value.length > 0) {
            return this.m_value[0];
        }
        return null;
    }

    public String[] getValues() {
        return this.m_value;
    }

    public boolean isMultivalued() {
        return this.m_ismultivalued;
    }

    public static boolean isRDN(String string) {
        RDN rDN = new RDN(string);
        return rDN.getTypes() != null && rDN.getValues() != null;
    }

    private boolean isValidType(String string) {
        if (string == null || string.length() < 1) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            int n2 = 0;
            while (n2 < DN.ESCAPED_CHAR.length) {
                if (string.charAt(n) == DN.ESCAPED_CHAR[n2]) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    private boolean isValidValue(String string) {
        if (string == null || string.length() < 1) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n2 >= 0 && n2 < string.length()) {
            if ((n2 = string.indexOf(34, n2)) < 0) continue;
            if (n2 == 0 || string.charAt(n2 - 1) != '\\') {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return true;
        }
        if (n != 2) {
            return false;
        }
        return string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"';
    }

    static String neutralizeEscapes(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '\\') {
                stringBuffer.setCharAt(n, 'x');
                if (n < stringBuffer.length() - 1) {
                    stringBuffer.setCharAt(n + 1, 'x');
                } else {
                    return null;
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == '\"') {
                bl ^= true;
            } else if (bl) {
                stringBuffer.setCharAt(n2, 'x');
            }
            ++n2;
        }
        return bl ? null : stringBuffer.toString();
    }

    public static void registerAttributeSyntax(String string, String string2) {
        m_attributehash.put(string.toLowerCase(), string2);
    }

    void sortTypesAndValues(String[] stringArray, String[] stringArray2) {
        do {
            boolean bl = true;
            int n = 0;
            while (n < stringArray.length - 1) {
                if (stringArray[n].toLowerCase().compareTo(stringArray[n + 1].toLowerCase()) > 0) {
                    String string = stringArray[n];
                    String string2 = stringArray2[n];
                    stringArray[n] = stringArray[n + 1];
                    stringArray2[n] = stringArray2[n + 1];
                    stringArray[n + 1] = string;
                    stringArray2[n + 1] = string2;
                    bl = false;
                }
                ++n;
            }
            bl = false;
        } while (false);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (this.m_type != null && n < this.m_type.length) {
            if (n != 0) {
                stringBuffer.append(" + ");
            }
            stringBuffer.append(String.valueOf(this.m_type[n]) + "=" + this.m_value[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void unregisterAttributeSyntax(String string) {
        m_attributehash.remove(string.toLowerCase());
    }
}

