/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.session;

import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.util.Properties;

public final class SessionReaper
extends Thread {
    private int _reapInterval = 600;
    private IWSHttpSessionManager _sessionMgr;
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private volatile boolean _done;

    public SessionReaper(Properties properties, IWSHttpSessionManager iWSHttpSessionManager) {
        String string;
        if (properties != null && (string = properties.getProperty("reapInterval")) != null) {
            try {
                this._reapInterval = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this._sessionMgr = iWSHttpSessionManager;
        this._done = false;
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("Starting reaper for " + this._sessionMgr));
        }
        this.start();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (!this._done) {
            try {
                Thread.sleep(this._reapInterval * 1000);
                IWSHttpSessionManager iWSHttpSessionManager = this._sessionMgr;
                synchronized (iWSHttpSessionManager) {
                    try {
                        this._sessionMgr.reaper();
                    }
                    catch (Exception exception) {
                        LogUtil.logWarning((String)_res.getProp("session.SessionReaper.msg_reaperException", (Object)exception));
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void shutdown() {
        if (this._done) {
            return;
        }
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("Stopping reaper for " + this._sessionMgr));
        }
        this._done = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {}
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("Stopped reaper for " + this._sessionMgr));
        }
    }
}

