/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.session;

import com.iplanet.server.http.session.IWSHttpSessionInputStream;
import com.iplanet.server.http.session.MMapSessionManager;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public class MMapSession
implements HttpSession {
    private static final String MMAPSESSION_BLOB_NAME = "httpsession";
    private String _id = null;
    private byte[] _idBytes = null;
    private boolean _isValid = true;
    private boolean _newSession = false;
    private MMapSessionManager _mgr = null;
    private int _numObjectsToBeUnbound = 0;
    private long _nativeMgr = 0L;
    private Hashtable _values;
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private ServletContext _context = null;
    private long _location = -1L;
    private long _lastAccessedTime;
    private long _maxInactiveInterval;
    private long _creationTime;
    private boolean _inUse = true;
    private boolean _timingOut = false;

    public MMapSession(String string, int n, MMapSessionManager mMapSessionManager, ServletContext servletContext) throws NullPointerException {
        this(string, n, mMapSessionManager, servletContext, true);
    }

    public MMapSession(String string, int n, MMapSessionManager mMapSessionManager, ServletContext servletContext, boolean bl) throws NullPointerException {
        this._id = string;
        this._idBytes = this._id.getBytes();
        this._mgr = mMapSessionManager;
        this._nativeMgr = this._mgr.getNativePtr();
        this._context = servletContext;
        this.setMaxInactiveInterval(n);
        this._location = bl ? this._createSession(this._nativeMgr, this._idBytes, n) : this._getSession(this._nativeMgr, this._idBytes);
        if (this._location == -1L) {
            this._isValid = false;
            throw new NullPointerException();
        }
        if (bl) {
            this._values = new Hashtable();
            this._newSession = true;
        }
    }

    private native long _createSession(long var1, byte[] var3, int var4);

    private native long _getSession(long var1, byte[] var3);

    private boolean _isInvalid() {
        return this.isInvalid(System.currentTimeMillis());
    }

    private native byte[] _loadSessionData(long var1, byte[] var3, long var4);

    private native boolean _saveSessionData(long var1, byte[] var3, byte[] var4, long var5, long var7);

    public Object getAttribute(String string) {
        return this.getValue(string);
    }

    public Enumeration getAttributeNames() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._values.keys();
    }

    public long getCreationTime() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._creationTime * 1000L;
    }

    public String getId() {
        return this._id;
    }

    protected String getIdWithoutExceptions() {
        return this._id;
    }

    public long getLastAccessedTime() {
        return this._lastAccessedTime * 1000L;
    }

    public final long getLocation() {
        return this._location;
    }

    public int getMaxInactiveInterval() {
        int n = (int)this._maxInactiveInterval;
        if (n == Integer.MAX_VALUE) {
            n = -1;
        }
        return n;
    }

    public final ServletContext getServletContext() {
        return this._context;
    }

    public HttpSessionContext getSessionContext() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._mgr.getContext();
    }

    public Object getValue(String string) {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        if (string == null) {
            throw new NullPointerException(_res.getProp("session.MMapSession.msg_namevalueNull"));
        }
        return this._values.get(string);
    }

    public String[] getValueNames() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        String[] stringArray = null;
        Hashtable hashtable = this._values;
        synchronized (hashtable) {
            stringArray = new String[this._values.size()];
            int n = 0;
            Enumeration enumeration = this._values.keys();
            while (enumeration.hasMoreElements()) {
                stringArray[n] = (String)enumeration.nextElement();
                ++n;
            }
        }
        return stringArray;
    }

    public void invalidate() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        this._mgr.deleteSession(this);
    }

    public final boolean isInUse() {
        return this._inUse;
    }

    public boolean isInvalid(long l) {
        if (!this._isValid) {
            return true;
        }
        long l2 = l / 1000L - this._lastAccessedTime;
        if (l2 >= this._maxInactiveInterval) {
            this._isValid = false;
            this._timingOut = true;
            return true;
        }
        return false;
    }

    public boolean isNew() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._newSession;
    }

    public void loadSessionData() throws IllegalStateException {
        Object object = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        byte[] byArray = this._loadSessionData(this._nativeMgr, this._idBytes, this._location);
        if (byArray != null && byArray.length > 0) {
            try {
                try {
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    if (this._context != null) {
                        ClassLoader classLoader = (ClassLoader)this._context.getAttribute("com.iplanet.server.http.servlet.classloader");
                        objectInputStream = new IWSHttpSessionInputStream(byteArrayInputStream, classLoader);
                    } else {
                        objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    }
                    object = objectInputStream.readObject();
                }
                catch (Exception exception) {
                    object = null;
                    LogUtil.logWarning((String)_res.getProp("session.MMapSession.msg_unable2Retrieve", (Object)exception));
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                        objectInputStream = null;
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                        byteArrayInputStream = null;
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                    objectInputStream = null;
                }
            }
            catch (IOException iOException) {}
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                    byteArrayInputStream = null;
                }
            }
            catch (IOException iOException) {}
        }
        if (this._isValid) {
            if (this._values != null) {
                this._values.clear();
            }
            this._newSession = false;
            this._inUse = true;
            this._values = object != null ? (Hashtable)object : new Hashtable();
        } else {
            LogUtil.TRACE((int)5, (String)("loadSessionData: failed to load " + this._id));
            throw new IllegalStateException();
        }
    }

    public void putValue(String string, Object object) {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        if (string == null || object == null) {
            throw new NullPointerException(_res.getProp("session.MMapSession.msg_namevalueNull"));
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException(_res.getProp("session.MMapSession.msg_badAttribute", (Object)string));
        }
        this._values.put(string, object);
        if (object instanceof HttpSessionBindingListener) {
            ++this._numObjectsToBeUnbound;
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)object;
            httpSessionBindingListener.valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    protected synchronized void removeAllObjects() {
        if (this._values == null) {
            return;
        }
        if (this._numObjectsToBeUnbound > 0) {
            Enumeration enumeration = this._values.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = this._values.get(string);
                if (v == null) continue;
                try {
                    this.unbindObject(string, v);
                }
                catch (Exception exception) {
                    LogUtil.logWarning((String)_res.getProp("session.IWSHttpSession.msg_UnbindError", (Object)string, (Object)LogUtil.getStackTrace((Throwable)exception)));
                }
                if (this._numObjectsToBeUnbound == 0) break;
            }
        }
        this._values.clear();
        this._values = null;
    }

    public void removeAttribute(String string) {
        this.removeValue(string);
    }

    public void removeValue(String string) {
        if (this._isInvalid() && !this._timingOut) {
            throw new IllegalStateException();
        }
        if (string == null) {
            throw new NullPointerException(_res.getProp("session.MMapSession.msg_namevalueNull"));
        }
        Object v = this._values.remove(string);
        if (v instanceof HttpSessionBindingListener) {
            --this._numObjectsToBeUnbound;
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)v;
            httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public void saveSessionData() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        byte[] byArray = null;
        Exception exception = null;
        try {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this._values);
                objectOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                    objectOutputStream = null;
                }
            }
            catch (IOException iOException) {}
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (objectOutputStream != null) {
                objectOutputStream.close();
                objectOutputStream = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
            }
        }
        catch (IOException iOException) {}
        if (byArray != null && !this._saveSessionData(this._nativeMgr, this._idBytes, byArray, this._location, this._maxInactiveInterval)) {
            exception = new IOException("_saveSessionData");
        }
        if (exception != null) {
            LogUtil.logWarning((String)_res.getProp("session.MMapSession.msg_unable2Store", (Object)exception));
            throw exception;
        }
        this._inUse = false;
    }

    public void setAttribute(String string, Object object) {
        this.putValue(string, object);
    }

    public void setMaxInactiveInterval(int n) {
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        this._maxInactiveInterval = n;
    }

    private void unbindObject(String string, Object object) {
        if (object instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)object;
            httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
            --this._numObjectsToBeUnbound;
        }
    }
}

