/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.session;

import com.iplanet.server.http.session.IWSHttpSession;
import com.iplanet.server.http.session.IWSHttpSessionInputStream;
import com.iplanet.server.http.session.SessionDataStore;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import com.iplanet.server.http.util.misc.ResourcePool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.servlet.ServletContext;

public class JdbcStore
extends SessionDataStore {
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private Connection _connection;
    private static final String prop_jdbcDriver = "provider";
    private static final String prop_jdbcUrl = "url";
    private static final String prop_tableName = "table";
    private static final String prop_username = "username";
    private static final String prop_password = "password";
    private static final String prop_reaperActive = "reaperActive";
    private static final String prop_lookupPool = "lookupPool";
    private static final String prop_insertPool = "insertPool";
    private static final String prop_updatePool = "updatePool";
    private static final String prop_deletePool = "deletePool";
    private int _lookupPoolSize = 4;
    private int _insertPoolSize = 4;
    private int _updatePoolSize = 4;
    private int _deletePoolSize = 2;
    private String _username = null;
    private String _password = null;
    private String _jdbcDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
    private String _jdbcUrl = "jdbc:odbc:LocalServer";
    private StatementsPool _stmt_lookup;
    private StatementsPool _stmt_insert;
    private StatementsPool _stmt_update;
    private StatementsPool _stmt_delete;
    private PreparedStatement _stmt_reaper;
    private String _table = "sessions";
    private String _accessTimeCol = "AccessTime";
    private String _timeOutCol = "TimeOut";
    private String _sessionIdCol = "SessionID";
    private String _valueCol = "Value";
    private boolean _initialized = false;
    private boolean _reaper_active = true;

    public boolean init(Properties properties) {
        if (properties != null) {
            int n;
            String string = properties.getProperty(prop_lookupPool);
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n < 1 || n > 100) {
                        LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_poolNotValid", (Object)prop_lookupPool));
                    } else {
                        this._lookupPoolSize = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_poolNotValid", (Object)prop_lookupPool));
                }
            }
            if ((string = properties.getProperty(prop_updatePool)) != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n < 1 || n > 100) {
                        LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_poolNotValid", (Object)prop_updatePool));
                    } else {
                        this._updatePoolSize = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_poolNotValid", (Object)prop_updatePool));
                }
            }
            if ((string = properties.getProperty(prop_insertPool)) != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n < 1 || n > 100) {
                        LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_poolNotValid", (Object)prop_insertPool));
                    } else {
                        this._insertPoolSize = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_poolNotValid", (Object)prop_insertPool));
                }
            }
            if ((string = properties.getProperty(prop_deletePool)) != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n < 1 || n > 100) {
                        LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_poolNotValid", (Object)prop_deletePool));
                    } else {
                        this._deletePoolSize = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_poolNotValid", (Object)prop_deletePool));
                }
            }
            if ((string = properties.getProperty(prop_jdbcDriver)) != null) {
                this._jdbcDriver = string;
            }
            if ((string = properties.getProperty(prop_jdbcUrl)) != null) {
                this._jdbcUrl = string;
            }
            this._username = properties.getProperty(prop_username);
            this._password = properties.getProperty(prop_password);
            string = properties.getProperty(prop_tableName);
            if (string != null) {
                this._table = string;
            }
            if ((string = properties.getProperty("accessTimeColumn")) != null) {
                this._accessTimeCol = string;
            }
            if ((string = properties.getProperty("timeOutColumn")) != null) {
                this._timeOutCol = string;
            }
            if ((string = properties.getProperty("sessionIdColumn")) != null) {
                this._sessionIdCol = string;
            }
            if ((string = properties.getProperty("valueColumn")) != null) {
                this._valueCol = string;
            }
            if ((string = properties.getProperty(prop_reaperActive)) != null) {
                this._reaper_active = Boolean.valueOf(string);
            }
        }
        try {
            Class.forName(this._jdbcDriver);
            this._connection = DriverManager.getConnection(this._jdbcUrl, this._username, this._password);
            this._connection.setAutoCommit(true);
            this._stmt_lookup = new StatementsPool(this._lookupPoolSize, "SELECT " + this._valueCol + " FROM " + this._table + " WHERE " + this._sessionIdCol + " = ?");
            this._stmt_delete = new StatementsPool(this._deletePoolSize, "DELETE FROM " + this._table + " WHERE " + this._sessionIdCol + " = ?");
            this._stmt_update = new StatementsPool(this._updatePoolSize, "UPDATE " + this._table + " SET " + this._accessTimeCol + " = ?, " + this._timeOutCol + " = ?, " + this._valueCol + " = ? WHERE " + this._sessionIdCol + " = ?");
            this._stmt_insert = new StatementsPool(this._insertPoolSize, "INSERT INTO " + this._table + " (" + this._sessionIdCol + "," + this._accessTimeCol + "," + this._timeOutCol + "," + this._valueCol + ") VALUES (?,?,?,?)");
            this._stmt_reaper = this._connection.prepareStatement("DELETE FROM " + this._table + " WHERE (" + this._accessTimeCol + " + " + this._timeOutCol + ") <= ? AND (" + this._sessionIdCol + " NOT LIKE '" + "NSContextSession1.0" + "%')");
            this._initialized = true;
            LogUtil.logInfo((String)_res.getProp("session.JdbcStore.msg_jdbcStoreInit", (Object)this._jdbcUrl, (Object)this._jdbcDriver));
        }
        catch (Exception exception) {
            LogUtil.logFailure((String)_res.getProp("session.JdbcStore.msg_jdbcStoreFailed", (Object)exception));
        }
        return this._initialized;
    }

    public IWSHttpSession load(IWSHttpSession iWSHttpSession) {
        IWSHttpSession iWSHttpSession2 = null;
        if (this._initialized && iWSHttpSession != null) {
            ObjectInputStream objectInputStream;
            block15: {
                PreparedStatement preparedStatement = null;
                ServletContext servletContext = iWSHttpSession.getServletContext();
                objectInputStream = null;
                String string = iWSHttpSession.getMangledId();
                try {
                    try {
                        byte[] byArray;
                        preparedStatement = this._stmt_lookup.acquireStatement();
                        preparedStatement.setString(1, string);
                        ResultSet resultSet = preparedStatement.executeQuery();
                        if (resultSet.next() && (byArray = resultSet.getBytes(1)) != null) {
                            if (servletContext != null) {
                                ClassLoader classLoader = (ClassLoader)servletContext.getAttribute("com.iplanet.server.http.servlet.classloader");
                                objectInputStream = new IWSHttpSessionInputStream(new BufferedInputStream(new ByteArrayInputStream(byArray)), classLoader);
                            } else {
                                objectInputStream = new ObjectInputStream(new BufferedInputStream(new ByteArrayInputStream(byArray)));
                            }
                            iWSHttpSession2 = (IWSHttpSession)objectInputStream.readObject();
                            iWSHttpSession2.unsetNew();
                        }
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_exceptionThrown", (Object)"load()", (Object)string, (Object)sQLException));
                    }
                    catch (Exception exception) {
                        LogUtil.logInfo((String)LogUtil.getStackTrace((Throwable)exception));
                    }
                    Object var8_12 = null;
                    if (preparedStatement == null) break block15;
                    this._stmt_lookup.release(preparedStatement);
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    if (preparedStatement != null) {
                        this._stmt_lookup.release(preparedStatement);
                    }
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return iWSHttpSession2;
    }

    public void reap(long l) {
        block3: {
            if (!this._initialized || !this._reaper_active) break block3;
            try {
                int n = (int)(l / 60000L);
                this._stmt_reaper.setInt(1, n);
                int n2 = this._stmt_reaper.executeUpdate();
                if (n2 > 0) {
                    LogUtil.logInfo((String)_res.getProp("session.JdbcStore.msg_sessionsReaped", (Object)new Integer(n2)));
                }
            }
            catch (SQLException sQLException) {
                LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_exceptionThrown", (Object)"reaper()", (Object)"none", (Object)sQLException));
            }
        }
    }

    public boolean remove(IWSHttpSession iWSHttpSession) {
        if (!this._initialized || iWSHttpSession == null) {
            return false;
        }
        String string = iWSHttpSession.getMangledId();
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = this._stmt_delete.acquireStatement();
                preparedStatement.setString(1, string);
                int n = preparedStatement.executeUpdate();
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("JdbcStore:.deleteSession(): id = " + string + ", executeUpdate = " + n));
                }
            }
            catch (SQLException sQLException) {
                LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_exceptionThrown", (Object)"deleteSession ()", (Object)string, (Object)sQLException));
            }
            Object var5_6 = null;
            if (preparedStatement != null) {
                this._stmt_delete.release(preparedStatement);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (preparedStatement != null) {
                this._stmt_delete.release(preparedStatement);
            }
            throw throwable;
        }
        return true;
    }

    public boolean save(IWSHttpSession iWSHttpSession) {
        String string = iWSHttpSession.getMangledId();
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));
                objectOutputStream.writeObject(iWSHttpSession);
                objectOutputStream.flush();
                preparedStatement = this._stmt_update.acquireStatement();
                int n = (int)(iWSHttpSession.getLastAccessedTime() / 60000L);
                int n2 = iWSHttpSession.getTimeout() / 60;
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n2);
                preparedStatement.setBytes(3, byteArrayOutputStream.toByteArray());
                preparedStatement.setString(4, string);
                int n3 = preparedStatement.executeUpdate();
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("JdbcStore:.save: id = " + string + ", executeUpdate = " + n3));
                }
                if (n3 == 0) {
                    preparedStatement2 = this._stmt_insert.acquireStatement();
                    preparedStatement2.setString(1, string);
                    preparedStatement2.setInt(2, n);
                    preparedStatement2.setInt(3, n2);
                    preparedStatement2.setBytes(4, byteArrayOutputStream.toByteArray());
                    preparedStatement2.executeUpdate();
                    if (LogUtil.enableTrace) {
                        LogUtil.TRACE((int)5, (String)("JdbcStore:inserting session " + string));
                    }
                } else if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("JdbcStore:updating session " + string));
                }
            }
            catch (Exception exception) {
                LogUtil.logWarning((String)_res.getProp("session.JdbcStore.msg_exceptionThrown", (Object)"save", (Object)string, (Object)exception));
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            if (preparedStatement != null) {
                this._stmt_update.release(preparedStatement);
            }
            if (preparedStatement2 != null) {
                this._stmt_insert.release(preparedStatement2);
            }
            throw throwable;
        }
        try {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
        catch (IOException iOException) {}
        if (preparedStatement != null) {
            this._stmt_update.release(preparedStatement);
        }
        if (preparedStatement2 != null) {
            this._stmt_insert.release(preparedStatement2);
        }
        return true;
    }

    private class StatementsPool
    extends ResourcePool {
        StatementsPool(int n, String string) throws SQLException {
            super(n);
            int n2 = 0;
            while (n2 < n) {
                Connection connection = DriverManager.getConnection(JdbcStore.this._jdbcUrl, JdbcStore.this._username, JdbcStore.this._password);
                connection.setAutoCommit(true);
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                this.release(preparedStatement);
                ++n2;
            }
        }

        public PreparedStatement acquireStatement() {
            return (PreparedStatement)super.acquire();
        }

        public void release(PreparedStatement preparedStatement) {
            super.release((Object)preparedStatement);
        }
    }
}

