/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSHttpServletRequest;
import com.iplanet.server.http.servlet.NSHttpServletResponse;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.SrvUtil;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringBufferInputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.Cookie;

public class NSServletSession {
    private long _d_ptr;
    private boolean _responseStarted = false;
    private int _statusCode = 200;
    private String _statusMessage = null;
    private boolean _valid = true;
    private boolean _error = false;
    private NSHttpServletRequest _req = null;
    private NSHttpServletResponse _res = null;
    private static SimpleDateFormat nscpCookieFormat = null;
    private Date _date = null;
    private int _cookieVersion = 0;
    private int _respondCookieVersion = 0;
    private boolean _encodeCookies = true;
    private boolean _isSSI = false;

    static {
        nscpCookieFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
        nscpCookieFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public NSServletSession(long l) {
        this._d_ptr = l;
        this._isSSI = this.isSSIRequest();
    }

    native boolean Authorize(String var1, String var2, String var3);

    void addCookie(Cookie cookie) {
        CharSequence charSequence;
        String string = cookie.getName();
        String string2 = cookie.getValue();
        String string3 = cookie.getDomain();
        String string4 = cookie.getPath();
        String string5 = cookie.getComment();
        int n = cookie.getMaxAge();
        int n2 = cookie.getVersion();
        if (string == null) {
            return;
        }
        if (n2 < this._respondCookieVersion) {
            n2 = this._respondCookieVersion;
        }
        if (n2 == 0 && this._cookieVersion > n2) {
            n2 = this._cookieVersion;
        }
        if (n2 > 0 && (charSequence = this.getProtocol()) != null) {
            try {
                int n3 = ((String)charSequence).charAt(5) - 48;
                int n4 = ((String)charSequence).charAt(7) - 48;
                if (n3 < 1 || n3 == 1 && n4 == 0) {
                    this._respondCookieVersion = 0;
                    n2 = 0;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        charSequence = new StringBuffer();
        if (this._encodeCookies) {
            ((StringBuffer)charSequence).append(String.valueOf(SrvUtil.encodeURI((String)cookie.getName())) + "=");
        } else {
            ((StringBuffer)charSequence).append(String.valueOf(cookie.getName()) + "=");
        }
        if (string2 != null) {
            if (this._encodeCookies) {
                ((StringBuffer)charSequence).append(SrvUtil.encodeURI((String)string2));
            } else {
                ((StringBuffer)charSequence).append(string2);
            }
        }
        if (string5 != null && n2 > 0) {
            if (string5.charAt(0) != '\"') {
                string5 = String.valueOf('\"') + string5 + '\"';
            }
            ((StringBuffer)charSequence).append("; Comment=" + string5);
        }
        if (string3 != null) {
            if (n2 == 0) {
                ((StringBuffer)charSequence).append(";domain=" + string3);
            } else {
                ((StringBuffer)charSequence).append("; Domain=" + string3);
            }
        }
        if (string4 != null) {
            if (n2 == 0) {
                ((StringBuffer)charSequence).append(";path=" + string4);
            } else {
                ((StringBuffer)charSequence).append("; Path=" + string4);
            }
        }
        if (n != -1) {
            if (n2 == 0) {
                if (this._date == null) {
                    this._date = new Date();
                }
                this._date.setTime((long)n * 1000L + System.currentTimeMillis());
                ((StringBuffer)charSequence).append(";expires=" + nscpCookieFormat.format(this._date));
            } else {
                ((StringBuffer)charSequence).append("; Max-Age=" + n);
            }
        }
        if (cookie.getSecure()) {
            if (n2 == 0) {
                ((StringBuffer)charSequence).append(";secure");
            } else {
                ((StringBuffer)charSequence).append("; Secure");
            }
        }
        if (n2 > 0) {
            ((StringBuffer)charSequence).append("; Version=" + n2);
        }
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("addCookie(): cookie=" + ((StringBuffer)charSequence).toString()));
        }
        this.addHeader("set-cookie", ((StringBuffer)charSequence).toString());
    }

    void addHeader(String string, String string2) {
        if (this._valid && string != null && string2 != null) {
            if (this._res.useResponseCTforHeaders()) {
                this.addHeaderPrivateBytes(string, this.getBytesUsingResponseEncoding(string2));
            } else {
                this.addHeaderPrivate(string, string2);
            }
        }
    }

    private native void addHeaderPrivate(String var1, String var2);

    private native void addHeaderPrivateBytes(String var1, byte[] var2);

    native int available(int var1);

    void flush() throws IOException {
        this.startResponse();
        this.ostream_flush();
    }

    native String[] getAllHeaderNames();

    native String[] getAllParameterNames();

    native String[] getAllResponseCharacterEncodings();

    native String[] getAllResponseHeaders(String var1);

    native String getAuthType();

    byte[] getBytesUsingResponseEncoding(String string) {
        byte[] byArray;
        block5: {
            byArray = null;
            if (string == null) break block5;
            try {
                byArray = string.getBytes(this._res.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            if (byArray == null) {
                try {
                    byArray = string.getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return byArray;
    }

    native String getCgiVariable(String var1);

    native String getClientOption(String var1);

    native int getContentLength();

    native String getContentType();

    Cookie getCookie(String string) {
        boolean bl = true;
        return this.getCookie(string, true);
    }

    Cookie getCookie(String string, boolean bl) {
        Cookie[] cookieArray = this.getCookies();
        Cookie cookie = null;
        int n = 0;
        while (n < cookieArray.length) {
            if (cookieArray[n].getName().equals(string)) {
                cookie = cookieArray[n];
                if (bl) break;
            }
            ++n;
        }
        return cookie;
    }

    Cookie[] getCookies() {
        int n;
        Object object;
        String string = this.getHeader("Cookie");
        Vector<Cookie> vector = new Vector<Cookie>();
        Cookie cookie = null;
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        if (string != null) {
            if (this._encodeCookies) {
                string = SrvUtil.decodeURI((String)string);
            }
            try {
                if (string.length() >= 9 && string.substring(0, 9).equalsIgnoreCase("$Version=")) {
                    n2 = string.charAt(string.charAt(9) == '\"' ? 10 : 9) - 48;
                }
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("getCookies (): version=" + n2));
                }
                if (n2 > 0) {
                    if (n2 > this._cookieVersion) {
                        this._cookieVersion = n2;
                    }
                    object = new StreamTokenizer(new StringBufferInputStream(string));
                    ((StreamTokenizer)object).resetSyntax();
                    ((StreamTokenizer)object).slashSlashComments(false);
                    ((StreamTokenizer)object).slashStarComments(false);
                    ((StreamTokenizer)object).wordChars(33, 126);
                    ((StreamTokenizer)object).wordChars(160, 255);
                    ((StreamTokenizer)object).quoteChar(34);
                    ((StreamTokenizer)object).commentChar(-1);
                    ((StreamTokenizer)object).whitespaceChars(0, 32);
                    ((StreamTokenizer)object).whitespaceChars(61, 61);
                    ((StreamTokenizer)object).whitespaceChars(59, 59);
                    ((StreamTokenizer)object).whitespaceChars(44, 44);
                    n = 1;
                    while (n != 0) {
                        switch (((StreamTokenizer)object).nextToken()) {
                            case -1: {
                                if (cookie != null) {
                                    vector.addElement(cookie);
                                }
                                n = 0;
                                break;
                            }
                            case -3: 
                            case 34: {
                                if (string2 == null) {
                                    string2 = ((StreamTokenizer)object).sval;
                                    break;
                                }
                                if (string2.charAt(0) == '$') {
                                    if (cookie != null) {
                                        if (string2.equalsIgnoreCase("$Path")) {
                                            cookie.setPath(((StreamTokenizer)object).sval);
                                        } else if (string2.equalsIgnoreCase("$Domain")) {
                                            cookie.setDomain(((StreamTokenizer)object).sval);
                                        }
                                    }
                                } else {
                                    if (cookie != null) {
                                        vector.addElement(cookie);
                                    }
                                    cookie = new Cookie(string2, ((StreamTokenizer)object).sval);
                                    cookie.setVersion(n2);
                                }
                                string2 = null;
                                break;
                            }
                        }
                    }
                } else {
                    object = new StringTokenizer(string, ";");
                    while (((StringTokenizer)object).hasMoreElements()) {
                        String string4 = ((StringTokenizer)object).nextToken();
                        int n3 = string4.indexOf(61);
                        if (n3 > 0) {
                            string2 = string4.substring(0, n3).trim();
                            string3 = string4.substring(n3 + 1).trim();
                            try {
                                cookie = new Cookie(string2, string3);
                                cookie.setVersion(0);
                                vector.addElement(cookie);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                            continue;
                        }
                        try {
                            cookie = new Cookie(string4, "");
                            cookie.setVersion(0);
                            vector.addElement(cookie);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            }
            catch (IOException iOException) {}
        }
        object = new Cookie[vector.size()];
        n = 0;
        while (n < ((Cookie[])object).length) {
            object[n] = (Cookie)vector.elementAt(n);
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)5, (String)("getCookies (): cookie[" + n + "]= " + object[n].getName() + "," + object[n].getValue()));
            }
            ++n;
        }
        return object;
    }

    native String getErrorMessage();

    native String getHeader(String var1);

    NSHttpServletRequest getHttpServletRequest() {
        return this._req;
    }

    NSHttpServletResponse getHttpServletResponse() {
        return this._res;
    }

    String getHttpSessionIdFromURL() {
        return this.getRequestVariable("JSESSIONID");
    }

    native String getLocation(String var1);

    native String getMethodName();

    native String getObjectType();

    native String getOrigReqStatusMsg();

    native String getOrigReqUri();

    native String getParameter(String var1);

    native byte[][] getParameterByteValues(String var1);

    native byte[] getParameterBytes(String var1);

    native String[] getParameterValues(String var1);

    native String getPathInfo();

    native String getPathTranslated();

    long getPrivate() {
        return this._d_ptr;
    }

    native String getProtocol();

    native String getQueryString();

    native String getRealPath(String var1);

    native String getRemoteAddr();

    native String getRemoteHost();

    native String getRemoteUser();

    native String getRequestCharacterEncoding();

    native String getRequestPath();

    native String getRequestURI();

    native String getRequestURL();

    native String getRequestVariable(String var1);

    native String getResponseCharacterEncoding();

    boolean getResponseError() {
        return this._error;
    }

    native String getResponseHeader(String var1);

    String getResponseMessage() {
        return this._statusMessage;
    }

    int getResponseStatus() {
        return this._statusCode;
    }

    native String getSSIServletCode();

    native String getSSIServletCodebase();

    native String[] getSSIServletInitParams();

    Properties getSSIServletInitProperties() {
        Properties properties = new Properties();
        String[] stringArray = this.getSSIServletInitParams();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                String string2 = stringArray[n + 1];
                try {
                    ((Hashtable)properties).put(string, string2);
                }
                catch (Exception exception) {}
                n += 2;
            }
        }
        return properties;
    }

    native String getSSIServletName();

    native String getScriptName();

    String getServerName() {
        return this.getServerNamePrivate();
    }

    private native String getServerNamePrivate();

    native String getServerOption(String var1);

    native int getServerPort();

    native String getServletPath();

    native boolean internalRedirect(String var1, boolean var2);

    void invalidate() {
        this._req = null;
        this._res = null;
        this.setPrivate(0L);
        this._valid = false;
    }

    native boolean isAuthRequired(String var1, String var2);

    native boolean isInternalRequest();

    boolean isSSI() {
        return this._isSSI;
    }

    native boolean isSSIRequest();

    native boolean isSecure();

    native boolean isUserInRole(String var1, int var2, String var3, String var4);

    native boolean ostream_canWrite(int var1);

    native void ostream_flush();

    native int ostream_getSize();

    native void ostream_reset();

    native void ostream_setFlushTimer(int var1);

    native void ostream_setSize(int var1);

    native boolean ostream_wasFlushed();

    native int read(byte[] var1, int var2, int var3);

    native int readByte();

    native int readLine(byte[] var1, int var2, int var3);

    boolean responseStarted() {
        return this._responseStarted;
    }

    void setContentLength(int n) {
        this.setHeader("Content-length", Integer.toString(n));
    }

    void setHeader(String string, String string2) {
        if (this._valid && string != null && string2 != null) {
            if (this._res.useResponseCTforHeaders()) {
                this.setHeaderPrivateBytes(string, this.getBytesUsingResponseEncoding(string2));
            } else {
                this.setHeaderPrivate(string, string2);
            }
        }
    }

    private native void setHeaderPrivate(String var1, String var2);

    private native void setHeaderPrivateBytes(String var1, byte[] var2);

    void setHttpServletRequest(NSHttpServletRequest nSHttpServletRequest) {
        this._req = nSHttpServletRequest;
    }

    void setHttpServletResponse(NSHttpServletResponse nSHttpServletResponse, int n, boolean bl) {
        this._res = nSHttpServletResponse;
        this._respondCookieVersion = n;
        this._encodeCookies = bl;
    }

    native void setPathInfo(String var1);

    void setPrivate(long l) {
        this._d_ptr = l;
    }

    void setRemoteUser(String string) {
        if (this._valid && string != null) {
            this.setRequestVariable("auth-user", string);
        }
    }

    native void setRequestVariable(String var1, String var2);

    void setResponseError(boolean bl) {
        this._error = bl;
    }

    void setResponseStatus(int n, String string) {
        this.setResponseStatus(n, string, null);
    }

    void setResponseStatus(int n, String string, String string2) {
        if (this.ostream_wasFlushed() || this._isSSI) {
            return;
        }
        this._statusCode = n;
        this._statusMessage = string;
        byte[] byArray = this.getBytesUsingResponseEncoding(string2);
        this.setStatusPrivate(this._statusCode, this._statusMessage, byArray);
    }

    native void setScriptName(String var1);

    private native void setStatusPrivate(int var1, String var2, byte[] var3);

    native boolean skip(int var1);

    void startResponse() throws IOException {
        if (!this._responseStarted) {
            this._responseStarted = true;
            this.setStatusPrivate(this._statusCode, this._statusMessage, null);
        }
    }

    private native boolean startResponsePrivate();

    public static String unquote(String string) {
        int n;
        if (string != null && (n = (string = string.trim()).length()) > 2 && string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, n - 1);
            string = string.trim();
        }
        return string;
    }

    void write(byte by) throws IOException {
        if (!this._valid) {
            throw new IOException();
        }
        this._responseStarted = true;
        if (!this.writeBytePrivate(by)) {
            throw new IOException(this.getErrorMessage());
        }
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        if (!this._valid) {
            throw new IOException();
        }
        if (n2 > 0) {
            this._responseStarted = true;
            if (this.writePrivate(byArray, n, n2) != n2) {
                throw new IOException(this.getErrorMessage());
            }
        }
    }

    private native boolean writeBytePrivate(byte var1);

    private native int writePrivate(byte[] var1, int var2, int var3);
}

