/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSHttpServletRequest;
import com.iplanet.server.http.servlet.NSHttpServletResponse;
import com.iplanet.server.http.servlet.NSPrincipal;
import com.iplanet.server.http.servlet.NSServletSession;
import com.iplanet.server.http.servlet.VirtualServer;
import com.iplanet.server.http.servlet.WebApplication;
import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import com.iplanet.server.http.util.XmlConfig;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class FormAuthenticator {
    public static final String FORMLOGIN_SERVLET_NAME = "/j_security_check";
    public static final String FORMLOGIN_USERNAME_FIELD = "j_username";
    public static final String FORMLOGIN_PASSWORD_FIELD = "j_password";
    public static final String FORMLOGIN_PRINCIPAL_KEY = "com.iplanet.server.http.servlet.LOGIN";
    public static final String FORMLOGIN_SAVEDREQUEST_KEY = "com.iplanet.server.http.servlet.SAVED_REQ";
    public static final String FORMLOGIN_COOKIE_NAME = "iwsformloginid";
    public static final int FORMLOGIN_SESSION_TIMEOUT = 600;
    String _formLoginPage;
    String _formErrorPage;
    private VirtualServer _vs;
    private WebApplication _webapp;
    private String _contextPath;
    private IWSHttpSessionManager _smFormLogin;
    private String _cookieName;
    private int _sessionTimeout;
    private static ResUtil _res = ResUtil.getDefaultResUtil();

    FormAuthenticator(WebApplication webApplication) {
        this._webapp = webApplication;
        this._vs = webApplication.getVS();
        this._contextPath = webApplication.getContextPath();
        this._smFormLogin = this._vs.getFormLoginSessionManager();
        XmlConfig xmlConfig = this._vs.getConfig();
        this._cookieName = xmlConfig.getString("/vs/form-login-session/cookie-name", FORMLOGIN_COOKIE_NAME);
        this._sessionTimeout = xmlConfig.findConfig("/vs/form-login-session/timeOut") != null ? xmlConfig.getInt("/vs/form-login-session/timeOut", 600) : this._webapp.getSessionTimeout();
    }

    int Authenticate(NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse, NSServletSession nSServletSession) {
        String string = nSHttpServletRequest._getRequestURI();
        if (string.endsWith(FORMLOGIN_SERVLET_NAME)) {
            return this.jSecurityCheck(nSHttpServletRequest, nSHttpServletResponse);
        }
        if (!string.equals(String.valueOf(this._contextPath) + this._formLoginPage) && !string.equals(String.valueOf(this._contextPath) + this._formErrorPage)) {
            NSPrincipal nSPrincipal = this.getUserPrincipal(nSHttpServletRequest, nSHttpServletResponse);
            String string2 = nSHttpServletRequest.getMethod();
            String string3 = "anyone";
            if (nSPrincipal == null) {
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)"Principal not found");
                }
                if (nSServletSession.isAuthRequired(string, string2)) {
                    if (LogUtil.enableTrace) {
                        LogUtil.TRACE((int)5, (String)("Authorization required for " + string + ", redirecting to login page"));
                    }
                    return this.saveRequestAndLogin(nSHttpServletRequest, nSHttpServletResponse);
                }
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("Authorization not required for " + string));
                }
            } else {
                string3 = nSPrincipal.getName();
                nSServletSession.setRemoteUser(string3);
            }
            if (!nSServletSession.Authorize(string3, string, string2)) {
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("User authorization failed for " + string));
                }
                try {
                    nSHttpServletResponse._sendError(403, null);
                }
                catch (IOException iOException) {}
                return -1;
            }
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)5, (String)("User authorization succeeded for " + string));
            }
        }
        return -2;
    }

    private HttpSession createCookieSession(NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse) {
        String string = this._smFormLogin.generateSID();
        HttpSession httpSession = this._smFormLogin.createSession(string, this._webapp);
        if (httpSession != null) {
            httpSession.setMaxInactiveInterval(this._sessionTimeout);
            Cookie cookie = new Cookie(this._cookieName, string);
            cookie.setPath("/");
            nSHttpServletResponse._addCookie(cookie);
        } else {
            LogUtil.logFailure((String)_res.getProp("servlet.FormAuthenticator.msg_couldnotCreateLoginSession"));
        }
        return httpSession;
    }

    private HttpSession getSession(NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse, boolean bl) {
        HttpSession httpSession = null;
        if (this._smFormLogin != null) {
            httpSession = nSHttpServletRequest.getSessionViaCookie(this._cookieName, this._smFormLogin);
            if (httpSession == null && bl) {
                httpSession = this.createCookieSession(nSHttpServletRequest, nSHttpServletResponse);
            }
        } else {
            httpSession = nSHttpServletRequest.getSession(bl);
        }
        return httpSession;
    }

    private NSPrincipal getUserPrincipal(NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse) {
        HttpSession httpSession = this.getSession(nSHttpServletRequest, nSHttpServletResponse, false);
        if (httpSession != null) {
            NSPrincipal nSPrincipal = (NSPrincipal)httpSession.getAttribute(FORMLOGIN_PRINCIPAL_KEY);
            return nSPrincipal;
        }
        return null;
    }

    private int jSecurityCheck(NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse) {
        NSPrincipal nSPrincipal;
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)"In j_security_check servlet");
        }
        if ((nSPrincipal = this.getUserPrincipal(nSHttpServletRequest, nSHttpServletResponse)) != null) {
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)5, (String)"User principal already exists in session");
            }
            return this.redirectToURI(this._contextPath, nSHttpServletRequest, nSHttpServletResponse);
        }
        String string = nSHttpServletRequest.getParameter(FORMLOGIN_USERNAME_FIELD);
        String string2 = nSHttpServletRequest.getParameter(FORMLOGIN_PASSWORD_FIELD);
        if (string == null || string.length() == 0) {
            LogUtil.logWarning((String)_res.getProp("servlet.FormAuthenticator.msg_userFieldEmpty"));
            return this.sendErrorPage(nSHttpServletRequest, nSHttpServletResponse);
        }
        if (this._vs.Authenticate(string, string2, this._webapp.getAuthDB())) {
            String string3;
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)5, (String)(String.valueOf(string) + " successfully authenticated"));
            }
            if (!this.setUserPrincipal(string, nSHttpServletRequest, nSHttpServletResponse)) {
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)"Unable to set principal in the session");
                }
                return -1;
            }
            String string4 = this._contextPath;
            HttpSession httpSession = this.getSession(nSHttpServletRequest, nSHttpServletResponse, false);
            if (httpSession != null && (string3 = (String)httpSession.getAttribute(FORMLOGIN_SAVEDREQUEST_KEY)) != null) {
                httpSession.removeAttribute(FORMLOGIN_SAVEDREQUEST_KEY);
                string4 = string3;
            }
            return this.redirectToURI(string4, nSHttpServletRequest, nSHttpServletResponse);
        }
        LogUtil.logInfo((String)(String.valueOf(string) + _res.getProp("servlet.FormAuthenticator.msg_authenticationFailed")));
        return this.sendErrorPage(nSHttpServletRequest, nSHttpServletResponse);
    }

    private int redirectToURI(String string, NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse) {
        try {
            String string2 = nSHttpServletResponse.encodeRedirectURL(string);
            nSHttpServletResponse.sendRedirect(string2);
        }
        catch (IOException iOException) {
            LogUtil.logWarning((String)_res.getProp("servlet.FormAuthenticator.msg_redirectUriFailed", (Object)string));
            return -1;
        }
        return 0;
    }

    private int saveRequestAndLogin(NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse) {
        if (nSHttpServletRequest.getMethod().equalsIgnoreCase("GET")) {
            HttpSession httpSession;
            String string = nSHttpServletRequest._getRequestURI();
            String string2 = nSHttpServletRequest._getQueryString();
            if (string2 != null) {
                string = String.valueOf(string) + "?" + string2;
            }
            if ((httpSession = this.getSession(nSHttpServletRequest, nSHttpServletResponse, true)) != null) {
                httpSession.setAttribute(FORMLOGIN_SAVEDREQUEST_KEY, (Object)string);
            } else {
                LogUtil.logInfo((String)_res.getProp("servlet.FormAuthenticator.msg_couldnotSaveRequest"));
            }
        }
        return this.redirectToURI(String.valueOf(this._contextPath) + this._formLoginPage, nSHttpServletRequest, nSHttpServletResponse);
    }

    private int sendErrorPage(NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse) {
        return this.redirectToURI(String.valueOf(this._contextPath) + this._formErrorPage, nSHttpServletRequest, nSHttpServletResponse);
    }

    void setFormErrorPage(String string) {
        this._formErrorPage = string.startsWith("/") ? string : "/" + string;
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)7, (String)("Form error page : " + this._formErrorPage));
        }
    }

    void setFormLoginPage(String string) {
        this._formLoginPage = string.startsWith("/") ? string : "/" + string;
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)7, (String)("Form login page : " + this._formLoginPage));
        }
    }

    private boolean setUserPrincipal(String string, NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse) {
        HttpSession httpSession = this.getSession(nSHttpServletRequest, nSHttpServletResponse, true);
        if (httpSession == null) {
            LogUtil.logInfo((String)_res.getProp("servlet.FormAuthenticator.msg_couldnotSetUserPrinicipal"));
            return false;
        }
        NSPrincipal nSPrincipal = new NSPrincipal(string);
        httpSession.setAttribute(FORMLOGIN_PRINCIPAL_KEY, (Object)nSPrincipal);
        return true;
    }
}

