#
# Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

RESOURCE_TYPE = "mps";
VENDOR_ID = SUNW;
RT_DESCRIPTION = "Sun Java(TM) System Administration Server on Sun Cluster";

RT_VERSION ="1.0"; 
API_VERSION = 2;	 
FAILOVER = TRUE;

INIT_NODES = RG_PRIMARIES;

RT_BASEDIR=/usr/sadm/mps/admin/v5.2/cluster;


START				=	as_svc_start;
STOP				=	as_svc_stop;

VALIDATE			=	as_validate;
UPDATE				=	as_update;

MONITOR_START			=	as_monitor_start;
MONITOR_STOP			=	as_monitor_stop;
MONITOR_CHECK			=	as_monitor_check;

PKGLIST = SUNWasha;

# The paramtable is a list of bracketed resource property declarations 
# that come after the resource-type declarations
# The property-name declaration must be the first attribute
# after the open curly of a paramtable entry
#
{  
	PROPERTY = Start_timeout; 
	MIN=60; 
	DEFAULT=300;
}
{
	PROPERTY = Stop_timeout; 
	MIN=60; 
	DEFAULT=300;
}
{ 
	PROPERTY = Validate_timeout; 
	MIN=60; 
	DEFAULT=300; 
}
{ 
	PROPERTY = Update_timeout; 
	MIN=60; 
	DEFAULT=300; 
}
{ 
	PROPERTY = Monitor_Start_timeout; 
	MIN=60; 
	DEFAULT=300; 
}
{ 
	PROPERTY = Monitor_Stop_timeout; 
	MIN=60; 
	DEFAULT=300; 
}
{ 
	PROPERTY = Monitor_Check_timeout; 
	MIN=60; 
	DEFAULT=300; 
}
{ 
	PROPERTY = Thorough_Probe_Interval; 
	MIN=0; 
	MAX=3600; 
	DEFAULT=60; 
	TUNABLE = ANYTIME;
}
{ 
	PROPERTY = Retry_Count; 
	MIN=0; 
	MAX=10; 
	DEFAULT=2; 
	TUNABLE = ANYTIME;
}
{ 
	PROPERTY = Retry_Interval; 
	MIN=0; 
	MAX=3600; 
	DEFAULT=300; 
	TUNABLE = ANYTIME;
}
{ 
	PROPERTY = FailOver_Mode;
	DEFAULT = SOFT; 
	TUNABLE = ANYTIME;
}
{ 
	PROPERTY = Network_resources_used; 
	TUNABLE = WHEN_DISABLED;
	DEFAULT = "";
}
{
        PROPERTY = Port_list;
        DEFAULT = "390/tcp";
        TUNABLE = AT_CREATION;
}

#
# Extension Properties
#

# Not to be edited by end user
{
	PROPERTY = Paramtable_version;
	EXTENSION;
	STRING;
	DEFAULT = "1.0";
	DESCRIPTION = "The Paramtable Version for this Resource";
}

# Must specify installation path of iPlanet (on PXFS)
# Can be a SET of these for sticky mode scalable iPlanet
# Web servers (These need to be under the same resource).
{
	PROPERTY = Confdir_list;
	EXTENSION;
	STRINGARRAY;
	TUNABLE = AT_CREATION;
	DESCRIPTION = "The Configuration Directory Path(s)";
}

# These two control the restarting of the fault monitor itself
# (not the serer daemon) by PMF.
{
	PROPERTY = Monitor_retry_count;
	EXTENSION;
	INT;
	MIN=-1;
	DEFAULT = 4;
	TUNABLE = ANYTIME;
	DESCRIPTION = "Number of PMF restarts allowed for the fault monitor";
}

{
	PROPERTY = Monitor_retry_interval;
	EXTENSION;
	INT;
	MIN=-1;
	DEFAULT = 2;
	TUNABLE = ANYTIME;
	DESCRIPTION = "Time window (minutes) for fault monitor restarts";
}

# Time out value for the probe
{
	PROPERTY = Probe_timeout;
	EXTENSION;
	INT;
	MIN=15;
	DEFAULT = 30;
	TUNABLE = ANYTIME;
	DESCRIPTION = "Time out value for the probe (seconds)";
}
