/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.FilteredInputDocument;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.EditableList;
import com.netscape.management.admserv.panel.FilterEditList;
import com.netscape.management.admserv.panel.FilterEditPanel;
import com.netscape.management.admserv.panel.NetworkConfigPanel;
import com.netscape.management.client.util.HostException;
import com.netscape.management.client.util.IPAddressValidator;
import com.netscape.management.client.util.ResourceSet;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

class IPAddrEditList
extends FilterEditList {
    static String _i18nEditIP = EditableList._resource.getString("network", "EditIPToolTip");
    static String _i18nAddIP = EditableList._resource.getString("network", "AddIPToolTip");
    static String _i18nRemoveIP = EditableList._resource.getString("network", "RemoveIPToolTip");

    IPAddrEditList() {
    }

    public JPanel getEditPanel() {
        this._editPanel = new FilterEditPanel(NetworkConfigPanel._i18nIPAddr, NetworkConfigPanel._i18nIPAddrFormat);
        ((JTextComponent)this._editPanel.getTextField()).setDocument(new FilteredInputDocument("1234567890.:abcdefABCDEF*"));
        this.setEditPanelInitalFocusComponent(this._editPanel.getTextField());
        this.setEditPanelCommitOnEnterComponents(new JTextField[]{this._editPanel.getTextField()});
        return this._editPanel;
    }

    public String getEditTitle() {
        return NetworkConfigPanel._i18nEditIPAddrDialog;
    }

    public String getAddTitle() {
        return NetworkConfigPanel._i18nAddIPAddrDialog;
    }

    public String getEditToolTip() {
        return _i18nEditIP;
    }

    public String getAddToolTip() {
        return _i18nAddIP;
    }

    public String getRemoveToolTip() {
        return _i18nRemoveIP;
    }

    public ResourceSet getHelpResourceSet() {
        return NetworkConfigPanel._resource;
    }

    public String getHelpToken() {
        return "editIPAddrHelp";
    }

    public void validateIPAddress(String string) throws ValidationException {
        IPAddressValidator iPAddressValidator = new IPAddressValidator(string, true);
        iPAddressValidator.setWildcardAllowed(true);
        try {
            iPAddressValidator.validate();
        }
        catch (HostException hostException) {
            String string2;
            switch (hostException.getResultCode()) {
                case 1: {
                    string2 = NetworkConfigPanel._i18nMsgEnterIPAddr;
                    break;
                }
                case 2: {
                    string2 = NetworkConfigPanel._i18nMsgEnterIPv6Addr;
                    break;
                }
                case 3: {
                    string2 = NetworkConfigPanel._i18nMsgEnterIPv4IPv6Addr;
                    break;
                }
                default: {
                    string2 = NetworkConfigPanel._i18nMsgEnterIPAddr;
                }
            }
            string2 = string2 + "\n" + NetworkConfigPanel._i18nMsgCanUseWildcards;
            throw new ValidationException("", string2);
        }
    }

    public void validateEdit() throws ValidationException {
        String string = this._editPanel.getItem();
        if (string.length() == 0) {
            String string2 = NetworkConfigPanel._i18nMsgEnterIPAddr + "\n" + NetworkConfigPanel._i18nMsgCanUseWildcards;
            throw new ValidationException("", string2);
        }
        if (string.equals("*")) {
            return;
        }
        this.validateIPAddress(string);
    }
}

