/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.config;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;

public class EditMonitor
implements ActionListener,
ChangeListener,
DocumentListener,
ItemListener,
ListDataListener {
    boolean _isDirty = false;
    boolean _isRunning = false;
    Vector _listeners;
    Vector _enableComponents = new Vector(5);
    Vector _disableComponents = new Vector(5);

    public EditMonitor() {
        this._listeners = new Vector(5);
    }

    void start() {
        this._isRunning = true;
    }

    void stop() {
        this._isRunning = false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listeners.addElement(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._listeners.removeElement(changeListener);
    }

    protected void fireChangeEvent() {
        int n = 0;
        while (n < this._listeners.size()) {
            ChangeListener changeListener = (ChangeListener)this._listeners.elementAt(n);
            changeListener.stateChanged(new ChangeEvent(new Boolean(this._isDirty)));
            ++n;
        }
    }

    public void setEnableComponets(Vector vector) {
        this._enableComponents = new Vector();
    }

    public void setDisableComponets(Vector vector) {
        this._disableComponents = new Vector();
    }

    public void addEnableComponent(Component component) {
        this._enableComponents.addElement(component);
        component.setEnabled(this._isDirty);
    }

    public void addDisableComponent(Component component) {
        this._disableComponents.addElement(component);
        component.setEnabled(!this._isDirty);
    }

    private void setComponentsEnabledState(boolean bl) {
        int n = 0;
        while (n < this._enableComponents.size()) {
            Component component = (Component)this._enableComponents.elementAt(n);
            component.setEnabled(bl);
            ++n;
        }
        int n2 = 0;
        while (n2 < this._disableComponents.size()) {
            Component component = (Component)this._disableComponents.elementAt(n2);
            component.setEnabled(!bl);
            ++n2;
        }
    }

    public void setDirtyFlag(boolean bl) {
        if (this._isRunning) {
            boolean bl2 = bl != this._isDirty;
            this._isDirty = bl;
            this.setComponentsEnabledState(this._isDirty);
            if (bl2) {
                this.fireChangeEvent();
            }
        }
    }

    public boolean getDirtyFlag() {
        return this._isDirty;
    }

    public void monitor(JTextComponent jTextComponent) {
        jTextComponent.getDocument().addDocumentListener(this);
    }

    public void monitor(JList jList) {
        jList.getModel().addListDataListener(this);
    }

    public void monitor(ListModel listModel) {
        listModel.addListDataListener(this);
    }

    public void monitor(JToggleButton jToggleButton) {
        jToggleButton.addActionListener(this);
    }

    public void monitor(JComboBox jComboBox) {
        jComboBox.addItemListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Component) {
            Component component = (Component)actionEvent.getSource();
            if (component.isEnabled()) {
                this.setDirtyFlag(true);
            }
        } else {
            this.setDirtyFlag(true);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setDirtyFlag(true);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirtyFlag(true);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirtyFlag(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirtyFlag(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof Component) {
            Component component = (Component)itemEvent.getSource();
            if (component.isEnabled()) {
                this.setDirtyFlag(true);
            }
        } else {
            this.setDirtyFlag(true);
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setDirtyFlag(true);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setDirtyFlag(true);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setDirtyFlag(true);
    }

    public String toString() {
        return "EditMonitor[dirty=" + this._isDirty + ", running=" + this._isRunning + "]";
    }
}

