/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.cmdln;

import com.netscape.management.admserv.cmdln.AdmpwTask;
import com.netscape.management.admserv.cmdln.CountLogEntriesTask;
import com.netscape.management.admserv.cmdln.ViewLogEntriesTask;
import com.netscape.management.client.cmd.CommandLineParser;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.URLByteEncoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandLine {
    protected static String[] _fileArgs = null;
    protected static CommandLineParser _fileOpt = null;
    protected static CommandLineParser _opt = null;
    protected static final int TC_SHOW_HELP = 0;
    protected static final int TC_RESTART = 1;
    protected static final int TC_STOP = 2;
    protected static final int TC_GET_SYSTEM_USER = 3;
    protected static final int TC_SET_SYSTEM_USER = 4;
    protected static final int TC_GET_PORT = 5;
    protected static final int TC_SET_PORT = 6;
    protected static final int TC_GET_ADMINUSERS = 7;
    protected static final int TC_SET_ADMINUSERS = 8;
    protected static final int TC_GET_ERRORLOG = 9;
    protected static final int TC_SET_ERRORLOG = 10;
    protected static final int TC_GET_ACCESSLOG = 11;
    protected static final int TC_SET_ACCESSLOG = 12;
    protected static final int TC_GET_HOSTS = 13;
    protected static final int TC_SET_HOSTS = 14;
    protected static final int TC_GET_ADDRESSES = 15;
    protected static final int TC_SET_ADDRESSES = 16;
    protected static final int TC_GET_ONEACLDIR = 17;
    protected static final int TC_SET_ONEACLDIR = 18;
    protected static final int TC_GET_DEFAULTACCEPTLANGUAGE = 19;
    protected static final int TC_SET_DEFAULTACCEPTLANGUAGE = 20;
    protected static final int TC_GET_CLASSNAME = 21;
    protected static final int TC_SET_CLASSNAME = 22;
    protected static final int TC_COUNT_ERRORLOG_ENTRIES = 23;
    protected static final int TC_VIEW_ERRORLOG_ENTRIES = 24;
    protected static final int TC_COUNT_ACCESSLOG_ENTRIES = 25;
    protected static final int TC_VIEW_ACCESSLOG_ENTRIES = 26;
    protected static final int TC_ENABLE_ENDUSER_ACCESS = 27;
    protected static final int TC_DISABLE_ENDUSER_ACCESS = 28;
    protected static final int TC_GET_ADMIN_UID = 29;
    protected static final int TC_SET_ADMIN_UID = 30;
    protected static final int TC_SET_ADMIN_PWD = 31;
    protected static final int TC_GET_DSCONFIG = 32;
    protected static final int TC_SET_DSCONFIG = 33;
    protected static final int TC_GET_CACHE_LIFETIME = 34;
    protected static final int TC_SET_CACHE_LIFETIME = 35;
    protected static final int TC_GET_SERVER_ADDRESS = 36;
    protected static final int TC_SET_SERVER_ADDRESS = 37;
    protected static final int TC_GET_UGDSCONFIG = 38;
    protected static final int TC_SET_UGDSCONFIG = 39;
    protected static final String[] _admconfigHelpLookup = new String[]{"[help-main]", "[help-restart]", "[help-stop]", "[help-getsystemuser]", "[help-setsystemuser]", "[help-getport]", "[help-setport]", "[help-getadminusers]", "[help-setadminusers]", "[help-geterrorlog]", "[help-seterrorlog]", "[help-getaccesslog]", "[help-setaccesslog]", "[help-gethosts]", "[help-sethosts]", "[help-getaddresses]", "[help-setaddresses]", "[help-getoneacldir]", "[help-setoneacldir]", "[help-getdefaultacceptlanguage]", "[help-setdefaultacceptlanguage]", "[help-getclassname]", "[help-setclassname]", "[help-counterrorlogentries]", "[help-viewerrorlogentries]", "[help-countaccesslogentries]", "[help-viewaccesslogentries]", "[help-enableenduseraccess]", "[help-disableenduseraccess]", "[help-getadminuid]", "[help-setadminuid]", "[help-setadminpwd]", "[help-getdsconfig]", "[help-setdsconfig]", "[help-getcachelifetime]", "[help-setcachelifetime]", "[help-getserveraddress]", "[help-setserveraddress]", "[help-getugdsconfig]", "[help-setugdsconfig]"};
    protected static final String[] _admconfigTaskLookup = new String[]{"-restart", "-stop", "-getsystemuser", "-setsystemuser", "-getport", "-setport", "-getadminusers", "-setadminusers", "-geterrorlog", "-seterrorlog", "-getaccesslog", "-setaccesslog", "-gethosts", "-sethosts", "-getaddresses", "-setaddresses", "-getoneacldir", "-setoneacldir", "-getdefaultacceptlanguage", "-setdefaultacceptlanguage", "-getclassname", "-setclassname", "-counterrorlogentries", "-viewerrorlogentries", "-countaccesslogentries", "-viewaccesslogentries", "-enableenduseraccess", "-disableenduseraccess", "-getadminuid", "-setadminuid", "-setadminpwd", "-getdsconfig", "-setdsconfig", "-getcachelifetime", "-setcachelifetime", "-getserveraddress", "-setserveraddress", "-getugdsconfig", "-setugdsconfig"};
    protected static final int OPT_ENCRYPTION = 0;
    protected static final int OPT_HELP = 1;
    protected static final int OPT_INPUT_FILE = 2;
    protected static final int OPT_QUIET_LEVEL = 3;
    protected static final int OPT_SERVER = 4;
    protected static final int OPT_USER = 5;
    protected static final int OPT_VERSION = 6;
    protected static final int OPT_CONTINUE_ON_ERROR = 7;
    protected static final int OPT_TASKS_OFFSET = 7;
    protected static final String[] _admconfigControlStrings = new String[]{"-encryption", "-help:", "-inputfile:", "-verbose:", "-server:", "-user:", "-version", "-continueonerror", "-restart", "-stop", "-getsystemuser", "-setsystemuser:", "-getport", "-setport:", "-getadminusers", "-setadminusers:", "-geterrorlog", "-seterrorlog:", "-getaccesslog", "-setaccesslog:", "-gethosts", "-sethosts:", "-getaddresses", "-setaddresses:", "-getoneacldir", "-setoneacldir:", "-getdefaultacceptlanguage", "-setdefaultacceptlanguage:", "-getclassname", "-setclassname:", "-counterrorlogentries", "-viewerrorlogentries:", "-countaccesslogentries", "-viewaccesslogentries:", "-enableenduseraccess", "-disableenduseraccess", "-getadminuid", "-setadminuid:", "-setadminpwd:", "-getdsconfig", "-setdsconfig:", "-getcachelifetime", "-setcachelifetime:", "-getserveraddress", "-setserveraddress:", "-getugdsconfig", "-setugdsconfig:"};
    protected static final String PACKAGE_DIR = "com/netscape/management/admserv/cmdln";
    protected static final String RESTART_TASK = "admin-serv/tasks/operation/Restart";
    protected static final String STOP_TASK = "admin-serv/tasks/operation/Stop";
    protected static final String READ_LOG_TASK = "admin-serv/tasks/configuration/ReadLog";
    protected static final String SERVER_SETUP_TASK = "admin-serv/tasks/configuration/ServerSetup";
    protected static final String ACCESS_SETUP_TASK = "admin-serv/tasks/configuration/AccessSetup";
    protected static final String DIRECTORY_SETUP_TASK = "admin-serv/tasks/configuration/DirectorySetup";
    protected static final String UG_DIRECTORY_SETUP_TASK = "admin-serv/tasks/configuration/UGDirectorySetup";
    protected static final String DATA_FILE = "admconfig.dat";
    protected static final String VERSION_FILE = "version.dat";
    protected String _protocol;
    protected String _server;
    protected String _admin;
    protected String _password;
    protected int _tc;
    protected String _task;
    protected String _inputFile;
    protected int _verbose;
    protected String _newValue;
    protected boolean _quitOnError;

    public static void main(String[] stringArray) {
        CommandLine commandLine = new CommandLine(stringArray);
        commandLine.run(_fileOpt, _fileArgs, false);
        commandLine.run(_opt, stringArray, true);
        System.exit(0);
    }

    private void printRestartMessage() {
        System.out.println("\nRestart the Admin Server for the changes to take effect.");
    }

    public CommandLine(String[] stringArray) {
        if (stringArray.length < 1) {
            this.showHelp(_admconfigHelpLookup[0]);
            System.exit(0);
        }
        _opt = new CommandLineParser(_admconfigControlStrings, stringArray);
        this._protocol = "http";
        this._tc = 0;
        this._verbose = 5;
        this._quitOnError = true;
        this.handleInputFile(_opt, stringArray);
        this.parseArguments(_opt, stringArray, true);
    }

    public void run(CommandLineParser commandLineParser, String[] stringArray, boolean bl) {
        if (commandLineParser == null || stringArray == null || stringArray.length == 0) {
            if (bl) {
                System.err.println("ERROR admconfig:");
                System.err.println("    Task not specified.");
                System.err.println("    Try admconfig -h for help on using admconfig.\n");
                System.exit(1);
            } else {
                return;
            }
        }
        int n = 0;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                this._newValue = null;
                n = this.getTaskCode(stringArray[n2], false);
                switch (n) {
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 16: 
                    case 18: 
                    case 20: 
                    case 22: 
                    case 24: 
                    case 26: 
                    case 30: 
                    case 31: 
                    case 33: 
                    case 35: 
                    case 37: {
                        this._newValue = commandLineParser.getOptionParam(_admconfigControlStrings[n + 7]);
                        if (this._newValue != null) break;
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Invalid number of parameters specified for task.");
                        this.showHelp(_admconfigHelpLookup[n]);
                        if (this._quitOnError) {
                            System.exit(1);
                            break;
                        }
                        return;
                    }
                    case 39: {
                        this._newValue = commandLineParser.getOptionParam(_admconfigControlStrings[n + 7]);
                        break;
                    }
                }
                if (0 != n) {
                    this._tc = n;
                    if (9 == this._verbose) {
                        System.out.println("\nadmconfig: about to run " + this._task);
                        if (this._newValue != null) {
                            System.out.println("admconfig:        task arg: " + this._newValue);
                        }
                    }
                    this.runTask();
                }
                ++n2;
            }
        }
        if (bl && 0 == this._tc) {
            System.err.println("ERROR admconfig:");
            System.err.println("    No valid task was specified.");
            System.err.println("    Try admconfig -h for help on using admconfig.\n");
            System.exit(1);
        }
    }

    public void runTask() {
        try {
            AdmTask admTask;
            URL uRL = null;
            String string = null;
            StringTokenizer stringTokenizer = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            switch (this._tc) {
                case 1: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + RESTART_TASK + "?op=restart");
                    break;
                }
                case 2: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + STOP_TASK);
                    break;
                }
                case 3: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nssuitespotuser") + "=");
                    break;
                }
                case 4: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nssuitespotuser") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 5: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsserverport") + "=");
                    break;
                }
                case 6: {
                    n4 = 0;
                    try {
                        n4 = Integer.parseInt(this._newValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Specified server port is invalid: " + this._newValue);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsserverport") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 7: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminusers") + "=");
                    break;
                }
                case 8: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminusers") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 9: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nserrorlog") + "=");
                    break;
                }
                case 10: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nserrorlog") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 11: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsaccesslog") + "=");
                    break;
                }
                case 12: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsaccesslog") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 13: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminaccesshosts") + "=");
                    break;
                }
                case 14: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminaccesshosts") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 15: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminaccessaddresses") + "=");
                    break;
                }
                case 16: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminaccessaddresses") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 17: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminoneacldir") + "=");
                    break;
                }
                case 18: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminoneacldir") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 19: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsdefaultacceptlanguage") + "=");
                    break;
                }
                case 20: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsdefaultacceptlanguage") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 21: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsclassname") + "=");
                    break;
                }
                case 22: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsclassname") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 34: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadmincachelifetime") + "=");
                    break;
                }
                case 35: {
                    n5 = 0;
                    try {
                        n5 = Integer.parseInt(this._newValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Specified cache lifetime is invalid: " + this._newValue);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadmincachelifetime") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 36: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsserveraddress") + "=");
                    break;
                }
                case 37: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsserveraddress") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 23: {
                    string = this.getLog("configuration.nserrorlog");
                    if (string == null) {
                        return;
                    }
                    uRL = new URL(this._protocol + "://" + this._server + "/" + READ_LOG_TASK + "?op=count&" + "name=" + string);
                    break;
                }
                case 24: {
                    stringTokenizer = new StringTokenizer(this._newValue);
                    if (stringTokenizer.countTokens() != 2) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Invalid number of arguments for the task: " + stringTokenizer.countTokens());
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        } else {
                            return;
                        }
                    }
                    string2 = stringTokenizer.nextToken();
                    n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The entry number to start viewing is invalid: " + string2);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    string3 = stringTokenizer.nextToken();
                    n2 = 0;
                    try {
                        n2 = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The entry number to stop viewing is invalid: " + string3);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    string = this.getLog("configuration.nserrorlog");
                    if (string == null) {
                        return;
                    }
                    uRL = new URL(this._protocol + "://" + this._server + "/" + READ_LOG_TASK + "?op=read&" + "name=" + string + "&start=" + string2 + "&stop=" + string3);
                    break;
                }
                case 25: {
                    string = this.getLog("configuration.nsaccesslog");
                    if (string == null) {
                        return;
                    }
                    uRL = new URL(this._protocol + "://" + this._server + "/" + READ_LOG_TASK + "?op=count&" + "name=" + string);
                    break;
                }
                case 26: {
                    stringTokenizer = new StringTokenizer(this._newValue);
                    if (stringTokenizer.countTokens() != 2) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Invalid number of arguments for the task: " + stringTokenizer.countTokens());
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        } else {
                            return;
                        }
                    }
                    string2 = stringTokenizer.nextToken();
                    n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The entry number to start viewing is invalid: " + string2);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    string3 = stringTokenizer.nextToken();
                    n2 = 0;
                    try {
                        n2 = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The entry number to stop viewing is invalid: " + string3);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    string = this.getLog("configuration.nsaccesslog");
                    if (string == null) {
                        return;
                    }
                    uRL = new URL(this._protocol + "://" + this._server + "/" + READ_LOG_TASK + "?op=read&" + "name=" + string + "&start=" + string2 + "&stop=" + string3);
                    break;
                }
                case 27: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=force_set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminenableenduser") + "=");
                    break;
                }
                case 28: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=force_set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminenableenduser") + "=off");
                    break;
                }
                case 29: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + ACCESS_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"admpw.uid") + "=");
                    break;
                }
                case 30: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + ACCESS_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"admpw.uid") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 31: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + ACCESS_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"admpw.pw") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 32: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + DIRECTORY_SETUP_TASK);
                    break;
                }
                case 33: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + DIRECTORY_SETUP_TASK);
                    stringTokenizer = new StringTokenizer(this._newValue);
                    if (stringTokenizer.countTokens() != 3) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Invalid number of arguments for the task: " + stringTokenizer.countTokens());
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        } else {
                            return;
                        }
                    }
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    n3 = 0;
                    try {
                        n3 = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The dsconfig.port parameter is invalid: " + string5);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    string7 = stringTokenizer.nextToken();
                    if (string7.equalsIgnoreCase("true") || string7.equalsIgnoreCase("false")) break;
                    System.err.println("ERROR admconfig:");
                    System.err.println("    Cannot run " + this._task);
                    System.err.println("    The dsconfig.ssl parameter is invalid: " + string7);
                    System.err.println("");
                    if (this._quitOnError) {
                        System.exit(1);
                        break;
                    }
                    return;
                }
                case 38: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + UG_DIRECTORY_SETUP_TASK);
                    break;
                }
                case 39: {
                    uRL = new URL(this._protocol + "://" + this._server + "/" + UG_DIRECTORY_SETUP_TASK);
                    if (this._newValue == null) break;
                    stringTokenizer = new StringTokenizer(this._newValue);
                    if (stringTokenizer.countTokens() != 6) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Invalid number of arguments for the task: " + stringTokenizer.countTokens());
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        } else {
                            return;
                        }
                    }
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    n3 = 0;
                    try {
                        n3 = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The port parameter is invalid: " + string5);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    string6 = stringTokenizer.nextToken();
                    string6 = string6.replace('+', ' ');
                    string7 = stringTokenizer.nextToken();
                    if (!string7.equalsIgnoreCase("true") && !string7.equalsIgnoreCase("false")) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The ssl parameter is invalid: " + string7);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        } else {
                            return;
                        }
                    }
                    string9 = stringTokenizer.nextToken();
                    string9 = string9.replace('+', ' ');
                    string10 = stringTokenizer.nextToken();
                    string10 = string10.replace('+', ' ');
                    break;
                }
                default: {
                    System.err.println("ERROR admconfig:");
                    System.err.println("    Invalid task specified = " + this._tc);
                    System.err.println("");
                    if (this._quitOnError) {
                        System.exit(1);
                        break;
                    }
                    return;
                }
            }
            switch (this._tc) {
                case 29: 
                case 30: 
                case 31: {
                    admTask = new AdmpwTask(uRL, this._admin, this._password);
                    break;
                }
                case 23: 
                case 25: {
                    admTask = new CountLogEntriesTask(uRL, this._admin, this._password);
                    break;
                }
                case 24: 
                case 26: {
                    admTask = new ViewLogEntriesTask(uRL, this._admin, this._password);
                    break;
                }
                case 32: {
                    admTask = new AdmTask(uRL, this._admin, this._password);
                    admTask.setArguments("op=getconfig");
                    break;
                }
                case 33: {
                    admTask = new AdmTask(uRL, this._admin, this._password);
                    admTask.setArguments("op=setconfig&" + URLByteEncoder.encodeUTF8((String)"dsconfig.host") + "=" + URLEncoder.encode(string4) + "&" + URLByteEncoder.encodeUTF8((String)"dsconfig.port") + "=" + string5 + "&" + URLByteEncoder.encodeUTF8((String)"dsconfig.ssl") + "=" + string7);
                    break;
                }
                case 38: {
                    admTask = new AdmTask(uRL, this._admin, this._password);
                    admTask.setArguments("op=getconfig");
                    break;
                }
                case 39: {
                    admTask = new AdmTask(uRL, this._admin, this._password);
                    if (this._newValue == null) {
                        admTask.setArguments("op=setconfig&" + URLByteEncoder.encodeUTF8((String)"ugdsconfig.inforef") + "=" + URLByteEncoder.encodeUTF8((String)"default"));
                        break;
                    }
                    string11 = string7.equalsIgnoreCase("true") ? "ldaps://" + string4 + ":" + string5 + "/" + string6 : "ldap://" + string4 + ":" + string5 + "/" + string6;
                    admTask.setArguments("op=setconfig&" + URLByteEncoder.encodeUTF8((String)"ugdsconfig.dirurl") + "=" + URLByteEncoder.encodeUTF8((String)string11) + "&" + URLByteEncoder.encodeUTF8((String)"ugdsconfig.binddn") + "=" + URLByteEncoder.encodeUTF8((String)string9) + "&" + URLByteEncoder.encodeUTF8((String)"ugdsconfig.bindpw") + "=" + URLByteEncoder.encodeUTF8((String)string10));
                    break;
                }
                default: {
                    admTask = new AdmTask(uRL, this._admin, this._password);
                }
            }
            int n6 = admTask.exec();
            if (n6 != 0) {
                System.err.println("Status = " + n6);
                System.err.println("    exec failed for " + this._task);
                System.err.println("");
                if (!this._quitOnError) {
                    return;
                }
            } else {
                int n7 = admTask.getStatus();
                if ((n7 != 3 || this._tc != 1 && this._tc != 2) && n7 != 0) {
                    System.err.println("Status = " + n7);
                    System.err.println("    Task " + this._task + " failed: " + admTask.getResult("NMC_ErrInfo"));
                    System.err.println("");
                    if (this._quitOnError) {
                        System.exit(n7);
                    } else {
                        return;
                    }
                }
                System.out.println("Task " + this._task + " succeeded with status = " + n7);
                switch (this._tc) {
                    case 1: {
                        System.out.println("    Server has been restarted.");
                        System.out.println("\nWaiting 15 seconds for the server to come up before continuing.");
                        System.out.println("Press Ctrl-C to exit admconfig.");
                        Thread.sleep(15000L);
                        break;
                    }
                    case 2: {
                        System.out.println("    Server has been stopped.");
                        System.out.println("\nThe server must be started before any more tasks can be run.\n");
                        System.exit(0);
                        break;
                    }
                    case 3: {
                        System.out.println("    configuration.nssuitespotuser = " + admTask.getResult("configuration.nssuitespotuser"));
                        break;
                    }
                    case 5: {
                        System.out.println("    configuration.nsserverport = " + admTask.getResult("configuration.nsserverport"));
                        break;
                    }
                    case 7: {
                        System.out.println("    configuration.nsadminusers = " + admTask.getResult("configuration.nsadminusers"));
                        break;
                    }
                    case 9: {
                        System.out.println("    configuration.nserrorlog = " + admTask.getResult("configuration.nserrorlog"));
                        break;
                    }
                    case 11: {
                        System.out.println("    configuration.nsaccesslog = " + admTask.getResult("configuration.nsaccesslog"));
                        break;
                    }
                    case 13: {
                        System.out.println("    configuration.nsadminaccesshosts = " + admTask.getResult("configuration.nsadminaccesshosts"));
                        break;
                    }
                    case 15: {
                        System.out.println("    configuration.nsadminaccessaddresses = " + admTask.getResult("configuration.nsadminaccessaddresses"));
                        break;
                    }
                    case 17: {
                        System.out.println("    configuration.nsadminoneacldir = " + admTask.getResult("configuration.nsadminoneacldir"));
                        break;
                    }
                    case 19: {
                        System.out.println("    configuration.nsdefaultacceptlanguage = " + admTask.getResult("configuration.nsdefaultacceptlanguage"));
                        break;
                    }
                    case 21: {
                        System.out.println("    configuration.nsclassname = " + admTask.getResult("configuration.nsclassname"));
                        break;
                    }
                    case 34: {
                        System.out.println("    configuration.nsadmincachelifetime = " + admTask.getResult("configuration.nsadmincachelifetime"));
                        break;
                    }
                    case 36: {
                        System.out.println("    configuration.nsserveraddress = " + admTask.getResult("configuration.nsserveraddress"));
                        break;
                    }
                    case 23: 
                    case 25: {
                        System.out.println("    count = " + admTask.getResult("count"));
                        break;
                    }
                    case 24: 
                    case 26: {
                        System.out.println(admTask.getResult("result"));
                        break;
                    }
                    case 27: {
                        System.out.println("    End user access has been enabled.");
                        break;
                    }
                    case 28: {
                        System.out.println("    End user access has been disabled.");
                        break;
                    }
                    case 29: {
                        System.out.println("    admpw.uid = " + admTask.getResult("admpw.uid"));
                        break;
                    }
                    case 32: {
                        System.out.println("    dsconfig.host   = " + admTask.getResult("dsconfig.host"));
                        System.out.println("    dsconfig.port   = " + admTask.getResult("dsconfig.port"));
                        string8 = (String)admTask.getResult("dsconfig.ssl");
                        if (string8 == null || string8.equalsIgnoreCase("false")) {
                            System.out.println("    dsconfig.ssl    = false");
                            break;
                        }
                        System.out.println("    dsconfig.ssl    = true");
                        break;
                    }
                    case 38: {
                        System.out.println("    ugdsconfig.inforef      = " + admTask.getResult("ugdsconfig.inforef"));
                        System.out.println("    ugdsconfig.globaldirurl = " + admTask.getResult("ugdsconfig.globaldirurl"));
                        System.out.println("    ugdsconfig.dirurl       = " + admTask.getResult("ugdsconfig.dirurl"));
                        System.out.println("    ugdsconfig.binddn       = " + admTask.getResult("ugdsconfig.binddn"));
                        break;
                    }
                }
                switch (this._tc) {
                    case 4: 
                    case 6: 
                    case 8: 
                    case 30: 
                    case 31: 
                    case 33: 
                    case 39: {
                        this.printRestartMessage();
                    }
                }
                System.out.println("");
                return;
            }
            System.exit(n6);
        }
        catch (Exception exception) {
            System.err.println("ERROR admconfig:");
            System.err.println("    Task " + this._task + " caused an exception.");
            System.err.println("    Exception: " + exception);
            System.err.println("");
            if (this._quitOnError) {
                System.exit(1);
            }
            return;
        }
    }

    protected void parseArguments(CommandLineParser commandLineParser, String[] stringArray, boolean bl) {
        String string;
        this.handleHelp(commandLineParser);
        this.handleVersion(commandLineParser);
        if (commandLineParser.hasOption(_admconfigControlStrings[3])) {
            string = commandLineParser.getOptionParam(_admconfigControlStrings[3]);
            if (null == string) {
                this._verbose = 9;
            } else {
                try {
                    this._verbose = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("WARNING admconfig:");
                    System.err.println("    Parameter for -verbose option is not a number: " + string);
                    System.err.println("    Setting verbose level to 9.");
                    this._verbose = 9;
                }
                if (this._verbose < 0 || this._verbose > 9) {
                    System.err.println("WARNING admconfig:");
                    System.err.println("    Invalid level: " + this._verbose);
                    System.err.println("    Setting verbose level to default value of 5.");
                    this._verbose = 5;
                }
            }
            if (9 == this._verbose) {
                System.out.println("admconfig:         verbose: " + this._verbose);
            }
        }
        if (commandLineParser.hasOption(_admconfigControlStrings[0])) {
            this._protocol = "https";
            if (9 == this._verbose) {
                System.out.println("admconfig:        protocol: " + this._protocol);
            }
        }
        if (commandLineParser.hasOption(_admconfigControlStrings[7])) {
            this._quitOnError = false;
            if (9 == this._verbose) {
                System.out.println("admconfig:   quit on error: " + this._quitOnError);
            }
        }
        if (commandLineParser.hasOption(_admconfigControlStrings[4])) {
            string = commandLineParser.getOptionParam(_admconfigControlStrings[4]);
            if (null == string) {
                System.err.println("ERROR admconfig:");
                System.err.println("    Required parameter for the -server option was not specified.");
                this.showHelp(_admconfigHelpLookup[0]);
                System.exit(1);
            } else {
                int n = string.indexOf(58);
                if (-1 == n || n + 1 == string.length()) {
                    System.err.println("ERROR admconfig:");
                    System.err.println("    Server port was not specified.");
                    System.err.println("    Try admconfig -h for help on using admconfig.\n");
                    System.exit(1);
                }
                this._server = 0 == n ? "localhost" + string : string;
            }
            if (9 == this._verbose) {
                System.out.println("admconfig:          server: " + this._server);
            }
        }
        if (bl && null == this._server) {
            System.err.println("ERROR admconfig:");
            System.err.println("    Server name and port number were not specified.");
            System.err.println("    Try admconfig -h for help on using admconfig.\n");
            System.exit(1);
        }
        if (commandLineParser.hasOption(_admconfigControlStrings[5])) {
            string = commandLineParser.getOptionParam(_admconfigControlStrings[5]);
            if (null == string) {
                System.err.println("ERROR admconfig:");
                System.err.println("    Required parameter for the -user option was not specified.");
                this.showHelp(_admconfigHelpLookup[0]);
                System.exit(1);
            } else {
                int n = string.indexOf(58);
                this._admin = -1 == n ? string : (0 == n ? System.getProperty("user.name") : string.substring(0, n));
                if (-1 == n || n + 1 == string.length()) {
                    this.promptForPassword();
                } else {
                    this._password = string.substring(n + 1);
                }
            }
            if (9 == this._verbose) {
                System.out.println("admconfig:          userid: " + this._admin);
                System.out.println("admconfig:        password: " + this._password);
            }
        }
        if (bl) {
            if (null == this._admin && null == this._password) {
                this.promptForAdminInfo();
                if (9 == this._verbose) {
                    System.out.println("admconfig:          userid: " + this._admin);
                    System.out.println("admconfig:        password: " + this._password);
                }
            } else if (null == this._admin || this._admin.length() == 0) {
                this._admin = System.getProperty("user.name");
            } else if (null == this._password || this._password.length() == 0) {
                this.promptForPassword();
            }
        }
    }

    protected void handleInputFile(CommandLineParser commandLineParser, String[] stringArray) {
        Object object;
        this._inputFile = null;
        if (commandLineParser.hasOption(_admconfigControlStrings[2])) {
            object = commandLineParser.getOptionParam(_admconfigControlStrings[2]);
            if (null == object) {
                System.err.println("ERROR admconfig:");
                System.err.println("    No file specified for the -inputFile option. Ignoring option.");
            } else {
                this._inputFile = object;
            }
        }
        if (this._inputFile != null) {
            try {
                object = new File(this._inputFile);
                FileReader fileReader = new FileReader((File)object);
                long l = ((File)object).length();
                char[] cArray = new char[(int)l];
                long l2 = 0L;
                while (l2 < l) {
                    l2 += (long)fileReader.read(cArray, (int)l2, (int)(l - l2));
                }
                fileReader.close();
                String string = new String(cArray);
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = null;
                Vector<String> vector = new Vector<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    Debug.println((String)("TRACE CommandLine.handleInputFile: token from file: " + string2));
                    vector.addElement(string2);
                }
                int n = vector.size();
                _fileArgs = new String[n];
                vector.copyInto(_fileArgs);
                _fileOpt = new CommandLineParser(_admconfigControlStrings, _fileArgs);
                this.parseArguments(_fileOpt, _fileArgs, false);
            }
            catch (IOException iOException) {
                System.err.println("ERROR admconfig:");
                System.err.println("    IOException: " + iOException);
                System.err.println("");
                System.exit(1);
            }
        }
    }

    protected void handleHelp(CommandLineParser commandLineParser) {
        if (commandLineParser.hasOption(_admconfigControlStrings[1])) {
            String string = commandLineParser.getOptionParam(_admconfigControlStrings[1]);
            this._tc = null == string ? 0 : this.getTaskCode("-" + string, true);
            this.showHelp(_admconfigHelpLookup[this._tc]);
            System.exit(0);
        }
    }

    protected void handleVersion(CommandLineParser commandLineParser) {
        if (commandLineParser.hasOption(_admconfigControlStrings[6])) {
            this.showVersion();
            System.exit(0);
        }
    }

    protected void showHelp(String string) {
        String string2 = DATA_FILE;
        if (string2 != null) {
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                InputStream inputStream = ClassLoader.getSystemResourceAsStream("com/netscape/management/admserv/cmdln/" + string2);
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.equalsIgnoreCase(string)) break;
                }
                if (string3 == null) {
                    System.err.println("ERROR admconfig:");
                    System.err.println("    No help information available for " + string);
                    System.err.println("");
                    System.exit(1);
                }
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.length() > 0 && string3.charAt(0) == '[') break;
                    System.out.println(string3);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println("ERROR admconfig:");
                System.err.println("    IOException: " + iOException);
                System.err.println("");
                System.exit(1);
            }
        }
    }

    protected void showVersion() {
        String string = VERSION_FILE;
        if (string != null) {
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                InputStream inputStream = ClassLoader.getSystemResourceAsStream("com/netscape/management/admserv/cmdln/" + string);
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    System.out.println(string2);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println("ERROR admconfig:");
                System.err.println("    IOException: " + iOException);
                System.err.println("");
                System.exit(1);
            }
        }
    }

    protected void promptForPassword() {
        try {
            FileReader fileReader = new FileReader(FileDescriptor.in);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            do {
                System.out.print("Password: ");
                this._password = bufferedReader.readLine();
            } while (this._password.length() <= 0);
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println("ERROR admconfig:");
            System.err.println("    IOException: " + iOException);
            System.err.println("");
            System.exit(1);
            return;
        }
    }

    protected void promptForAdminInfo() {
        try {
            FileReader fileReader = new FileReader(FileDescriptor.in);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            do {
                System.out.print("Username: ");
                this._admin = bufferedReader.readLine();
            } while (this._admin.length() <= 0);
            do {
                System.out.print("Password: ");
                this._password = bufferedReader.readLine();
            } while (this._password.length() <= 0);
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println("ERROR admconfig:");
            System.err.println("    IOException: " + iOException);
            System.err.println("");
            System.exit(1);
            return;
        }
    }

    protected int getTaskCode(String string, boolean bl) {
        int n = 0;
        int n2 = 0;
        String string2 = string.toLowerCase();
        int n3 = 0;
        while (n3 < _admconfigTaskLookup.length) {
            if (_admconfigTaskLookup[n3].startsWith(string2)) {
                ++n;
                n2 = n3 + 1;
                this._task = string + " (" + _admconfigTaskLookup[n3] + ")";
            }
            ++n3;
        }
        if (n == 0 || n > 1) {
            if (bl) {
                System.err.println("ERROR admconfig:");
                System.err.println("    Unknown or ambiguous task: " + string);
            }
            return 0;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getLog(String string) {
        String string2 = null;
        try {
            URL uRL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)string) + "=");
            AdmTask admTask = new AdmTask(uRL, this._admin, this._password);
            int n = admTask.exec();
            if (n != 0) {
                System.err.println("Status = " + n);
                System.err.println("    Failed to get " + string);
                System.err.println("");
                if (!this._quitOnError) return null;
                System.exit(n);
            } else {
                int n2 = admTask.getStatus();
                if (n2 != 0) {
                    System.err.println("Status = " + n2);
                    System.err.println("    Failed to get " + string + ": " + admTask.getResult("NMC_ErrInfo"));
                    System.err.println("");
                    if (!this._quitOnError) return null;
                    System.exit(n2);
                }
            }
            String string3 = (String)admTask.getResult(string);
            if (string3.startsWith("admin-serv/") && string3.indexOf("..") == -1) {
                return URLByteEncoder.encodeUTF8((String)("../../../../" + string3));
            }
            System.err.println("ERROR admconfig:");
            System.err.println("    Cannot run " + this._task);
            System.err.println("    Invalid log name: " + string3);
            System.err.println("    Log names must start with \"admin-serv/\" and no \"..\" are allowed.\n");
            if (!this._quitOnError) return null;
            System.exit(1);
            return string2;
        }
        catch (Exception exception) {
            System.err.println("ERROR admconfig:");
            System.err.println("    Exception: " + exception);
            System.err.println("");
            if (!this._quitOnError) return null;
            System.exit(1);
            return string2;
        }
    }
}

