/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv;

import com.netscape.management.admserv.AdminResourceModel;
import com.netscape.management.admserv.AdminResourcePage;
import com.netscape.management.admserv.AdminServer;
import com.netscape.management.admserv.panel.AdminConfigData;
import com.netscape.management.admserv.task.AdminTaskObject;
import com.netscape.management.client.AboutDialog;
import com.netscape.management.client.FrameworkInitializer;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceModel;
import com.netscape.management.client.TaskObject;
import com.netscape.management.client.TaskPage;
import com.netscape.management.client.UIPermissions;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JFrame;
import netscape.ldap.LDAPConnection;
import netscape.ldap.util.DN;

public class AdminFrameworkInitializer
extends FrameworkInitializer {
    private static String PERMID_SECURITY = "SecurityVisibility";
    private ConsoleInfo _consoleInfo;
    public static boolean canAccessSecurity = false;

    public AdminFrameworkInitializer(ConsoleInfo consoleInfo) {
        Console.setConsoleInfo((ConsoleInfo)consoleInfo);
        this._consoleInfo = consoleInfo;
        UIPermissions uIPermissions = new UIPermissions(LDAPUtil.getAdminGlobalParameterEntry());
        canAccessSecurity = uIPermissions.hasPermission(PERMID_SECURITY);
        TaskPage taskPage = new TaskPage(consoleInfo);
        TaskObject taskObject = (TaskObject)taskPage.getModel().getRoot();
        if (AdminConfigData.isWindowsNTPlatform(consoleInfo)) {
            this.removeTask(taskObject, "SNMPSetup");
        }
        this.addPage((IPage)taskPage);
        String[] stringArray = this.getTaskList(taskPage);
        this.setTaskConsoleInfo(taskPage, consoleInfo);
        this.addPage((IPage)new AdminResourcePage((IResourceModel)new AdminResourceModel(consoleInfo, stringArray)));
        RemoteImage remoteImage = UITools.getOS().equals("Win32") ? new RemoteImage(AdminServer._resource.getString("admin", "smallIcon")) : new RemoteImage(AdminServer._resource.getString("admin", "largeIcon"));
        this.setMinimizedImage(remoteImage.getImage());
        this.setBannerImage(this.getBannerImage(consoleInfo));
        this.setFrameTitle(consoleInfo.getLDAPConnection(), consoleInfo.getCurrentDN());
        this.setBannerText(AdminServer._resource.getString("admin", "version"));
    }

    public void aboutInvoked(JFrame jFrame) {
        UtilConsoleGlobals.getActivatedFrame().setCursor(new Cursor(3));
        try {
            if (this.aboutDialog == null) {
                String[] stringArray;
                ResourceSet resourceSet = new ResourceSet("com.netscape.management.client.defaultLicense");
                ResourceSet resourceSet2 = new ResourceSet("com.netscape.management.admserv.admserv");
                this.aboutDialog = new AboutDialog((Frame)jFrame, resourceSet2.getString("aboutDialog", "dialogTitle"), true);
                RemoteImage remoteImage = new RemoteImage(resourceSet.getString("defaultAbout", "productLogo"));
                remoteImage.setDescription(resourceSet.getString("defaultAbout", "productLogo-description"));
                String string = resourceSet2.getString("aboutDialog", "buildnotavailable");
                LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
                String[] stringArray2 = new String[]{"nsBuildNumber"};
                String string2 = this._consoleInfo.getCurrentDN();
                DN dN = new DN(string2);
                String string3 = dN.getParent().toString();
                try {
                    stringArray = lDAPConnection.read(string3, stringArray2);
                    string = stringArray.getAttribute("nsBuildNumber").getStringValueArray()[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stringArray = new String[]{string};
                String string4 = resourceSet2.getString("aboutDialog", "productInfo", stringArray);
                this.aboutDialog.setProduct((Icon)remoteImage, string4, resourceSet.getString("defaultAbout", "productCopyright"), resourceSet.getString("defaultAbout", "productLicense"));
                StringTokenizer stringTokenizer = new StringTokenizer(resourceSet.getString("defaultAbout", "vendorsList"), ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    RemoteImage remoteImage2 = null;
                    try {
                        remoteImage2 = new RemoteImage(resourceSet.getString("defaultAbout", "vendor-" + string5 + "-logo"));
                        remoteImage2.setDescription(resourceSet.getString("defaultAbout", "vendor-" + string5 + "-logo-description"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.aboutDialog.addVendor((Icon)remoteImage2, resourceSet.getString("defaultAbout", "vendor-" + string5 + "-license"));
                }
            }
            this.aboutDialog.show();
        }
        catch (Exception exception) {
            Debug.println((String)("FrameworkInitializer:" + exception));
        }
        UtilConsoleGlobals.getActivatedFrame().setCursor(new Cursor(0));
    }

    private Image getBannerImage(ConsoleInfo consoleInfo) {
        String string = "com/netscape/management/admserv/images/";
        return new RemoteImage(string + "admin52.gif").getImage();
    }

    private String[] getTaskList(TaskPage taskPage) {
        TaskObject taskObject = (TaskObject)taskPage.getModel().getRoot();
        String[] stringArray = new String[taskObject.getChildCount()];
        int n = 0;
        while (n < taskObject.getChildCount()) {
            stringArray[n] = taskObject.getChildAt(n).getClass().getName();
            ++n;
        }
        return stringArray;
    }

    private void setTaskConsoleInfo(TaskPage taskPage, ConsoleInfo consoleInfo) {
        TaskObject taskObject = (TaskObject)taskPage.getModel().getRoot();
        int n = 0;
        while (n < taskObject.getChildCount()) {
            AdminTaskObject adminTaskObject = (AdminTaskObject)((Object)taskObject.getChildAt(n));
            adminTaskObject.setConsoleInfo(new TaskConsoleInfo(adminTaskObject.getConsoleInfo(), consoleInfo));
            ++n;
        }
    }

    private void removeTask(TaskObject taskObject, String string) {
        int n = 0;
        while (n < taskObject.getChildCount()) {
            if (taskObject.getChildAt(n).getClass().getName().endsWith(string)) {
                taskObject.remove(n);
                break;
            }
            ++n;
        }
    }

    private static class TaskConsoleInfo
    extends ConsoleInfo {
        private ConsoleInfo serverNodeConsoleInfo;

        public TaskConsoleInfo(ConsoleInfo consoleInfo, ConsoleInfo consoleInfo2) {
            Enumeration enumeration = consoleInfo.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = consoleInfo.get(k);
                ((Hashtable)((Object)this)).put(k, v);
            }
            this.serverNodeConsoleInfo = consoleInfo2;
        }

        public String getAdminURL() {
            return this.serverNodeConsoleInfo.getAdminURL();
        }
    }
}

