/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.preferences.FilePreferenceManager;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JSS3SocketFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateFactory;
import java.util.Locale;
import javax.swing.JFrame;
import netscape.ldap.LDAPSocketFactory;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.AlreadyInitializedException;

public class UtilConsoleGlobals {
    private static String _adminURL;
    private static String _adminHelpURL;
    private static JFrame _consoleFrame;
    private static JFrame _activatedFrame;
    private static int _windowCount;
    private static JFrame _rootTopologyFrame;
    private static boolean _doServerAuth;
    private static boolean _contextHelp;
    private static LDAPSocketFactory _socketFactory;
    private static CertificateFactory _certFactory;

    public static void setContextHelpEnabled(boolean bl) {
        _contextHelp = bl;
    }

    public static boolean isContextHelpEnabled() {
        return _contextHelp;
    }

    public static void setServerAuthEnabled(boolean bl) {
        _doServerAuth = bl;
    }

    public static boolean isServerAuthEnabled() {
        return _doServerAuth;
    }

    public static LDAPSocketFactory getLDAPSSLSocketFactory() {
        UtilConsoleGlobals.initJSS();
        if (_socketFactory == null) {
            try {
                _socketFactory = new JSS3SocketFactory();
            }
            catch (Exception exception) {
                Debug.println((String)("Unable to create a JSS ldap socket factory " + exception));
            }
        }
        return _socketFactory;
    }

    public static CertificateFactory getX509CertificateFactory() {
        UtilConsoleGlobals.initJSS();
        return _certFactory;
    }

    public static synchronized void initJSS() {
        if (_certFactory != null) {
            return;
        }
        try {
            _certFactory = CertificateFactory.getInstance("X.509", "SUN");
            try {
                String string = FilePreferenceManager.getHomePath();
                CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(string, "", "", "secmod.db");
                initializationValues.installJSSProvider = false;
                initializationValues.removeSunProvider = false;
                CryptoManager.initialize((CryptoManager.InitializationValues)initializationValues);
            }
            catch (AlreadyInitializedException alreadyInitializedException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAdminHelpURL(String string) {
        _adminHelpURL = string;
    }

    public static URL getAdminHelpURL() {
        URL uRL;
        try {
            uRL = new URL(_adminHelpURL);
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println((int)0, (String)("Invalid URL passed to Console.  Exception " + malformedURLException));
            return null;
        }
        return uRL;
    }

    public static void setAdminURL(String string) {
        _adminURL = string;
    }

    public static URL getAdminURL() {
        URL uRL;
        try {
            uRL = new URL(_adminURL);
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println((int)0, (String)("Invalid URL passed to Console.  Exception " + malformedURLException));
            return null;
        }
        return uRL;
    }

    public static void setRootFrame(JFrame jFrame) {
        _consoleFrame = jFrame;
    }

    public static JFrame getRootFrame() {
        return _consoleFrame;
    }

    public static synchronized void setActivatedFrame(JFrame jFrame) {
        _activatedFrame = jFrame;
    }

    public static synchronized JFrame getActivatedFrame() {
        return _activatedFrame;
    }

    public static synchronized void setClosingFrame(JFrame jFrame) {
        if (_activatedFrame == jFrame) {
            _activatedFrame = null;
        }
    }

    public static int getWindowCount() {
        return _windowCount;
    }

    public static int setWindowCount(int n) {
        _windowCount = n;
        return _windowCount;
    }

    public static int incrementWindowCount() {
        return ++_windowCount;
    }

    public static int decrementWindowCount() {
        return --_windowCount;
    }

    public static void setRootTopologyFrame(JFrame jFrame) {
        _rootTopologyFrame = jFrame;
    }

    public static JFrame getRootTopologyFrame() {
        return _rootTopologyFrame;
    }

    public static String getDefaultDialect() {
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        if (string.equals("zh") && locale.getCountry().equals("TW")) {
            string = "zh_TW";
        }
        return string;
    }

    static {
        _windowCount = 0;
        _doServerAuth = false;
        _contextHelp = true;
    }
}

