/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.Framework;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.AbstractServerObject;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.topology.IServerObject;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.topology.NodeDataPanel;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.event.ChangeListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

public abstract class AbstractServerObject
extends ResourceObject
implements IServerObject,
INodeInfo,
SuiConstants {
    public static ResourceSet _resource = TopologyInitializer._resource;
    public static int STATUS_UPDATE_INTERVAL = 15000;
    public static String RESOURCE_GROUP = "ServerObject";
    public static String ID_SERVER_STATUS = "SERVER_STATUS";
    protected ConsoleInfo _consoleInfo;
    protected NodeData[] _nodeData;
    protected NodeData _nameNodeData;
    protected NodeDataPanel _nodeDataPanel;
    protected Hashtable _nodeDataTable = new Hashtable();
    protected IPage _viewInstance;
    protected ResourceObject _nodeObject;
    private boolean _showServerStatus = true;
    private int _serverStatus = 0;
    private long _lastStatusCheckTime;
    private NodeData _statusNodeData;
    private Vector _changeListeners = new Vector();
    private StatusThread _statusThread;
    static String[] _serverDataKey = new String[]{"cn", "serverProductName", "description", "administratorContactInfo", "installationTimeStamp", "serverRoot", "serverHostName"};
    static String[] _productDataKey = new String[]{"nsProductName", "nsVendor", "nsProductVersion", "nsBuildNumber", "nsRevisionNumber", "nsBuildSecurity"};
    static String[] _editableDataKey = new String[]{"serverProductName", "administratorContactInfo", "description"};
    static String[] _7bitDataKey = new String[]{"serverProductName"};
    static String[] _displayDataKey = new String[]{"serverProductName", "description", "installationTimeStamp", "serverRoot", "nsProductName", "nsVendor", "nsProductVersion", "nsBuildNumber", "nsRevisionNumber", "nsBuildSecurity"};
    static String _nodeNameKey = "serverProductName";
    private static KeyAdapter _tmpGrabKey = new /* Unavailable Anonymous Inner Class!! */;
    private static MouseAdapter _tmpGrabMouse = new /* Unavailable Anonymous Inner Class!! */;

    public void initialize(ConsoleInfo consoleInfo) {
        this._consoleInfo = consoleInfo;
        this.initializeNodeDataTable(consoleInfo.getCurrentDN());
        String string = (String)this._nodeDataTable.get(_nodeNameKey);
        if (string == null) {
            this._nodeDataTable.put(_nodeNameKey, (String)this._nodeDataTable.get("cn"));
        }
        this.setName((String)this._nodeDataTable.get(_nodeNameKey));
        Vector vector = this.initializeNodeDataVector(_displayDataKey);
        this._nodeData = new NodeData[vector.size()];
        vector.copyInto(this._nodeData);
    }

    private void initializeNodeDataTable(String string) {
        this.initializeNodeDataTable(string, _serverDataKey);
        this.initializeNodeDataTable(string.substring(string.indexOf(44) + 1), _productDataKey);
    }

    protected Vector initializeNodeDataVector(String[] stringArray) {
        String string;
        String string2;
        Vector<NodeData> vector = new Vector<NodeData>();
        int n = 0;
        while (n < stringArray.length) {
            string2 = stringArray[n];
            string = (String)this._nodeDataTable.get(string2);
            vector.addElement(new NodeData(string2, _resource.getString(RESOURCE_GROUP, string2), (Object)string, this.isEditable(string2), this.is7bit(string2)));
            if (string2.equals(_nodeNameKey)) {
                this._nameNodeData = (NodeData)vector.elementAt(vector.size() - 1);
            }
            ++n;
        }
        if (this._showServerStatus) {
            string2 = _resource.getString(RESOURCE_GROUP, ID_SERVER_STATUS);
            string = AbstractServerObject.getServerStatusString(this._serverStatus);
            this._statusNodeData = new NodeData(ID_SERVER_STATUS, string2, (Object)string);
            vector.addElement(this._statusNodeData);
        }
        return vector;
    }

    int getFontStyle() {
        int n = this._serverStatus == 1 ? 0 : 2;
        return n;
    }

    protected boolean isEditable(String string) {
        int n = 0;
        while (n < _editableDataKey.length) {
            if (_editableDataKey[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean is7bit(String string) {
        int n = 0;
        while (n < _7bitDataKey.length) {
            if (_7bitDataKey[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void initializeNodeDataTable(String string, String[] stringArray) {
        try {
            LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
            LDAPEntry lDAPEntry = lDAPConnection.read(string);
            String string2 = LDAPUtil.getLDAPAttributeLocale();
            int n = 0;
            while (n < stringArray.length) {
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[n], string2);
                if (lDAPAttribute != null) {
                    String string3;
                    if (stringArray[n].equals("installationTimeStamp")) {
                        Enumeration enumeration = lDAPAttribute.getStringValues();
                        string3 = (String)enumeration.nextElement();
                        string3 = LDAPUtil.formatDateTime((String)string3);
                    } else {
                        string3 = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
                    }
                    this._nodeDataTable.put(stringArray[n], string3);
                }
                ++n;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("AbstractServerObject.initializeNodeDataTable: " + (Object)((Object)lDAPException) + " DN=" + string));
        }
    }

    public Component getCustomPanel() {
        this._nodeDataPanel = new NodeDataPanel(this.getIcon(), (String)this._nodeDataTable.get(_nodeNameKey), (INodeInfo)this, true);
        this._nodeDataPanel.setHelpTopic("admin", "topology-servernode");
        return this._nodeDataPanel;
    }

    public int getNodeDataCount() {
        return this._nodeData.length;
    }

    public NodeData getNodeData(int n) {
        return this._nodeData[n];
    }

    public void replaceNodeDataValue(NodeData nodeData) {
        int n = 0;
        while (n < this._nodeData.length) {
            if (this._nodeData[n].getName().equals(nodeData.getName())) {
                this._nodeData[n].setValue(nodeData.getValue());
                return;
            }
            ++n;
        }
    }

    private synchronized void setGrabAllInput(IPage iPage, boolean bl) {
        JFrame jFrame = iPage.getFramework().getJFrame();
        Component component = jFrame.getGlassPane();
        if (bl) {
            component.addKeyListener(_tmpGrabKey);
            component.addMouseListener(_tmpGrabMouse);
            component.setVisible(true);
        } else {
            component.removeKeyListener(_tmpGrabKey);
            component.removeMouseListener(_tmpGrabMouse);
            component.setVisible(false);
        }
    }

    private synchronized void setBusyIndicator(IPage iPage, boolean bl, String string) {
        this.setGrabAllInput(iPage, bl);
        if (!(iPage instanceof ResourcePage)) {
            return;
        }
        ResourcePage resourcePage = (ResourcePage)iPage;
        ResourceModel resourceModel = (ResourceModel)resourcePage.getModel();
        if (bl) {
            ((Framework)iPage.getFramework()).setBusyCursor(true);
            resourceModel.fireChangeStatusItemState(null, "StatusItemText", (Object)string);
            resourceModel.fireChangeStatusItemState(null, "StatusItemProgress", (Object)StatusItemProgress.STATE_BUSY);
        } else {
            ((Framework)iPage.getFramework()).setBusyCursor(false);
            resourceModel.fireChangeStatusItemState(null, "StatusItemText", (Object)string);
            resourceModel.fireChangeStatusItemState(null, "StatusItemProgress", (Object)new Integer(0));
        }
    }

    public void actionNodeDataChanged(NodeData nodeData) {
        this.replaceNodeDataValue(nodeData);
        if (nodeData.getID().equals(NodeDataPanel.ID_OPEN)) {
            if (Debug.timeTraceEnabled()) {
                Debug.println((String)"rsptime", (String)("Open " + this.getName() + " ..."));
            }
            IResourceObject[] iResourceObjectArray = new IResourceObject[]{this};
            if (this._viewInstance instanceof ResourcePage) {
                iResourceObjectArray = ((ResourcePage)this._viewInstance).getSelection();
            }
            ServerRunThread serverRunThread = new ServerRunThread(this, (IResourceObject)this, this._viewInstance, iResourceObjectArray);
            serverRunThread.start();
            return;
        }
        String string = this._consoleInfo.getCurrentDN();
        LDAPAttribute lDAPAttribute = new LDAPAttribute(nodeData.getID(), (String)nodeData.getValue());
        LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
        LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
        try {
            lDAPConnection.modify(string, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 16) {
                try {
                    lDAPModification = new LDAPModification(0, lDAPAttribute);
                    lDAPConnection.modify(string, lDAPModification);
                }
                catch (LDAPException lDAPException2) {
                    Debug.println((String)("AbstractServerObject.actionNodeDataChanged() " + (Object)((Object)lDAPException2)));
                }
            }
            Debug.println((String)("AbstractServerObject.actionNodeDataChanged() " + (Object)((Object)lDAPException)));
        }
        if (nodeData.getID().equals(_nodeNameKey)) {
            ResourcePage resourcePage;
            this._nodeDataPanel.setTitle((String)nodeData.getValue());
            this._nodeDataTable.put(_nodeNameKey, nodeData.getValue());
            this._nameNodeData.setValue(nodeData.getValue());
            this.setName((String)nodeData.getValue());
            if (this._viewInstance != null && this._viewInstance instanceof ResourcePage && (resourcePage = (ResourcePage)this._viewInstance).getTreeModel() instanceof ResourceModel && this._nodeObject != null) {
                this._nodeObject.setName(this.getName());
                ((ResourceModel)resourcePage.getTreeModel()).fireTreeNodeChanged(this._nodeObject);
            }
        }
    }

    public void setNodeObject(ResourceObject resourceObject) {
        this._nodeObject = resourceObject;
        if (this._showServerStatus && this._statusThread == null) {
            Debug.println((int)7, (String)"AbstractServerObject.getCustomPanel():Create status thread");
            this._statusThread = new StatusThread(this);
            this._statusThread.start();
        }
    }

    public ResourceObject getNodeObject() {
        return this._nodeObject;
    }

    protected void setShowServerStatus(boolean bl) {
        this._showServerStatus = bl;
    }

    protected boolean getShowServerStatus() {
        return this._showServerStatus;
    }

    public void unselect(IPage iPage) {
        this._nodeDataPanel = null;
        if (this._statusThread != null) {
            Debug.println((int)7, (String)"AbstractServerObject.unselect: Destroy status thread");
            this._statusThread.halt();
            this._statusThread = null;
        }
    }

    public void select(IPage iPage) {
        super.select(iPage);
        this._viewInstance = iPage;
    }

    public static String getServerStatusString(int n) {
        switch (n) {
            case 0: {
                return _resource.getString("server", "unknown");
            }
            case 1: {
                return _resource.getString("server", "started");
            }
            case 2: {
                return _resource.getString("server", "stopped");
            }
            case 3: {
                return _resource.getString("server", "alert");
            }
            case 4: {
                return _resource.getString("server", "notsupported");
            }
        }
        return "";
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListeners.addElement(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListeners.removeElement(changeListener);
    }

    public abstract boolean run(IPage var1, IResourceObject[] var2);

    public abstract int getServerStatus();

    public abstract void cloneFrom(String var1);

    public boolean isACLEnabled() {
        return true;
    }

    public boolean isCloningEnabled() {
        return true;
    }

    public boolean isMigrationEnabled() {
        return true;
    }

    static /* synthetic */ void access$000(AbstractServerObject abstractServerObject, IPage iPage, boolean bl, String string) {
        abstractServerObject.setBusyIndicator(iPage, bl, string);
    }

    static /* synthetic */ Vector access$100(AbstractServerObject abstractServerObject) {
        return abstractServerObject._changeListeners;
    }

    static /* synthetic */ long access$200(AbstractServerObject abstractServerObject) {
        return abstractServerObject._lastStatusCheckTime;
    }

    static /* synthetic */ int access$302(AbstractServerObject abstractServerObject, int n) {
        abstractServerObject._serverStatus = n;
        return abstractServerObject._serverStatus;
    }

    static /* synthetic */ long access$202(AbstractServerObject abstractServerObject, long l) {
        abstractServerObject._lastStatusCheckTime = l;
        return abstractServerObject._lastStatusCheckTime;
    }

    static /* synthetic */ int access$300(AbstractServerObject abstractServerObject) {
        return abstractServerObject._serverStatus;
    }

    static /* synthetic */ NodeData access$400(AbstractServerObject abstractServerObject) {
        return abstractServerObject._statusNodeData;
    }
}

