/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.util;

import java.util.HashMap;
import java.util.Locale;

public class MapEncoding {
    static HashMap mimeCharsets;
    static HashMap javaEncodings;
    static HashMap localeNames;

    static {
        javaEncodings = new HashMap();
        mimeCharsets = new HashMap();
        localeNames = new HashMap();
        mimeCharsets.put("ANSI_X3.4-1968", "US-ASCII");
        mimeCharsets.put("ISO-IR-6", "US-ASCII");
        mimeCharsets.put("ISO_646.IRV:1991", "US-ASCII");
        mimeCharsets.put("ASCII", "US-ASCII");
        mimeCharsets.put("ISO646-US", "US-ASCII");
        mimeCharsets.put("US-ASCII", "US-ASCII");
        mimeCharsets.put("us", "US-ASCII");
        mimeCharsets.put("IBM367", "US-ASCII");
        mimeCharsets.put("CP367", "US-ASCII");
        mimeCharsets.put("CSASCII", "US-ASCII");
        mimeCharsets.put("US_ASCII", "US-ASCII");
        javaEncodings.put("US-ASCII", "ISO8859_1");
        mimeCharsets.put("ISO-2022-KR", "ISO-2022-KR");
        mimeCharsets.put("CSISO2022KR", "ISO-2022-KR");
        mimeCharsets.put("ISO2022_KR", "ISO-2022-KR");
        javaEncodings.put("ISO-2022-KR", "ISO2022_KR");
        mimeCharsets.put("EUC-KR", "EUC-KR");
        mimeCharsets.put("CSEUCKR", "EUC-KR");
        mimeCharsets.put("EUC_KR", "EUC-KR");
        javaEncodings.put("EUC-KR", "EUC_KR");
        mimeCharsets.put("ISO-2022-JP", "ISO-2022-JP");
        mimeCharsets.put("CSISO2022JP", "ISO-2022-JP");
        mimeCharsets.put("ISO2022_JP", "ISO-2022-JP");
        javaEncodings.put("ISO-2022-JP", "ISO2022JP");
        mimeCharsets.put("ISO-2022-JP-2", "ISO-2022-JP-2");
        mimeCharsets.put("CSISO2022JP2", "ISO-2022-JP-2");
        mimeCharsets.put("ISO2022_JP2", "ISO-2022-JP-2");
        javaEncodings.put("ISO-2022-JP-2", "ISO2022_JP2");
        mimeCharsets.put("ISO_8859-1:1987", "ISO-8859-1");
        mimeCharsets.put("ISO-IR-100", "ISO-8859-1");
        mimeCharsets.put("ISO_8859-1", "ISO-8859-1");
        mimeCharsets.put("ISO-8859-1", "ISO-8859-1");
        mimeCharsets.put("LATIN1", "ISO-8859-1");
        mimeCharsets.put("LATIN-1", "ISO-8859-1");
        mimeCharsets.put("L1", "ISO-8859-1");
        mimeCharsets.put("IBM819", "ISO-8859-1");
        mimeCharsets.put("CP819", "ISO-8859-1");
        mimeCharsets.put("CSISOLATIN1", "ISO-8859-1");
        mimeCharsets.put("ISO8859_1", "ISO-8859-1");
        mimeCharsets.put("ISO8859-1", "ISO-8859-1");
        javaEncodings.put("ISO-8859-1", "ISO8859_1");
        mimeCharsets.put("ISO_8859-2:1987", "ISO-8859-2");
        mimeCharsets.put("ISO-IR-101", "ISO-8859-2");
        mimeCharsets.put("ISO_8859-2", "ISO-8859-2");
        mimeCharsets.put("ISO-8859-2", "ISO-8859-2");
        mimeCharsets.put("LATIN2", "ISO-8859-2");
        mimeCharsets.put("LATIN-2", "ISO-8859-2");
        mimeCharsets.put("L2", "ISO-8859-2");
        mimeCharsets.put("CSISOLATIN2", "ISO-8859-2");
        mimeCharsets.put("ISO8859_2", "ISO-8859-2");
        javaEncodings.put("ISO-8859-2", "ISO8859_2");
        mimeCharsets.put("ISO_8859-3:1988", "ISO-8859-3");
        mimeCharsets.put("ISO-IR-109", "ISO-8859-3");
        mimeCharsets.put("ISO_8859-3", "ISO-8859-3");
        mimeCharsets.put("ISO-8859-3", "ISO-8859-3");
        mimeCharsets.put("LATIN3", "ISO-8859-3");
        mimeCharsets.put("LATIN-3", "ISO-8859-3");
        mimeCharsets.put("L3", "ISO-8859-3");
        mimeCharsets.put("CSISOLATIN3", "ISO-8859-3");
        mimeCharsets.put("ISO8859_3", "ISO-8859-3");
        javaEncodings.put("ISO-8859-3", "ISO8859_3");
        mimeCharsets.put("ISO_8859-4:1988", "ISO-8859-4");
        mimeCharsets.put("ISO-IR-110", "ISO-8859-4");
        mimeCharsets.put("ISO_8859-4", "ISO-8859-4");
        mimeCharsets.put("ISO-8859-4", "ISO-8859-4");
        mimeCharsets.put("LATIN4", "ISO-8859-4");
        mimeCharsets.put("LATIN-4", "ISO-8859-4");
        mimeCharsets.put("L4", "ISO-8859-4");
        mimeCharsets.put("CSISOLATIN4", "ISO-8859-4");
        mimeCharsets.put("ISO8859_4", "ISO-8859-4");
        javaEncodings.put("ISO-8859-4", "ISO8859_4");
        mimeCharsets.put("ISO_8859-5:1988", "ISO-8859-5");
        mimeCharsets.put("ISO-IR-144", "ISO-8859-5");
        mimeCharsets.put("ISO_8859-5", "ISO-8859-5");
        mimeCharsets.put("ISO-8859-5", "ISO-8859-5");
        mimeCharsets.put("CYRILLIC", "ISO-8859-5");
        mimeCharsets.put("CSISOLATINCYRILLIC", "ISO-8859-5");
        mimeCharsets.put("ISO8859_5", "ISO-8859-5");
        javaEncodings.put("ISO-8859-5", "ISO8859_5");
        mimeCharsets.put("ISO_8859-6:1987", "ISO-8859-6");
        mimeCharsets.put("ISO-IR-127", "ISO-8859-6");
        mimeCharsets.put("ISO_8859-6", "ISO-8859-6");
        mimeCharsets.put("ISO-8859-6", "ISO-8859-6");
        mimeCharsets.put("ECMA-114", "ISO-8859-6");
        mimeCharsets.put("ASMO-708", "ISO-8859-6");
        mimeCharsets.put("ARABIC", "ISO-8859-6");
        mimeCharsets.put("CSISOLATINARABIC", "ISO-8859-6");
        mimeCharsets.put("ISO8859_6", "ISO-8859-6");
        javaEncodings.put("ISO-8859-6", "ISO8859_6");
        mimeCharsets.put("ISO_8859-7:1987", "ISO-8859-7");
        mimeCharsets.put("ISO-IR-126", "ISO-8859-7");
        mimeCharsets.put("ISO_8859-7", "ISO-8859-7");
        mimeCharsets.put("ISO-8859-7", "ISO-8859-7");
        mimeCharsets.put("ELOT_928", "ISO-8859-7");
        mimeCharsets.put("ECMA-118", "ISO-8859-7");
        mimeCharsets.put("GREEK", "ISO-8859-7");
        mimeCharsets.put("GREEK8", "ISO-8859-7");
        mimeCharsets.put("CSISOLATINGREEN", "ISO-8859-7");
        mimeCharsets.put("ISO8859_7", "ISO-8859-7");
        javaEncodings.put("ISO-8859-7", "ISO8859_7");
        mimeCharsets.put("ISO_8859-8:1988", "ISO-8859-8");
        mimeCharsets.put("ISO-IR-138", "ISO-8859-8");
        mimeCharsets.put("ISO_8859-8", "ISO-8859-8");
        mimeCharsets.put("ISO-8859-8", "ISO-8859-8");
        mimeCharsets.put("HEBREW", "ISO-8859-8");
        mimeCharsets.put("CSISOLATINHEBREW", "ISO-8859-8");
        mimeCharsets.put("ISO8859_8", "ISO-8859-8");
        javaEncodings.put("ISO-8859-8", "ISO8859_8");
        mimeCharsets.put("ISO_8859-9:1989", "ISO-8859-9");
        mimeCharsets.put("ISO-IR-148", "ISO-8859-9");
        mimeCharsets.put("ISO_8859-9", "ISO-8859-9");
        mimeCharsets.put("ISO-8859-9", "ISO-8859-9");
        mimeCharsets.put("LATIN5", "ISO-8859-9");
        mimeCharsets.put("LATIN-5", "ISO-8859-9");
        mimeCharsets.put("L5", "ISO-8859-9");
        mimeCharsets.put("CSISOLATIN5", "ISO-8859-9");
        mimeCharsets.put("ISO8859_9", "ISO-8859-9");
        javaEncodings.put("ISO-8859-9", "ISO8859_9");
        mimeCharsets.put("UTF-7", "UTF-7");
        mimeCharsets.put("UTF7", "UTF-7");
        javaEncodings.put("UTF-7", "UTF7");
        mimeCharsets.put("UTF-8", "UTF-8");
        mimeCharsets.put("UTF8", "UTF-8");
        javaEncodings.put("UTF-8", "UTF8");
        mimeCharsets.put("UTF-16", "UTF-16");
        mimeCharsets.put("UTF16", "UTF-16");
        javaEncodings.put("UTF-16", "UTF16");
        mimeCharsets.put("JIS-ENCODING", "JIS_Encoding");
        mimeCharsets.put("JIS_ENCODING", "JIS_Encoding");
        mimeCharsets.put("CSJISENCODING", "JIS_Encoding");
        javaEncodings.put("JIS-ENCODING", "JIS_ENCODING");
        mimeCharsets.put("SHIFT-JIS", "Shift_JIS");
        mimeCharsets.put("SHIFT_JIS", "Shift_JIS");
        mimeCharsets.put("CSSHIFTJIS", "Shift_JIS");
        mimeCharsets.put("SJIS", "Shift_JIS");
        javaEncodings.put("Shift_JIS", "SJIS");
        mimeCharsets.put("EUC-JP", "EUC-JP");
        mimeCharsets.put("EUC_JP", "EUC-JP");
        mimeCharsets.put("EUCJP", "EUC-JP");
        javaEncodings.put("EUC-JP", "EUC_JP");
        mimeCharsets.put("GB2312", "GB2312");
        mimeCharsets.put("CSGB2312", "GB2312");
        javaEncodings.put("GB2312", "GB2312");
        mimeCharsets.put("BIG5", "Big5");
        mimeCharsets.put("BIG-5", "Big5");
        mimeCharsets.put("CSBIG5", "Big5");
        javaEncodings.put("Big5", "BIG5");
        mimeCharsets.put("KOI8-R", "KOI8-R");
        mimeCharsets.put("KOI-8-R", "KOI8-R");
        mimeCharsets.put("KOI8_R", "KOI8-R");
        javaEncodings.put("KOI8-R", "KOI8_R");
        mimeCharsets.put("CP1250", "windows-1250");
        mimeCharsets.put("WINDOWS-1250", "windows-1250");
        javaEncodings.put("windows-1250", "Cp1250");
        mimeCharsets.put("CP1251", "windows-1251");
        mimeCharsets.put("WINDOWS-1251", "windows-1251");
        javaEncodings.put("windows-1251", "Cp1251");
        mimeCharsets.put("CP1252", "windows-1252");
        mimeCharsets.put("WINDOWS-1252", "windows-1252");
        javaEncodings.put("windows-1252", "Cp1252");
        mimeCharsets.put("CP1253", "windows-1253");
        mimeCharsets.put("WINDOWS-1253", "windows-1253");
        javaEncodings.put("windows-1253", "Cp1253");
        mimeCharsets.put("CP1254", "windows-1254");
        mimeCharsets.put("WINDOWS-1254", "windows-1254");
        javaEncodings.put("windows-1254", "Cp1254");
        mimeCharsets.put("CP1255", "windows-1255");
        mimeCharsets.put("WINDOWS-1255", "windows-1255");
        javaEncodings.put("windows-1255", "Cp1255");
        mimeCharsets.put("CP1256", "windows-1256");
        mimeCharsets.put("WINDOWS-1256", "windows-1256");
        javaEncodings.put("windows-1256", "Cp1256");
        mimeCharsets.put("CP1257", "windows-1257");
        mimeCharsets.put("WINDOWS-1257", "windows-1257");
        javaEncodings.put("windows-1257", "Cp1257");
        mimeCharsets.put("CP1258", "windows-1258");
        mimeCharsets.put("WINDOWS-1258", "windows-1258");
        javaEncodings.put("windows-1258", "Cp1258");
        localeNames = new HashMap();
        localeNames.put("af", "ISO-8859-1");
        localeNames.put("sq", "ISO-8859-1");
        localeNames.put("ar", "ISO-8859-6");
        localeNames.put("eu", "ISO-8859-1");
        localeNames.put("bg", "ISO-8859-5");
        localeNames.put("be", "ISO-8859-5");
        localeNames.put("ca", "ISO-8859-1");
        localeNames.put("hr", "ISO-8859-2");
        localeNames.put("cs", "ISO-8859-2");
        localeNames.put("da", "ISO-8859-1");
        localeNames.put("nl", "ISO-8859-1");
        localeNames.put("en", "ISO-8859-1");
        localeNames.put("eo", "ISO-8859-3");
        localeNames.put("et", "ISO-8859-10");
        localeNames.put("fo", "ISO-8859-1");
        localeNames.put("fi", "ISO-8859-1");
        localeNames.put("fr", "ISO-8859-1");
        localeNames.put("gl", "ISO-8859-1");
        localeNames.put("de", "ISO-8859-1");
        localeNames.put("el", "ISO-8859-7");
        localeNames.put("iw", "ISO-8859-8");
        localeNames.put("hu", "ISO-8859-2");
        localeNames.put("is", "ISO-8859-1");
        localeNames.put("ga", "ISO-8859-1");
        localeNames.put("it", "ISO-8859-1");
        localeNames.put("lv", "ISO-8859-10");
        localeNames.put("lt", "ISO-8859-10");
        localeNames.put("mk", "ISO-8859-5");
        localeNames.put("mt", "ISO-8859-3");
        localeNames.put("no", "ISO-8859-1");
        localeNames.put("pl", "ISO-8859-2");
        localeNames.put("pt", "ISO-8859-1");
        localeNames.put("ro", "ISO-8859-2");
        localeNames.put("ru", "KOI8-R");
        localeNames.put("gd", "ISO-8859-1");
        localeNames.put("sr", "ISO-8859-5");
        localeNames.put("sk", "ISO-8859-2");
        localeNames.put("sl", "ISO-8859-2");
        localeNames.put("es", "ISO-8859-1");
        localeNames.put("sv", "ISO-8859-1");
        localeNames.put("tr", "ISO-8859-9");
        localeNames.put("uk", "ISO-8859-5");
        localeNames.put("ja", "Shift_JIS");
        localeNames.put("ko", "EUC-KR");
        localeNames.put("zh", "GB2312");
        localeNames.put("zh_TW", "Big5");
    }

    private MapEncoding() {
    }

    public static String getDefaultJavaEncoding() {
        return MapEncoding.getJavaEncoding(MapEncoding.getMimeCharset(Locale.getDefault()));
    }

    public static String getJavaEncoding(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toUpperCase();
        String string3 = (String)mimeCharsets.get(string2);
        if (string3 != null) {
            string3 = (String)javaEncodings.get(string3);
        }
        return string3;
    }

    public static String getMimeCharset(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toUpperCase();
        String string3 = (String)mimeCharsets.get(string2);
        return string3;
    }

    public static String getMimeCharset(Locale locale) {
        if (locale == null) {
            return null;
        }
        String string = (String)localeNames.get(locale.toString());
        if (string == null) {
            string = (String)localeNames.get(locale.getLanguage());
        }
        return string;
    }

    public static String parseCharset(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        while ((n = string2.indexOf(59)) >= 0 && n < string2.length()) {
            char c;
            ++n;
            while (n < string2.length() && ((c = string2.charAt(n)) == ' ' || c == '\t')) {
                ++n;
            }
            if (n >= string2.length()) {
                return null;
            }
            if ((n = (string2 = string2.substring(n)).indexOf(61)) >= 0) {
                if (!string2.startsWith("charset")) continue;
                ++n;
                while (n < string2.length() && ((c = string2.charAt(n)) == ' ' || c == '\t')) {
                    ++n;
                }
                string2 = string2.substring(n);
            }
            n = 0;
            while (n < string2.length() && (c = string2.charAt(n)) != ';' && c != ' ') {
                ++n;
            }
            return string2.substring(0, n);
        }
        return null;
    }
}

