/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.server.http.session;

import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import com.iplanet.server.http.util.misc.ResourcePool;
import com.netscape.server.http.session.JdbcSession;
import com.netscape.server.http.session.NSHttpSessionContext;
import com.netscape.server.http.session.NSHttpSessionManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.servlet.http.HttpSession;

public class JdbcSessionManager
extends NSHttpSessionManager {
    private static NSHttpSessionContext _ctx = new NSHttpSessionContext();
    private int _timeOut = 1800;
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private Connection _connection;
    private static final String prop_timeOut = "timeOut";
    private static final String prop_jdbcDriver = "provider";
    private static final String prop_jdbcUrl = "url";
    private static final String prop_tableName = "table";
    private static final String prop_username = "username";
    private static final String prop_password = "password";
    private static final String prop_reaperActive = "reaperActive";
    private static final String prop_accessTimeCol = "accessTimeColumn";
    private static final String prop_sessionIdCol = "sessionIdColumn";
    private static final String prop_valueCol = "valueColumn";
    private static final String prop_lookupPool = "lookupPool";
    private static final String prop_insertPool = "insertPool";
    private static final String prop_updatePool = "updatePool";
    private static final String prop_deletePool = "deletePool";
    private int _lookupPoolSize = 4;
    private int _insertPoolSize = 4;
    private int _updatePoolSize = 4;
    private int _deletePoolSize = 2;
    private String _username = null;
    private String _password = null;
    private String _jdbcDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
    private String _jdbcUrl = "jdbc:odbc:LocalServer";
    private StatementsPool _stmt_lookup;
    private StatementsPool _stmt_insert;
    private StatementsPool _stmt_update;
    private StatementsPool _stmt_delete;
    private PreparedStatement _stmt_reaper;
    private String _table = "sessions";
    private String _accessTimeCol = "AccessTime";
    private String _sessionIdCol = "SessionID";
    private String _valueCol = "Value";
    private boolean _initialized = false;
    private boolean _reaper_active = true;

    public HttpSession createSession(String string) {
        if (!this._initialized) {
            return null;
        }
        JdbcSession jdbcSession = new JdbcSession(string, this._timeOut, this, null, _res);
        jdbcSession.setNew();
        PreparedStatement preparedStatement = null;
        try {
            try {
                int n = (int)(jdbcSession.getLastAccessedTime() / 60000L);
                preparedStatement = this._stmt_insert.acquireStatement();
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, n);
                preparedStatement.setBytes(3, this.storeObject(jdbcSession.pack()));
                int n2 = preparedStatement.executeUpdate();
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("JdbcSessionManager.createSession (): id = " + string + ", executeUpdate = " + n2));
                }
                if (n2 == 0) {
                    jdbcSession = (JdbcSession)this.getSession(string);
                }
            }
            catch (SQLException sQLException) {
                LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_exceptionThrown", (Object)"createSession ()", (Object)string, (Object)sQLException));
            }
            Object var5_7 = null;
            if (preparedStatement != null) {
                this._stmt_insert.release(preparedStatement);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (preparedStatement != null) {
                this._stmt_insert.release(preparedStatement);
            }
            throw throwable;
        }
        return jdbcSession;
    }

    public void deleteSession(HttpSession httpSession) {
        if (!this._initialized || httpSession == null) {
            return;
        }
        JdbcSession jdbcSession = (JdbcSession)httpSession;
        String string = jdbcSession.getIdWithoutExceptions();
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = this._stmt_delete.acquireStatement();
                preparedStatement.setString(1, string);
                int n = preparedStatement.executeUpdate();
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("JdbcSessionManager.deleteSession(): id = " + string + ", executeUpdate = " + n));
                }
            }
            catch (SQLException sQLException) {
                LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_exceptionThrown", (Object)"deleteSession ()", (Object)string, (Object)sQLException));
            }
            Object var6_7 = null;
            if (preparedStatement != null) {
                this._stmt_delete.release(preparedStatement);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (preparedStatement != null) {
                this._stmt_delete.release(preparedStatement);
            }
            throw throwable;
        }
    }

    public String generateSID() {
        return super.generateSID();
    }

    public NSHttpSessionContext getContext() {
        return _ctx;
    }

    public int getDefaultTimeOut() {
        return this._timeOut;
    }

    public HttpSession getSession(String string) {
        JdbcSession jdbcSession = null;
        if (this._initialized && string != null) {
            PreparedStatement preparedStatement = null;
            try {
                try {
                    byte[] byArray;
                    preparedStatement = this._stmt_lookup.acquireStatement();
                    preparedStatement.setString(1, string);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next() && (byArray = resultSet.getBytes(1)) != null) {
                        jdbcSession = new JdbcSession(string, this._timeOut, this, this.unpackObject(byArray), _res);
                        jdbcSession.unsetNew();
                    }
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    jdbcSession = null;
                    LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_exceptionThrown", (Object)"getSession()", (Object)string, (Object)sQLException));
                }
                Object var5_7 = null;
                if (preparedStatement != null) {
                    this._stmt_lookup.release(preparedStatement);
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (preparedStatement != null) {
                    this._stmt_lookup.release(preparedStatement);
                }
                throw throwable;
            }
        }
        return jdbcSession;
    }

    public void init(Properties properties) {
        if (properties != null) {
            int n;
            String string = properties.getProperty(prop_timeOut);
            if (string != null) {
                try {
                    this._timeOut = Integer.parseInt(string);
                    if (this._timeOut < 0) {
                        this._timeOut = -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_timeoutNotValid", (Object)string));
                }
            }
            if ((string = properties.getProperty(prop_lookupPool)) != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n < 1 || n > 100) {
                        LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_poolNotValid", (Object)prop_lookupPool));
                    } else {
                        this._lookupPoolSize = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_poolNotValid", (Object)prop_lookupPool));
                }
            }
            if ((string = properties.getProperty(prop_updatePool)) != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n < 1 || n > 100) {
                        LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_poolNotValid", (Object)prop_updatePool));
                    } else {
                        this._updatePoolSize = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_poolNotValid", (Object)prop_updatePool));
                }
            }
            if ((string = properties.getProperty(prop_insertPool)) != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n < 1 || n > 100) {
                        LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_poolNotValid", (Object)prop_insertPool));
                    } else {
                        this._insertPoolSize = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_poolNotValid", (Object)prop_insertPool));
                }
            }
            if ((string = properties.getProperty(prop_deletePool)) != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n < 1 || n > 100) {
                        LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_poolNotValid", (Object)prop_deletePool));
                    } else {
                        this._deletePoolSize = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_poolNotValid", (Object)prop_deletePool));
                }
            }
            if ((string = properties.getProperty(prop_jdbcDriver)) != null) {
                this._jdbcDriver = string;
            }
            if ((string = properties.getProperty(prop_jdbcUrl)) != null) {
                this._jdbcUrl = string;
            }
            this._username = properties.getProperty(prop_username);
            this._password = properties.getProperty(prop_password);
            string = properties.getProperty(prop_tableName);
            if (string != null) {
                this._table = string;
            }
            if ((string = properties.getProperty(prop_accessTimeCol)) != null) {
                this._accessTimeCol = string;
            }
            if ((string = properties.getProperty(prop_sessionIdCol)) != null) {
                this._sessionIdCol = string;
            }
            if ((string = properties.getProperty(prop_valueCol)) != null) {
                this._valueCol = string;
            }
            if ((string = properties.getProperty(prop_reaperActive)) != null) {
                this._reaper_active = Boolean.valueOf(string);
            }
        }
        try {
            Class.forName(this._jdbcDriver);
            this._connection = DriverManager.getConnection(this._jdbcUrl, this._username, this._password);
            this._connection.setAutoCommit(true);
            this._stmt_lookup = new StatementsPool(this._lookupPoolSize, "SELECT " + this._valueCol + " FROM " + this._table + " WHERE " + this._sessionIdCol + " = ?");
            this._stmt_delete = new StatementsPool(this._deletePoolSize, "DELETE FROM " + this._table + " WHERE " + this._sessionIdCol + " = ?");
            this._stmt_update = new StatementsPool(this._updatePoolSize, "UPDATE " + this._table + " SET " + this._accessTimeCol + " = ?, " + this._valueCol + " = ? WHERE " + this._sessionIdCol + " = ?");
            this._stmt_insert = new StatementsPool(this._insertPoolSize, "INSERT INTO " + this._table + " (" + this._sessionIdCol + "," + this._accessTimeCol + "," + this._valueCol + ") VALUES (?,?,?)");
            this._stmt_reaper = this._connection.prepareStatement("DELETE FROM " + this._table + " WHERE " + this._accessTimeCol + " <= ? AND (" + this._sessionIdCol + " NOT LIKE '" + "NSContextSession1.0" + "%')");
            this._initialized = true;
            LogUtil.logInfo((String)_res.getProp("session.JdbcSessionManager.msg_jdbcSessionManagerInit", (Object)new Integer(this._timeOut), (Object)this._jdbcUrl, (Object)this._jdbcDriver));
        }
        catch (Exception exception) {
            LogUtil.logFailure((String)_res.getProp("session.JdbcSessionManager.msg_jdbcSessionManagerFailed", (Object)exception));
        }
    }

    public synchronized void reaper() {
        block3: {
            if (!this._initialized || !this._reaper_active) break block3;
            try {
                int n = (int)((System.currentTimeMillis() - (long)this._timeOut * 1000L) / 60000L);
                this._stmt_reaper.setInt(1, n);
                int n2 = this._stmt_reaper.executeUpdate();
                if (n2 > 0) {
                    LogUtil.logInfo((String)_res.getProp("session.JdbcSessionManager.msg_sessionsReaped", (Object)new Integer(n2)));
                }
            }
            catch (SQLException sQLException) {
                LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_exceptionThrown", (Object)"reaper()", (Object)"none", (Object)sQLException));
            }
        }
    }

    private byte[] storeObject(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        byte[] byArray = null;
        try {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_unable2Store", (Object)exception));
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                    objectOutputStream = null;
                }
            }
            catch (IOException iOException) {}
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (objectOutputStream != null) {
                objectOutputStream.close();
                objectOutputStream = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
            }
        }
        catch (IOException iOException) {}
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object unpackObject(byte[] byArray) {
        ObjectInputStream objectInputStream;
        ByteArrayInputStream byteArrayInputStream;
        Object object;
        block17: {
            Object var5_5;
            block16: {
                object = null;
                byteArrayInputStream = null;
                objectInputStream = null;
                try {
                    try {
                        if (byArray == null || byArray.length <= 0) {
                            var5_5 = null;
                            Object var7_6 = null;
                            break block16;
                        }
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        object = objectInputStream.readObject();
                    }
                    catch (Exception exception) {
                        object = null;
                        LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_unable2Retrieve", (Object)exception));
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                            objectInputStream = null;
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (byteArrayInputStream == null) throw throwable;
                        byteArrayInputStream.close();
                        byteArrayInputStream = null;
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            if (objectInputStream != null) {
                objectInputStream.close();
                objectInputStream = null;
            }
            try {}
            catch (IOException iOException) {}
            if (byteArrayInputStream == null) return var5_5;
            byteArrayInputStream.close();
            return var5_5;
        }
        Object var7_7 = null;
        try {}
        catch (IOException iOException) {}
        if (objectInputStream != null) {
            objectInputStream.close();
            objectInputStream = null;
        }
        try {}
        catch (IOException iOException) {
            return object;
        }
        if (byteArrayInputStream == null) return object;
        byteArrayInputStream.close();
        byteArrayInputStream = null;
        return object;
    }

    public void update(HttpSession httpSession) {
        if (!this._initialized) {
            return;
        }
        JdbcSession jdbcSession = (JdbcSession)httpSession;
        jdbcSession.unsetNew();
        int n = (int)(System.currentTimeMillis() / 60000L);
        byte[] byArray = this.storeObject(jdbcSession.pack());
        String string = jdbcSession.getIdWithoutExceptions();
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        try {
            block15: {
                try {
                    preparedStatement2 = this._stmt_update.acquireStatement();
                    preparedStatement2.setInt(1, n);
                    preparedStatement2.setBytes(2, byArray);
                    preparedStatement2.setString(3, string);
                    int n2 = preparedStatement2.executeUpdate();
                    if (LogUtil.enableTrace) {
                        LogUtil.TRACE((int)5, (String)("JdbcSessionManager.update(): id = " + string + ", _stmt_update.executeUpdate = " + n2));
                    }
                    if (n2 != 0) break block15;
                    try {
                        try {
                            preparedStatement = this._stmt_insert.acquireStatement();
                            preparedStatement.setString(1, string);
                            preparedStatement.setInt(2, n);
                            preparedStatement.setBytes(3, byArray);
                            n2 = preparedStatement.executeUpdate();
                            if (LogUtil.enableTrace) {
                                LogUtil.TRACE((int)5, (String)("JdbcSessionManager.update(): id = " + string + ", _stmt_insert.executeUpdate = " + n2));
                            }
                        }
                        catch (SQLException sQLException) {
                            LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_exceptionThrown", (Object)"update()/insert", (Object)string, (Object)sQLException));
                        }
                        Object var12_11 = null;
                        if (preparedStatement != null) {
                            this._stmt_insert.release(preparedStatement);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        if (preparedStatement != null) {
                            this._stmt_insert.release(preparedStatement);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException sQLException) {
                    LogUtil.logWarning((String)_res.getProp("session.JdbcSessionManager.msg_exceptionThrown", (Object)"update()", (Object)string, (Object)sQLException));
                }
            }
            Object var9_14 = null;
            if (preparedStatement2 != null) {
                this._stmt_update.release(preparedStatement2);
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (preparedStatement2 != null) {
                this._stmt_update.release(preparedStatement2);
            }
            throw throwable;
        }
    }

    private class StatementsPool
    extends ResourcePool {
        StatementsPool(int n, String string) throws SQLException {
            super(n);
            int n2 = 0;
            while (n2 < n) {
                Connection connection = DriverManager.getConnection(JdbcSessionManager.this._jdbcUrl, JdbcSessionManager.this._username, JdbcSessionManager.this._password);
                connection.setAutoCommit(true);
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                this.release(preparedStatement);
                ++n2;
            }
        }

        public PreparedStatement acquireStatement() {
            return (PreparedStatement)super.acquire();
        }

        public void release(PreparedStatement preparedStatement) {
            super.release((Object)preparedStatement);
        }
    }
}

