/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.session;

import com.iplanet.server.http.session.IWSHttpSession;
import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.session.SessionDataStore;
import com.iplanet.server.http.util.CfgUtil;
import com.iplanet.server.http.util.LockManager;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class IWSSessionManager
extends IWSHttpSessionManager {
    private int _timeOut = 1800;
    private Hashtable _sessions = new Hashtable();
    private int _maxSessions = 1000;
    private boolean _failoverEnabled = false;
    private boolean _initialized = false;
    private int _reapCount = 0;
    private SessionDataStore _store = null;
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private static boolean _multiProcessMode = CfgUtil.isSingleProcess() ^ true;
    private static final String DEFAULT_STORE_CLASS = "com.iplanet.server.http.session.FileStore";
    private LockManager _mpLockMgr = null;
    private LockManager _mpStoreLockMgr = null;

    public void close() {
        if (this._initialized) {
            super.close();
            if (this._store != null) {
                if (_multiProcessMode) {
                    this._mpStoreLockMgr.lock("store");
                }
                this._store.reap(System.currentTimeMillis());
                if (_multiProcessMode) {
                    this._mpStoreLockMgr.unlock("store");
                }
            }
            if (_multiProcessMode) {
                if (this._mpLockMgr != null) {
                    this._mpLockMgr.destroy();
                }
                if (this._mpStoreLockMgr != null) {
                    this._mpStoreLockMgr.destroy();
                }
            }
        }
    }

    public HttpSession createSession(String string) {
        return this.createSession(string, null);
    }

    public HttpSession createSession(String string, ServletContext servletContext) {
        if (!this._initialized) {
            return null;
        }
        String string2 = null;
        if (_multiProcessMode) {
            string2 = IWSHttpSession.getMangledString(string);
            this.lock(string2);
        }
        IWSHttpSession iWSHttpSession = new IWSHttpSession(string, this._timeOut, this, servletContext);
        iWSHttpSession.setNew();
        if (this._sessions.size() <= this._maxSessions) {
            if (!this._failoverEnabled) {
                this._sessions.put(string, iWSHttpSession);
            }
        } else {
            Integer n = new Integer(this._maxSessions);
            LogUtil.logInfo((String)_res.getProp("session.IWSSessionManager.msg_TooManySessions", (Object)n));
            iWSHttpSession = null;
        }
        if (this._store != null && iWSHttpSession != null) {
            this._store.save(iWSHttpSession);
        }
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)7, (String)("IWSSessionManager: newSession " + string));
        }
        if (iWSHttpSession == null) {
            this.unlock(string2);
        }
        return iWSHttpSession;
    }

    public void deleteSession(HttpSession httpSession) {
        if (!this._initialized || httpSession == null) {
            return;
        }
        if (httpSession instanceof IWSHttpSession) {
            IWSHttpSession iWSHttpSession = (IWSHttpSession)httpSession;
            iWSHttpSession.removeAllObjects();
            if (this._store != null) {
                this._store.remove(iWSHttpSession);
            }
            String string = iWSHttpSession.getId();
            if (!this._failoverEnabled) {
                this._sessions.remove(string);
            }
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)7, (String)("IWSSessionManager: deleteSession " + string));
            }
            iWSHttpSession.close();
        }
    }

    public int getDefaultTimeOut() {
        return this._timeOut;
    }

    public int getMaxSession() {
        return this._maxSessions;
    }

    public HttpSession getSession(String string) {
        return this.getSession(string, null);
    }

    public HttpSession getSession(String string, ServletContext servletContext) {
        IWSHttpSession iWSHttpSession = null;
        boolean bl = false;
        if (this._initialized && string != null) {
            IWSHttpSession iWSHttpSession2;
            String string2 = null;
            if (_multiProcessMode) {
                string2 = IWSHttpSession.getMangledString(string);
                this.lock(string2);
            }
            if (!this._failoverEnabled) {
                iWSHttpSession = (IWSHttpSession)this._sessions.get(string);
            }
            if (iWSHttpSession == null) {
                bl = true;
            }
            if (this._store != null && (this._failoverEnabled || bl) && (iWSHttpSession = this._store.load(iWSHttpSession2 = new IWSHttpSession(string, this._timeOut, this, servletContext))) != null) {
                iWSHttpSession.setIWSContext(this, servletContext);
                if (!this._failoverEnabled) {
                    this._sessions.put(string, iWSHttpSession);
                }
            }
            if (iWSHttpSession != null) {
                iWSHttpSession.updateAccessTime();
                iWSHttpSession.unsetNew();
                if (iWSHttpSession._isInvalid()) {
                    this.deleteSession(iWSHttpSession);
                    iWSHttpSession = null;
                }
            }
            if (iWSHttpSession == null) {
                this.unlock(string2);
                this.reaped(string2);
            }
        }
        return iWSHttpSession;
    }

    public int getSessionCount() {
        return this._sessions.size();
    }

    public int getSessionReapCount() {
        return this._reapCount;
    }

    protected boolean hasPersistence() {
        return this._store != null;
    }

    public void init(Properties properties) {
        block21: {
            if (properties == null && !this._initialized) break block21;
            String string = properties.getProperty("timeOut");
            if (string != null) {
                try {
                    this._timeOut = Integer.parseInt(string);
                    if (this._timeOut < 0) {
                        this._timeOut = -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.IWSSessionManager.msg_timeoutNotValid", (Object)string));
                }
            }
            if ((string = properties.getProperty("maxSessions")) != null) {
                try {
                    this._maxSessions = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.IWSSessionManager.msg_maxSessionsNotValid ", (Object)string));
                }
            }
            Integer n = new Integer(this._maxSessions);
            LogUtil.logInfo((String)_res.getProp("session.IWSSessionManager.msg_Settings", (Object)n));
            this._initialized = true;
            string = properties.getProperty("session-failover-enabled");
            if (string != null) {
                this._failoverEnabled = Boolean.valueOf(string);
            }
            if (_multiProcessMode) {
                LogUtil.logInfo((String)_res.getProp("session.IWSSessionManager.msg_mpMode"));
                if (!this._failoverEnabled) {
                    this._failoverEnabled = true;
                }
                if ((string = properties.getProperty("session-context-name")) == null) {
                    string = "default-iwssessionmanager";
                }
                int n2 = 10;
                String string2 = properties.getProperty("maxLocks");
                if (string2 != null) {
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LogUtil.logWarning((String)_res.getProp("session.IWSSessionManager.msg_maxLocksNotValid ", (Object)new Integer(10)));
                    }
                }
                this._mpLockMgr = new LockManager(string, n2);
                StringBuffer stringBuffer = new StringBuffer(string).append("_store");
                this._mpStoreLockMgr = new LockManager(stringBuffer.toString(), 1);
            }
            if ((string = properties.getProperty("session-data-store")) == null && _multiProcessMode) {
                string = DEFAULT_STORE_CLASS;
            }
            if (string != null) {
                try {
                    this._store = (SessionDataStore)Class.forName(string).newInstance();
                    this._store.setManager(this);
                    if (_multiProcessMode) {
                        this._mpStoreLockMgr.lock("store");
                    }
                    if (!this._store.init(properties)) {
                        this._initialized = false;
                    }
                    if (_multiProcessMode) {
                        this._mpStoreLockMgr.unlock("store");
                    }
                }
                catch (Exception exception) {
                    LogUtil.logInfo((String)_res.getProp("session.IWSSessionManager.msg_BadClass", (Object)LogUtil.getStackTrace((Throwable)exception)));
                    this._initialized = false;
                }
            }
        }
    }

    protected boolean lock(String string) {
        boolean bl = false;
        if (_multiProcessMode && this._mpLockMgr != null && string != null) {
            bl = this._mpLockMgr.lock(string);
        }
        return bl;
    }

    protected void reaped(String string) {
        if (_multiProcessMode && this._mpLockMgr != null && string != null) {
            this._mpLockMgr.remove(string);
        }
    }

    public synchronized void reaper() {
        Object object;
        if (!this._initialized) {
            return;
        }
        Object object2 = null;
        int n = 0;
        int n2 = 0;
        long l = System.currentTimeMillis();
        if (!this._failoverEnabled && (object = this._sessions.elements()) != null) {
            while (object.hasMoreElements()) {
                IWSHttpSession iWSHttpSession = (IWSHttpSession)object.nextElement();
                if (iWSHttpSession.isInvalid(l)) {
                    ++this._reapCount;
                    if (object2 == null) {
                        object2 = iWSHttpSession.getServletContext();
                    }
                    this.deleteSession(iWSHttpSession);
                    iWSHttpSession = null;
                    ++n;
                    continue;
                }
                ++n2;
            }
        }
        if (this._store != null) {
            if (_multiProcessMode) {
                this._mpStoreLockMgr.lock("store");
            }
            this._store.reap(l);
            if (_multiProcessMode) {
                this._mpStoreLockMgr.unlock("store");
            }
        }
        if (n > 0 && LogUtil.enableTrace) {
            object = object2 != null ? object2.toString() : "";
            int n3 = 0;
            if (this.getHandleFormLoginSessions()) {
                n3 = n2;
            }
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)5, (String)("session reaper stats: " + (String)object + " number of live sessions = " + n2 + ", number of sessions expired/total = " + n + "/" + this._reapCount + ", number of live form-login sessions = " + n3));
            }
        }
    }

    protected boolean unlock(String string) {
        boolean bl = false;
        if (_multiProcessMode && this._mpLockMgr != null && string != null) {
            bl = this._mpLockMgr.unlock(string);
        }
        return bl;
    }

    public void update(HttpSession httpSession) {
        if (!this._initialized) {
            return;
        }
        if (httpSession instanceof IWSHttpSession) {
            IWSHttpSession iWSHttpSession = (IWSHttpSession)httpSession;
            if (iWSHttpSession.isValid()) {
                iWSHttpSession.unsetNew();
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)7, (String)("IWSSessionManager: update " + iWSHttpSession.getId()));
                }
                if (this._store != null) {
                    this._store.save(iWSHttpSession);
                }
            }
            if (_multiProcessMode) {
                this.unlock(iWSHttpSession.getMangledId());
            }
        }
    }
}

