/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSAXErrorHandler
implements ErrorHandler {
    static final int PARSER_ERROR_CHECKING_DISABLED = 0;
    static final int CHECK_PARSER_WARNINGS = 1;
    static final int CHECK_PARSER_ERRORS = 2;
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    static int errorChecking = 2;
    static int warnings;
    static int errors;
    static String _vsID;
    private static WSAXErrorHandler staticHandler;

    static {
        staticHandler = new WSAXErrorHandler();
    }

    private WSAXErrorHandler() {
    }

    public void checkParserErrors() throws Exception {
        if (errorChecking == 1 && warnings != 0 || errorChecking == 2 && errors != 0) {
            throw new Exception(_res.getProp("servlet.WSAXErrorHandler.msg_ParserErrors"));
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (errorChecking < 2) {
            return;
        }
        ++errors;
        LogUtil.logWarning((String)_vsID, (String)_res.getProp("servlet.WSAXErrorHandle.msg_SAXParserError", (Object)sAXParseException.getMessage(), (Object)sAXParseException.getSystemId(), (Object)new Integer(sAXParseException.getLineNumber())));
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        LogUtil.logFailure((String)_vsID, (String)_res.getProp("servlet.WSAXErrorHandler.msg_SAXParserFatalError", (Object)sAXParseException.getMessage(), (Object)sAXParseException.getSystemId(), (Object)new Integer(sAXParseException.getLineNumber())));
    }

    static WSAXErrorHandler getErrorHandler(String string) {
        _vsID = string;
        warnings = 0;
        errors = 0;
        return staticHandler;
    }

    void reset() {
        _vsID = null;
        errors = 0;
        warnings = 0;
    }

    static void setErrorChecking(String string) {
        if (string == null) {
            return;
        }
        try {
            errorChecking = Integer.parseInt(string);
        }
        catch (Exception exception) {}
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (errorChecking < 1) {
            return;
        }
        ++warnings;
        LogUtil.logInfo((String)_vsID, (String)_res.getProp("servlet.WSAXErrorHandler.msg_SAXParserWarning", (Object)sAXParseException.getMessage(), (Object)sAXParseException.getSystemId(), (Object)new Integer(sAXParseException.getLineNumber())));
    }
}

