/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.IWSWebContainerSupport;
import com.iplanet.server.http.servlet.NSServletInputStream;
import com.iplanet.server.http.servlet.NSServletRunner;
import com.iplanet.server.http.servlet.NSServletSession;
import com.iplanet.server.http.servlet.RequestParameterCache;
import com.iplanet.server.http.servlet.WServletContext;
import com.iplanet.server.http.util.CertUtil;
import com.iplanet.server.http.util.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;

public class NSServletRequest
implements ServletRequest,
IWSWebContainerSupport {
    public static final String IWS_REQUEST_PARAMETER_ENCODING = "com.iplanet.server.http.servlet.parameterEncoding";
    protected NSServletSession _session;
    protected WServletContext _context;
    private NSServletInputStream _inputStream = null;
    private BufferedReader _bufferedreader = null;
    private Hashtable _attrs = new Hashtable();
    private Vector _locales = null;
    protected int nestCounter = 0;
    private String _characterEncoding = null;
    private boolean _characterEncodingParsed = false;
    private static final int PARAM_ENC_AUTO = 1;
    private static final int PARAM_ENC_RESPONSE_CT = 2;
    private static final int PARAM_ENC_NONE = 3;
    private static final int PARAM_ENC_CONFIGURED = 4;
    private int _paramEncodingMode = 1;
    private String _configParamEncoding;
    protected RequestParameterCache _paramCache;
    private boolean _isSecure;

    public NSServletRequest(WServletContext wServletContext, NSServletSession nSServletSession) {
        this._context = wServletContext;
        this._session = nSServletSession;
        this._isSecure = this._session.isSecure();
        if (this._isSecure) {
            this.setSSLAttributes();
        }
        this._attrs.put("com.iplanet.server.http.servlet.web_container_support", this);
        String string = this._context.getParameterEncoding();
        if (string == null || string.equals("auto")) {
            this._paramEncodingMode = 1;
        } else if (string.equals("responseCT")) {
            this._paramEncodingMode = 2;
        } else if (string.equals("none")) {
            this._paramEncodingMode = 3;
        } else {
            this._paramEncodingMode = 4;
            this._configParamEncoding = string.equalsIgnoreCase("utf8") ? "UTF-8" : string;
        }
    }

    private String checkParameterEncodingHints() {
        String string = (String)this.getAttribute(IWS_REQUEST_PARAMETER_ENCODING);
        if (string != null) {
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)5, (String)("hint from request attribute: " + string));
            }
            return string;
        }
        byte[] byArray = this._session.getParameterBytes(this._context.getFormEncodingHint());
        if (byArray != null) {
            try {
                string = new String(byArray, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            if (string != null) {
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("hint from j_encoding param: " + string));
                }
                return string;
            }
        }
        return null;
    }

    public boolean checkRecursionDepth() {
        return NSServletRunner.maxRequestDispatcherRecursionDepth >= this.nestCounter;
    }

    void closeInputStream() {
        try {
            if (this._bufferedreader != null) {
                this._bufferedreader.close();
            } else if (this._inputStream != null) {
                this._inputStream.close();
            } else {
                this._session.skip(this.getContentLength());
            }
        }
        catch (IOException iOException) {}
    }

    public void decrnestCounter() {
        --this.nestCounter;
    }

    public Object getAttribute(String string) {
        if (string == null) {
            return null;
        }
        return this._attrs.get(string);
    }

    public Enumeration getAttributeNames() {
        return this._attrs.keys();
    }

    public String getCharacterEncoding() {
        if (!this._characterEncodingParsed) {
            String string = this._session.getRequestCharacterEncoding();
            this._characterEncoding = NSServletSession.unquote(string);
            this._characterEncodingParsed = true;
        }
        return this._characterEncoding;
    }

    public int getContentLength() {
        return this._session.getContentLength();
    }

    public String getContentType() {
        return this._session.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException, IllegalStateException {
        if (this._bufferedreader != null) {
            throw new IllegalStateException();
        }
        if (this._inputStream == null) {
            int n = this.getContentLength();
            this._inputStream = n >= 0 ? new NSServletInputStream(this._session, n) : new NSServletInputStream(this._session);
        }
        return this._inputStream;
    }

    public Locale getLocale() {
        this.parseLocales();
        return (Locale)this._locales.elementAt(0);
    }

    public Enumeration getLocales() {
        this.parseLocales();
        return this._locales.elements();
    }

    NSServletSession getNSServletSession() {
        return this._session;
    }

    public String getNsapiRequestVar(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        return this._session.getRequestVariable(string);
    }

    public String getParameter(String string) {
        String string2;
        block4: {
            if (this._paramCache != null && (string2 = this._paramCache.getParameter(string)) != null) {
                return string2;
            }
            string2 = null;
            byte[] byArray = this._session.getParameterBytes(string);
            if (byArray == null) break block4;
            String string3 = this.getParameterEncoding();
            try {
                if (string3 != null) {
                    string2 = new String(byArray, string3);
                    break block4;
                }
                string2 = new String(byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!LogUtil.enableTrace) break block4;
                LogUtil.TRACE((int)5, (String)("getParameter(): java.io.UnsupportedEncodingException -- encoding:" + string3));
            }
        }
        return string2;
    }

    private String getParameterEncoding() {
        String string = this.getCharacterEncoding();
        if (string != null) {
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)5, (String)("encoding from request charset : " + string));
            }
            return string;
        }
        switch (this._paramEncodingMode) {
            case 3: {
                string = null;
                if (!LogUtil.enableTrace) break;
                LogUtil.TRACE((int)5, (String)"configured to use platform default encoding.");
                break;
            }
            case 4: {
                string = this._configParamEncoding;
                if (!LogUtil.enableTrace) break;
                LogUtil.TRACE((int)5, (String)("encoding from context : " + string));
                break;
            }
            case 1: {
                string = this.checkParameterEncodingHints();
                break;
            }
            case 2: {
                string = this._session.getResponseCharacterEncoding();
                if (!LogUtil.enableTrace || string == null) break;
                LogUtil.TRACE((int)5, (String)("hint from response charset: " + string));
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public Enumeration getParameterNames() {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        if (this._paramCache != null && (stringArray = this._paramCache.getParameterNames()) != null) {
            while (stringArray.hasMoreElements()) {
                String string = (String)stringArray.nextElement();
                vector.add(string);
            }
        }
        if ((stringArray = this._session.getAllParameterNames()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (!vector.contains(stringArray[n])) {
                    vector.add(stringArray[n]);
                }
                ++n;
            }
        }
        return vector.elements();
    }

    public String[] getParameterValues(String string) {
        String[] stringArray;
        block8: {
            int n = 0;
            byte[][] byArray = this._session.getParameterByteValues(string);
            if (byArray != null) {
                n = byArray.length;
            }
            String[] stringArray2 = null;
            if (this._paramCache != null && (stringArray2 = this._paramCache.getParameterValues(string)) != null) {
                n += stringArray2.length;
            }
            stringArray = null;
            if (n <= 0) break block8;
            stringArray = new String[n];
            int n2 = 0;
            if (stringArray2 != null) {
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    stringArray[n2] = stringArray2[n3];
                    ++n3;
                    ++n2;
                }
            }
            if (byArray != null) {
                String string2 = this.getParameterEncoding();
                try {
                    int n4 = 0;
                    while (n4 < byArray.length) {
                        stringArray[n2] = string2 != null ? new String(byArray[n4], string2) : new String(byArray[n4]);
                        ++n4;
                        ++n2;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (!LogUtil.enableTrace) break block8;
                    LogUtil.TRACE((int)5, (String)("getParameterValues(): java.io.UnsupportedEncodingException -- encoding:" + string2));
                }
            }
        }
        return stringArray;
    }

    public String getProtocol() {
        return this._session.getProtocol();
    }

    public BufferedReader getReader() throws IOException, IllegalStateException, UnsupportedEncodingException {
        if (this._inputStream != null) {
            throw new IllegalStateException();
        }
        if (this._bufferedreader == null) {
            int n = this.getContentLength();
            NSServletInputStream nSServletInputStream = n >= 0 ? new NSServletInputStream(this._session, n) : new NSServletInputStream(this._session);
            String string = this.getCharacterEncoding();
            this._bufferedreader = string == null ? new BufferedReader(new InputStreamReader((InputStream)((Object)nSServletInputStream))) : new BufferedReader(new InputStreamReader((InputStream)((Object)nSServletInputStream), string));
        }
        return this._bufferedreader;
    }

    public String getRealPath(String string) {
        if (string == null) {
            return null;
        }
        return this._session.getRealPath(string);
    }

    public String getRemoteAddr() {
        return this._session.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this._session.getRemoteHost();
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.startsWith("/")) {
            return this._context.getRequestDispatcher(string);
        }
        String string2 = "";
        String string3 = this._session.getServletPath();
        if (string3 != null && (n = string3.lastIndexOf(47)) >= 0) {
            string2 = string3.substring(0, n);
        }
        string = String.valueOf(string2) + "/" + string;
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("NSServletRequest.getDispacher: " + string));
        }
        return this._context.getRequestDispatcher(string);
    }

    public String getScheme() {
        int n;
        String string = this._session.getRequestURL();
        if (string != null && (n = string.indexOf(58)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public String getServerName() {
        return this._session.getServerName();
    }

    public int getServerPort() {
        return this._session.getServerPort();
    }

    WServletContext getWServletContext() {
        return this._context;
    }

    public void incrnestCounter() {
        ++this.nestCounter;
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    private void parseLocales() {
        if (this._locales == null) {
            this._locales = new Vector();
            String string = this._session.getHeader("accept-language");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string6 = stringTokenizer2.nextToken();
                        int n = string6.indexOf(59);
                        if (n != -1) {
                            string6 = string6.substring(0, n);
                        }
                        if (string6.length() <= 0) continue;
                        if (string3 == null) {
                            string3 = string6;
                            continue;
                        }
                        if (string4 == null) {
                            string4 = string6;
                            continue;
                        }
                        if (string5 != null) break;
                        string5 = string6;
                    }
                    if (string3 == null) continue;
                    this._locales.addElement(new Locale(string3, string4 == null ? "" : string4, string5 == null ? "" : string5));
                }
            }
            if (this._locales.size() == 0) {
                this._locales.addElement(Locale.getDefault());
            }
        }
    }

    public void removeAttribute(String string) {
        if (string != null) {
            this._attrs.remove(string);
        }
    }

    public void setAttribute(String string, Object object) {
        if (string != null) {
            if (object == null) {
                this._attrs.remove(string);
            } else {
                this._attrs.put(string, object);
            }
        }
    }

    private void setSSLAttributes() {
        String string = this._session.getCgiVariable("CLIENT_CERT");
        if (string != null) {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{CertUtil.getX509Certificate((String)string)};
            this.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
        }
    }

    void setWServletContext(WServletContext wServletContext) {
        this._context = wServletContext;
    }
}

