/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.Debug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

class SwingPackageNameConverter {
    public static final int CONST_CLASS = 7;
    public static final int CONST_FIELDREF = 9;
    public static final int CONST_METHODREF = 10;
    public static final int CONST_IMETHODREF = 11;
    public static final int CONST_STRING = 8;
    public static final int CONST_INTEGER = 3;
    public static final int CONST_FLOAT = 4;
    public static final int CONST_LONG = 5;
    public static final int CONST_DOUBLE = 6;
    public static final int CONST_NAMEANDTYPE = 12;
    public static final int CONST_UTF8 = 1;
    private static final int OLD_PACKAGE = 0;
    private static final int NEW_PACKAGE = 1;
    private static final int PLAF_WINDOWS = 2;
    private static final int PLAF_MOTIF = 3;
    private static String[][] convTable = new String[][]{{"com/sun/java/swing", "javax/swing", "/plaf/windows/", "/plaf/motif/"}, {"com$sun$java$swing", "javax$swing", "$plaf$windows$", "$plaf$motif$"}, {"com.sun.java.swing", "javax.swing", ".plaf.windows.", ".plaf.motif."}};
    private static byte[] buf = new byte[16384];
    private static final String debugTag = "ClassLoader: ";

    SwingPackageNameConverter() {
    }

    static String convertPackageName(String string) {
        int n = 0;
        while (n < convTable.length) {
            int n2 = -1;
            int n3 = 0;
            String[] stringArray = convTable[n];
            StringBuffer stringBuffer = null;
            while ((n2 = string.indexOf(stringArray[0], n3)) >= 0) {
                int n4 = n2 + stringArray[0].length();
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(string.substring(n3, n2));
                if (string.indexOf(stringArray[2], n4) == n4) {
                    stringBuffer.append(stringArray[0]);
                } else if (string.indexOf(stringArray[3], n4) == n4) {
                    stringBuffer.append(stringArray[0]);
                } else {
                    stringBuffer.append(stringArray[1]);
                }
                n3 = n4;
            }
            if (stringBuffer != null) {
                stringBuffer.append(string.substring(n3, string.length()));
                if (Debug.getTraceLevel() == 9) {
                    Debug.println(9, debugTag + string + " -> " + stringBuffer.toString());
                }
                string = stringBuffer.toString();
            }
            ++n;
        }
        return string;
    }

    public static synchronized void convert(InputStream inputStream, OutputStream outputStream) throws IOException, Exception {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        n = dataInputStream.readInt();
        if (n != -889275714) {
            throw new Exception("Not a java class file");
        }
        dataOutputStream.writeInt(n);
        short s = dataInputStream.readShort();
        n2 = s;
        dataOutputStream.writeShort(s);
        short s2 = dataInputStream.readShort();
        n3 = s2;
        dataOutputStream.writeShort(s2);
        if (n2 != 3 && n3 != 45) {
            Debug.println(0, "ClassLoader: majorVersion=" + n2 + " minorVersion=" + n3);
        }
        byte[] byArray = SwingPackageNameConverter.convertConstPool(dataInputStream);
        dataOutputStream.write(byArray);
        try {
            int n4;
            while ((n4 = dataInputStream.read(buf)) > 0) {
                dataOutputStream.write(buf, 0, n4);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            Debug.println(0, "SwingPackageNameConverter.convert " + exception);
            throw exception;
        }
        dataOutputStream.flush();
    }

    static byte[] convertConstPool(DataInputStream dataInputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte by = 0;
        int n = 0;
        n = dataInputStream.readShort();
        dataOutputStream.writeShort(n);
        int n2 = 1;
        while (n2 < n) {
            by = dataInputStream.readByte();
            dataOutputStream.writeByte(by);
            switch (by) {
                case 1: {
                    dataOutputStream.writeUTF(SwingPackageNameConverter.convertPackageName(dataInputStream.readUTF()));
                    break;
                }
                case 7: {
                    dataOutputStream.writeShort(dataInputStream.readShort());
                    break;
                }
                case 8: {
                    dataOutputStream.writeShort(dataInputStream.readShort());
                    break;
                }
                case 9: {
                    dataOutputStream.writeShort(dataInputStream.readShort());
                    dataOutputStream.writeShort(dataInputStream.readShort());
                    break;
                }
                case 10: 
                case 11: {
                    dataOutputStream.writeShort(dataInputStream.readShort());
                    dataOutputStream.writeShort(dataInputStream.readShort());
                    break;
                }
                case 12: {
                    dataOutputStream.writeShort(dataInputStream.readShort());
                    dataOutputStream.writeShort(dataInputStream.readShort());
                    break;
                }
                case 3: {
                    dataOutputStream.writeInt(dataInputStream.readInt());
                    break;
                }
                case 4: {
                    dataOutputStream.writeFloat(dataInputStream.readFloat());
                    break;
                }
                case 5: {
                    dataOutputStream.writeLong(dataInputStream.readLong());
                    ++n2;
                    break;
                }
                case 6: {
                    dataOutputStream.writeDouble(dataInputStream.readDouble());
                    ++n2;
                    break;
                }
                default: {
                    throw new Exception("Bad constant tag " + by + " at position " + n2);
                }
            }
            ++n2;
        }
        dataOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void convertJar(String string) {
        long l = System.currentTimeMillis();
        try {
            ZipEntry zipEntry;
            int n;
            int n2;
            block12: {
                ZipFile zipFile = new ZipFile(string);
                n2 = 0;
                n = 0;
                try {
                    try {
                        n2 = zipFile.size();
                    }
                    catch (Throwable throwable) {
                        System.err.println("ZipFile.size() method missing");
                        n2 = -1;
                        zipEntry = null;
                        zipFile.close();
                        break block12;
                    }
                    zipEntry = null;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    zipFile.close();
                    throw throwable;
                }
                zipFile.close();
            }
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(string)));
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string + ".comp")));
            zipEntry = null;
            ZipEntry zipEntry2 = null;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            byte[] byArray = new byte[512];
            while (true) {
                if ((zipEntry = zipInputStream.getNextEntry()) == null) {
                    zipInputStream.close();
                    zipOutputStream.close();
                    long l2 = System.currentTimeMillis();
                    System.err.println("");
                    System.err.println("Conversion time " + (double)(l2 - l) / 1000.0 + " sec");
                    return;
                }
                if (zipEntry.getName().endsWith(".class")) {
                    zipEntry2 = new ZipEntry(zipEntry.getName());
                    zipOutputStream.putNextEntry(zipEntry2);
                    SwingPackageNameConverter.convert(zipInputStream, zipOutputStream);
                } else {
                    zipEntry2 = new ZipEntry(zipEntry.getName());
                    zipOutputStream.putNextEntry(zipEntry2);
                    n3 = (int)zipEntry.getSize();
                    n4 = 0;
                    n4 = 0;
                    while (n4 < n3) {
                        n5 = zipInputStream.read(byArray, 0, 512);
                        zipOutputStream.write(byArray, 0, n5);
                        n4 += n5;
                    }
                }
                zipOutputStream.closeEntry();
                zipInputStream.closeEntry();
                if (n2 == -1) {
                    System.err.print("Converting...\r");
                    continue;
                }
                System.err.print("Converted " + ++n + " out of " + n2 + " files...\r");
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
    }

    public static void main00(String[] stringArray) {
        if (stringArray.length != 1 && stringArray.length != 2) {
            System.err.println("Usage: SwingPackageNameConverter <name>.class [outputDir]");
            System.exit(1);
        }
        try {
            Debug.setTraceLevel(9);
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            if (stringArray.length == 2) {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(stringArray[1]));
                SwingPackageNameConverter.convert(fileInputStream, fileOutputStream);
            } else {
                SwingPackageNameConverter.convert(fileInputStream, new ByteArrayOutputStream());
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: SwingPackageNameConverter zip-or-jar-file");
            System.exit(1);
        }
        try {
            SwingPackageNameConverter.convertJar(stringArray[0]);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }
}

