/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.security.PromptForTrustDialog;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;

public class JSS3SocketFactory
implements Serializable,
LDAPSocketFactory,
SSLCertificateApprovalCallback {
    static final long serialVersionUID = -6926469178017736902L;
    private static boolean initialized = false;
    private static PromptForTrustDialog promptForTrustDialog = null;
    private String _lastHost;
    private int _lastPort;

    public JSS3SocketFactory() throws LDAPException {
        if (!initialized) {
            JSS3SocketFactory.initialize(".");
        }
    }

    public static void initialize(String string) throws LDAPException {
        if (initialized) {
            throw new LDAPException("JSS3SocketFactory is already initialized", 80);
        }
        try {
            initialized = true;
            CryptoManager.initialize((String)string);
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to initialize JSS3SocketFactory: " + exception.getMessage(), 80);
        }
    }

    public static void initialize(String string, String string2, String string3, String string4) throws LDAPException {
        if (initialized) {
            throw new LDAPException("JSS3SocketFactory is already initialized", 80);
        }
        try {
            initialized = true;
            CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(string, string2, string3, string4);
            CryptoManager.initialize((CryptoManager.InitializationValues)initializationValues);
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to initialize JSS3SocketFactory: " + exception.getMessage(), 80);
        }
    }

    public Socket makeSocket(String string, int n) throws LDAPException {
        this._lastHost = string;
        this._lastPort = n;
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = new SSLSocket(InetAddress.getByName(string), n, null, 0, true, (SSLCertificateApprovalCallback)this, null);
            sSLSocket.forceHandshake();
        }
        catch (Exception exception) {
            throw new LDAPException("SSL connection to " + string + ":" + n + ", " + exception.getMessage(), 91);
        }
        return sSLSocket;
    }

    public boolean approve(X509Certificate x509Certificate, SSLCertificateApprovalCallback.ValidityStatus validityStatus) {
        boolean bl = true;
        if (UtilConsoleGlobals.isServerAuthEnabled()) {
            boolean bl2 = false;
            Enumeration enumeration = validityStatus.getReasons();
            bl2 = enumeration.hasMoreElements();
            if (bl2) {
                Object object;
                java.security.cert.X509Certificate x509Certificate2 = null;
                try {
                    object = new ByteArrayInputStream(x509Certificate.getEncoded());
                    while (((ByteArrayInputStream)object).available() > 0) {
                        x509Certificate2 = (java.security.cert.X509Certificate)UtilConsoleGlobals.getX509CertificateFactory().generateCertificate((InputStream)object);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (promptForTrustDialog == null) {
                    promptForTrustDialog = new PromptForTrustDialog(null, x509Certificate2, validityStatus);
                } else {
                    promptForTrustDialog.setCertificateInfo(x509Certificate2, validityStatus);
                }
                promptForTrustDialog.setServerName(this._lastHost + ":" + this._lastPort);
                if (SwingUtilities.isEventDispatchThread()) {
                    promptForTrustDialog.setVisible(true);
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                promptForTrustDialog.setVisible(true);
                            }
                        });
                    }
                    catch (Exception exception) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                promptForTrustDialog.setVisible(false);
                            }
                        });
                    }
                }
                bl = promptForTrustDialog.isCertAccepted();
                if (bl && !promptForTrustDialog.isAcceptedForOneSession()) {
                    try {
                        object = x509Certificate.getNickname();
                        InternalCertificate internalCertificate = CryptoManager.getInstance().importCertToPerm(x509Certificate, (String)(object == null ? x509Certificate.getSubjectDN().toString() : object));
                        internalCertificate.setSSLTrust(3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return bl;
    }
}

