/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractModalDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.controls.LDAPSortControl;

public class OUPickerDialog
extends AbstractModalDialog {
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.topology.topology");
    private ConsoleInfo _consoleInfo;
    private JList _ouList;
    private Help _helpSession;
    private Vector _ous;
    private Vector _ouDNs;
    private static final int DISPLAY_USER_STRINGS = 0;
    private static final int DISPLAY_DNS = 1;
    private int displayMode = 0;
    private MouseAdapter _mouseAdaptor = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int[] nArray = OUPickerDialog.this._ouList.getSelectedIndices();
                int n = OUPickerDialog.this._ouList.locationToIndex(mouseEvent.getPoint());
                if (n >= 0 && n < OUPickerDialog.this._ouDNs.size() && nArray.length > 0) {
                    OUPickerDialog.this.setOKButtonEnabled(true);
                    OUPickerDialog.this.okInvoked();
                }
            }
        }
    };

    public OUPickerDialog(ConsoleInfo consoleInfo) {
        super((Frame)null, _resource.getString("OUPickerDialog", "Title"));
        this._consoleInfo = consoleInfo;
        this._ous = new Vector();
        this._ouDNs = new Vector();
        this._helpSession = new Help(_resource);
        JLabel jLabel = new JLabel(_resource.getString("OUPickerDialog", "Prompt"));
        this._ouList = new JList();
        jLabel.setLabelFor(this._ouList);
        this._ouList.addListSelectionListener(new DialogListSelectionListener());
        this._ouList.addMouseMotionListener(new DialogMouseMotionListener());
        this._ouList.addMouseListener(this._mouseAdaptor);
        this._ouList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this._ouList);
        jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagUtil.constrain(jPanel, jLabel, 0, 0, 0, 1, 1.0, 0.0, 17, 2, 9, 9, 0, 0);
        GridBagUtil.constrain(jPanel, jScrollPane, 0, 1, -1, 0, 1.0, 1.0, 17, 1, 9, 9, 0, 9);
        String string = _resource.getString("OUPickerDialog", "toggle_show_dns");
        String string2 = _resource.getString("OUPickerDialog", "toggle_show_strings");
        String string3 = string != null && string.length() > string2.length() ? string : string2;
        final JButton jButton = new JButton(string3);
        JButtonFactory.resize(jButton);
        jButton.setText(string);
        jButton.setToolTipText(_resource.getString("OUPickerDialog", "toggle_tt"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OUPickerDialog.this.displayMode == 1) {
                    OUPickerDialog.this.displayMode = 0;
                    jButton.setText(_resource.getString("OUPickerDialog", "toggle_show_dns"));
                } else {
                    OUPickerDialog.this.displayMode = 1;
                    jButton.setText(_resource.getString("OUPickerDialog", "toggle_show_strings"));
                }
                OUPickerDialog.this.setOUList(OUPickerDialog.this.displayMode);
            }
        });
        GridBagUtil.constrain(jPanel, jButton, 1, 1, 1, 0, 0.0, 0.0, 18, 0, 9, 9, 9, 9);
        this.setPanel(jPanel);
        this.setMinimumSize(500, 225);
    }

    public void show() {
        this.setOUList(this.displayMode);
        this.setFocusComponent(this._ouList);
        this.setDefaultButton(1);
        super.show();
    }

    public void show(ConsoleInfo consoleInfo) {
        this._consoleInfo = consoleInfo;
        this.show();
    }

    private void setOUList(int n) {
        LDAPSortKey lDAPSortKey;
        Object object;
        Object e = this._ouList.getSelectedValue();
        int n2 = this._ouList.getSelectedIndex();
        this._ouList.clearSelection();
        String string = _resource.getString("OUPickerDialog", "SearchFilter");
        LDAPConnection lDAPConnection = this._consoleInfo.getUserLDAPConnection();
        if (lDAPConnection == null) {
            Debug.println("ERROR OUPickerDialog.setOUList: no LDAP connection");
            return;
        }
        this._ous.removeAllElements();
        this._ouDNs.removeAllElements();
        this._ouDNs.addElement(this._consoleInfo.getUserBaseDN());
        if (n == 0) {
            this._ous.addElement(_resource.getString("OUPickerDialog", "BaseDNString"));
        } else {
            this._ous.addElement(this._consoleInfo.getUserBaseDN());
        }
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        if (LDAPUtil.isVersion4(lDAPConnection)) {
            object = Locale.getDefault().getLanguage();
            lDAPSortKey = object == null || ((String)object).equals("") ? new LDAPSortKey("ou", false) : new LDAPSortKey("ou", false, (String)object);
            lDAPSearchConstraints.setServerControls((LDAPControl)new LDAPSortControl(lDAPSortKey, false));
        }
        try {
            lDAPSortKey = lDAPConnection.search(this._consoleInfo.getUserBaseDN(), 2, string, null, false);
            object = null;
            while (lDAPSortKey.hasMoreElements()) {
                object = lDAPSortKey.next();
                if (n == 0) {
                    StringBuffer stringBuffer = new StringBuffer(LDAPUtil.flatting(object.getAttribute("ou", LDAPUtil.getLDAPAttributeLocale())));
                    String string2 = LDAPUtil.flatting(object.getAttribute("description", LDAPUtil.getLDAPAttributeLocale()));
                    if (string2 != null && !string2.trim().equals("")) {
                        stringBuffer.append(" (");
                        stringBuffer.append(string2);
                        stringBuffer.append(")");
                    }
                    this._ous.addElement(stringBuffer.toString());
                } else {
                    this._ous.addElement(object.getDN());
                }
                this._ouDNs.addElement(object.getDN());
            }
            this._ouList.setListData(this._ous);
            if (e != null) {
                this._ouList.setSelectedValue(e, true);
                if (this._ouList.getSelectedIndex() == -1) {
                    this._ouList.setSelectedIndex(n2);
                }
            } else if (this._ouList.getModel().getSize() > 0) {
                this._ouList.setSelectedIndex(0);
            }
            this._ouList.revalidate();
            this._ouList.repaint();
        }
        catch (LDAPException lDAPException) {
            Debug.println("ERROR OUPickerDialog.setOUList: exception during search: " + (Object)((Object)lDAPException));
        }
        object = this._ouList.getSelectedIndices();
        this.setOKButtonEnabled(((Object)object).length > 0);
    }

    public int getSelectedIndex() {
        return this._ouList.getSelectedIndex();
    }

    public Object getSelectedValue() {
        return this._ouDNs.elementAt(this._ouList.getSelectedIndex());
    }

    public void okInvoked() {
        super.okInvoked();
    }

    public void helpInvoked() {
        this._helpSession.contextHelp("topology", "oupickerdialog");
    }

    class DialogListSelectionListener
    implements ListSelectionListener {
        DialogListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = OUPickerDialog.this._ouList.getSelectedIndices();
            if (nArray.length == 0) {
                OUPickerDialog.this.setOKButtonEnabled(false);
            } else {
                OUPickerDialog.this.setOKButtonEnabled(true);
            }
        }
    }

    class DialogMouseMotionListener
    implements MouseMotionListener {
        DialogMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = OUPickerDialog.this._ouList.locationToIndex(mouseEvent.getPoint());
            if (n >= 0 && n < OUPickerDialog.this._ouDNs.size()) {
                OUPickerDialog.this._ouList.setToolTipText((String)OUPickerDialog.this._ouDNs.elementAt(n));
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = OUPickerDialog.this._ouList.locationToIndex(mouseEvent.getPoint());
            if (n >= 0 && n < OUPickerDialog.this._ouDNs.size()) {
                OUPickerDialog.this._ouList.setToolTipText((String)OUPickerDialog.this._ouDNs.elementAt(n));
            }
        }
    }
}

