/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.components.Table;
import com.netscape.management.client.security.SecurityUtil;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class CipherPreferenceDialog
extends AbstractDialog {
    Vector _ciphers;
    Hashtable _cipherSettings = new Hashtable();
    Table cipherTable;
    JTabbedPane tabbedPane;
    Help help;
    String rc2;
    String rc4;
    String des;
    String tripleDes;
    String fips;
    String none;
    String v2;
    String v3;
    String tls;
    String export;
    String enabledTitle;
    String sha;
    String md5;
    String fortezza;
    String cipherLabel;
    String bits;
    String msgAlgo;
    String version;
    String title;
    public static final String SSL_V2 = "V2";
    public static final String SSL_V3 = "V3";
    public static final String SSL_TLS = "TLS";
    public static final String RC4EXPORT = "rc4export";
    public static final String RC2EXPORT = "rc2export";
    public static final String RC4 = "rc4";
    public static final String RC2 = "rc2";
    public static final String DES = "des";
    public static final String DES3 = "desede3";
    public static final String RSA_RC4_40_MD5 = "rsa_rc4_40_md5";
    public static final String RSA_RC2_40_MD5 = "rsa_rc2_40_md5";
    public static final String RSA_NULL_MD5 = "rsa_null_md5";
    public static final String TLS_RSA_DES_SHA = "tls_rsa_export1024_with_des_cbc_sha";
    public static final String TLS_RSA_RC4_SHA = "tls_rsa_export1024_with_rc4_56_sha";
    public static final String RSA_DES_SHA = "rsa_des_sha";
    public static final String RSA_RC4_128_MD5 = "rsa_rc4_128_md5";
    public static final String RSA_3DES_SHA = "rsa_3des_sha";
    public static final String FORTEZZA = "fortezza";
    public static final String FORTEZZA_RC4_128_SHA = "fortezza_rc4_128_sha";
    public static final String FORTEZZA_NULL = "fortezza_null";
    public static final String RSA_FIPS_DES_SHA = "rsa_fips_des_sha";
    public static final String RSA_FIPS_3DES_SHA = "rsa_fips_3des_sha";
    static final String V2EXPORT = "+rc4export,+rc2export";
    static final String V2DOMESTIC = "+rc4,+rc2,+des,+desede3";
    static final String V3EXPORT = "+rsa_rc4_40_md5,+rsa_rc2_40_md5,-rsa_null_md5";
    static final String V3DOMESTIC = "+rsa_des_sha,+rsa_rc4_128_md5,+rsa_3des_sha,+rsa_fips_des_sha,+rsa_fips_3des_sha";
    static final String V3FORETEZZA = "+fortezza,+fortezza_rc4_128_sha,-fortezza_null";
    static final String V3TLS = "+tls_rsa_export1024_with_des_cbc_sha,+tls_rsa_export1024_with_rc4_56_sha";

    public void cipherStateChanged(String string, String string2, boolean bl) {
        Debug.println("cipher: " + string2 + " change state to: " + bl);
    }

    protected void helpInvoked() {
        String string = this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
        if (string.equals(this.v3)) {
            this.help.contextHelp("CipherPreferenceDialog", "v3Help");
        } else if (string.equals(this.tls)) {
            this.help.contextHelp("CipherPreferenceDialog", "tlsHelp");
        } else {
            this.help.contextHelp("CipherPreferenceDialog", "v2Help");
        }
    }

    void init() {
        ResourceSet resourceSet = new ResourceSet("com.netscape.management.client.security.securityResource");
        this.help = new Help(resourceSet);
        this.rc2 = resourceSet.getString("CipherPreferenceDialog", RC2);
        this.rc4 = resourceSet.getString("CipherPreferenceDialog", RC4);
        this.des = resourceSet.getString("CipherPreferenceDialog", DES);
        this.tripleDes = resourceSet.getString("CipherPreferenceDialog", "3des");
        this.fips = resourceSet.getString("CipherPreferenceDialog", "fips");
        this.export = resourceSet.getString("CipherPreferenceDialog", "export");
        this.none = resourceSet.getString("CipherPreferenceDialog", "none");
        this.md5 = resourceSet.getString("CipherPreferenceDialog", "md5");
        this.sha = resourceSet.getString("CipherPreferenceDialog", "sha");
        this.fortezza = resourceSet.getString("CipherPreferenceDialog", FORTEZZA);
        this.v2 = resourceSet.getString("CipherPreferenceDialog", "v2");
        this.v3 = resourceSet.getString("CipherPreferenceDialog", "v3");
        this.tls = resourceSet.getString("CipherPreferenceDialog", "tls");
        this.cipherLabel = resourceSet.getString("CipherPreferenceDialog", "cipherLabel");
        this.bits = resourceSet.getString("CipherPreferenceDialog", "bits");
        this.msgAlgo = resourceSet.getString("CipherPreferenceDialog", "msgAlgo");
        this.version = resourceSet.getString("CipherPreferenceDialog", "sslV");
        this.title = resourceSet.getString("CipherPreferenceDialog", "title");
        this.enabledTitle = resourceSet.getString("CipherPreferenceDialog", "enabledTitle");
    }

    public Vector getCipherList(String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._cipherSettings.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            vector.addElement(((CipherEntry)this._cipherSettings.get((Object)string2))._cipher);
        }
        return vector;
    }

    public String getCipherPreference(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this._cipherSettings.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            CipherEntry cipherEntry = (CipherEntry)this._cipherSettings.get(string2);
            stringBuffer.append(stringBuffer.length() > 0 ? "," : "");
            stringBuffer.append(cipherEntry._enabled.isSelected() ? "+" : "-");
            stringBuffer.append(cipherEntry._cipher);
        }
        return stringBuffer.toString();
    }

    public boolean isCipherEnabled(String string, String string2) {
        Object v = this._cipherSettings.get(string + string2);
        boolean bl = false;
        if (v != null) {
            bl = ((CipherEntry)v)._enabled.isSelected();
        }
        return bl;
    }

    public boolean isSSLVersionEnabled(String string) {
        boolean bl = false;
        Enumeration enumeration = this._cipherSettings.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            CipherEntry cipherEntry = (CipherEntry)this._cipherSettings.get(string2);
            if (!cipherEntry._enabled.isSelected()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void setCipherEnabled(String string, String string2, boolean bl) {
        Object v = this._cipherSettings.get(string + string2);
        if (v != null) {
            ((CipherEntry)v)._enabled.setSelected(bl);
        }
        this.cipherTable.validate();
        this.cipherTable.repaint();
    }

    public void setCipherEnabled(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            boolean bl = string3.startsWith("+");
            this.setCipherEnabled(string, string3.substring(1, string3.length()), bl);
        }
    }

    CipherEntry createCipherEntry(String string, String string2) {
        CipherEntry cipherEntry = null;
        if (string.equals(SSL_V2)) {
            if (string2.equals(RC4)) {
                cipherEntry = new CipherEntry(string2, true, this.rc4, 128, this.md5, SSL_V2);
            } else if (string2.equals(RC4EXPORT)) {
                cipherEntry = new CipherEntry(string2, true, this.rc4, 40, this.md5, SSL_V2, true);
            } else if (string2.equals(RC2)) {
                cipherEntry = new CipherEntry(string2, true, this.rc2, 128, this.md5, SSL_V2);
            } else if (string2.equals(RC2EXPORT)) {
                cipherEntry = new CipherEntry(string2, true, this.rc2, 40, this.md5, SSL_V2, true);
            } else if (string2.equals(DES)) {
                cipherEntry = new CipherEntry(string2, true, this.des, 56, this.md5, SSL_V2);
            } else if (string2.equals(DES3)) {
                cipherEntry = new CipherEntry(string2, true, this.des, 168, this.md5, SSL_V2);
            }
        } else if (string.equals(SSL_TLS) || string.equals(SSL_V3)) {
            if (string2.equals(RSA_RC4_128_MD5)) {
                cipherEntry = new CipherEntry(string2, true, this.rc4, 128, this.md5, SSL_V3);
            } else if (string2.equals(RSA_3DES_SHA)) {
                cipherEntry = new CipherEntry(string2, true, this.tripleDes, 168, this.sha, SSL_V3);
            } else if (string2.equals(RSA_DES_SHA)) {
                cipherEntry = new CipherEntry(string2, true, this.des, 56, this.sha, SSL_V3);
            } else if (string2.equals(RSA_RC4_40_MD5)) {
                cipherEntry = new CipherEntry(string2, true, this.rc4, 40, this.md5, SSL_V3, true);
            } else if (string2.equals(RSA_RC2_40_MD5)) {
                cipherEntry = new CipherEntry(string2, true, this.rc2, 40, this.md5, SSL_V3, true);
            } else if (string2.equals(RSA_NULL_MD5)) {
                cipherEntry = new CipherEntry(string2, false, this.none, 0, this.md5, SSL_V3);
            } else if (string2.equals(RSA_FIPS_DES_SHA)) {
                cipherEntry = new CipherEntry(string2, true, this.des + " " + this.fips, 56, this.sha, SSL_V3);
            } else if (string2.equals(RSA_FIPS_3DES_SHA)) {
                cipherEntry = new CipherEntry(string2, true, this.tripleDes + " " + this.fips, 168, this.sha, SSL_V3);
            } else if (string2.equals(FORTEZZA)) {
                cipherEntry = new CipherEntry(string2, true, this.fortezza, 80, this.sha, SSL_V3);
            } else if (string2.equals(FORTEZZA_RC4_128_SHA)) {
                cipherEntry = new CipherEntry(string2, true, this.rc4 + " " + this.fortezza, 128, this.sha, SSL_V3);
            } else if (string2.equals(FORTEZZA_NULL)) {
                cipherEntry = new CipherEntry(string2, false, this.none + " " + this.fortezza, 0, this.sha, SSL_V3);
            }
            if (string.equals(SSL_TLS)) {
                if (string2.equals(TLS_RSA_DES_SHA)) {
                    cipherEntry = new CipherEntry(string2, true, this.des, 56, this.sha, SSL_V3, true);
                } else if (string2.equals(TLS_RSA_RC4_SHA)) {
                    cipherEntry = new CipherEntry(string2, true, this.rc4, 56, this.sha, SSL_V3, true);
                }
            }
        }
        if (cipherEntry != null) {
            this._cipherSettings.put(string + string2, cipherEntry);
        }
        return cipherEntry;
    }

    public CipherPreferenceDialog(Frame frame, String string, String string2, String string3) {
        super(frame, "", true, 11);
        this.init();
        this.setTitle(this.title);
        this.tabbedPane = new JTabbedPane();
        if (string != null && string.length() > 0) {
            this.tabbedPane.addTab(this.v2, new SSLCipherPref(SSL_V2, string));
        }
        if (string2 != null && string2.length() > 0) {
            this.tabbedPane.addTab(this.v3, new SSLCipherPref(SSL_V3, string2));
        }
        if (string3 != null && string3.length() > 0) {
            this.tabbedPane.addTab(this.tls, new SSLCipherPref(SSL_TLS, string3));
        }
        this.getContentPane().add(this.tabbedPane);
        this.pack();
    }

    static String getCipherListString(Vector vector) {
        if (vector == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append(stringBuffer.length() > 0 ? "," : "" + vector.elementAt(n).toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public CipherPreferenceDialog(Frame frame, Vector vector, Vector vector2, Vector vector3) {
        this(frame, CipherPreferenceDialog.getCipherListString(vector), CipherPreferenceDialog.getCipherListString(vector2), CipherPreferenceDialog.getCipherListString(vector3));
    }

    public CipherPreferenceDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(frame, bl ? V2EXPORT + (bl4 ? ",+rc4,+rc2,+des,+desede3" : "") : "", (bl2 ? V3EXPORT + (bl4 ? ",+rsa_des_sha,+rsa_rc4_128_md5,+rsa_3des_sha,+rsa_fips_des_sha,+rsa_fips_3des_sha" : "") : "") + (bl2 & bl4 & bl5 ? ",+fortezza,+fortezza_rc4_128_sha,-fortezza_null" : ""), bl3 ? V3EXPORT + (bl4 ? ",+rsa_des_sha,+rsa_rc4_128_md5,+rsa_3des_sha,+rsa_fips_des_sha,+rsa_fips_3des_sha" : "") + "," + V3TLS : "");
    }

    class SSLCipherPref
    extends JPanel {
        JCheckBox cipherEnabled;

        public SSLCipherPref(String string, String string2) {
            Object object;
            Object object2;
            this.setLayout(new GridBagLayout());
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken();
                try {
                    object = CipherPreferenceDialog.this.createCipherEntry(string, ((String)object2).substring(((String)object2).startsWith("+") || ((String)object2).startsWith("-") ? 1 : 0, ((String)object2).length()));
                    if (object == null) continue;
                    ((CipherEntry)object)._enabled.setSelected(((String)object2).startsWith("+"));
                    vector.addElement(object);
                }
                catch (Exception exception) {
                    SecurityUtil.printException("CipherPreferenceDialog::SSLCipherPref::SSLCipherPref(...)", exception);
                }
            }
            object2 = new Vector();
            ((Vector)object2).addElement(CipherPreferenceDialog.this.enabledTitle);
            ((Vector)object2).addElement(CipherPreferenceDialog.this.cipherLabel);
            ((Vector)object2).addElement(CipherPreferenceDialog.this.bits);
            ((Vector)object2).addElement(CipherPreferenceDialog.this.msgAlgo);
            object = new cipherListModel((Vector)object2, vector);
            CipherPreferenceDialog.this.cipherTable = new Table((TableModel)object, true);
            String string3 = "";
            if (string.equals(CipherPreferenceDialog.SSL_V2)) {
                string3 = CipherPreferenceDialog.this.v2;
            } else if (string.equals(CipherPreferenceDialog.SSL_V3)) {
                string3 = CipherPreferenceDialog.this.v3;
            } else if (string.equals(CipherPreferenceDialog.SSL_TLS)) {
                string3 = CipherPreferenceDialog.this.tls;
            }
            CipherPreferenceDialog.this.cipherTable.size();
            GridBagUtil.constrain(this, new JScrollPane(CipherPreferenceDialog.this.cipherTable), 0, 0, 1, 1, 1.0, 1.0, 17, 1, 0, 0, 0, 0);
            CipherPreferenceDialog.this.cipherTable.setPreferredScrollableViewportSize(new Dimension(350, 200));
            CipherPreferenceDialog.this.cipherTable.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        }
    }

    class CipherEntry {
        public String _cipher;
        public JCheckBox _enabled;
        public String _cipherLabel;
        public int _bits;
        public String _messageAlgo;
        public String _sslVersion;
        public boolean _export;

        public CipherEntry(String string, boolean bl, String string2, int n, String string3, String string4) {
            this(string, bl, string2, n, string3, string4, false);
        }

        public CipherEntry(String string, boolean bl, String string2, int n, String string3, String string4, boolean bl2) {
            this._cipher = string;
            this._enabled = new JCheckBox("", bl);
            this._cipherLabel = string2;
            this._bits = n;
            this._messageAlgo = string3;
            this._sslVersion = string4;
            this._export = bl2;
            CipherPreferenceDialog.this._cipherSettings.put(string, this);
        }

        public void setSelected(boolean bl) {
            CipherPreferenceDialog.this.cipherStateChanged(this._sslVersion, this._cipher, bl);
            this._enabled.setSelected(bl);
        }

        public Object getObject(String string) {
            if (string.equals(CipherPreferenceDialog.this.cipherLabel)) {
                return this._cipherLabel + (this._export ? " " + CipherPreferenceDialog.this.export : "");
            }
            if (string.equals(CipherPreferenceDialog.this.bits)) {
                return this._bits == 0 ? CipherPreferenceDialog.this.none : Integer.toString(this._bits);
            }
            if (string.equals(CipherPreferenceDialog.this.msgAlgo)) {
                return this._messageAlgo;
            }
            if (string.equals(CipherPreferenceDialog.this.version)) {
                if (this._sslVersion.equals(CipherPreferenceDialog.SSL_V2)) {
                    return CipherPreferenceDialog.this.v2;
                }
                if (this._sslVersion.equals(CipherPreferenceDialog.SSL_V3)) {
                    return CipherPreferenceDialog.this.v3;
                }
                return "";
            }
            return this._enabled.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    class cipherListModel
    extends AbstractTableModel {
        Vector _header;
        Vector _rowData;
        JLabel label = new JLabel();

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return this.getValueAt(n, n2) instanceof Boolean;
        }

        public TableCellEditor getColumnCellEditor(int n) {
            if (n == 0) {
                JCheckBox jCheckBox = new JCheckBox();
                return new DefaultCellEditor(jCheckBox);
            }
            return new DefaultCellEditor(new JTextField());
        }

        public cipherListModel(Vector vector, Vector vector2) {
            this._header = vector;
            this._rowData = vector2;
        }

        public void setRowData(Vector vector) {
            this._rowData = vector;
        }

        public int getRowCount() {
            return this._rowData.size();
        }

        public int getColumnCount() {
            return this._header.size();
        }

        public String getColumnName(int n) {
            return n >= this._header.size() ? "" : (String)this._header.elementAt(n);
        }

        public Object getValueAt(int n, int n2) {
            return ((CipherEntry)this._rowData.elementAt(n)).getObject(this.getColumnName(n2));
        }

        public void setValueAt(Object object, int n, int n2) {
            try {
                ((CipherEntry)this._rowData.elementAt(n)).setSelected((Boolean)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

