/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.components.Table;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.CertificateDialog;
import com.netscape.management.client.security.CertificateInfoPanels;
import com.netscape.management.client.security.CertificateList;
import com.netscape.management.client.security.CertificateListPane;
import com.netscape.management.client.security.InstallCRLDialog;
import com.netscape.management.client.security.ListTableModel;
import com.netscape.management.client.security.SecurityUtil;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

class CRLCertificatePane
extends CertificateListPane {
    Table crlCertTable;
    private JTabbedPane infoPane = new JTabbedPane();
    ListTableModel tableModel;
    Vector certs;
    String _sie;
    ConsoleInfo _consoleInfo;
    CertificateDialog _certDialog;

    public CRLCertificatePane(Vector vector, ConsoleInfo consoleInfo, String string, CertificateDialog certificateDialog) {
        this._certDialog = certificateDialog;
        this.resource = new ResourceSet("com.netscape.management.client.security.securityResource");
        this.certs = vector;
        this._sie = string;
        this._consoleInfo = consoleInfo;
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(this.resource.getString("CRLCertificatePane", "issuedByLabel"));
        vector2.addElement(this.resource.getString("CRLCertificatePane", "effectiveDateLabel"));
        vector2.addElement(this.resource.getString("CRLCertificatePane", "nextUpdateLabel"));
        vector2.addElement(this.resource.getString("CRLCertificatePane", "typeLabel"));
        this.tableModel = new ListTableModel(vector2, null);
        this.setCertData(vector);
        this.crlCertTable = new Table((TableModel)this.tableModel, true);
        this.crlCertTable.getSelectionModel().setSelectionMode(0);
        this.setContent(this.crlCertTable, this.resource.getString("CRLCertificatePane", "tableTitle"), CertificateListPane.ADD);
        this.crlCertTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = CRLCertificatePane.this.crlCertTable.getSelectedRow();
                if (n != -1) {
                    CRLCertificatePane.this.detail.setEnabled(true);
                    CRLCertificatePane.this.delete.setEnabled(true);
                }
            }
        });
        this.detail.setEnabled(false);
        this.delete.setEnabled(false);
    }

    public void setCertData(Vector vector) {
        Vector vector2 = new Vector();
        int n = vector.size() - 1;
        while (n >= 0) {
            Vector vector3 = new Vector();
            Hashtable hashtable = (Hashtable)vector.elementAt(n);
            vector3.addElement(hashtable.get("NAME"));
            vector3.addElement(hashtable.get("LAST_UPDATE"));
            vector3.addElement(hashtable.get("NEXT_UPDATE"));
            vector3.addElement(hashtable.get("TYPE"));
            vector2.addElement(vector3);
            --n;
        }
        this.tableModel.setRowData(vector2);
    }

    public void detailInvoked() {
        String string = this.getSelectedCertNickname(this.crlCertTable, this.resource.getString("CRLCertificatePane", "issuedByLabel"));
        if (string.length() != 0) {
            try {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("formop", "FIND_CRL_CKL");
                hashtable.put("sie", this._sie);
                hashtable.put("crlname", string);
                hashtable.put("list_type", this.getSelectedCertNickname(this.crlCertTable, this.resource.getString("CRLCertificatePane", "typeLabel")));
                Debug.println(hashtable.toString());
                AdmTask admTask = new AdmTask(new URL(this._consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SecurityOp"), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
                admTask.setArguments(hashtable);
                admTask.exec();
                Debug.println(admTask.getResultString().toString());
                if (!SecurityUtil.showError(admTask)) {
                    CertificateList certificateList = new CertificateList(admTask.getResultString().toString());
                    Hashtable hashtable2 = null;
                    if (certificateList.getCRLCerts().size() != 0) {
                        hashtable2 = (Hashtable)certificateList.getCRLCerts().elementAt(0);
                        ((Component)new RevocationListDialog(hashtable2)).setVisible(true);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Debug.println(exception.toString());
            }
        }
    }

    public void addInvoked() {
        InstallCRLDialog installCRLDialog = new InstallCRLDialog(this, this._consoleInfo, this._sie);
        installCRLDialog.show();
        this._certDialog.refresh();
    }

    public void deleteInvoked() {
        String string = this.getSelectedCertNickname(this.crlCertTable, this.resource.getString("CRLCertificatePane", "issuedByLabel"));
        if (string.length() != 0 && this.confirmDeleteDialog(string)) {
            try {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("formop", "DELETE_CRL_CKL");
                hashtable.put("sie", this._sie);
                hashtable.put("crlname", string);
                hashtable.put("list_type", this.getSelectedCertNickname(this.crlCertTable, this.resource.getString("CRLCertificatePane", "typeLabel")));
                AdmTask admTask = new AdmTask(new URL(this._consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SecurityOp"), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
                admTask.setArguments(hashtable);
                admTask.exec();
                if (!SecurityUtil.showError(admTask)) {
                    this.tableModel.deleteRow(string);
                    this.crlCertTable.clearSelection();
                    this.crlCertTable.repaint();
                }
            }
            catch (Exception exception) {
                Debug.println(exception.toString());
            }
        }
    }

    public void helpInvoked() {
        this.help.contextHelp("CRLCertificatePane", "help");
    }

    class RevocationListDialog
    extends AbstractDialog {
        public RevocationListDialog(Hashtable hashtable) {
            super(null, CRLCertificatePane.this.resource.getString("CertificateDetailDialog", "title"), true, 9);
            CertificateInfoPanels certificateInfoPanels = new CertificateInfoPanels(hashtable);
            CRLCertificatePane.this.infoPane.add(CRLCertificatePane.this.resource.getString("CertificateDetailDialog", "generalTitle"), certificateInfoPanels.getDetailInfo());
            CRLCertificatePane.this.infoPane.add(CRLCertificatePane.this.resource.getString("CertificateDetailDialog", "revocationList"), certificateInfoPanels.getRevocationList());
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagUtil.constrain(this.getContentPane(), CRLCertificatePane.this.infoPane, 0, 0, 1, 1, 1.0, 1.0, 11, 1, 0, 0, 0, 0);
            this.pack();
        }

        public void helpInvoked() {
            Help help = new Help(CRLCertificatePane.this.resource);
            help.contextHelp("CertificateDetailDialog_CRL", "help");
        }
    }
}

