/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.preferences;

import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.FilePreferenceManager;
import com.netscape.management.client.preferences.LDAPPreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class PreferenceManager {
    private static Hashtable _pmTable = new Hashtable();
    private static boolean _isStoredLocally = false;
    protected String _product;
    protected String _version;

    protected PreferenceManager(String string, String string2) {
        this._product = string;
        this._version = string2;
    }

    public static boolean getLocalStorageFlag() {
        return _isStoredLocally;
    }

    public static void setLocalStorageFlag(boolean bl) {
        _isStoredLocally = bl;
    }

    public static PreferenceManager getPreferenceManager(String string, String string2) {
        PreferenceManager preferenceManager = (PreferenceManager)_pmTable.get(string + string2);
        if (preferenceManager == null) {
            if (_isStoredLocally || Console.getConsoleInfo() == null) {
                preferenceManager = new FilePreferenceManager(string, string2);
                _isStoredLocally = true;
            } else {
                ConsoleInfo consoleInfo = Console.getConsoleInfo();
                preferenceManager = new LDAPPreferenceManager(consoleInfo.getLDAPConnection(), consoleInfo.getUserPreferenceDN(), string, string2);
            }
            _pmTable.put(string + string2, preferenceManager);
        }
        return preferenceManager;
    }

    public String getProduct() {
        return this._product;
    }

    public String getVersion() {
        return this._version;
    }

    public abstract String[] getPreferencesList();

    public abstract Preferences getPreferences(String var1);

    public abstract void savePreferences();

    public abstract boolean isPreferencesDirty();

    public static PreferenceManager[] getPreferenceManagerList() {
        PreferenceManager[] preferenceManagerArray = new PreferenceManager[_pmTable.size()];
        Enumeration enumeration = _pmTable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            preferenceManagerArray[n] = (PreferenceManager)enumeration.nextElement();
            ++n;
        }
        return preferenceManagerArray;
    }

    public static boolean isSaveNeeded() {
        PreferenceManager[] preferenceManagerArray = PreferenceManager.getPreferenceManagerList();
        if (preferenceManagerArray != null) {
            int n = 0;
            while (n < preferenceManagerArray.length) {
                if (preferenceManagerArray[n].isPreferencesDirty()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static void saveAllPreferences() {
        PreferenceManager[] preferenceManagerArray = PreferenceManager.getPreferenceManagerList();
        if (preferenceManagerArray != null) {
            int n = 0;
            while (n < preferenceManagerArray.length) {
                preferenceManagerArray[n].savePreferences();
                ++n;
            }
        }
    }

    public static void clearAllPreferences() {
        PreferenceManager[] preferenceManagerArray = PreferenceManager.getPreferenceManagerList();
        if (preferenceManagerArray != null) {
            int n = 0;
            while (n < preferenceManagerArray.length) {
                String[] stringArray = preferenceManagerArray[n].getPreferencesList();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    Preferences preferences = preferenceManagerArray[n].getPreferences(stringArray[n2]);
                    preferences.clear();
                    preferences.delete();
                    ++n2;
                }
                ++n;
            }
        }
    }
}

