/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.console;

import com.netscape.management.client.Framework;
import com.netscape.management.client.IFrameworkInitializer;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.cmd.GetOpt;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.comm.HttpChannel;
import com.netscape.management.client.comm.HttpException;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.components.FontFactory;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.console.LoginDialog;
import com.netscape.management.client.console.Response;
import com.netscape.management.client.console.RestartDialog;
import com.netscape.management.client.console.SplashScreen;
import com.netscape.management.client.console.TeeStream;
import com.netscape.management.client.console.VersionInfo;
import com.netscape.management.client.preferences.FilePreferences;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.topology.IServerObject;
import com.netscape.management.client.topology.ITopologyPlugin;
import com.netscape.management.client.topology.ServerNode;
import com.netscape.management.client.topology.ServiceLocator;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ClassLoaderUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.KingpinLDAPConnection;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiLookAndFeelFactory;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class Console
implements CommClient {
    static long _t0 = System.currentTimeMillis();
    public static final String IDENTIFIER = "Console";
    public static final String VERSION = "4.0";
    public static final String PREFERENCES_LOGIN = "Console.4.0.Login.preferences";
    public static final String PREFERENCE_UID = "UserID";
    public static final String PREFERENCE_REMEMBER_UID = "RememberUserID";
    public static final String PREFERENCE_URL = "HostURL";
    public static final String PREFERENCE_LOCAL = "StorePrefsToDisk";
    public static final String PREFERENCE_X = "X";
    public static final String PREFERENCE_Y = "Y";
    public static final String OPTION_NOWINPOS = "nowinpos";
    public static final String OPTION_NOLOGO = "nologo";
    public static final int MAX_RECENT_URLS = 5;
    protected static final double MIN_CONTEXT_HELP_VERSION = 4.5;
    public static Preferences _preferences;
    public static ConsoleInfo _info;
    public static String _consoleAdminURL;
    public static ResourceSet _resource;
    public TopologyInitializer _topologyInitializer;
    private String _adminServerSIE;
    private JFrame _frame = null;
    private SplashScreen _splashScreen = null;
    private static boolean _showSplashScreen;
    private static final int LDAP_INIT_OK = 0;
    private static final int LDAP_INIT_FAILED = 1;
    private static final int LDAP_INIT_DS_RESTART = 2;
    private static final int LDAP_INIT_BIND_FAIL = 3;
    private boolean _dsHasBeenRestarted = false;
    private String _adminVersion = null;
    static Console _console;

    public static void loadFontPreferences() {
    }

    private static Locale findLocale(String string) {
        Locale locale = null;
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = 0;
        while (n < localeArray.length && locale == null) {
            if (string.compareTo(localeArray[n].toString()) == 0) {
                locale = localeArray[n];
            }
            ++n;
        }
        return locale;
    }

    protected static void common_init(String string, String string2) {
        Object object;
        if (string == null) {
            Debug.println("Console.common_init: no locale specified with option -l");
        } else {
            Debug.println("Console.common_init: option -l requests locale " + string);
            object = Console.findLocale(string);
            if (object != null) {
                Locale.setDefault((Locale)object);
            } else {
                Debug.println(0, "Console.common_init: cannot find any locale matching " + string);
            }
        }
        Debug.println("Console.common_init: using locale " + Locale.getDefault());
        try {
            if (_info == null) {
                _info = new ConsoleInfo();
            }
            PreferenceManager.setLocalStorageFlag(_preferences.getBoolean(PREFERENCE_LOCAL, false));
            object = SuiLookAndFeelFactory.createLookAndFeel((String)string2);
            UIManager.setLookAndFeel((LookAndFeel)object);
            FontFactory.initializeLFFonts();
        }
        catch (InternalError internalError) {
            System.err.println("Console: " + internalError.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            Debug.println("Console.common_init: Cannot init " + exception);
        }
    }

    public static ConsoleInfo getConsoleInfo() {
        return _info;
    }

    public static void setConsoleInfo(ConsoleInfo consoleInfo) {
        _info = consoleInfo;
    }

    public TopologyInitializer getTopologyInitializer() {
        return this._topologyInitializer;
    }

    public void setTopologyInitializer(TopologyInitializer topologyInitializer) {
        this._topologyInitializer = topologyInitializer;
    }

    public static boolean canSetLocalPreferencesFlag() {
        return _preferences != null;
    }

    public static void setLocalPreferencesFlag(boolean bl) {
        if (_preferences != null) {
            _preferences.set(PREFERENCE_LOCAL, bl);
            _preferences.save();
        }
    }

    public static boolean getLocalPreferencesFlag() {
        if (_preferences != null) {
            return _preferences.getBoolean(PREFERENCE_LOCAL);
        }
        return true;
    }

    protected String getInstanceAdminURL(LDAPConnection lDAPConnection, String string) {
        ServiceLocator serviceLocator = new ServiceLocator(_info);
        String string2 = null;
        try {
            String string3;
            String string4 = string.substring(string.indexOf(44) + 1);
            String string5 = string4.substring(string4.indexOf(44) + 1);
            String string6 = serviceLocator.getAdminServer(string5);
            if (string6 == null) {
                Debug.println("ERROR ConsoleInfo.getInstanceAdminURL: could not get admin server entry = " + string5);
                return null;
            }
            String string7 = "cn=configuration," + string6;
            string2 = string7;
            LDAPEntry lDAPEntry = lDAPConnection.read(string2);
            if (lDAPEntry == null) {
                Debug.println("ERROR ConsoleInfo.getInstanceAdminURL: could not get admin server config entry = " + string7);
                return null;
            }
            String string8 = LDAPUtil.flatting(lDAPEntry.getAttribute("nsserveraddress"));
            String string9 = LDAPUtil.flatting(lDAPEntry.getAttribute("nsServerport"));
            boolean bl = LDAPUtil.flatting(lDAPEntry.getAttribute("nsServersecurity")).equalsIgnoreCase("on");
            if (string8 == null || string8.trim().length() == 0) {
                string2 = string6;
                string3 = lDAPConnection.read(string2, new String[]{"serverhostname"});
                if (string3 == null) {
                    Debug.println("ERROR Console.getInstanceAdminURL: could not get serverhostname from " + string6);
                    return null;
                }
                string8 = LDAPUtil.flatting(string3.getAttribute("serverhostname"));
            }
            string3 = "http";
            if (bl) {
                string3 = string3 + "s";
            }
            string3 = string3 + "://" + string8 + ":" + string9 + "/";
            return string3;
        }
        catch (LDAPException lDAPException) {
            Debug.println("ERROR Console.getInstanceAdminURL: LDAP error " + (Object)((Object)lDAPException) + " dn=" + string2);
            return null;
        }
    }

    protected String getInstanceAdminOS(LDAPConnection lDAPConnection, String string) {
        try {
            String string2 = string.substring(string.indexOf(44) + 1);
            String string3 = string2.substring(string2.indexOf(44) + 1);
            String string4 = string3.substring(string3.indexOf(44) + 1);
            LDAPEntry lDAPEntry = lDAPConnection.read(string4);
            if (lDAPEntry == null) {
                Debug.println("ERROR ConsoleInfo.getInstanceAdminOS: could not get host entry = " + string4);
                return null;
            }
            String string5 = LDAPUtil.flatting(lDAPEntry.getAttribute("nsosversion", LDAPUtil.getLDAPAttributeLocale()));
            return string5;
        }
        catch (LDAPException lDAPException) {
            Debug.println("ERROR ConsoleInfo.getInstanceAdminOS: LDAP error " + (Object)((Object)lDAPException));
            return null;
        }
    }

    protected void createPerInstanceUI(String string) {
        LDAPConnection lDAPConnection = _info.getLDAPConnection();
        String string2 = "cn=configuration," + string;
        try {
            String string3;
            LDAPEntry lDAPEntry = lDAPConnection.read(string2);
            String string4 = LDAPUtil.flatting(lDAPEntry.getAttribute("nsclassname", LDAPUtil.getLDAPAttributeLocale()));
            if (string4 == null) {
                Debug.println("ERROR Console: no 'nsclassname' attribute in " + string2);
                System.exit(0);
            }
            if ((string3 = this.getInstanceAdminURL(lDAPConnection, string)) == null) {
                Debug.println("ERROR Console: could not set the adminURL for " + string);
            } else {
                _info.setAdminURL(string3);
            }
            String string5 = this.getInstanceAdminOS(lDAPConnection, string);
            if (string5 == null) {
                Debug.println("ERROR Console.constructor: could not set the adminOS for " + string);
            } else {
                _info.setAdminOS(string5);
            }
            _info.setCurrentDN(string);
            Class clazz = ClassLoaderUtil.getClass((ConsoleInfo)_info, (String)string4);
            if (clazz == null) {
                Debug.println("ERROR Console.constructor: could not get class " + string4);
                System.exit(0);
            }
            try {
                Hashtable hashtable = TopologyInitializer.getTopologyPluginFromDS(_info);
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    ITopologyPlugin iTopologyPlugin = (ITopologyPlugin)enumeration.nextElement();
                    ResourceObject resourceObject = iTopologyPlugin.getResourceObjectByID(string);
                    if (resourceObject == null) continue;
                    if (resourceObject instanceof ServerNode) {
                        ServerNode serverNode = (ServerNode)resourceObject;
                        IServerObject iServerObject = null;
                        serverNode.reload();
                        while ((iServerObject = serverNode.getServerObject()) == null) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        IResourceObject[] iResourceObjectArray = new IResourceObject[]{iServerObject};
                        iServerObject.run((IPage)null, iResourceObjectArray);
                        return;
                    }
                    if (!(resourceObject instanceof ServerNode)) continue;
                }
                Debug.println("ERROR Console.constructor: cannot find associated plugin for " + string);
            }
            catch (Exception exception) {
                Debug.println("ERROR Console.constructor: could not create " + string4);
                Debug.println("    Exception: " + exception);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("ERROR Console.constructor: createServerInstance failed");
            Debug.println("    LDAPException: " + (Object)((Object)lDAPException));
        }
        System.exit(0);
    }

    public Console(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        int n;
        LoginDialog loginDialog;
        String string8;
        Vector<String> vector = new Vector<String>();
        Console.common_init(string3, string7);
        String string9 = string5;
        String string10 = string6;
        _resource = new ResourceSet("com.netscape.management.client.console.console");
        if (string9 == null) {
            string9 = _preferences.getString(PREFERENCE_UID);
        }
        if ((string8 = _preferences.getString(PREFERENCE_URL)) != null) {
            vector.addElement(string8);
            if (string == null) {
                string = string8;
            }
        }
        if (string == null) {
            string = string2;
        }
        int n2 = 1;
        while (n2 < 5) {
            String string11 = _preferences.getString(PREFERENCE_URL + Integer.toString(n2));
            if (string11 != null && string11.length() > 0) {
                vector.addElement(string11);
            }
            ++n2;
        }
        this._frame = new JFrame();
        ((Frame)this._frame).setIconImage(new RemoteImage("com/netscape/management/client/images/Console16x_JLF.gif").getImage());
        ModalDialogUtil.setWindowLocation(this._frame);
        UtilConsoleGlobals.setServerAuthEnabled((boolean)true);
        this._splashScreen = new SplashScreen(this._frame);
        this._splashScreen.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        if (_showSplashScreen) {
            this._splashScreen.showWindow();
        }
        boolean bl = false;
        while (true) {
            loginDialog = null;
            this._splashScreen.setStatusText(_resource.getString("splash", "PleaseLogin"));
            this._splashScreen.setCursor(Cursor.getPredefinedCursor(3));
            if (string == null || string9 == null || string10 == null || bl) {
                loginDialog = new LoginDialog((Frame)this._frame, string9, string, vector);
                Dimension dimension = loginDialog.getSize();
                Dimension dimension2 = loginDialog.getToolkit().getScreenSize();
                int n3 = (dimension2.width - dimension.width) / 2;
                n = (dimension2.height - dimension.height) / 2;
                int n4 = _preferences.getInt(PREFERENCE_X, n3);
                int n5 = _preferences.getInt(PREFERENCE_Y, n);
                UtilConsoleGlobals.setAdminURL((String)string);
                UtilConsoleGlobals.setAdminHelpURL((String)string);
                loginDialog.setInitialLocation(n4, n5);
                this._splashScreen.setCursor(Cursor.getPredefinedCursor(0));
                loginDialog.showModal();
                if (loginDialog.isCancel()) {
                    System.exit(0);
                }
                this._splashScreen.toFront();
                this._splashScreen.setCursor(Cursor.getPredefinedCursor(3));
                string9 = loginDialog.getUsername();
                string = loginDialog.getURL();
                if (!string.startsWith("http://") && !string.startsWith("https://")) {
                    string = "http://" + string;
                }
                string10 = loginDialog.getPassword();
            }
            bl = true;
            UtilConsoleGlobals.setAdminURL((String)string);
            UtilConsoleGlobals.setAdminHelpURL((String)string);
            _consoleAdminURL = string;
            this._splashScreen.setStatusText(MessageFormat.format(_resource.getString("splash", "authenticate"), string9));
            if (!this.authenticate_user(string, _info, string9, string10)) continue;
            this._splashScreen.setStatusText(_resource.getString("splash", "initializing"));
            int n6 = this.LDAPinitialization(_info);
            if (n6 == 1) {
                Debug.println("Console: LDAPinitialization() failed.");
                System.exit(1);
                break;
            }
            if (n6 == 2) {
                Debug.println("Console: LDAPinitialization() DS restarted.");
                this._splashScreen.setStatusText(MessageFormat.format(_resource.getString("splash", "authenticate"), string9));
                if (!this.authenticate_user(string, _info, string9, string10)) continue;
                this._splashScreen.setStatusText(_resource.getString("splash", "initializing"));
                if (this.LDAPinitialization(_info) != 1) break;
                Debug.println("Console: LDAPinitialization() failed.");
                System.exit(1);
                break;
            }
            if (n6 != 3) break;
        }
        boolean bl2 = _preferences.getBoolean(PREFERENCE_REMEMBER_UID, true);
        if (bl2) {
            _preferences.set(PREFERENCE_UID, string9);
            _preferences.set(PREFERENCE_URL, string);
            n = 1;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string12 = (String)enumeration.nextElement();
                if (string12.equals(string)) continue;
                _preferences.set(PREFERENCE_URL + Integer.toString(n++), string12);
            }
            while (n < 5) {
                ((Hashtable)_preferences).remove(PREFERENCE_URL + Integer.toString(n));
                ++n;
            }
            if (loginDialog != null) {
                Point point = loginDialog.getLocation();
                _preferences.set(PREFERENCE_X, point.x);
                _preferences.set(PREFERENCE_Y, point.y);
                loginDialog.dispose();
                loginDialog = null;
            }
            _preferences.save();
        }
        this.initialize(_info);
        if (string4 == null) {
            Framework framework = new Framework((IFrameworkInitializer)this._topologyInitializer);
            UtilConsoleGlobals.setRootFrame((JFrame)framework.getJFrame());
        } else {
            this.createPerInstanceUI(string4);
        }
        this._frame.dispose();
        this._splashScreen.dispose();
        SplashScreen.removeInstance();
        this._splashScreen = null;
    }

    public Console(String string, String string2, boolean bl, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        Console.common_init(string6, string9);
        if (this.authenticate_user_DS(string, Integer.parseInt(string2), bl, string3, string4, string5)) {
            this._adminServerSIE = "ou=" + string7 + ",o=netscaperoot";
            this.initialize(_info);
            _info.put("ldapSecurity", bl ? "on" : "off");
            if (string8 == null) {
                Framework framework = new Framework((IFrameworkInitializer)this._topologyInitializer);
                UtilConsoleGlobals.setRootFrame((JFrame)framework.getJFrame());
            } else {
                this.createPerInstanceUI(string8);
            }
            return;
        }
    }

    public void setDomainSuffix(String string) {
        String string2 = "";
        if (string != null) {
            String string3 = string;
            int n = 0;
            int n2 = 0;
            while (n2 < 4) {
                n = string3.indexOf(44, n);
                ++n;
                ++n2;
            }
            string2 = string3.substring(n);
            LDAPUtil.setInstalledSoftwareDN(string2);
        }
    }

    public void initialize(ConsoleInfo consoleInfo) {
        this.setDomainSuffix(this._adminServerSIE);
        LDAPConnection lDAPConnection = _info.getLDAPConnection();
        this._topologyInitializer = new TopologyInitializer(_info);
        if (lDAPConnection != null) {
            Object object;
            Enumeration enumeration;
            Object object2;
            LDAPAttribute lDAPAttribute;
            LDAPEntry lDAPEntry;
            String string = "";
            try {
                string = "cn=user, cn=DefaultObjectClassesContainer," + LDAPUtil.getAdminGlobalParameterEntry();
                lDAPEntry = lDAPConnection.read(string);
                if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute("nsDefaultObjectClass", LDAPUtil.getLDAPAttributeLocale())) != null) {
                    object2 = new Vector();
                    enumeration = lDAPAttribute.getStringValues();
                    while (enumeration.hasMoreElements()) {
                        object = (String)enumeration.nextElement();
                        ((Vector)object2).addElement(object);
                    }
                    ResourceEditor.getNewObjectClasses().put("newUserObjectClasses", object2);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println("Console: Cannot open: " + string);
            }
            if (ResourceEditor.getNewObjectClasses().get("newUserObjectClasses") == null) {
                object2 = new Vector<String>();
                ((Vector)object2).addElement("top");
                ((Vector)object2).addElement("person");
                ((Vector)object2).addElement("organizationalPerson");
                ((Vector)object2).addElement("inetorgperson");
                ResourceEditor.getNewObjectClasses().put("newUserObjectClasses", object2);
            }
            try {
                string = "cn=group, cn=DefaultObjectClassesContainer," + LDAPUtil.getAdminGlobalParameterEntry();
                lDAPEntry = lDAPConnection.read(string);
                if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute("nsDefaultObjectClass", LDAPUtil.getLDAPAttributeLocale())) != null) {
                    object2 = new Vector();
                    enumeration = lDAPAttribute.getStringValues();
                    while (enumeration.hasMoreElements()) {
                        object = (String)enumeration.nextElement();
                        ((Vector)object2).addElement(object);
                    }
                    ResourceEditor.getNewObjectClasses().put("newGroupObjectClasses", object2);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println("Console: Cannot open " + string);
            }
            if (ResourceEditor.getNewObjectClasses().get("newGroupObjectClasses") == null) {
                object2 = new Vector();
                ((Vector)object2).addElement("top");
                ((Vector)object2).addElement("groupofuniquenames");
                ResourceEditor.getNewObjectClasses().put("newGroupObjectClasses", object2);
            }
            try {
                string = "cn=OU, cn=DefaultObjectClassesContainer," + LDAPUtil.getAdminGlobalParameterEntry();
                lDAPEntry = lDAPConnection.read(string);
                if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute("nsDefaultObjectClass", LDAPUtil.getLDAPAttributeLocale())) != null) {
                    object2 = new Vector();
                    enumeration = lDAPAttribute.getStringValues();
                    while (enumeration.hasMoreElements()) {
                        object = (String)enumeration.nextElement();
                        ((Vector)object2).addElement(object);
                    }
                    ResourceEditor.getNewObjectClasses().put("newOUObjectClasses", object2);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println("Console: Cannot open " + string);
            }
            if (ResourceEditor.getNewObjectClasses().get("newOUObjectClasses") == null) {
                object2 = new Vector();
                ((Vector)object2).addElement("top");
                ((Vector)object2).addElement("organizationalunit");
                ResourceEditor.getNewObjectClasses().put("newOUObjectClasses", object2);
            }
            try {
                Object object3;
                String string2;
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
                lDAPSearchConstraints.setBatchSize(1);
                string = "cn=ResourceEditorExtension," + LDAPUtil.getAdminGlobalParameterEntry();
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, "(Objectclass=nsAdminResourceEditorExtension)", null, false, lDAPSearchConstraints);
                object2 = new Hashtable();
                object = new Hashtable();
                if (lDAPSearchResults != null) {
                    while (lDAPSearchResults.hasMoreElements()) {
                        Object object4;
                        Object object5;
                        Object object6;
                        try {
                            string2 = lDAPSearchResults.next();
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        lDAPAttribute = string2.getAttribute("cn", LDAPUtil.getLDAPAttributeLocale());
                        object3 = lDAPAttribute.getStringValues();
                        String string3 = "";
                        if (object3.hasMoreElements()) {
                            string3 = (String)object3.nextElement();
                        }
                        lDAPAttribute = string2.getAttribute("nsClassname", LDAPUtil.getLDAPAttributeLocale());
                        if (lDAPAttribute != null) {
                            object3 = lDAPAttribute.getStringValues();
                            object6 = new Vector();
                            while (object3.hasMoreElements()) {
                                object5 = (String)object3.nextElement();
                                object4 = ClassLoaderUtil.getClass((ConsoleInfo)_info, (String)object5);
                                if (object4 == null) continue;
                                ((Vector)object6).addElement(object4);
                            }
                            ((Hashtable)object2).put(string3.toLowerCase(), object6);
                        }
                        if ((lDAPAttribute = string2.getAttribute("nsDeleteClassname", LDAPUtil.getLDAPAttributeLocale())) == null) continue;
                        object6 = lDAPAttribute.getStringValues();
                        object5 = new Vector();
                        while (object6.hasMoreElements()) {
                            object4 = (String)object6.nextElement();
                            Class clazz = ClassLoaderUtil.getClass((ConsoleInfo)_info, (String)object4);
                            if (clazz == null) continue;
                            ((Vector)object5).addElement(clazz);
                        }
                        ((Hashtable)object).put(string3.toLowerCase(), object5);
                    }
                    ResourceEditor.setResourceEditorExtension((Hashtable)object2);
                    ResourceEditor.setDeleteResourceEditorExtension((Hashtable)object);
                }
                ResourceEditor.setUniqueAttribute(LDAPUtil.getUniqueAttribute(_info.getLDAPConnection(), LDAPUtil.getCommonGlobalParameterEntry()));
                string2 = LDAPUtil.getCommonGlobalParameterEntry();
                lDAPEntry = lDAPConnection.read(string2);
                if (lDAPEntry != null) {
                    lDAPAttribute = lDAPEntry.getAttribute("nsUserRDNComponent");
                    object3 = LDAPUtil.flatting(lDAPAttribute);
                    ResourceEditor.setUserRDNComponent((String)object3);
                    lDAPAttribute = lDAPEntry.getAttribute("nsUserIDFormat");
                    object3 = LDAPUtil.flatting(lDAPAttribute);
                    ResourceEditor.setUserIDFormat((String)object3);
                    lDAPAttribute = lDAPEntry.getAttribute("nsGroupRDNComponent");
                    object3 = LDAPUtil.flatting(lDAPAttribute);
                    ResourceEditor.setGroupRDNComponent((String)object3);
                }
                ResourceEditor.setAccountPlugin(this.buildAccountPluginHashtable());
            }
            catch (LDAPException lDAPException) {
                Debug.println("Console: Cannot open " + string);
            }
            object2 = LDAPUtil.createEntry(lDAPConnection, LDAPUtil.getUserPreferenceOU(), LDAPUtil.getInstalledSoftwareDN());
            object2 = LDAPUtil.createEntry(lDAPConnection, "\"" + _info.getAuthenticationDN() + "\"", object2, true);
            _info.setUserPreferenceDN((String)object2);
        }
        this.checkHelpSystem();
    }

    protected void checkHelpSystem() {
        boolean bl = false;
        if (this._adminVersion != null) {
            bl = !this._adminVersion.startsWith("5.2") ? Double.parseDouble(this._adminVersion) >= 4.5 : true;
            Debug.println("Console.checkHelpSystem: contextHelp=" + bl);
        } else {
            Debug.println("Console.checkHelpSystem: cannot determine Admin Version");
        }
        UtilConsoleGlobals.setContextHelpEnabled((boolean)bl);
    }

    private Hashtable buildAccountPluginHashtable() {
        Hashtable hashtable;
        block9: {
            hashtable = new Hashtable();
            try {
                LDAPConnection lDAPConnection = _info.getLDAPConnection();
                String string = "cn=ResourceEditorExtension, " + LDAPUtil.getAdminGlobalParameterEntry();
                String[] stringArray = new String[]{"cn", "nsadminaccountInfo"};
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, "(nsadminaccountInfo=*)", stringArray, false);
                if (lDAPSearchResults == null) break block9;
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry;
                    try {
                        lDAPEntry = lDAPSearchResults.next();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                    Enumeration enumeration = lDAPAttributeSet.getAttributes();
                    String string2 = "";
                    Vector<String> vector = new Vector<String>();
                    while (enumeration.hasMoreElements()) {
                        LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                        if (lDAPAttribute.getName().equalsIgnoreCase("cn")) {
                            string2 = LDAPUtil.flatting(lDAPAttribute.getStringValues());
                            continue;
                        }
                        if (!lDAPAttribute.getName().equalsIgnoreCase("nsadminaccountInfo")) continue;
                        String string3 = LDAPUtil.flatting(lDAPAttribute.getStringValues());
                        boolean bl = false;
                        do {
                            int n;
                            if ((n = string3.indexOf(91)) < 0) {
                                bl = true;
                                continue;
                            }
                            int n2 = string3.indexOf(93, n + 1);
                            String string4 = string3.substring(n + 1, n2);
                            vector.addElement(string4);
                            string3 = string3.substring(n2 + 1);
                        } while (!bl);
                    }
                    if (string2 == null) continue;
                    hashtable.put(string2.toLowerCase(), vector);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println("Console.buildAccountPluginHashtable: ResEditorAccountPage LDAP Exception: " + (Object)((Object)lDAPException));
            }
        }
        return hashtable;
    }

    private boolean authenticate_user_DS(String string, int n, boolean bl, String string2, String string3, String string4) {
        String string5;
        KingpinLDAPConnection kingpinLDAPConnection;
        boolean bl2;
        block5: {
            bl2 = false;
            kingpinLDAPConnection = null;
            try {
                kingpinLDAPConnection = bl ? new KingpinLDAPConnection(UtilConsoleGlobals.getLDAPSSLSocketFactory(), string3, string4) : new KingpinLDAPConnection(string3, string4);
                kingpinLDAPConnection.connect(3, string, n, string3, string4);
                string5 = string3;
                bl2 = true;
            }
            catch (LDAPException lDAPException) {
                string5 = LDAPUtil.getDNFromUID(string, n, bl, string2, string3);
                if (string5 == null) break block5;
                try {
                    kingpinLDAPConnection = bl ? new KingpinLDAPConnection(UtilConsoleGlobals.getLDAPSSLSocketFactory(), string5, string4) : new KingpinLDAPConnection(string5, string4);
                    kingpinLDAPConnection.connect(3, string, n, string5, string4);
                    bl2 = true;
                }
                catch (LDAPException lDAPException2) {
                    Debug.println("Console.authenticate_user_ds: bad password");
                }
            }
        }
        if (bl2) {
            _info.setLDAPConnection((LDAPConnection)kingpinLDAPConnection);
            _info.setAuthenticationDN(string5);
            _info.setAuthenticationPassword(string4);
            _info.setHost(string);
            _info.setPort(n);
            _info.setBaseDN(string2);
        }
        return bl2;
    }

    private final synchronized boolean authenticate_user(String string, ConsoleInfo consoleInfo, String string2, String string3) {
        URL uRL;
        try {
            uRL = new URL(new URL(string), "/admin-serv/authenticate");
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println("Console:authenticate_user():Unable to create authentication URL");
            return false;
        }
        Hashtable hashtable = new Hashtable();
        boolean bl = this.invoke_task(uRL, string2, string3, hashtable);
        String string4 = (String)hashtable.get("NW_PASSWD_EXPIRING");
        if (string4 != null) {
            int n = Integer.parseInt(string4);
            if (n == 0) {
                String string5 = _resource.getString("error", "pwExpired");
                System.err.println(string5);
                JOptionPane.showMessageDialog(SplashScreen.getInstance(), string5, _resource.getString("error", "pwTitle"), 0);
                ModalDialogUtil.sleep();
                System.exit(1);
            } else {
                double d = (double)n / 86400.0;
                String string6 = MessageFormat.format(_resource.getString("warning", "pwExpireSoon"), new Double(d));
                Debug.println("Console: " + string6);
                JOptionPane.showMessageDialog(SplashScreen.getInstance(), string6, _resource.getString("warning", "title"), 0);
                ModalDialogUtil.sleep();
            }
        }
        if (!bl) {
            return false;
        }
        string4 = (String)hashtable.get("UserDN");
        if (string4 != null) {
            consoleInfo.setAuthenticationDN(string4);
        } else {
            Debug.println("Console:authenticate_user():UserDN not found");
            consoleInfo.setAuthenticationDN(string2);
        }
        consoleInfo.setAuthenticationPassword(string3);
        consoleInfo.setAuthenticationValues(hashtable);
        return true;
    }

    protected boolean restartDirectoryServer(String string, String string2, String string3) {
        URL uRL;
        try {
            uRL = new URL(new URL(string3), "/admin-serv/tasks/operation/StartConfigDS");
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println("Console:restartDirectoryServer():Unable to create start task URL");
            JOptionPane.showMessageDialog(SplashScreen.getInstance(), _resource.getString("error", "url-incorrect-msg"), _resource.getString("error", "url-incorrect-title"), 0);
            return false;
        }
        return this.invoke_task(uRL, string, string2, new Hashtable());
    }

    private final synchronized boolean invoke_task(URL uRL, String string, String string2, Hashtable hashtable) {
        String string3;
        BufferedReader bufferedReader;
        InputStream inputStream;
        Response response;
        HttpManager httpManager = new HttpManager();
        Exception exception = null;
        try {
            response = new Response(string, string2);
            httpManager.get(uRL, (CommClient)this, (Object)response, 2);
        }
        catch (Exception exception2) {
            String string4;
            try {
                string4 = new URL(uRL, "/").toString();
            }
            catch (MalformedURLException malformedURLException) {
                string4 = uRL.toString();
            }
            String string5 = MessageFormat.format(_resource.getString("error", "connectAS"), string4);
            JOptionPane.showMessageDialog(SplashScreen.getInstance(), string5, _resource.getString("error", "title"), 0);
            ModalDialogUtil.sleep();
            return false;
        }
        try {
            while ((inputStream = response.getInputStream()) == null && (exception = response.getError()) == null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            Debug.println("Console:invoke_task():task response interrupted");
            return false;
        }
        if (exception != null) {
            String string6 = MessageFormat.format(_resource.getString("error", "task"), exception.toString());
            JOptionPane.showMessageDialog(SplashScreen.getInstance(), string6, _resource.getString("error", "title"), 0);
            ModalDialogUtil.sleep();
            if (!(exception instanceof HttpException)) {
                Debug.println("Console:invoke_task():error:" + exception);
            }
            return false;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
        }
        catch (Exception exception3) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            Debug.println("Console:BufferedReader(UTF8) Error");
        }
        try {
            while ((string3 = bufferedReader.readLine()) != null) {
                int n = string3.indexOf(58);
                if (n == -1) continue;
                hashtable.put(string3.substring(0, n), string3.substring(n + 2));
            }
        }
        catch (Exception exception4) {
            // empty catch block
        }
        string3 = (String)hashtable.get("NMC_Status");
        if (string3 == null || Integer.parseInt(string3) != 0) {
            Debug.println("Console:invoke_task():invocation failed");
            return false;
        }
        return true;
    }

    private final int LDAPinitialization(ConsoleInfo consoleInfo) {
        LDAPConnection lDAPConnection;
        Hashtable hashtable = _info.getAuthenticationValues();
        String string = (String)hashtable.get("SIE");
        if (string != null) {
            this._adminServerSIE = string;
        } else {
            Debug.println("Console:authenticate_user():SIE not found");
        }
        string = (String)hashtable.get("ldapHost");
        if (string != null) {
            consoleInfo.setHost(string);
        } else {
            Debug.println("Console:authenticate_user():ldapHost not found");
        }
        string = (String)hashtable.get("ldapPort");
        if (string != null) {
            consoleInfo.setPort(Integer.parseInt(string));
        } else {
            Debug.println("Console:authenticate_user():ldapPort not found");
        }
        string = (String)hashtable.get("ldapBaseDN");
        if (string != null) {
            consoleInfo.setBaseDN(string);
        } else {
            Debug.println("Console:authenticate_user():ldapBaseDN not found");
        }
        string = (String)hashtable.get("ldapSecurity");
        boolean bl = false;
        if (string != null && string.equals("on")) {
            consoleInfo.put("ldapSecurity", "on");
            bl = true;
        } else {
            consoleInfo.put("ldapSecurity", "off");
        }
        try {
            lDAPConnection = this.createLDAPConnection(consoleInfo);
            if (lDAPConnection == null) {
                return 3;
            }
            consoleInfo.setLDAPConnection(lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            String string2 = (bl ? "ldaps" : "ldap") + "://" + consoleInfo.getHost() + ":" + consoleInfo.getPort();
            String string3 = MessageFormat.format(_resource.getString("error", "connectDS"), string2, lDAPException.getMessage());
            Debug.println("Console:authenticate_user():" + string3);
            if (this._dsHasBeenRestarted) {
                JOptionPane.showMessageDialog(SplashScreen.getInstance(), string3, _resource.getString("error", "title"), 0);
                ModalDialogUtil.sleep();
                return 1;
            }
            Object[] objectArray = new Object[]{_resource.getString("error", "restartDSButton"), _resource.getString("error", "cancelButton")};
            Object[] objectArray2 = new Object[]{string3, " ", _resource.getString("error", "restartDSMessage"), " "};
            int n = JOptionPane.showOptionDialog(SplashScreen.getInstance(), objectArray2, _resource.getString("error", "inittitle"), -1, 3, null, objectArray, objectArray[0]);
            if (n == 1) {
                System.exit(1);
            }
            boolean bl2 = false;
            RestartDialog restartDialog = new RestartDialog(this._frame);
            restartDialog.setDialogLocation(this._frame);
            restartDialog.setModal(true);
            while (true) {
                restartDialog.show();
                if (restartDialog.isCancel()) {
                    if (!bl2) {
                        System.exit(0);
                    } else {
                        return 1;
                    }
                }
                this._splashScreen.toFront();
                if (this.restartDirectoryServer(restartDialog.getUsername(), restartDialog.getPassword(), restartDialog.getURL())) break;
                bl2 = true;
            }
            string3 = _resource.getString("info", "restartDS");
            JOptionPane.showMessageDialog(SplashScreen.getInstance(), string3, _resource.getString("info", "restartDSTitle"), 1);
            this._dsHasBeenRestarted = true;
            return 2;
        }
        string = (String)hashtable.get("UserDirectory");
        if (string != null && !string.equals("?")) {
            lDAPConnection = null;
            boolean bl3 = false;
            String string4 = consoleInfo.getHost();
            int n = consoleInfo.getPort();
            String string5 = consoleInfo.getBaseDN();
            int n2 = 7;
            if (string.startsWith("ldaps://")) {
                bl3 = true;
                n2 = 8;
            }
            int n3 = string.indexOf(47, 8);
            int n4 = string.indexOf(58, 8);
            int n5 = string.indexOf(32, 8);
            if (n3 > n4 && n4 != -1) {
                n = n5 != -1 && n5 < n3 ? Integer.parseInt(string.substring(n4 + 1, n5)) : Integer.parseInt(string.substring(n4 + 1, n3));
                string4 = string.substring(n2, n4);
            } else {
                string4 = string.substring(n2, n3);
            }
            string5 = string.substring(n3 + 1);
            consoleInfo.setUserHost(string4);
            consoleInfo.setUserPort(n);
            consoleInfo.setUserBaseDN(string5);
            lDAPConnection = bl3 ? new KingpinLDAPConnection(UtilConsoleGlobals.getLDAPSSLSocketFactory(), consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword()) : new KingpinLDAPConnection(consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
            try {
                lDAPConnection.connect(consoleInfo.getUserHost(), consoleInfo.getUserPort());
                lDAPConnection.authenticate(3, consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
            }
            catch (Exception exception) {
                Debug.println("Console: cannot connect to the user database");
            }
            consoleInfo.setUserLDAPConnection(lDAPConnection);
        } else {
            Debug.println("Console.authenticate_user():UserDirectory value not found");
        }
        return 0;
    }

    protected LDAPConnection createLDAPConnection(ConsoleInfo consoleInfo) throws LDAPException {
        KingpinLDAPConnection kingpinLDAPConnection = null;
        kingpinLDAPConnection = consoleInfo.get("ldapSecurity").equals("on") ? new KingpinLDAPConnection(UtilConsoleGlobals.getLDAPSSLSocketFactory(), consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword()) : new KingpinLDAPConnection(consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
        kingpinLDAPConnection.connect(consoleInfo.getHost(), consoleInfo.getPort());
        try {
            kingpinLDAPConnection.authenticate(3, consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, _resource.getString("error", "cannotconnect") + exception, _resource.getString("error", "title"), 0);
            kingpinLDAPConnection = null;
        }
        return kingpinLDAPConnection;
    }

    public synchronized void replyHandler(InputStream inputStream, CommRecord commRecord) {
        HttpChannel httpChannel = (HttpChannel)commRecord.getChannel();
        if (httpChannel != null) {
            this._adminVersion = httpChannel.getAdminVersion();
            Debug.println("Console.replyHandler: adminVersion = " + this._adminVersion);
        } else {
            Debug.println("Console.replyHandler: no channel");
        }
        ((Response)commRecord.getArg()).setInputStream(inputStream);
        this.notifyAll();
    }

    public synchronized void errorHandler(Exception exception, CommRecord commRecord) {
        ((Response)commRecord.getArg()).setError(exception);
        this.notifyAll();
    }

    public String username(Object object, CommRecord commRecord) {
        return ((Response)commRecord.getArg()).getUsername();
    }

    public String password(Object object, CommRecord commRecord) {
        return ((Response)commRecord.getArg()).getPassword();
    }

    private static void waitForKeyPress() {
        if (System.getProperty("os.name").startsWith("Win")) {
            System.out.print("\nPress Enter key to continue ...");
            try {
                System.in.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        String string;
        String string2;
        Object object;
        Object object2;
        String string3;
        GetOpt getOpt = new GetOpt("h:a:A:f:l:d:p:b:u:w:s:D:o:x:Z:L", stringArray);
        if (getOpt.hasOption('f')) {
            string3 = getOpt.getOptionParam('f');
            try {
                TeeStream.tee(string3);
            }
            catch (Exception exception) {
                System.err.println("Missing or invalid output file specification for the -f option: " + exception);
                System.exit(1);
            }
        }
        if (getOpt.hasOption('D')) {
            Debug.setApplicationStartTime(_t0);
            string3 = getOpt.getOptionParam('D');
            if (string3 != null) {
                if (string3.equals("?") || !Debug.setTraceMode(string3)) {
                    System.out.println(Debug.getUsage());
                    Console.waitForKeyPress();
                    System.exit(0);
                }
            } else {
                Debug.setTraceMode(null);
            }
            if (Debug.getTraceLevel() == 9) {
                try {
                    object2 = System.getProperties();
                    object = ((Hashtable)object2).keys();
                    while (object.hasMoreElements()) {
                        string2 = (String)object.nextElement();
                        string = (String)((Hashtable)object2).get(string2);
                        Debug.println(9, string2 + "=" + string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Debug.println(0, "Sun-ONE-Console/" + VersionInfo.getVersionNumber() + " B" + VersionInfo.getBuildNumber());
        string3 = null;
        object2 = System.getProperty("os.name");
        if (object2 != null && ((String)object2).indexOf("Windows") != -1) {
            Debug.println(7, "Console: windows os detected");
            string3 = "windows";
        } else {
            Debug.println(7, "Console: unix os detected");
            string3 = "metal";
        }
        if (getOpt.hasOption('x')) {
            object = getOpt.getOptionParam('x');
            boolean bl = false;
            if (object == null) {
                object = "";
            }
            if (((String)object).indexOf(OPTION_NOLOGO) != -1) {
                _showSplashScreen = false;
                bl = true;
            }
            if (((String)object).indexOf(OPTION_NOWINPOS) != -1) {
                Framework.setEnableWinPositioning(false);
                bl = true;
            }
            if (((String)object).indexOf("windows") != -1) {
                string3 = "windows";
                bl = true;
            }
            if (((String)object).indexOf("motif") != -1) {
                string3 = "motif";
                bl = true;
            }
            if (((String)object).indexOf("metal") != -1) {
                string3 = "metal";
                bl = true;
            }
            if (!bl) {
                getOpt = new GetOpt("h:", new String[]{"-h"});
            }
        }
        if (getOpt.hasOption('d')) {
            object = getOpt.getOptionParam('d');
            string2 = getOpt.getOptionParam('p');
            string = getOpt.getOptionParam('b');
            String string4 = getOpt.getOptionParam('u');
            String string5 = getOpt.getOptionParam('w');
            if (object == null || string2 == null || string == null || string4 == null) {
                System.err.println("Error: missing Directory Host, Directory Port, BaseDN or UserDN for Directory Server authentication");
                System.err.println("The syntax is:");
                System.err.println("   -d <Directory Host Name>");
                System.err.println("   -p <Port number>");
                System.err.println("   -b <Base DN>");
                System.err.println("   -u <User DN>");
                System.err.println("   -w <password>");
                System.err.println("   -o <Domain DN>");
                System.err.println("   -s <Server DN>");
                Console.waitForKeyPress();
                System.exit(0);
            }
            String string6 = null;
            String string7 = null;
            String string8 = null;
            if (getOpt.hasOption('l')) {
                string6 = getOpt.getOptionParam('l');
            }
            if (getOpt.hasOption('s')) {
                string8 = getOpt.getOptionParam('s');
            }
            if (getOpt.hasOption('o')) {
                string7 = getOpt.getOptionParam('o');
            } else {
                System.err.println("Error: missing -o option for Directory Server authentication");
                System.err.println("       Please provide domain information. ie, -o \"mcom.com\".");
                Console.waitForKeyPress();
                System.exit(0);
            }
            if (string5 == null) {
                class PasswordDialog
                extends AbstractDialog {
                    JPasswordField jpf;

                    public PasswordDialog() {
                        super(null, _resource.getString("login", "passwordDialogTitle"), true, 1);
                        this.jpf = new JPasswordField(20);
                        Container container = this.getContentPane();
                        container.setLayout(new GridBagLayout());
                        this.setFocusComponent(this.jpf);
                        JLabel jLabel = new JLabel(_resource.getString("login", "password"));
                        jLabel.setLabelFor(this.jpf);
                        GridBagUtil.constrain(container, jLabel, 0, 0, 1, 1, 0.0, 0.0, 13, 0, 0, 0, 0, 9);
                        GridBagUtil.constrain(container, this.jpf, 1, 0, 1, 1, 0.0, 0.0, 13, 0, 0, 0, 0, 0);
                        this.pack();
                        ModalDialogUtil.setCenteredDialog(this);
                        this.show();
                    }

                    public String getPassword() {
                        return new String(this.jpf.getPassword());
                    }
                }
                string5 = new PasswordDialog().getPassword();
            }
            boolean bl = getOpt.hasOption('Z');
            if (string4 == null) {
                string4 = "cn=Directory Manager";
            }
            _console = new Console((String)object, string2, bl, string, string4, string5, string6, string7, string8, string3);
            return;
        }
        if (getOpt.hasOption('h')) {
            System.err.println("Syntax:  Console [-a <URL>] [-l <Language Code>] [-s <SIE DN>] [-x <options>]");
            System.err.println("         -a admin server base URL");
            System.err.println("         -l language code (en fr gr)");
            System.err.println("         -f <file> capture stderr and stdout to <file> (like Unix tee command)");
            System.err.println("         -s server DN");
            System.err.println("         -L look and feel (metal, motif, windows)");
            System.err.println("         -x extra options (nowinpos,nologo)");
            System.err.println("\nExample: Console -a https://hostname:10021 -l en");
            Console.waitForKeyPress();
            System.exit(0);
        }
        object = null;
        if (getOpt.hasOption('a')) {
            object = getOpt.getOptionParam('a');
        }
        string2 = null;
        if (getOpt.hasOption('A')) {
            string2 = getOpt.getOptionParam('A');
        }
        string = null;
        if (getOpt.hasOption('l')) {
            string = getOpt.getOptionParam('l');
        }
        String string9 = null;
        if (getOpt.hasOption('s')) {
            string9 = getOpt.getOptionParam('s');
        }
        String string10 = null;
        if (getOpt.hasOption('u')) {
            string10 = getOpt.getOptionParam('u');
        }
        String string11 = null;
        if (getOpt.hasOption('w')) {
            string11 = getOpt.getOptionParam('w');
        }
        _console = new Console((String)object, string2, string, string9, string10, string11, string3);
    }

    static {
        _showSplashScreen = true;
        if (_preferences == null) {
            _preferences = new FilePreferences(PREFERENCES_LOGIN);
        }
    }
}

