/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class IPByteField
extends JTextField {
    private Toolkit toolkit;
    private NumberFormat integerFormatter;
    private char wildcardCharacter = (char)42;
    private boolean isWildcardAllowed = false;

    public IPByteField() {
        this("");
    }

    public IPByteField(String string) {
        super(3);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.integerFormatter = NumberFormat.getNumberInstance(Locale.US);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setText(string);
        this.setHorizontalAlignment(4);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    protected Document createDefaultModel() {
        return new IPByteDocument();
    }

    public int getValue() {
        int n = 0;
        try {
            n = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return n;
    }

    public void setValue(int n) {
        this.setText(this.integerFormatter.format(n));
    }

    public void setWildcardAllowed(boolean bl) {
        this.isWildcardAllowed = bl;
    }

    public boolean isWildcardAllowed() {
        return this.isWildcardAllowed;
    }

    class IPByteDocument
    extends PlainDocument {
        IPByteDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 < cArray.length) {
                char c = cArray[n3];
                if (Character.isDigit(c)) {
                    cArray2[n2++] = c;
                } else if (c == IPByteField.this.wildcardCharacter) {
                    if (IPByteField.this.isWildcardAllowed) {
                        cArray2[n2++] = c;
                    }
                } else if (this.getLength() > 0 && (c == '.' || c == ' ')) {
                    IPByteField.this.transferFocus();
                    break;
                }
                ++n3;
            }
            if (this.getLength() < 3 && !IPByteField.this.getText().equals("*")) {
                super.insertString(n, new String(cArray2, 0, n2), attributeSet);
            }
            if (this.getLength() >= 3) {
                IPByteField.this.transferFocus();
            }
        }
    }
}

