/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.UIConstants;
import com.netscape.management.client.util.Help;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GenericDialog
extends JDialog
implements UIConstants {
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 0;
    public static final int NO_BUTTONS = 0;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int CLOSE = 4;
    public static final int HELP = 8;
    public static final int OK_CANCEL_HELP = 11;
    public static final int CLOSE_HELP = 12;
    private static final int DO_NOTHING = 0;
    private static final int DO_ACTION = 1;
    private static final int DO_CANCEL = 2;
    private int actionPerformed = 0;
    private FocusListener focusListener = new ButtonFocusListener();
    private KeyListener textFieldKeyListener = new TextFieldKeyListener();
    private Frame parentFrame = null;
    private JComponent focusComponent = null;
    private JPanel contentPanel = new JPanel(new BorderLayout());
    private JPanel extraPanel = null;
    private JButton defaultButton = null;
    private JButton closeButton = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton helpButton = null;
    private int minWidth = 0;
    private int minHeight = 0;
    private String helpProduct = null;
    private String helpTopic = null;

    public GenericDialog(JFrame jFrame) {
        this(jFrame, "");
    }

    public GenericDialog(JFrame jFrame, String string) {
        this(jFrame, string, 11);
    }

    public GenericDialog(JFrame jFrame, String string, int n) {
        this(jFrame, string, n, 1);
    }

    public GenericDialog(JFrame jFrame, String string, int n, int n2) {
        super(jFrame, string, true);
        this.addComponentListener(new ResizeComponentListener());
        this.addWindowListener(new DialogWindowListener());
        Container container = super.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = n == 0 ? new Insets(9, 9, 9, 9) : (n2 == 0 ? new Insets(9, 9, 12, 9) : new Insets(9, 9, 9, 12));
        gridBagLayout.setConstraints(this.contentPanel, gridBagConstraints);
        container.add(this.contentPanel);
        JPanel jPanel = this.createButtonPanel(n, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        if (n2 == 0) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.insets = new Insets(0, 9, 9, 9);
        } else {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(9, 0, 9, 9);
        }
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
    }

    private JPanel createButtonPanel(int n, int n2) {
        Object[] objectArray;
        Vector<JButton> vector = new Vector<JButton>();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.extraPanel = new JPanel(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        DefaultActionListener defaultActionListener = new DefaultActionListener();
        if (n2 == 0) {
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 2;
            objectArray = this.getButtonComponent();
            gridBagLayout.setConstraints(this.extraPanel, gridBagConstraints);
            jPanel.add(this.extraPanel);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        } else {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        }
        if ((n & 1) == 1) {
            this.okButton = ButtonFactory.createPredefinedButton("OK", defaultActionListener);
            this.okButton.addFocusListener(this.focusListener);
            vector.addElement(this.okButton);
            this.setDefaultButton(1);
            gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
            jPanel.add(this.okButton);
        }
        if ((n & 2) == 2) {
            gridBagConstraints.insets = n2 == 0 ? new Insets(0, 6, 0, 0) : new Insets(6, 0, 0, 0);
            this.cancelButton = ButtonFactory.createPredefinedButton("CANCEL", defaultActionListener);
            this.cancelButton.addFocusListener(this.focusListener);
            this.setFocusComponent(this.cancelButton);
            this.setDefaultButton(4);
            vector.addElement(this.cancelButton);
            gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
            jPanel.add(this.cancelButton);
        }
        if ((n & 4) == 4) {
            this.closeButton = ButtonFactory.createPredefinedButton("CLOSE", defaultActionListener);
            this.closeButton.addFocusListener(this.focusListener);
            this.setFocusComponent(this.closeButton);
            this.setDefaultButton(4);
            vector.addElement(this.closeButton);
            gridBagLayout.setConstraints(this.closeButton, gridBagConstraints);
            jPanel.add(this.closeButton);
        }
        if ((n & 8) == 8) {
            gridBagConstraints.insets = n2 == 0 ? new Insets(0, 12, 0, 0) : new Insets(12, 0, 0, 0);
            this.helpButton = ButtonFactory.createPredefinedButton("HELP", defaultActionListener);
            this.helpButton.addFocusListener(this.focusListener);
            vector.addElement(this.helpButton);
            gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
            jPanel.add(this.helpButton);
        }
        if (n2 == 1) {
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(this.extraPanel, gridBagConstraints);
            jPanel.add(this.extraPanel);
        }
        objectArray = new JButton[vector.size()];
        vector.copyInto(objectArray);
        ButtonFactory.resizeButtons((JButton[])objectArray);
        return jPanel;
    }

    protected JComponent getButtonComponent() {
        if (this.extraPanel.getComponentCount() > 0) {
            return (JComponent)this.extraPanel.getComponent(0);
        }
        return null;
    }

    protected void setButtonComponent(JComponent jComponent) {
        this.extraPanel.removeAll();
        this.extraPanel.add(jComponent);
    }

    public Container getContentPane() {
        return this.contentPanel;
    }

    public void setMinimumSize(Dimension dimension) {
        this.setMinimumSize(dimension.width, dimension.height);
    }

    public void setMinimumSize(int n, int n2) {
        this.minWidth = n;
        this.minHeight = n2;
        super.setSize(n, n2);
    }

    public void setHelpTopic(String string, String string2) {
        this.helpProduct = string;
        this.helpTopic = string2;
    }

    public String getHelpTopic() {
        return this.helpTopic;
    }

    private void addTextFieldKeyListener(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JTextField) {
                componentArray[n].removeKeyListener(this.textFieldKeyListener);
                componentArray[n].addKeyListener(this.textFieldKeyListener);
            } else if (componentArray[n] instanceof Container) {
                this.addTextFieldKeyListener((Container)componentArray[n]);
            }
            ++n;
        }
    }

    public void show() {
        this.addTextFieldKeyListener(this.contentPanel);
        if (this.parentFrame == null) {
            this.centerDialog();
        }
        this.pack();
        super.show();
    }

    private void centerDialog() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        ((Component)this).setLocation(n2, n);
    }

    public void setDefaultButton(int n) {
        switch (n) {
            case 1: {
                this.setDefaultButton(this.okButton);
                break;
            }
            case 2: {
                this.setDefaultButton(this.cancelButton);
                break;
            }
            case 4: {
                this.setDefaultButton(this.closeButton);
                break;
            }
            case 8: {
                this.setDefaultButton(this.helpButton);
            }
        }
    }

    public void setDefaultButton(JButton jButton) {
        this.defaultButton = jButton;
        this.getRootPane().setDefaultButton(jButton);
    }

    public void setFocusComponent(JComponent jComponent) {
        this.focusComponent = jComponent;
    }

    public JComponent getFocusComponent() {
        return this.focusComponent;
    }

    public void setOKButtonEnabled(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    public boolean isCancel() {
        return this.actionPerformed == 2;
    }

    protected void closeInvoked() {
        this.actionPerformed = 1;
        ((Component)this).setVisible(false);
    }

    protected void okInvoked() {
        this.actionPerformed = 1;
        ((Component)this).setVisible(false);
    }

    protected void cancelInvoked() {
        this.actionPerformed = 2;
        ((Component)this).setVisible(false);
    }

    protected void helpInvoked() {
        if (this.helpProduct == null || this.helpTopic == null) {
            throw new IllegalStateException("Help product or token not set.");
        }
        Help.showContextHelp(this.helpProduct, this.helpTopic);
    }

    class DefaultActionListener
    implements ActionListener {
        DefaultActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                if (string.equals("OK")) {
                    GenericDialog.this.okInvoked();
                } else if (string.equals("CLOSE")) {
                    GenericDialog.this.closeInvoked();
                } else if (string.equals("CANCEL")) {
                    GenericDialog.this.cancelInvoked();
                } else if (string.equals("HELP")) {
                    GenericDialog.this.helpInvoked();
                }
            }
        }
    }

    class DialogWindowListener
    extends WindowAdapter {
        DialogWindowListener() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            if (GenericDialog.this.focusComponent != null) {
                GenericDialog.this.focusComponent.requestFocus();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            GenericDialog.this.cancelInvoked();
        }
    }

    class ResizeComponentListener
    extends ComponentAdapter {
        ResizeComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (GenericDialog.this.isResizable()) {
                boolean bl;
                boolean bl2 = GenericDialog.this.getSize().width < GenericDialog.this.minWidth;
                boolean bl3 = bl = GenericDialog.this.getSize().height < GenericDialog.this.minHeight;
                if (bl2 || bl) {
                    ((Component)GenericDialog.this).setSize(bl2 ? GenericDialog.this.minWidth : GenericDialog.this.getSize().width, bl ? GenericDialog.this.minHeight : GenericDialog.this.getSize().height);
                }
            }
        }
    }

    class TextFieldKeyListener
    extends KeyAdapter {
        TextFieldKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && GenericDialog.this.defaultButton != null) {
                GenericDialog.this.defaultButton.doClick();
            }
        }
    }

    class ButtonFocusListener
    extends FocusAdapter {
        ButtonFocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            GenericDialog.this.setDefaultButton(GenericDialog.this.defaultButton);
        }
    }
}

