/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acl.ACL;
import com.netscape.management.client.acl.Rule;
import com.netscape.management.client.acleditor.ACLEditor;
import com.netscape.management.client.acleditor.ACLEditorConstants;
import com.netscape.management.client.acleditor.ACLEditorWindow;
import com.netscape.management.client.acleditor.ACLRuleTableWindow;
import com.netscape.management.client.acleditor.ACLSelectorWindow;
import com.netscape.management.client.acleditor.AttributesWindow;
import com.netscape.management.client.acleditor.DataModelAdapter;
import com.netscape.management.client.acleditor.PickerWindow;
import com.netscape.management.client.acleditor.RightsWindow;
import com.netscape.management.client.acleditor.SyntaxWindow;
import com.netscape.management.client.acleditor.TimeWindow;
import com.netscape.management.client.acleditor.WindowFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;

public class DefaultWindowFactory
implements WindowFactory,
ACLEditorConstants {
    public static ResourceSet defaultResourceSet = new ResourceSet("com.netscape.management.client.acleditor.ACLResources");
    public static Help defaultHelp = null;
    public String sessionIdentifier = "<not specified>";
    protected ACLEditorWindow selectorWindow = null;

    public DefaultWindowFactory() {
    }

    public DefaultWindowFactory(String string) {
        this.sessionIdentifier = string;
    }

    public ResourceSet getResourceSet() {
        return defaultResourceSet;
    }

    public Help getHelp() {
        if (defaultHelp != null) {
            return defaultHelp;
        }
        defaultHelp = new Help(this.getResourceSet());
        return defaultHelp;
    }

    public String getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    public void setSessionIdentifier(String string) {
        this.sessionIdentifier = string;
    }

    public ACLEditorWindow createUserGroupWindow(DataModelAdapter dataModelAdapter, ConsoleInfo consoleInfo) {
        return new PickerWindow("userGroup", this, dataModelAdapter, consoleInfo);
    }

    public ACLEditorWindow createHostsWindow(DataModelAdapter dataModelAdapter, ConsoleInfo consoleInfo) {
        return new PickerWindow("hosts", this, dataModelAdapter, consoleInfo);
    }

    public ACLEditorWindow createRightsWindow(DataModelAdapter dataModelAdapter) {
        return new RightsWindow("rights", this, dataModelAdapter);
    }

    public ACLEditorWindow createTimeWindow(Rule rule) {
        return new TimeWindow("time", this, rule);
    }

    public ACLEditorWindow createSyntaxWindow(ACL aCL) {
        return new SyntaxWindow("syntax", this, aCL);
    }

    public ACLEditorWindow createAttributesWindow(ACL aCL) {
        return new AttributesWindow("attributes", this, aCL);
    }

    public ACLEditorWindow createTestACLWindow(ConsoleInfo consoleInfo, Object object) {
        System.err.println("Test ACL Window unimplemented");
        return null;
    }

    public ACLEditorWindow createACLSelectorWindow(ACLEditor aCLEditor) {
        if (this.selectorWindow != null) {
            return this.selectorWindow;
        }
        this.selectorWindow = new ACLSelectorWindow(aCLEditor);
        return this.selectorWindow;
    }

    public ACLEditorWindow createACLRuleTableWindow(ACLEditor aCLEditor) {
        return new ACLRuleTableWindow(aCLEditor.getConsoleInfo(), aCLEditor.getDataModelFactory(), aCLEditor.getWindowFactory(), aCLEditor.getSessionLabel());
    }
}

