/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acl;

import com.netscape.management.client.acl.AttributeList;
import com.netscape.management.client.acl.Rule;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

public class LdapRule
extends Rule {
    public static final String timeAttribute = "timeofday";
    public static final String dayAttribute = "dayofweek";
    public static final String userAttribute = "userdn";
    public static final String groupAttribute = "groupdn";
    public static final String hostAttribute = "dns";
    public static final String ipaddrAttribute = "ip";

    public LdapRule(StreamTokenizer streamTokenizer) throws IOException {
        super(streamTokenizer);
    }

    public LdapRule() {
    }

    protected void setDefaults() {
        this.setAllow(false);
        this.setRight("all");
        this.setAttribute(userAttribute, "ldap:///anyone");
    }

    protected String newLine() {
        return " ";
    }

    protected String indent() {
        return "";
    }

    protected void writeContent(Writer writer) throws IOException {
        if (this.syntaxOverrideSet()) {
            writer.write(this.syntax + this.newLine());
            return;
        }
        if (this.attr.size() == 0) {
            return;
        }
        Hashtable hashtable = new Hashtable();
        String[] stringArray = new String[]{timeAttribute, dayAttribute};
        int n = 0;
        while (n < stringArray.length) {
            if (this.processAttribute(stringArray[n], writer, hashtable)) {
                return;
            }
            ++n;
        }
        String[] stringArray2 = new String[]{userAttribute, groupAttribute};
        if (this.processAttributes(stringArray2, writer, hashtable)) {
            return;
        }
        String[] stringArray3 = new String[]{hostAttribute, ipaddrAttribute};
        if (this.processAttributes(stringArray3, writer, hashtable)) {
            return;
        }
        writer.write("(");
        Enumeration enumeration = this.attr.keys();
        while (true) {
            String string = (String)enumeration.nextElement();
            writer.write(this.indent() + this.getAttributeList(string).generateExpression(string));
            if (!enumeration.hasMoreElements()) {
                writer.write(");" + this.newLine());
                this.restoreAttributeLists(hashtable);
                return;
            }
            writer.write(" or" + this.newLine());
        }
    }

    protected boolean processAttribute(String string, Writer writer, Hashtable hashtable) throws IOException {
        AttributeList attributeList = this.getAttributeList(string);
        if (attributeList == null) {
            return false;
        }
        writer.write(this.indent() + attributeList.generateExpression(string));
        hashtable.put(string, attributeList);
        this.removeAttributeList(string);
        if (this.attr.size() == 0) {
            writer.write(";" + this.newLine());
            this.restoreAttributeLists(hashtable);
            return true;
        }
        writer.write(" and" + this.newLine());
        return false;
    }

    protected boolean processAttributes(String[] stringArray, Writer writer, Hashtable hashtable) throws IOException {
        boolean bl;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (this.attr.containsKey(stringArray[n2])) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return false;
        }
        boolean bl2 = bl = n > 1;
        if (bl) {
            writer.write("(");
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            AttributeList attributeList = this.getAttributeList(stringArray[n3]);
            if (attributeList != null) {
                writer.write(this.indent() + attributeList.generateExpression(stringArray[n3]));
                hashtable.put(stringArray[n3], attributeList);
                this.removeAttributeList(stringArray[n3]);
                if (--n == 0) {
                    if (bl) {
                        writer.write(")");
                    }
                } else {
                    writer.write(" or" + this.newLine());
                }
            }
            ++n3;
        }
        if (this.attr.size() == 0) {
            writer.write(";" + this.newLine());
            this.restoreAttributeLists(hashtable);
            return true;
        }
        writer.write(" and" + this.newLine());
        return false;
    }

    protected void restoreAttributeLists(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setAttributeList(string, (AttributeList)hashtable.get(string));
        }
    }
}

