/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ace;

import com.netscape.management.client.ace.ACIAttribute;
import com.netscape.management.client.ace.IACITab;
import com.netscape.management.client.ace.UGChooserDialog;
import com.netscape.management.client.ace.UGTable;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.UIConstants;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class UGTab
implements IACITab,
UIConstants {
    private static ResourceSet i18n = new ResourceSet("com.netscape.management.client.ace.ace");
    private static String KEYWORD_USERDN = "userdn";
    private static String KEYWORD_GROUPDN = "groupdn";
    private static String KEYWORD_OR = "or";
    private static String KEYWORD_AND = "and";
    private static int TAB_POSITION = 0;
    public static String ADMIN_BASE_DN = "ou=Administrators, ou=TopologyManagement, o=netscapeRoot";
    public static String BIND_PREFIX = "ldap:///";
    public static String BIND_AUTHENTICATED = "all";
    public static String BIND_ANYONE = "anyone";
    public static String BIND_SELF = "self";
    private JFrame parentFrame;
    private UGTable ugTable;
    private JButton addButton;
    private JButton removeButton;
    private LDAPConnection aciLdc;
    private LDAPConnection ugLdc;
    private String ugDN;
    private JPanel p = new JPanel();
    private boolean isInitialized = false;

    UGTab() {
    }

    public static String i18n(String string) {
        return i18n.getString("ug", string);
    }

    public void initialize(JFrame jFrame, LDAPConnection lDAPConnection, String string, LDAPConnection lDAPConnection2, String string2) {
        this.parentFrame = jFrame;
        this.aciLdc = lDAPConnection;
        this.ugLdc = lDAPConnection2;
        this.ugDN = string2;
    }

    public ACIAttribute[] aciChanged(ACIAttribute[] aCIAttributeArray, String string) throws Exception {
        ACIAttribute aCIAttribute;
        Vector<Object> vector = new Vector<Object>();
        this.ugTable.deleteAllRows();
        int n = 0;
        while (n < aCIAttributeArray.length) {
            aCIAttribute = aCIAttributeArray[n];
            if (aCIAttribute.getName().equalsIgnoreCase(KEYWORD_USERDN) || aCIAttribute.getName().equalsIgnoreCase(KEYWORD_GROUPDN)) {
                Object object;
                String string2;
                vector.addElement(aCIAttribute);
                if (n > 0 && ((string2 = ((ACIAttribute)(object = aCIAttributeArray[n - 1])).getOperator()).equalsIgnoreCase(KEYWORD_OR) || string2.equalsIgnoreCase(KEYWORD_AND))) {
                    vector.addElement(object);
                }
                if (((String)(object = aCIAttribute.getValue())).startsWith(BIND_PREFIX)) {
                    object = ((String)object).substring(BIND_PREFIX.length());
                }
                if (((String)object).equalsIgnoreCase(BIND_AUTHENTICATED) || ((String)object).equalsIgnoreCase(BIND_ANYONE) || ((String)object).equalsIgnoreCase(BIND_SELF)) {
                    string2 = new LDAPEntry((String)object, new LDAPAttributeSet());
                    this.ugTable.addRow((LDAPEntry)string2);
                } else {
                    if (!DN.isDN((String)object)) {
                        Debug.println("UGTab: can not edit visually, unsupported=" + (String)object);
                        throw new Exception(i18n.getString("ed", "visualUnsupported"));
                    }
                    try {
                        Debug.println("UGTab: LDAP read: " + (String)object);
                        string2 = this.ugLdc.read((String)object);
                        this.ugTable.addRow((LDAPEntry)string2);
                    }
                    catch (LDAPException lDAPException) {
                        Debug.println("UGTab: Unable to read entry.\nException: " + (Object)((Object)lDAPException));
                        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                        Vector vector2 = new DN((String)object).getRDNs();
                        if (vector2.size() > 0) {
                            RDN rDN = (RDN)vector2.elementAt(0);
                            lDAPAttributeSet.add(new LDAPAttribute(rDN.getType(), rDN.getValue()));
                        }
                        if (aCIAttribute.getName().equalsIgnoreCase(KEYWORD_USERDN)) {
                            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "person"));
                        } else if (aCIAttribute.getName().equalsIgnoreCase(KEYWORD_GROUPDN)) {
                            lDAPAttributeSet.add(new LDAPAttribute("objectclass", "groupofuniquenames"));
                        }
                        this.ugTable.addRow(new LDAPEntry((String)object, lDAPAttributeSet));
                    }
                }
            }
            ++n;
        }
        if (this.ugTable.getRowCount() == 0) {
            aCIAttribute = new LDAPEntry(BIND_ANYONE, new LDAPAttributeSet());
            this.ugTable.addRow((LDAPEntry)aCIAttribute);
        }
        return ACIAttribute.toArray(vector);
    }

    public JComponent getComponent() {
        this.ugTable = new UGTable();
        this.ugTable.getAccessibleContext().setAccessibleDescription(UGTab.i18n("info"));
        this.ugTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        TableColumnModel tableColumnModel = this.ugTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(50);
        tableColumnModel.getColumn(2).setPreferredWidth(50);
        this.p.setPreferredSize(new Dimension(480, 260));
        return this.p;
    }

    public int getPreferredPosition() {
        return TAB_POSITION;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        ButtonActionListener buttonActionListener = new ButtonActionListener();
        this.addButton = ButtonFactory.createPredefinedButton("ADD", buttonActionListener);
        this.addButton.setToolTipText(UGTab.i18n("add_tt"));
        gridBagLayout.setConstraints(this.addButton, gridBagConstraints);
        jPanel.add(this.addButton);
        this.removeButton = ButtonFactory.createPredefinedButton("REMOVE", buttonActionListener);
        this.removeButton.setToolTipText(UGTab.i18n("remove_tt"));
        this.removeButton.setEnabled(false);
        gridBagLayout.setConstraints(this.removeButton, gridBagConstraints);
        jPanel.add(this.removeButton);
        ButtonFactory.resizeButtons(this.addButton, this.removeButton);
        this.enableButtons();
        return jPanel;
    }

    private void enableButtons() {
        this.removeButton.setEnabled(this.ugTable.getSelectedRowCount() > 0);
    }

    public String getTitle() {
        return UGTab.i18n("title");
    }

    public void tabSelected() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.p.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.p.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel();
        jLabel.setText(UGTab.i18n("info"));
        jLabel.setLabelFor(this.ugTable);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.p.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ListSelectionModel listSelectionModel = this.ugTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    UGTab.this.removeButton.setEnabled(!UGTab.this.ugTable.getSelectionModel().isSelectionEmpty());
                }
            }
        });
        this.ugTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = ((TableModel)tableModelEvent.getSource()).getRowCount();
                UGTab.this.removeButton.setEnabled(n > 0);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.ugTable);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.p.add(jScrollPane);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        JPanel jPanel = this.createButtonPanel();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.p.add(jPanel);
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("ace-ug");
    }

    public void okInvoked() {
    }

    public void cancelInvoked() {
    }

    public StringBuffer createACI(StringBuffer stringBuffer) {
        if (this.ugTable.getRowCount() <= 0) {
            return stringBuffer;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (!stringBuffer.toString().endsWith(";\n;)")) {
            stringBuffer2.append("and");
        }
        stringBuffer2.append("\n(");
        int n = this.ugTable.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            LDAPEntry lDAPEntry = this.ugTable.getRow(n2);
            String string = lDAPEntry.getDN();
            if (string.equalsIgnoreCase(BIND_AUTHENTICATED) || string.equalsIgnoreCase(BIND_ANYONE) || string.equalsIgnoreCase(BIND_SELF)) {
                stringBuffer2.append(KEYWORD_USERDN);
            } else if (this.isOfType(lDAPEntry, "person")) {
                stringBuffer2.append(KEYWORD_USERDN);
            } else if (this.isOfType(lDAPEntry, "groupofuniquenames")) {
                stringBuffer2.append(KEYWORD_GROUPDN);
            } else {
                stringBuffer2.append("??????");
                Debug.println("UGTab ERROR: unexpected object type " + lDAPEntry.getAttribute("objectclass"));
            }
            stringBuffer2.append(" = \"" + BIND_PREFIX + lDAPEntry.getDN() + "\"");
            if (n2 < n - 1) {
                stringBuffer2.append(" or \n");
            }
            ++n2;
        }
        stringBuffer2.append(")");
        if (stringBuffer.toString().endsWith("\n;)")) {
            int n3 = stringBuffer.length() - 3;
            stringBuffer.insert(n3, (Object)stringBuffer2);
        }
        return stringBuffer;
    }

    private boolean isOfType(LDAPEntry lDAPEntry, String string) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        if (lDAPAttribute == null) {
            Debug.println("UGTab ERROR: no objectclass found in " + lDAPEntry.getDN());
            return false;
        }
        String[] stringArray = lDAPAttribute.getStringValueArray();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void addUser() {
        UGChooserDialog uGChooserDialog = new UGChooserDialog(this.parentFrame, this.aciLdc, this.ugLdc, this.ugDN);
        uGChooserDialog.show();
        if (!uGChooserDialog.isCancel()) {
            int n = 0;
            while (n < this.ugTable.getRowCount()) {
                LDAPEntry lDAPEntry = this.ugTable.getRow(n);
                if (lDAPEntry.getDN().equals(BIND_ANYONE)) {
                    this.ugTable.deleteRow(n);
                }
                ++n;
            }
            int n2 = this.ugTable.getRowCount();
            int n3 = uGChooserDialog.getResultCount();
            int n4 = 0;
            while (n4 < n3) {
                this.ugTable.addRow(uGChooserDialog.getResult(n4));
                ++n4;
            }
            ListSelectionModel listSelectionModel = this.ugTable.getSelectionModel();
            listSelectionModel.setSelectionInterval(n2, this.ugTable.getRowCount() - 1);
        }
    }

    private void removeUser() {
        int n;
        int n2 = this.ugTable.getSelectedRow() - 1;
        int[] nArray = this.ugTable.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            this.ugTable.deleteRows(nArray);
        }
        if ((n = this.ugTable.getRowCount()) > 0) {
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= n) {
                n2 = n;
            }
            ListSelectionModel listSelectionModel = this.ugTable.getSelectionModel();
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    private JPanel createAddContentPanel(JTextField jTextField) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel("Enter LDAP URL of user or group:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        jPanel.add(jTextField);
        return jPanel;
    }

    public ACIAttribute[] getSupportedAttributes() {
        return new ACIAttribute[]{new ACIAttribute(KEYWORD_USERDN, "=|!=", "\"" + BIND_PREFIX + "*" + "\""), new ACIAttribute(KEYWORD_USERDN, "=|!=", "\"" + BIND_PREFIX + BIND_AUTHENTICATED + "\""), new ACIAttribute(KEYWORD_USERDN, "=|!=", "\"" + BIND_PREFIX + BIND_ANYONE + "\""), new ACIAttribute(KEYWORD_USERDN, "=|!=", "\"" + BIND_PREFIX + BIND_SELF + "\""), new ACIAttribute(KEYWORD_GROUPDN, "=|!=", "\"" + BIND_PREFIX + "*" + "\"")};
    }

    class ButtonActionListener
    implements ActionListener {
        ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ADD")) {
                UGTab.this.addUser();
            } else if (string.equals("REMOVE")) {
                UGTab.this.removeUser();
            }
        }
    }
}

