/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.FontPreferencesTab;
import com.netscape.management.client.FrameworkInitializer;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IFrameworkInitializer;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.MenuData;
import com.netscape.management.client.MenuItemCategory;
import com.netscape.management.client.MenuItemCheckBox;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.SettingsPreferencesTab;
import com.netscape.management.client.StatusItemText;
import com.netscape.management.client.UIPermissions;
import com.netscape.management.client.components.FontFactory;
import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.preferences.IPreferencesTab;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.preferences.PreferencesDialog;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.util.Browser;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ImageInfo;
import com.netscape.management.client.util.IndexDialog;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiConstants;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Framework
extends JFrame
implements IFramework,
SuiConstants {
    public static final String IDENTIFIER = "Console";
    public static final String VERSION = "4.0";
    public static final String PREFERENCES_GENERAL = "General";
    public static final String PREFERENCES_FONTS = "Fonts";
    public static final String PREFERENCE_X = "X";
    public static final String PREFERENCE_Y = "Y";
    public static final String PREFERENCE_WIDTH = "Width";
    public static final String PREFERENCE_HEIGHT = "Height";
    public static final String PREFERENCE_SHOW_BANNER = "ShowBannerBar";
    public static final String PREFERENCE_SHOW_STATUS = "ShowStatusBar";
    public static final String PREFERENCE_AUTO_SAVE = "AutoSave";
    public static final String MENU_TOP = "<top>";
    public static final String MENU_FILE = "FILE";
    public static final String MENU_EDIT = "EDIT";
    public static final String MENU_VIEW = "VIEW";
    public static final String MENU_HELP = "HELP";
    public static final String MENU_HELPWEBHELP = "HELPWEBHELP";
    public static final String MENU_HELPCONTENTS = "HELPCONTENTS";
    public static final String MENU_HELPINDEX = "HELPINDEX";
    public static final String MENU_HELPDOCHOME = "HELPDOCHOME";
    public static final String STATUS_TEXT = "StatusItemText";
    public static final String STATUS_SECURE_MODE = "StatusItemSecureMode";
    public static final int DEFAULT_WIDTH = 750;
    public static final int DEFAULT_HEIGHT = 530;
    private static Point _initialLocation = null;
    private static Dimension _initialDimension = null;
    private Image _bannerImage = null;
    public static String _imageSource = "com/netscape/management/client/images/";
    public static ResourceSet _resource = new ResourceSet("com.netscape.management.client.default");
    public static Help _help = new Help("com.netscape.management.client.default");
    protected boolean[] _isPageInitialized;
    protected IFrameworkInitializer _frameworkInitializer;
    protected JPanel _framePanel;
    protected JPanel _pagePanel;
    protected JPanel _customPanel;
    protected JPanel _bannerPanel;
    protected JPanel _statusPanel;
    protected JTabbedPane _tabbedPane;
    protected JMenuBar _menuBar;
    protected Box _statusBarLeft;
    protected Box _statusBarCenter;
    protected Box _statusBarRight;
    protected Vector _statusBarList = new Vector();
    protected IPage[] _pageList;
    protected boolean _isBannerBarVisible = true;
    protected boolean _isStatusBarVisible = true;
    protected ButtonGroup _tabButtonGroup = new ButtonGroup();
    protected StatusItemText _statusItemText;
    protected static Color _bannerBackground;
    protected MenuItemCheckBox _bannerMenuItem;
    protected static boolean _enableWinPositioning;
    private boolean _busyCursorOn;
    private boolean _isTopologyFramework = false;
    private boolean _isClosing = false;
    private static PreferenceManager _preferenceManager;
    private UIPermissions _uiPermissions = null;
    private String _helpdir = "admin";
    private URL _adminURL = null;
    private WindowAdapter _windowAdaptor = new WindowAdapter(){

        public void windowActivated(WindowEvent windowEvent) {
            UtilConsoleGlobals.setActivatedFrame((JFrame)((JFrame)windowEvent.getSource()));
        }

        public void windowOpened(WindowEvent windowEvent) {
            UtilConsoleGlobals.setActivatedFrame((JFrame)((JFrame)windowEvent.getSource()));
        }
    };

    public Framework() {
        UtilConsoleGlobals.incrementWindowCount();
        Debug.println("memgc", "Create   Framework " + this.getName());
        if (UtilConsoleGlobals.getWindowCount() == 1) {
            UtilConsoleGlobals.setRootTopologyFrame((JFrame)this);
        }
        this.setDefaultCloseOperation(0);
    }

    public Framework(IFrameworkInitializer iFrameworkInitializer) {
        this();
        this._frameworkInitializer = iFrameworkInitializer;
        if (iFrameworkInitializer instanceof FrameworkInitializer) {
            this._uiPermissions = ((FrameworkInitializer)iFrameworkInitializer).getUIPermissions();
        }
        this.loadPreferences();
        this._isTopologyFramework = iFrameworkInitializer instanceof TopologyInitializer;
        this.initializeUI();
        this.initializePages(iFrameworkInitializer);
        this.show();
    }

    public UIPermissions getUIPermissions() {
        return this._uiPermissions;
    }

    protected void finalize() throws Throwable {
        Debug.println("memgc", "FINALIZE Framework " + this.getName());
        super.finalize();
    }

    public static String i18n(String string, String string2) {
        return _resource.getString(string, string2);
    }

    protected void initializeUI() {
        ((Component)this).setBackground(UIManager.getColor("control"));
        this._menuBar = this.createDefaultMenuBar();
        this.setJMenuBar(this._menuBar);
        this._framePanel = new JPanel();
        this._framePanel.setLayout(new BorderLayout());
        this._framePanel.setBorder(BorderFactory.createEmptyBorder(2, 9, 2, 9));
        this._bannerPanel = new JPanel(new BorderLayout());
        this._bannerPanel.getAccessibleContext().setAccessibleDescription(Framework.i18n("banner", "console"));
        this._bannerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._pagePanel = new JPanel();
        this._pagePanel.setLayout(new BorderLayout());
        this._pagePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this._tabbedPane = new JTabbedPane();
        this._pagePanel.add(this._tabbedPane);
        this._framePanel.add("Center", this._pagePanel);
        this._statusBarLeft = Box.createHorizontalBox();
        this._statusBarCenter = Box.createHorizontalBox();
        this._statusBarRight = Box.createHorizontalBox();
        this._statusBarLeft.add(Box.createVerticalStrut(15));
        this._statusPanel = new JPanel();
        this._statusPanel.setLayout(new BorderLayout());
        this._statusPanel.add("West", this._statusBarLeft);
        this._statusPanel.add("Center", this._statusBarCenter);
        this._statusPanel.add("East", this._statusBarRight);
        this._statusItemText = new StatusItemText(STATUS_TEXT);
        this.addStatusItem(this._statusItemText, "LF");
        TabChangeActionListener tabChangeActionListener = new TabChangeActionListener();
        this.addWindowListener(this._windowAdaptor);
    }

    protected void initializePages(IFrameworkInitializer iFrameworkInitializer) {
        this.setTitle(iFrameworkInitializer.getFrameTitle());
        ((Frame)this).setIconImage(iFrameworkInitializer.getMinimizedImage());
        this._bannerImage = iFrameworkInitializer.getBannerImage();
        if (this._bannerImage != null) {
            ImageIcon imageIcon = new ImageIcon(this._bannerImage, _resource.getString("framework", "bannericon-description"));
            this._bannerPanel.add("West", new JLabel(imageIcon));
            _bannerBackground = new ImageInfo(this._bannerImage).getTopRightAverageColor(4);
            if (!this._isTopologyFramework) {
                JLabel jLabel = new JLabel(iFrameworkInitializer.getBannerText());
                jLabel.setForeground(Color.white);
                this._bannerPanel.add("Center", jLabel);
                jLabel.setLabelFor(this._bannerPanel);
            }
        } else {
            this._isBannerBarVisible = false;
            _bannerBackground = ((Component)this).getBackground();
            this._bannerMenuItem.setChecked(false);
            this._bannerMenuItem.setEnabled(false);
        }
        int n = iFrameworkInitializer.getPageCount();
        this._pageList = new IPage[n];
        int n2 = 0;
        while (n2 < n) {
            IPage iPage = iFrameworkInitializer.getPageAt(n2);
            this._tabbedPane.addTab(iPage.getPageTitle(), null, (Component)iPage);
            this._pageList[n2] = iPage;
            ++n2;
        }
        this._isPageInitialized = new boolean[n2];
        this.initializePages();
    }

    protected void initializeColors(Color color) {
        this._bannerPanel.setBackground(color);
        this._framePanel.setBackground(color);
        this._pagePanel.setBackground(color);
        this._statusPanel.setBackground(color);
        ((Component)this._statusBarLeft).setBackground(color);
        ((Component)this._statusBarCenter).setBackground(color);
        ((Component)this._statusBarRight).setBackground(color);
        if (_bannerBackground.equals(color)) {
            this._statusItemText.setForeground(Color.white);
        } else {
            this._statusItemText.setForeground(Color.black);
        }
    }

    protected void initializePages() {
        this.setStatusPanel(this._isStatusBarVisible);
        this.setBannerPanel(this._isBannerBarVisible);
        this.getContentPane().add("Center", this._framePanel);
        this.addWindowListener(new FrameworkWindowListener());
        TabChangeListener tabChangeListener = new TabChangeListener();
        this._tabbedPane.addChangeListener(tabChangeListener);
        this._tabbedPane.setSelectedIndex(0);
        tabChangeListener.stateChanged(null);
    }

    public Color getBannerBackground() {
        if (_bannerBackground == null) {
            _bannerBackground = ((Component)this).getBackground();
        }
        return _bannerBackground;
    }

    protected void setLocationOnScreen() {
        JFrame jFrame = UtilConsoleGlobals.getActivatedFrame();
        if (jFrame == null) {
            ((Component)this).setLocation(ModalDialogUtil.calcWindowLocation(_initialDimension));
        } else {
            Point point = jFrame.getLocationOnScreen();
            JMenuBar jMenuBar = jFrame.getJMenuBar();
            if (jMenuBar == null) {
                ((Component)this).setLocation(ModalDialogUtil.calcWindowLocation(_initialDimension));
                Debug.println("Framework.setLocationOnScreen: no menu bar");
                return;
            }
            Point point2 = jMenuBar.getLocationOnScreen();
            point2.x += point2.y - point.y - (point2.x - point.x);
            if (point2.x < 0) {
                point2 = new Point(0, 0);
            }
            ((Component)this).setLocation(point2);
            Debug.println("Framework: location set: " + point2);
        }
    }

    public static void setEnableWinPositioning(boolean bl) {
        _enableWinPositioning = bl;
    }

    public JFrame getJFrame() {
        return this;
    }

    public void setCursor(Cursor cursor) {
        if (this._busyCursorOn && cursor.getType() != 3) {
            Debug.println(9, "Framework.setCursor(): Discarding change of cursor");
            return;
        }
        super.setCursor(cursor);
    }

    public void setBusyCursor(boolean bl) {
        this._busyCursorOn = bl;
        Cursor cursor = Cursor.getPredefinedCursor(bl ? 3 : 0);
        super.setCursor(cursor);
        this.setCursorOnChildren(this, cursor);
    }

    void setCursorOnChildren(Container container, Cursor cursor) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                this.setCursorOnChildren((Container)componentArray[n], cursor);
            }
            if (componentArray[n].getClass().getName().indexOf("PaneDivider") > 0) {
                return;
            }
            componentArray[n].setCursor(cursor);
            ++n;
        }
    }

    public void addStatusItem(IStatusItem iStatusItem, String string) {
        if (string.equals("LF")) {
            this._statusBarLeft.add(iStatusItem.getComponent(), 0);
        } else if (string.equals("L")) {
            this._statusBarLeft.add(iStatusItem.getComponent());
        } else if (string.equals("C")) {
            this._statusBarCenter.add(iStatusItem.getComponent());
        } else if (string.equals("CF")) {
            this._statusBarCenter.add(iStatusItem.getComponent(), 0);
        } else if (string.equals("R")) {
            this._statusBarRight.add(iStatusItem.getComponent());
        } else if (string.equals("RF")) {
            this._statusBarRight.add(iStatusItem.getComponent(), 0);
        }
        this._framePanel.validate();
        this._framePanel.repaint();
    }

    private void removeStatusItem(Box box, IStatusItem iStatusItem) {
        Component[] componentArray = box.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (iStatusItem.getComponent() == componentArray[n]) {
                box.remove(componentArray[n]);
            }
            ++n;
        }
    }

    public void removeStatusItem(IStatusItem iStatusItem) {
        this.removeStatusItem(this._statusBarLeft, iStatusItem);
        this.removeStatusItem(this._statusBarCenter, iStatusItem);
        this.removeStatusItem(this._statusBarRight, iStatusItem);
        this._framePanel.validate();
        this._framePanel.repaint();
    }

    public void changeStatusItemState(IStatusItem iStatusItem) {
        this.changeStatusItemState(iStatusItem.getID(), iStatusItem.getState());
    }

    private void changeStatusItemState(Box box, String string, Object object) {
        Component[] componentArray = box.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            IStatusItem iStatusItem;
            if (componentArray[n] instanceof IStatusItem && (iStatusItem = (IStatusItem)((Object)componentArray[n])).getID().equals(string)) {
                iStatusItem.setState(object);
            }
            ++n;
        }
    }

    public void changeStatusItemState(String string, Object object) {
        this.changeStatusItemState(this._statusBarLeft, string, object);
        this.changeStatusItemState(this._statusBarCenter, string, object);
        this.changeStatusItemState(this._statusBarRight, string, object);
        this._framePanel.validate();
        this._framePanel.repaint();
    }

    public void addMenuItem(String string, IMenuItem iMenuItem) {
        if (string.equals(MENU_TOP)) {
            if (iMenuItem.getComponent() instanceof JMenu) {
                Vector<Component> vector = new Vector<Component>();
                int n = 0;
                while (n < this._menuBar.getMenuCount()) {
                    vector.addElement(this._menuBar.getMenu(n));
                    ++n;
                }
                int n2 = 0;
                while (n2 < this._menuBar.getMenuCount()) {
                    this._menuBar.remove(n2);
                    ++n2;
                }
                vector.insertElementAt(iMenuItem.getComponent(), vector.size() - 1);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this._menuBar.add((JMenu)enumeration.nextElement());
                }
                JMenu jMenu = (JMenu)iMenuItem.getComponent();
                if (jMenu.getMenuComponentCount() > 0) {
                    jMenu.setEnabled(true);
                } else {
                    jMenu.setEnabled(false);
                }
                this._menuBar.validate();
                this._menuBar.repaint();
            }
        } else {
            JMenu jMenu = MenuData.getMenu(this._menuBar, string);
            if (jMenu != null) {
                if (string.equals(MENU_FILE)) {
                    int n = jMenu.getMenuComponentCount();
                    ((MenuItemCategory)jMenu).insert(iMenuItem.getComponent(), n - 2);
                } else {
                    jMenu.add(iMenuItem.getComponent());
                }
                if (jMenu.getMenuComponentCount() > 0) {
                    jMenu.setEnabled(true);
                }
            }
        }
    }

    public boolean removeMenuItem(IMenuItem iMenuItem) {
        boolean bl = false;
        int n = 0;
        while (n < this._menuBar.getMenuCount()) {
            JMenu jMenu = this._menuBar.getMenu(n);
            if (jMenu instanceof IMenuItem && jMenu == iMenuItem) {
                this._menuBar.remove(n);
                this._menuBar.validate();
                this._menuBar.repaint();
                bl = true;
                break;
            }
            if (jMenu instanceof JMenu && MenuData.removeMenuItem(jMenu, iMenuItem)) {
                jMenu.setPopupMenuVisible(false);
                if (jMenu.getMenuComponentCount() == 0) {
                    jMenu.setEnabled(false);
                }
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public void setSelectedPage(int n) {
        this._tabbedPane.setSelectedIndex(n);
    }

    public IPage getSelectedPage() {
        return (IPage)this._tabbedPane.getComponentAt(this._tabbedPane.getSelectedIndex());
    }

    private JMenuBar createDefaultMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        MenuItemCategory menuItemCategory = new MenuItemCategory(MENU_FILE, Framework.i18n("menu", "File"));
        if (Debug.gcTraceEnabled()) {
            menuItemCategory.addSeparator();
            menuItemCategory.add(new MenuItemText("Memory Check", null, new MemCheckAction()));
            menuItemCategory.add(new MenuItemText("Run GC", null, new GCAction()));
            menuItemCategory.addSeparator();
        }
        MenuItemText menuItemText = new MenuItemText(Framework.i18n("menu", "FileClose"), "TODO:description", new CloseAction());
        menuItemText.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        menuItemCategory.add(menuItemText);
        menuItemText = new MenuItemText(Framework.i18n("menu", "FileExit"), "TODO:description", new ExitAction());
        menuItemText.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        menuItemCategory.add(menuItemText);
        MenuItemCategory menuItemCategory2 = new MenuItemCategory(MENU_EDIT, Framework.i18n("menu", "Edit"));
        menuItemCategory2.add(new MenuItemText(Framework.i18n("menu", "EditPreferences"), "TODO:description", new PreferencesAction()));
        MenuItemCategory menuItemCategory3 = new MenuItemCategory(MENU_VIEW, Framework.i18n("menu", "View"));
        this._bannerMenuItem = new MenuItemCheckBox(Framework.i18n("menu", "ViewToggleBanner"), "TODO:description", new BannerBarToggleAction(), this._isBannerBarVisible);
        menuItemCategory3.add(this._bannerMenuItem);
        menuItemCategory3.add(new MenuItemCheckBox(Framework.i18n("menu", "ViewToggleStatus"), "TODO:description", new StatusBarToggleAction(), this._isStatusBarVisible));
        if (!this._isTopologyFramework) {
            menuItemCategory3.add(new MenuItemText(Framework.i18n("menu", "ViewShowRootTopology"), "TODO:description", new ShowTopologyButtonAction()));
        }
        MenuItemCategory menuItemCategory4 = new MenuItemCategory(MENU_HELP, Framework.i18n("menu", "Help"));
        menuItemText = new MenuItemText(MENU_HELPCONTENTS, Framework.i18n("menu", "HelpContents"), "TODO:description", new HelpContentsAction());
        menuItemText.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.getKeyText(112)));
        menuItemCategory4.add(menuItemText);
        menuItemCategory4.add(new MenuItemText(MENU_HELPINDEX, Framework.i18n("menu", "HelpIndex"), "TODO:description", new HelpIndexAction()));
        menuItemCategory4.addSeparator();
        menuItemCategory4.add(new MenuItemText(MENU_HELPDOCHOME, Framework.i18n("menu", "HelpSuiteSpot"), "TODO:description", new HelpDocHomeAction()));
        menuItemCategory4.addSeparator();
        menuItemCategory4.add(new MenuItemText(Framework.i18n("menu", "HelpAbout"), "TODO:description", new HelpAboutAction()));
        jMenuBar.add(menuItemCategory);
        jMenuBar.add(menuItemCategory2);
        jMenuBar.add(menuItemCategory3);
        jMenuBar.add(menuItemCategory4);
        return jMenuBar;
    }

    private void loadFontPreferences(PreferenceManager preferenceManager) {
        Preferences preferences = preferenceManager.getPreferences(PREFERENCES_FONTS);
        if (!preferences.isEmpty()) {
            Enumeration enumeration = FontFactory.getFontIDs();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)((Hashtable)preferences).get(string);
                if (string2 == null) continue;
                FontFactory.setFont(string, FontFactory.toFont(string2));
            }
            FontFactory.initializeLFFonts();
        }
    }

    private void loadPreferences() {
        if (_preferenceManager == null) {
            _preferenceManager = PreferenceManager.getPreferenceManager(IDENTIFIER, VERSION);
        }
        Preferences preferences = _preferenceManager.getPreferences(PREFERENCES_GENERAL);
        int n = preferences.getInt(PREFERENCE_X, 0);
        int n2 = preferences.getInt(PREFERENCE_Y, 0);
        _initialLocation = new Point(n, n2);
        int n3 = preferences.getInt(PREFERENCE_WIDTH, 750);
        int n4 = preferences.getInt(PREFERENCE_HEIGHT, 530);
        _initialDimension = new Dimension(n3, n4);
        ((Component)this).setSize(_initialDimension);
        if (_enableWinPositioning) {
            if (Framework._initialLocation.x != 0 && UtilConsoleGlobals.getActivatedFrame() == null) {
                ((Component)this).setLocation(Framework._initialLocation.x, Framework._initialLocation.y);
            } else {
                this.setLocationOnScreen();
            }
        }
        this._isBannerBarVisible = preferences.getBoolean(PREFERENCE_SHOW_BANNER, true);
        this._isStatusBarVisible = preferences.getBoolean(PREFERENCE_SHOW_STATUS, true);
        this.loadFontPreferences(_preferenceManager);
    }

    private void savePreferences() {
        Preferences preferences = _preferenceManager.getPreferences(PREFERENCES_GENERAL);
        Point point = this.getLocation();
        preferences.set(PREFERENCE_X, point.x);
        preferences.set(PREFERENCE_Y, point.y);
        Dimension dimension = this.getSize();
        preferences.set(PREFERENCE_WIDTH, dimension.width);
        preferences.set(PREFERENCE_HEIGHT, dimension.height);
        if (preferences.getBoolean(PREFERENCE_AUTO_SAVE, true)) {
            PreferenceManager.saveAllPreferences();
        }
    }

    public void setHelpDirectory(String string) {
        this._helpdir = string;
    }

    public String getHelpDirectory() {
        return this._helpdir;
    }

    public void setHelpAdminURL(URL uRL) {
        this._adminURL = uRL;
    }

    public URL getHelpAdminURL() {
        return this._adminURL;
    }

    protected void helpMenuInvoked(String string) {
        if (string.equals(MENU_HELPCONTENTS)) {
            if (this._adminURL == null) {
                Help.showContextHelp(this.getHelpDirectory(), "framework-menubar-contents");
            } else {
                Help.showContextHelp(this.getHelpDirectory(), "framework-menubar-contents", this._adminURL);
            }
        } else if (string.equals(MENU_HELPINDEX)) {
            URL uRL = this.getHelpUrl(this.getHelpDirectory(), "framework", "menubar-index", "topicindex.htm");
            final IndexDialog indexDialog = new IndexDialog((JFrame)this, uRL);
            indexDialog.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("URL")) {
                        String string = (String)propertyChangeEvent.getNewValue();
                        Debug.println("Selected URL: " + string);
                        if (string != null && string.length() > 0) {
                            if (!Framework.this.isLocalUrl(string)) {
                                new Browser().open(string, 3);
                            } else {
                                Help.showContextHelp(string);
                            }
                        }
                    }
                }
            });
            indexDialog.show();
        } else if (string.equals(MENU_HELPDOCHOME)) {
            if (this._adminURL == null) {
                Help.showContextHelp(this.getHelpDirectory(), "framework-menubar-dochome");
            } else {
                Help.showContextHelp(this.getHelpDirectory(), "framework-menubar-dochome", this._adminURL);
            }
        } else {
            Debug.println("Unrecognized Help Menu ID: " + string);
        }
    }

    private URL getHelpUrl(String string, String string2, String string3, String string4) {
        String string5;
        if (string == null) {
            return null;
        }
        String string6 = string5 = this._adminURL == null ? UtilConsoleGlobals.getAdminHelpURL().toString() : this._adminURL.toString();
        if (!string5.endsWith("/")) {
            string5 = string5 + "/";
        }
        String string7 = string5 + "manual/" + UtilConsoleGlobals.getDefaultDialect() + '/' + string + '/' + string4;
        try {
            return new URL(string7);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isClosing() {
        return this._isClosing;
    }

    protected void closeFramework() {
        if (this.okToClose()) {
            this._isClosing = true;
            this.savePreferences();
            if (this.getJFrame() == UtilConsoleGlobals.getRootTopologyFrame() && UtilConsoleGlobals.getWindowCount() != 1) {
                ((Component)UtilConsoleGlobals.getRootTopologyFrame()).setVisible(false);
            } else {
                UtilConsoleGlobals.setClosingFrame((JFrame)this.getJFrame());
                UtilConsoleGlobals.decrementWindowCount();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Framework.this.getJFrame().dispose();
                    }
                });
                int n = UtilConsoleGlobals.getWindowCount();
                if (n == 0 || n == 1 && !UtilConsoleGlobals.getRootTopologyFrame().isVisible()) {
                    System.exit(0);
                }
            }
        }
    }

    private boolean isLocalUrl(String string) {
        boolean bl = false;
        String string2 = UtilConsoleGlobals.getAdminHelpURL().toString();
        if (string2 != null) {
            boolean bl2 = bl = string.indexOf(string2) >= 0;
        }
        if (!bl && this._adminURL != null) {
            string2 = this._adminURL.toString().toLowerCase();
            bl = string.toLowerCase().indexOf(string2) >= 0;
        }
        return bl;
    }

    public void exitFramework() {
        if (this.okToClose()) {
            this.savePreferences();
            System.exit(0);
        }
    }

    protected boolean okToClose() {
        int n;
        boolean bl = true;
        int n2 = 0;
        while (n2 < this._pageList.length) {
            try {
                this._pageList[n2].actionViewClosing((IFramework)this);
            }
            catch (CloseVetoException closeVetoException) {
                bl = false;
            }
            ++n2;
        }
        if (!bl && (n = SuiOptionPane.showConfirmDialog((Component)this.getJFrame(), (Object)Framework.i18n("dialog", "closetext"), (String)Framework.i18n("dialog", "closetitle"), (int)0, (int)3)) == 0) {
            bl = true;
        }
        return bl;
    }

    private void setBannerPanel(boolean bl) {
        this._isBannerBarVisible = bl;
        if (this._isBannerBarVisible) {
            this._framePanel.add("North", this._bannerPanel);
            this.initializeColors(this.getBannerBackground());
        } else {
            this._framePanel.remove(this._bannerPanel);
            this.initializeColors(((Component)this).getBackground());
        }
        this._framePanel.setBorder(BorderFactory.createEmptyBorder(this._isBannerBarVisible ? 2 : 9, 9, this._isStatusBarVisible ? 2 : 9, 9));
        Preferences preferences = _preferenceManager.getPreferences(PREFERENCES_GENERAL);
        preferences.set(PREFERENCE_SHOW_BANNER, this._isBannerBarVisible);
    }

    private void setStatusPanel(boolean bl) {
        this._isStatusBarVisible = bl;
        if (this._isStatusBarVisible) {
            this._framePanel.add("South", this._statusPanel);
        } else {
            this._framePanel.remove(this._statusPanel);
        }
        this._framePanel.setBorder(BorderFactory.createEmptyBorder(this._isBannerBarVisible ? 2 : 9, 9, this._isStatusBarVisible ? 2 : 9, 9));
        Preferences preferences = _preferenceManager.getPreferences(PREFERENCES_GENERAL);
        preferences.set(PREFERENCE_SHOW_STATUS, this._isStatusBarVisible);
    }

    static {
        _enableWinPositioning = true;
    }

    class TabChangeListener
    implements ChangeListener {
        int _previousIndex = -1;

        TabChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object;
            int n = Framework.this._tabbedPane.getSelectedIndex();
            if (n == -1) {
                return;
            }
            if (!Framework.this._isPageInitialized[n]) {
                Framework.this._isPageInitialized[n] = true;
                IPage iPage = (IPage)Framework.this._tabbedPane.getComponentAt(n);
                object = Framework.this.getCursor();
                Framework.this.setCursor(Cursor.getPredefinedCursor(3));
                iPage.initialize((IFramework)Framework.this);
                Framework.this.setCursor((Cursor)object);
            }
            if (this._previousIndex != -1) {
                Framework.this._pageList[this._previousIndex].pageUnselected((IFramework)Framework.this);
            }
            if (this._previousIndex != n) {
                Framework.this._pageList[n].pageSelected((IFramework)Framework.this);
                this._previousIndex = n;
            }
            int n2 = -1;
            object = Framework.this._tabButtonGroup.getElements();
            AbstractButton abstractButton = null;
            while (n2 != n) {
                if (!object.hasMoreElements()) break;
                abstractButton = (AbstractButton)object.nextElement();
                ++n2;
            }
            if (abstractButton != null) {
                abstractButton.setSelected(true);
            }
        }
    }

    class BannerBarToggleAction
    implements ActionListener {
        BannerBarToggleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            Framework.this.setBannerPanel(jCheckBoxMenuItem.getState());
            Framework.this._framePanel.validate();
            Framework.this._framePanel.repaint();
        }
    }

    class ShowTopologyButtonAction
    implements ActionListener {
        ShowTopologyButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)UtilConsoleGlobals.getRootTopologyFrame()).setVisible(true);
            UtilConsoleGlobals.getRootTopologyFrame().toFront();
        }
    }

    class StatusBarToggleAction
    implements ActionListener {
        StatusBarToggleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            Framework.this.setStatusPanel(jCheckBoxMenuItem.getState());
            Framework.this._framePanel.validate();
            Framework.this._framePanel.repaint();
        }
    }

    class TabChangeActionListener
    implements ActionListener {
        TabChangeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            Framework.this._tabbedPane.setSelectedIndex(Framework.this._tabbedPane.indexOfTab(abstractButton.getText()));
        }
    }

    class PreferencesAction
    implements ActionListener {
        private IPreferencesTab[] tabs = null;

        PreferencesAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            if (this.tabs == null) {
                serializable = new Vector<SettingsPreferencesTab>();
                ((Vector)serializable).addElement(new SettingsPreferencesTab());
                ((Vector)serializable).addElement(new FontPreferencesTab());
                if (Framework.this._frameworkInitializer instanceof FrameworkInitializer) {
                    FrameworkInitializer frameworkInitializer = (FrameworkInitializer)Framework.this._frameworkInitializer;
                    int n = frameworkInitializer.getPreferencesTabCount();
                    int n2 = 0;
                    while (n2 < n) {
                        ((Vector)serializable).addElement(frameworkInitializer.getPreferencesTab(n2));
                        ++n2;
                    }
                }
                this.tabs = new IPreferencesTab[((Vector)serializable).size()];
                ((Vector)serializable).copyInto(this.tabs);
            }
            serializable = new PreferencesDialog(Framework.this.getJFrame(), this.tabs);
            ((GenericDialog)serializable).show();
        }
    }

    class NotYetImplemented
    implements ActionListener {
        NotYetImplemented() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Debug.println("Framework.actionPerformed:Not Yet Implemented: " + ((JMenuItem)actionEvent.getSource()).getText());
        }
    }

    class FileNewAction
    implements ActionListener {
        FileNewAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Framework.this._frameworkInitializer != null) {
                new Framework(Framework.this._frameworkInitializer);
            }
        }
    }

    class MemCheckAction
    implements ActionListener {
        MemCheckAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l = Runtime.getRuntime().freeMemory();
            long l2 = Runtime.getRuntime().totalMemory();
            String string = "  totlMem=" + l2 / 1024L + " freeMem=" + l / 1024L;
            Framework.this.changeStatusItemState(Framework.STATUS_TEXT, string);
            Debug.println("memgc", "Heap:" + string);
        }
    }

    class GCAction
    implements ActionListener {
        GCAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l = Runtime.getRuntime().freeMemory();
            long l2 = Runtime.getRuntime().totalMemory();
            System.gc();
            long l3 = Runtime.getRuntime().freeMemory();
            long l4 = Runtime.getRuntime().totalMemory();
            long l5 = l3 - l;
            String string = "  totlMem=" + l4 / 1024L + " freeMem=" + l3 / 1024L + " GCfreed=" + l5 / 1024L;
            Framework.this.changeStatusItemState(Framework.STATUS_TEXT, string);
            Debug.println("memgc", "Run GC, Heap:" + string);
        }
    }

    class ExitAction
    implements ActionListener {
        ExitAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Framework.this.exitFramework();
        }
    }

    class CloseAction
    implements ActionListener {
        CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Framework.this.closeFramework();
        }
    }

    class HelpAboutAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Framework.this._frameworkInitializer.aboutInvoked(UtilConsoleGlobals.getActivatedFrame());
        }
    }

    class HelpDocHomeAction
    implements ActionListener {
        HelpDocHomeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Framework.this.helpMenuInvoked(Framework.MENU_HELPDOCHOME);
        }
    }

    class HelpIndexAction
    implements ActionListener {
        HelpIndexAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Framework.this.helpMenuInvoked(Framework.MENU_HELPINDEX);
        }
    }

    class HelpContentsAction
    implements ActionListener {
        HelpContentsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Framework.this.helpMenuInvoked(Framework.MENU_HELPCONTENTS);
        }
    }

    class FrameworkWindowListener
    implements WindowListener {
        FrameworkWindowListener() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            if (Debug.timeTraceEnabled()) {
                Debug.println("rsptime", "Framework window shown");
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            Framework.this.closeFramework();
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

