/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.NewProfile;
import com.netscape.management.client.components.FontChooserDialog;
import com.netscape.management.client.components.FontFactory;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.preferences.AbstractPreferencesTab;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.util.ExtendedMouseAdapter;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

class FontPreferencesTab
extends AbstractPreferencesTab {
    public static String PREFERENCES_PROFILE = "FontProfile_";
    public static String PREFERENCE_ActiveFontProfile = "ActiveFontProfile";
    private static ResourceSet resource = new ResourceSet("com.netscape.management.client.default");
    private static boolean isRestartRequired = false;
    private boolean isDirty = false;
    private JComboBox profileCombo;
    private JButton changeButton;
    private JButton saveButton;
    private JButton removeButton;
    private Table fontTable;
    private FontTableModel fontTableModel;
    private Hashtable fontHashtable = new Hashtable();
    private PreferenceManager preferenceManager;
    private ProfileSelectionListener profileSelectionListener = new ProfileSelectionListener();
    private TableSelectionListener fontTableSelectionListener = new TableSelectionListener();
    private boolean isTabCreated = false;

    public static String i18n(String string) {
        return resource.getString("fontTab", string);
    }

    public FontPreferencesTab() {
        this.preferenceManager = PreferenceManager.getPreferenceManager("Console", "4.0");
        this.setTitle(FontPreferencesTab.i18n("title"));
    }

    public void initialize(JFrame jFrame) {
        super.initialize(jFrame);
        this.isTabCreated = false;
    }

    public void tabSelected() {
        if (!this.isTabCreated) {
            this.isTabCreated = true;
            this.setRestartRequired(isRestartRequired);
            this.setComponent(this.createTabPanel());
        }
    }

    protected JPanel createTabPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.profileCombo = new JComboBox();
        GridBagUtil.constrain(jPanel, this.profileCombo, 0, 1, 1, 1, 1.0, 0.0, 18, 2, 0, 0, 1, 12);
        String string = UITools.getDisplayLabel(FontPreferencesTab.i18n("profile"));
        JLabel jLabel = new JLabel(string);
        char c = UITools.getMnemonic(FontPreferencesTab.i18n("profile"));
        char c2 = Character.toUpperCase(c);
        char c3 = Character.toLowerCase(c);
        jLabel.setDisplayedMnemonic(c);
        ProfileListener profileListener = new ProfileListener();
        this.profileCombo.registerKeyboardAction(profileListener, KeyStroke.getKeyStroke(Character.getNumericValue(c2), 18), 2);
        this.profileCombo.registerKeyboardAction(profileListener, KeyStroke.getKeyStroke(Character.getNumericValue(c3), 18), 2);
        GridBagUtil.constrain(jPanel, jLabel, 0, 0, 1, 1, 0.0, 0.0, 18, 0, 0, 0, 0, 0);
        this.saveButton = JButtonFactory.create(FontPreferencesTab.i18n("saveas"), new SaveButtonListener(), "SAVE");
        this.saveButton.setToolTipText(FontPreferencesTab.i18n("saveas_tt"));
        GridBagUtil.constrain(jPanel, this.saveButton, 1, 1, 1, 1, 0.0, 0.0, 18, 0, 0, 0, 0, 6);
        this.removeButton = JButtonFactory.create(FontPreferencesTab.i18n("remove"), new RemoveButtonListener(), "REMOVE");
        this.removeButton.setToolTipText(FontPreferencesTab.i18n("remove_tt"));
        GridBagUtil.constrain(jPanel, this.removeButton, 2, 1, 1, 1, 0.0, 0.0, 18, 0, 0, 0, 0, 0);
        this.fontHashtable = this.getPreferenceFonts("Fonts");
        this.fontTableModel = new FontTableModel();
        this.fontTableModel.addColumn(FontPreferencesTab.i18n("columnItem"));
        this.fontTableModel.addColumn(FontPreferencesTab.i18n("columnFont"));
        this.fontTableModel.setTableData(this.fontHashtable);
        this.fontTable = new Table((TableModel)this.fontTableModel, true);
        this.fontTable.setToolTipText(FontPreferencesTab.i18n("table_tt"));
        this.fontTable.setSelectionMode(2);
        ListSelectionModel listSelectionModel = this.fontTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this.fontTableSelectionListener);
        JScrollPane jScrollPane = new JScrollPane(this.fontTable);
        int n = (int)this.fontTable.getPreferredScrollableViewportSize().getWidth();
        int n2 = this.fontTable.getRowHeight() * 10;
        this.fontTable.setPreferredScrollableViewportSize(new Dimension(n, n2));
        GridBagUtil.constrain(jPanel, jScrollPane, 0, 2, 3, 1, 1.0, 1.0, 18, 1, 12, 0, 0, 0);
        this.changeButton = JButtonFactory.create(FontPreferencesTab.i18n("change"), new ChangeButtonListener(), "CHANGE");
        this.changeButton.setToolTipText(FontPreferencesTab.i18n("change_tt"));
        this.changeButton.setEnabled(this.fontTable.getSelectedRowCount() > 0);
        this.fontTable.addMouseListener(new ExtendedMouseAdapter(this.changeButton));
        GridBagUtil.constrain(jPanel, this.changeButton, 0, 3, 1, 1, 0.0, 0.0, 18, 0, 6, 0, 0, 0);
        this.reloadProfiles();
        Preferences preferences = this.preferenceManager.getPreferences("General");
        String string2 = preferences.getString(PREFERENCE_ActiveFontProfile);
        this.profileCombo.setSelectedItem(string2);
        JButtonFactory.resize(this.saveButton, this.removeButton);
        this.profileCombo.addActionListener(this.profileSelectionListener);
        return jPanel;
    }

    public void okInvoked() {
        if (this.isDirty) {
            this.saveFontTable("Fonts", false);
            Preferences preferences = this.preferenceManager.getPreferences("General");
            String string = (String)this.profileCombo.getSelectedItem();
            if (string != null && string.length() > 0) {
                preferences.set(PREFERENCE_ActiveFontProfile, string);
                this.saveFontTable(PREFERENCES_PROFILE + string, true);
            }
        }
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("preferences-fonts");
    }

    private void requireRestart() {
        isRestartRequired = true;
        this.setRestartRequired(isRestartRequired);
    }

    private void saveFontTable(String string, boolean bl) {
        Preferences preferences = this.preferenceManager.getPreferences(string);
        Enumeration enumeration = this.fontHashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            preferences.set(string2, FontFactory.toFontInfoString((Font)this.fontHashtable.get(string2)));
        }
        if (bl) {
            preferences.save();
        }
    }

    private Hashtable getPreferenceFonts(String string) {
        Hashtable<String, Font> hashtable = new Hashtable<String, Font>();
        Preferences preferences = this.preferenceManager.getPreferences(string);
        if (!preferences.isEmpty()) {
            Enumeration enumeration = preferences.getNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)((Hashtable)preferences).get(string2);
                hashtable.put(string2, FontFactory.toFont(string3));
            }
            return hashtable;
        }
        Enumeration enumeration = FontFactory.getFontIDs();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            hashtable.put(string4, FontFactory.getFont(string4));
        }
        return hashtable;
    }

    void reloadProfiles() {
        String[] stringArray = this.preferenceManager.getPreferencesList();
        this.profileCombo.removeAllItems();
        this.profileCombo.setEnabled(true);
        this.removeButton.setEnabled(true);
        if (stringArray != null) {
            this.profileCombo.removeAllItems();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].indexOf(PREFERENCES_PROFILE) != -1) {
                    int n2 = stringArray[n].indexOf(PREFERENCES_PROFILE) + PREFERENCES_PROFILE.length();
                    String string = stringArray[n].substring(n2);
                    this.profileCombo.addItem(string);
                }
                ++n;
            }
        }
        if (this.profileCombo.getItemCount() == 0) {
            this.profileCombo.addItem(" ");
            this.profileCombo.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    public static String getUID() {
        return String.valueOf(System.currentTimeMillis());
    }

    class ProfileListener
    implements ActionListener {
        ProfileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FontPreferencesTab.this.profileCombo.requestFocus();
        }
    }

    class RemoveButtonListener
    implements ActionListener {
        RemoveButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)FontPreferencesTab.this.profileCombo.getSelectedItem();
            int n = JOptionPane.showConfirmDialog(FontPreferencesTab.super.getFrame(), FontPreferencesTab.i18n("removeConfirm") + string + "?", FontPreferencesTab.i18n("removeConfirmTitle"), 0, 3);
            if (n == 0) {
                Preferences preferences = FontPreferencesTab.this.preferenceManager.getPreferences(PREFERENCES_PROFILE + string);
                preferences.delete();
                FontPreferencesTab.this.profileCombo.removeActionListener(FontPreferencesTab.this.profileSelectionListener);
                FontPreferencesTab.this.reloadProfiles();
                FontPreferencesTab.this.profileCombo.addActionListener(FontPreferencesTab.this.profileSelectionListener);
            }
        }
    }

    class SaveButtonListener
    implements ActionListener {
        SaveButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewProfile newProfile = new NewProfile(FontPreferencesTab.super.getFrame());
            newProfile.show();
            if (!newProfile.isCancel()) {
                String string = newProfile.getResult();
                FontPreferencesTab.this.saveFontTable(PREFERENCES_PROFILE + string, true);
                FontPreferencesTab.this.profileCombo.removeActionListener(FontPreferencesTab.this.profileSelectionListener);
                FontPreferencesTab.this.reloadProfiles();
                FontPreferencesTab.this.profileCombo.setSelectedItem(string);
                FontPreferencesTab.this.profileCombo.addActionListener(FontPreferencesTab.this.profileSelectionListener);
                FontPreferencesTab.this.isDirty = true;
                FontPreferencesTab.this.requireRestart();
            }
        }
    }

    class ChangeButtonListener
    implements ActionListener {
        ChangeButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableModel tableModel = FontPreferencesTab.this.fontTable.getModel();
            int[] nArray = FontPreferencesTab.this.fontTable.getSelectedRows();
            JLabel jLabel = (JLabel)tableModel.getValueAt(nArray[0], 1);
            Font font = jLabel.getFont();
            FontChooserDialog fontChooserDialog = new FontChooserDialog(FontPreferencesTab.super.getFrame(), font.getName(), font.getStyle(), font.getSize());
            fontChooserDialog.show();
            if (!fontChooserDialog.isCancel()) {
                int n = 0;
                while (n < nArray.length) {
                    jLabel = (JLabel)tableModel.getValueAt(nArray[n], 1);
                    jLabel.setFont(new Font(fontChooserDialog.getFontName(), fontChooserDialog.getFontStyle(), fontChooserDialog.getFontSize()));
                    String string = (String)tableModel.getValueAt(nArray[n], 0);
                    Enumeration enumeration = FontPreferencesTab.this.fontHashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        String string3 = FontFactory.getFontDescription(string2);
                        if (!string.equals(string3)) continue;
                        FontPreferencesTab.this.fontHashtable.put(string2, jLabel.getFont());
                    }
                    ++n;
                }
                FontPreferencesTab.this.profileCombo.removeActionListener(FontPreferencesTab.this.profileSelectionListener);
                FontPreferencesTab.this.profileCombo.addActionListener(FontPreferencesTab.this.profileSelectionListener);
                FontPreferencesTab.this.fontTable.validate();
                FontPreferencesTab.this.fontTable.repaint();
                FontPreferencesTab.this.isDirty = true;
                FontPreferencesTab.this.requireRestart();
            }
        }
    }

    class ProfileSelectionListener
    implements ActionListener {
        ProfileSelectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)FontPreferencesTab.this.profileCombo.getSelectedItem();
            FontPreferencesTab.this.fontHashtable = FontPreferencesTab.this.getPreferenceFonts(PREFERENCES_PROFILE + string);
            FontPreferencesTab.this.fontTableModel.setTableData(FontPreferencesTab.this.fontHashtable);
            FontPreferencesTab.this.removeButton.setEnabled(true);
            FontPreferencesTab.this.isDirty = true;
            FontPreferencesTab.this.requireRestart();
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FontPreferencesTab.this.changeButton.setEnabled(FontPreferencesTab.this.fontTable.getSelectedRowCount() > 0);
        }
    }

    class FontTableModel
    extends DefaultTableModel {
        FontTableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setTableData(Hashtable hashtable) {
            int n = FontPreferencesTab.this.fontTableModel.getRowCount();
            int n2 = n - 1;
            while (n2 >= 0) {
                FontPreferencesTab.this.fontTableModel.removeRow(n2);
                --n2;
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JLabel jLabel = new JLabel(FontPreferencesTab.i18n("sampleText"));
                jLabel.setFont((Font)FontPreferencesTab.this.fontHashtable.get(string));
                FontPreferencesTab.this.fontTableModel.addRow(new Object[]{FontFactory.getFontDescription(string), jLabel});
            }
        }
    }
}

