/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import org.apache.jasper.compiler.Mark;

public class ServletWriter {
    public static int TAB_WIDTH = 4;
    public static String SPACES = "                              ";
    int indent = 0;
    PrintWriter writer;

    public ServletWriter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void indent() {
        this.writer.print(SPACES.substring(0, this.indent));
    }

    public void popIndent() {
        if ((this.indent -= TAB_WIDTH) <= 0) {
            this.indent = 0;
        }
    }

    public void print(String string) {
        this.writer.print(string);
    }

    public void printComment(Mark mark, Mark mark2, char[] cArray) {
        if (mark != null && mark2 != null) {
            this.println("// from=" + mark);
            this.println("//   to=" + mark2);
        }
        if (cArray != null) {
            int n = 0;
            while (n < cArray.length) {
                this.indent();
                this.print("// ");
                while (cArray[n] != '\n' && n < cArray.length) {
                    this.writer.print(cArray[n++]);
                }
            }
        }
    }

    public void printMultiLn(String string) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                this.println(string2);
            }
        }
        catch (IOException iOException) {}
    }

    public void println() {
        this.writer.println("");
    }

    public void println(String string) {
        this.writer.println(String.valueOf(SPACES.substring(0, this.indent)) + string);
    }

    public void pushIndent() {
        if ((this.indent += TAB_WIDTH) > SPACES.length()) {
            this.indent = SPACES.length();
        }
    }

    public String quoteString(String string) {
        if (string == null) {
            return "null";
        }
        if (string.indexOf(34) < 0 && string.indexOf(92) < 0 && string.indexOf(10) < 0 && string.indexOf(13) < 0) {
            return "\"" + string + "\"";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        stringBuffer.append('\"');
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\' && n2 + 1 < n) {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
                stringBuffer.append(string.charAt(++n2));
            } else if (c == '\"') {
                stringBuffer.append('\\');
                stringBuffer.append('\"');
            } else if (c == '\n') {
                stringBuffer.append("\\n");
            } else if (c == '\r') {
                stringBuffer.append("\\r");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }
}

