/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.jasper.Constants;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseException;

public class JspReader {
    protected Mark current = null;
    String master = null;
    String defEncoding = "8859_1";
    Vector sourceFiles = new Vector();
    int currFileId = 0;
    int size = 0;
    private JspCompilationContext context;

    protected JspReader(String string, JspCompilationContext jspCompilationContext, String string2) throws ParseException, FileNotFoundException {
        this.context = jspCompilationContext;
        this.pushFile(string, string2);
    }

    public void advance(int n) throws ParseException {
        while (--n >= 0) {
            this.nextChar();
        }
    }

    public static JspReader createJspReader(String string, JspCompilationContext jspCompilationContext, String string2) throws ParseException, FileNotFoundException {
        return new JspReader(string, jspCompilationContext, string2);
    }

    char[] getChars(Mark mark, Mark mark2) throws ParseException {
        Mark mark3 = this.mark();
        this.reset(mark);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        while (!mark2.equals(this.mark())) {
            charArrayWriter.write(this.nextChar());
        }
        charArrayWriter.close();
        this.reset(mark3);
        return charArrayWriter.toCharArray();
    }

    public String getFile(int n) {
        return (String)this.sourceFiles.elementAt(n);
    }

    public boolean hasMoreInput() throws ParseException {
        if (this.current.cursor >= this.current.stream.length) {
            while (this.popFile()) {
                if (this.current.cursor >= this.current.stream.length) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isDelimiter() throws ParseException {
        if (!this.isSpace()) {
            int n = this.peekChar();
            if (n == 61 || n == 62 || n == 34 || n == 39 || n == 47) {
                return true;
            }
            if (n == 45) {
                Mark mark = this.mark();
                n = this.nextChar();
                if (n == 62 || n == 45 && this.nextChar() == 62) {
                    this.reset(mark);
                    return true;
                }
                this.reset(mark);
                return false;
            }
            return false;
        }
        return true;
    }

    final boolean isSpace() {
        return this.peekChar() <= 32;
    }

    public Mark mark() {
        return new Mark(this.current);
    }

    public boolean matches(String string) throws ParseException {
        Mark mark = this.mark();
        int n = 0;
        int n2 = 0;
        do {
            if ((char)(n = this.nextChar()) == string.charAt(n2++)) continue;
            this.reset(mark);
            return false;
        } while (n2 < string.length());
        this.reset(mark);
        return true;
    }

    public boolean matchesIgnoreCase(String string) throws ParseException {
        Mark mark = this.mark();
        int n = 0;
        int n2 = 0;
        do {
            if (Character.toLowerCase((char)(n = this.nextChar())) == string.charAt(n2++)) continue;
            this.reset(mark);
            return false;
        } while (n2 < string.length());
        this.reset(mark);
        return true;
    }

    public int nextChar() throws ParseException {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char c = this.current.stream[this.current.cursor];
        ++this.current.cursor;
        if (c == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return c;
    }

    String nextContent() {
        char c;
        int n = this.current.cursor;
        int n2 = this.current.stream.length;
        if (this.peekChar() == 10) {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        while (++this.current.cursor < n2 && (c = this.current.stream[this.current.cursor]) != '<') {
            if (c == '\n') {
                ++this.current.line;
                this.current.col = 0;
                continue;
            }
            ++this.current.col;
        }
        return new String(this.current.stream, n, this.current.cursor - n);
    }

    private void parseAttributeValue(Hashtable hashtable) throws ParseException {
        this.skipSpaces();
        String string = this.parseToken(false);
        this.skipSpaces();
        if (this.peekChar() != 61) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.attr.novalue", new Object[]{string}));
        }
        char c = (char)this.nextChar();
        this.skipSpaces();
        String string2 = this.parseToken(true);
        this.skipSpaces();
        hashtable.put(string, string2);
    }

    public void parseParamTag(Hashtable hashtable) throws ParseException {
        if (this.matches("param")) {
            this.advance(6);
            this.parseParams(hashtable);
        }
    }

    private void parseParams(Hashtable hashtable) throws ParseException {
        Hashtable hashtable2 = this.parseTagAttributes();
        String string = (String)hashtable2.get("name");
        String string2 = (String)hashtable2.get("value");
        if (string == null) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.param.noname"));
        }
        if (string2 == null) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.param.novalue"));
        }
        String[] stringArray = (String[])hashtable.get(string);
        if (stringArray == null) {
            String[] stringArray2 = new String[]{string2};
            hashtable.put(string, stringArray2);
        } else {
            String[] stringArray3 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            stringArray3[stringArray.length] = string2;
            hashtable.put(string, stringArray3);
        }
    }

    public void parsePluginParamTag(Hashtable hashtable) throws ParseException {
        if (this.matches("<jsp:param")) {
            this.advance(11);
            this.parseParams(hashtable);
        }
    }

    public Hashtable parseTagAttributes() throws ParseException {
        Hashtable hashtable = new Hashtable(11);
        while (true) {
            Object var6_4;
            Mark mark;
            this.skipSpaces();
            int n = this.peekChar();
            if (n == 62) {
                return hashtable;
            }
            if (n == 45) {
                mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 45 && this.nextChar() == 62) {
                        Hashtable hashtable2 = hashtable;
                        var6_4 = null;
                        this.reset(mark);
                        return hashtable2;
                    }
                    var6_4 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (n == 37) {
                mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        Hashtable hashtable3 = hashtable;
                        var6_4 = null;
                        this.reset(mark);
                        return hashtable3;
                    }
                    var6_4 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (n == 47) {
                mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        Hashtable hashtable4 = hashtable;
                        var6_4 = null;
                        this.reset(mark);
                        return hashtable4;
                    }
                    var6_4 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (n == -1) break;
            this.parseAttributeValue(hashtable);
        }
        throw new ParseException(this.mark(), Constants.getString("jsp.error.tag.attr.unterminated"));
    }

    public Hashtable parseTagAttributesBean() throws ParseException {
        Hashtable hashtable = new Hashtable(11);
        while (true) {
            this.skipSpaces();
            int n = this.peekChar();
            if (n == 62) {
                return hashtable;
            }
            if (n == 47) {
                Object var6_4;
                Mark mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        Hashtable hashtable2 = hashtable;
                        var6_4 = null;
                        this.reset(mark);
                        return hashtable2;
                    }
                    var6_4 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (n == -1) break;
            this.parseAttributeValue(hashtable);
        }
        throw new ParseException(this.mark(), Constants.getString("jsp.error.tag.attr.unterminated"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parseToken(boolean bl) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        this.skipSpaces();
        stringBuffer.setLength(0);
        int n = this.peekChar();
        if (bl) {
            if (n != 34 && n != 39) throw new ParseException(this.mark(), Constants.getString("jsp.error.attr.quoted"));
            int n2 = n == 34 ? 34 : 39;
            n = this.nextChar();
            n = this.nextChar();
            while (n != -1 && n != n2) {
                if (n == 92) {
                    n = this.nextChar();
                }
                stringBuffer.append((char)n);
                n = this.nextChar();
            }
            if (n != -1) return stringBuffer.toString();
            throw new ParseException(this.mark(), Constants.getString("jsp.error.quotes.unterminated"));
        }
        if (this.isDelimiter()) return stringBuffer.toString();
        do {
            if ((n = this.nextChar()) == 92 && (this.peekChar() == 34 || this.peekChar() == 39 || this.peekChar() == 62 || this.peekChar() == 37)) {
                n = this.nextChar();
            }
            stringBuffer.append((char)n);
        } while (!this.isDelimiter());
        return stringBuffer.toString();
    }

    public int peekChar() {
        return this.current.stream[this.current.cursor];
    }

    public boolean popFile() throws ParseException {
        if (this.current == null) {
            return false;
        }
        if (this.currFileId < 0) {
            throw new ParseException(Constants.getString("jsp.error.no.more.content"));
        }
        String string = this.getFile(this.currFileId);
        this.currFileId = this.unregisterSourceFile(string);
        if (this.currFileId < -1) {
            throw new ParseException(Constants.getString("jsp.error.file.not.registered", new Object[]{string}));
        }
        boolean bl = this.current.popStream();
        if (bl) {
            this.master = this.current.baseDir;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pushFile(String string, String string2) throws ParseException, FileNotFoundException {
        if (string2 == null) {
            string2 = this.defEncoding;
        } else {
            this.defEncoding = string2;
        }
        String string3 = this.master == null ? null : this.master.substring(0, this.master.lastIndexOf("/") + 1);
        boolean bl = string.startsWith("/");
        this.master = string3 == null || bl ? string : String.valueOf(string3) + string;
        String string4 = null;
        File file = null;
        if (this.context != null) {
            string4 = this.context.getRealPath(this.master);
            if (string4 != null) {
                file = new File(string4);
            }
        } else {
            file = new File(this.master);
            if (file.exists()) {
                string4 = file.getAbsolutePath();
            }
        }
        if (string4 == null) {
            throw new FileNotFoundException(this.master);
        }
        int n = this.registerSourceFile(string4);
        if (n == -1) {
            throw new ParseException(Constants.getString("jsp.error.file.already.registered", new Object[]{file}));
        }
        this.currFileId = n;
        InputStreamReader inputStreamReader = null;
        try {
            try {
                Closeable closeable;
                if (this.context == null) {
                    inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), string2);
                } else {
                    closeable = this.context.getResourceAsStream(this.master);
                    if (closeable == null) {
                        throw new FileNotFoundException(string4);
                    }
                    try {
                        inputStreamReader = new InputStreamReader((InputStream)closeable, string2);
                    }
                    catch (Exception exception) {
                        throw new FileNotFoundException(String.valueOf(string4) + ": " + exception.getMessage());
                    }
                }
                closeable = new CharArrayWriter();
                char[] cArray = new char[1024];
                int n2 = 0;
                while ((n2 = inputStreamReader.read(cArray)) != -1) {
                    ((CharArrayWriter)closeable).write(cArray, 0, n2);
                }
                ((CharArrayWriter)closeable).close();
                if (this.current == null) {
                    this.current = new Mark(this, ((CharArrayWriter)closeable).toCharArray(), n, this.getFile(n), this.master, string2);
                } else {
                    this.current.pushStream(((CharArrayWriter)closeable).toCharArray(), n, this.getFile(n), this.master, string2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (Exception exception) {
                this.popFile();
                throw new ParseException(Constants.getString("jsp.error.file.cannot.read", new Object[]{file}));
            }
            Object var10_14 = null;
            if (inputStreamReader == null) return;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (inputStreamReader == null) throw throwable;
            try {
                inputStreamReader.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            inputStreamReader.close();
            return;
        }
        catch (Exception exception) {}
    }

    protected int registerSourceFile(String string) {
        if (this.sourceFiles.contains(string)) {
            return -1;
        }
        this.sourceFiles.addElement(string);
        ++this.size;
        return this.sourceFiles.size() - 1;
    }

    public void reset(Mark mark) {
        this.current = new Mark(mark);
    }

    public int skipSpaces() throws ParseException {
        int n = 0;
        while (this.isSpace()) {
            ++n;
            this.nextChar();
        }
        return n;
    }

    public Mark skipUntil(String string) throws ParseException {
        Mark mark = null;
        int n = string.length();
        mark = this.mark();
        int n2 = this.nextChar();
        while (n2 != -1) {
            block4: {
                if (n2 == string.charAt(0)) {
                    int n3 = 1;
                    while (n3 < n) {
                        if (Character.toLowerCase((char)this.nextChar()) == string.charAt(n3)) {
                            ++n3;
                            continue;
                        }
                        break block4;
                    }
                    return mark;
                }
            }
            mark = this.mark();
            n2 = this.nextChar();
        }
        return null;
    }

    protected int unregisterSourceFile(String string) {
        if (!this.sourceFiles.contains(string)) {
            return -1;
        }
        this.sourceFiles.removeElement(string);
        --this.size;
        return this.sourceFiles.size() - 1;
    }
}

