/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.factory;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;

public class JSSESocketFactory
implements LDAPSocketFactory,
Serializable {
    static final long serialVersionUID = 6834205777733266609L;
    private String[] suites;
    private SSLSocketFactory factory;

    public JSSESocketFactory(String[] stringArray) {
        this(stringArray, null);
    }

    public JSSESocketFactory(String[] stringArray, SSLSocketFactory sSLSocketFactory) {
        this.suites = stringArray;
        this.factory = sSLSocketFactory != null ? sSLSocketFactory : (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public Socket makeSocket(String string, int n) throws LDAPException {
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)this.factory.createSocket(string, n);
            if (this.suites != null) {
                sSLSocket.setEnabledCipherSuites(this.suites);
            }
            sSLSocket.startHandshake();
        }
        catch (UnknownHostException unknownHostException) {
            throw new LDAPException("SSL connection to " + string + ":" + n + ", " + unknownHostException.getMessage(), 91);
        }
        catch (IOException iOException) {
            throw new LDAPException("SSL connection to " + string + ":" + n + ", " + iOException.getMessage(), 91);
        }
        return sSLSocket;
    }
}

