/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.servlet.topology.TopologyImageData;
import com.sun.web.ui.servlet.topology.TopologyRenderer;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

class SessionImageCache
implements HttpSessionBindingListener {
    private static final String CACHE_ATTR = "CCTopologyServlet.imageCache";
    private static final int MAX_IMAGE_LOAD_WAIT = 500;
    private static long lastPutKey;
    private static String lastGetKey;
    private static final Map instanceCache;
    private final Map imageCache;
    private BackgroundRenderer bgRenderer;
    private CacheReaper cacheReaper;

    public static SessionImageCache getInstance(HttpSession httpSession) {
        SessionImageCache sessionImageCache = null;
        Object v = instanceCache.get(httpSession.getId());
        if (v instanceof SessionImageCache) {
            sessionImageCache = (SessionImageCache)v;
        } else {
            sessionImageCache = new SessionImageCache(httpSession);
            instanceCache.put(httpSession.getId(), sessionImageCache);
        }
        return sessionImageCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionImageCache(HttpSession httpSession) {
        if (!(httpSession.getAttribute(CACHE_ATTR) instanceof Map)) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                if (!(httpSession.getAttribute(CACHE_ATTR) instanceof Map)) {
                    httpSession.setAttribute(CACHE_ATTR, new HashMap());
                }
            }
        }
        this.imageCache = (Map)httpSession.getAttribute(CACHE_ATTR);
        httpSession.setAttribute("com.sun.web.ui.servlet.topology.SessionImageCache:" + this.hashCode(), (Object)this);
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this.bgRenderer != null) {
            this.bgRenderer.stop();
            this.bgRenderer = null;
        }
        if (this.cacheReaper != null) {
            this.cacheReaper.stop();
            this.cacheReaper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackgroundRenderer getBackgroundRenderer() {
        if (this.bgRenderer == null) {
            SessionImageCache sessionImageCache = this;
            synchronized (sessionImageCache) {
                if (this.bgRenderer == null) {
                    this.bgRenderer = new BackgroundRenderer();
                    new Thread(this.bgRenderer).start();
                    this.cacheReaper = new CacheReaper();
                    new Thread(this.cacheReaper).start();
                }
            }
        }
        return this.bgRenderer;
    }

    public String cacheImage(TopologyRenderer topologyRenderer, Rectangle rectangle, String string) {
        long l;
        lastPutKey = l = Math.max(System.currentTimeMillis(), lastPutKey + 1L);
        String string2 = Long.toString(l);
        TopologyImageData topologyImageData = new TopologyImageData(topologyRenderer, rectangle, string);
        this.imageCache.put(string2, topologyImageData.asPrimitives());
        if (CCDebug.isOn()) {
            CCDebug.trace3((String)("caching image " + string2 + ", " + topologyImageData.asPrimitives()));
        }
        this.getBackgroundRenderer().renderImage(topologyImageData);
        return string2;
    }

    public TopologyImageData takeImageData(String string) {
        if (lastGetKey != null && !lastGetKey.equals(string)) {
            this.imageCache.remove(lastGetKey);
        }
        lastGetKey = string;
        Object v = this.imageCache.get(lastGetKey);
        return TopologyImageData.createFromPrimitives(v);
    }

    static {
        instanceCache = new WeakHashMap();
    }

    private class BackgroundRenderer
    implements Runnable {
        private List queue = new ArrayList();
        private boolean isStopped;

        public void stop() {
            this.isStopped = true;
        }

        public synchronized void renderImage(TopologyImageData topologyImageData) {
            this.queue.add(topologyImageData);
            this.notifyAll();
        }

        public synchronized void run() {
            while (true) {
                if (this.queue.size() > 0) {
                    ((TopologyImageData)this.queue.remove(0)).encodeImage();
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isStopped) break;
            }
            this.queue.clear();
        }
    }

    private class CacheReaper
    implements Runnable {
        private static final long REAP_INTERVAL = 60000L;
        private static final long STALE_DURATION = 120000L;
        private boolean isStopped;

        public void stop() {
            this.isStopped = true;
        }

        public synchronized void run() {
            do {
                long l = System.currentTimeMillis() + 60000L;
                while (System.currentTimeMillis() < l) {
                    try {
                        this.wait(l - System.currentTimeMillis());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                String string = Long.toString(System.currentTimeMillis() - 120000L);
                Iterator iterator = SessionImageCache.this.imageCache.keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string2 == null || string.compareTo(string2) <= 0 && !this.isStopped) continue;
                    iterator.remove();
                    if (!CCDebug.isOn()) continue;
                    CCDebug.trace3((String)("Deleted stale image " + string2));
                }
            } while (!this.isStopped);
            SessionImageCache.this.imageCache.clear();
        }
    }
}

