/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCTopologyModelInterface;
import com.sun.web.ui.servlet.topology.TopologyRenderer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;

public class DefaultTopologyRenderer
implements TopologyRenderer {
    private static final int DEFAULT_ICON_SIZE = 8;
    private static final int EDGE_HOT_SPACE = 2;
    private static final int TEXT_HSPACE = 5;
    private static final int TEXT_VSPACE = 1;
    private static final int MIN_EDGE_LENGTH = 10;
    private static final int ARROW_SPACE = 7;
    private static final int NODE_SPACE = 5;
    private static final int EDGE_SPACE = 4;
    private static final int BADGE_OVERHANG = 3;
    private static final int NODE_EDGE_SPACE = 3;
    private static final Color BG_COLOR = Color.white;
    private static final Color FG_COLOR = Color.black;
    private static final Object NULL_SIZE = new Object();
    private final Color FILTER_COLOR = new Color(204, 204, 204);
    private final Stroke NORMAL_STROKE = new BasicStroke(1.0f);
    private final Stroke EDGE_BORDER_STROKE = new BasicStroke(3.0f, 0, 2);
    private final CCTopologyModelInterface.IconSet iconSet;
    private final CCTopologyModelInterface.BadgeSet badgeSet;
    private final CCTopologyModelInterface model;
    private final Font font;
    private final FontRenderContext fontContext;
    private final CCI18N i18n;
    private LayoutModel layoutModel;
    private Dimension size;
    private final Map filteredImages = new WeakHashMap();
    private final Map badgeSizes = new HashMap();

    public DefaultTopologyRenderer(CCTopologyModelInterface cCTopologyModelInterface, CCI18N cCI18N) {
        this(cCTopologyModelInterface, cCI18N, cCTopologyModelInterface.getIconSet(), cCTopologyModelInterface.getBadgeSet(), null);
    }

    public DefaultTopologyRenderer(CCTopologyModelInterface cCTopologyModelInterface, CCI18N cCI18N, CCTopologyModelInterface.IconSet iconSet, CCTopologyModelInterface.BadgeSet badgeSet, Font font) {
        this.validateModel(cCTopologyModelInterface);
        this.model = cCTopologyModelInterface;
        this.i18n = cCI18N;
        this.iconSet = iconSet;
        this.badgeSet = badgeSet;
        this.font = font != null ? font : this.getDefaultLabelFont();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.font);
        this.fontContext = graphics2D.getFontRenderContext();
        graphics2D.dispose();
        bufferedImage.flush();
    }

    public static Image createFilteredImage(Image image) {
        if (image == null) {
            return null;
        }
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.2f);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(BG_COLOR);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setComposite(alphaComposite);
        graphics2D.drawImage(image, 0, 0, BG_COLOR, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public final CCTopologyModelInterface getModel() {
        return this.model;
    }

    public final void renderModel() {
        this.layoutImage();
    }

    public Dimension getImageSize() {
        if (this.layoutModel == null) {
            this.layoutImage();
        }
        return this.size;
    }

    public final BufferedImage getImage(Rectangle rectangle) {
        if (this.layoutModel == null) {
            this.layoutImage();
        }
        BufferedImage bufferedImage = null;
        try {
            int n = rectangle == null ? this.size.width : Math.min(this.size.width, rectangle.width);
            int n2 = rectangle == null ? this.size.height : Math.min(this.size.height, rectangle.height);
            bufferedImage = new BufferedImage(n, n2, 1);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (CCDebug.isOn()) {
                CCDebug.trace1((String)"Could not create off-screen image", (Throwable)outOfMemoryError);
            }
            return null;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (rectangle != null) {
            graphics2D.setTransform(AffineTransform.getTranslateInstance(-rectangle.x, -rectangle.y));
            graphics2D.clip(rectangle);
        }
        this.drawTopology(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public Rectangle[] getBounds(CCTopologyModelInterface.Node node, Rectangle rectangle) {
        LayoutElement layoutElement;
        if (this.layoutModel == null) {
            this.layoutImage();
        }
        Rectangle[] rectangleArray = (layoutElement = this.layoutModel.getLayoutElement(node)) == null ? null : layoutElement.getBounds();
        return this.clipBounds(rectangleArray, rectangle);
    }

    public Rectangle[] getBounds(CCTopologyModelInterface.Edge edge, Rectangle rectangle) {
        LayoutElement layoutElement;
        if (this.layoutModel == null) {
            this.layoutImage();
        }
        Rectangle[] rectangleArray = (layoutElement = this.layoutModel.getLayoutElement(edge)) == null ? null : layoutElement.getBounds();
        return this.clipBounds(rectangleArray, rectangle);
    }

    public Rectangle[] getBadgeBounds(CCTopologyModelInterface.Node node, Rectangle rectangle) {
        Dimension dimension;
        if (this.layoutModel == null) {
            this.layoutImage();
        }
        if ((dimension = this.getBadgeSize(node.getBadge())) == null) {
            return new Rectangle[0];
        }
        LayoutNode layoutNode = (LayoutNode)this.layoutModel.getLayoutElement(node);
        return layoutNode == null ? new Rectangle[]{} : this.clipBounds(new Rectangle[]{new Rectangle(layoutNode.imageBounds.x + layoutNode.imageBounds.width - dimension.width + 3, layoutNode.imageBounds.y + layoutNode.imageBounds.height - dimension.height + 3, dimension.width, dimension.height)}, rectangle);
    }

    public Rectangle[] getBadgeBounds(CCTopologyModelInterface.Edge edge, Rectangle rectangle) {
        Dimension dimension;
        if (this.layoutModel == null) {
            this.layoutImage();
        }
        if ((dimension = this.getBadgeSize(edge.getBadge())) != null) {
            LayoutEdge layoutEdge = (LayoutEdge)this.layoutModel.getLayoutElement(edge);
            if (layoutEdge == null) {
                return new Rectangle[0];
            }
            if (layoutEdge.getBadge() != 0) {
                Point point = layoutEdge.getPoints()[layoutEdge.badgePoint];
                int n = point.x - dimension.width / 2;
                int n2 = point.y - dimension.height / 2;
                return this.clipBounds(new Rectangle[]{new Rectangle(n, n2, dimension.width, dimension.height)}, rectangle);
            }
        }
        return new Rectangle[0];
    }

    public final Font getLabelFont() {
        return this.font;
    }

    public final Font getDefaultLabelFont() {
        return new Font("SansSerif", 10, 0).deriveFont(0, 10.0f);
    }

    private void validateModel(CCTopologyModelInterface cCTopologyModelInterface) {
        if (cCTopologyModelInterface == null) {
            throw new IllegalArgumentException("model == null");
        }
        int n = cCTopologyModelInterface.getTierCount();
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("invalid model: tierCount < 1 or > 3");
        }
        TreeSet<CCTopologyModelInterface.Node> treeSet = new TreeSet<CCTopologyModelInterface.Node>(new Comparator(){

            public int compare(Object object, Object object2) {
                if (!(object instanceof CCTopologyModelInterface.Node) || !(object2 instanceof CCTopologyModelInterface.Node) || object == object2) {
                    return 0;
                }
                int n = ((CCTopologyModelInterface.Node)object).getLabel().compareTo(((CCTopologyModelInterface.Node)object2).getLabel());
                return n != 0 ? n : object2.hashCode() - object.hashCode();
            }
        });
        CCTopologyModelInterface.Node[][] nodeArray = new CCTopologyModelInterface.Node[n][0];
        int n2 = 0;
        while (n2 < n) {
            nodeArray[n2] = cCTopologyModelInterface.getTierNodes(n2);
            if (nodeArray[n2] == null) {
                throw new IllegalArgumentException("invalid model: getTierNodes(" + n2 + ") == null");
            }
            int n3 = 0;
            while (n3 < nodeArray[n2].length) {
                if (nodeArray[n2][n3] == null) {
                    throw new IllegalArgumentException("invalid model: getTierNodes(" + n2 + ")[" + n3 + "] == null");
                }
                if (nodeArray[n2][n3].getLabel() == null) {
                    throw new IllegalArgumentException("invalid model: getTierNodes(" + n2 + ")[" + n3 + "].getLabel() == null");
                }
                treeSet.add(nodeArray[n2][n3]);
                ++n3;
            }
            ++n2;
        }
        CCTopologyModelInterface.Edge[] edgeArray = cCTopologyModelInterface.getEdges();
        if (edgeArray == null) {
            throw new IllegalArgumentException("invalid model: getEdges() == null");
        }
        int n4 = 0;
        while (n4 < edgeArray.length) {
            if (edgeArray[n4] == null) {
                throw new IllegalArgumentException("invalid model: getEdges()[" + n4 + "] == null");
            }
            CCTopologyModelInterface.Node node = edgeArray[n4].getSource();
            CCTopologyModelInterface.Node node2 = edgeArray[n4].getDestination();
            if (node == null) {
                throw new IllegalArgumentException("invalid model: getEdges()[" + n4 + "].getSource() == null");
            }
            if (node2 == null) {
                throw new IllegalArgumentException("invalid model: getEdges()[" + n4 + "].getDestination() == null");
            }
            if (!treeSet.contains(node)) {
                throw new IllegalArgumentException("invalid model: getEdges()[" + n4 + "].getSource() == invalid node");
            }
            if (!treeSet.contains(node2)) {
                throw new IllegalArgumentException("invalid model: getEdges()[" + n4 + "].getDestination() == invalid node");
            }
            ++n4;
        }
    }

    private Dimension getBadgeSize(int n) {
        Integer n2 = new Integer(n);
        Object object = this.badgeSizes.get(n2);
        if (object == null) {
            Image image = this.badgeSet.getImage(n);
            object = image == null ? NULL_SIZE : new Dimension(image.getWidth(null), image.getHeight(null));
            this.badgeSizes.put(n2, object);
        }
        return object instanceof Dimension ? (Dimension)object : null;
    }

    private Rectangle[] clipBounds(Rectangle[] rectangleArray, Rectangle rectangle) {
        if (rectangleArray == null || rectangleArray.length == 0) {
            return new Rectangle[0];
        }
        if (rectangle == null) {
            return rectangleArray;
        }
        HashSet<Rectangle> hashSet = new HashSet<Rectangle>();
        int n = 0;
        while (n < rectangleArray.length) {
            if (rectangle.intersects(rectangleArray[n])) {
                Rectangle rectangle2 = rectangle.intersection(rectangleArray[n]);
                rectangle2.x -= rectangle.x;
                rectangle2.y -= rectangle.y;
                hashSet.add(rectangle2);
            }
            ++n;
        }
        return hashSet.toArray(new Rectangle[hashSet.size()]);
    }

    private void layoutImage() {
        this.layoutModel = new LayoutModel(this.model, this.i18n);
        switch (this.layoutModel.getTierCount()) {
            case 1: {
                this.size = this.layoutSingleTier();
                break;
            }
            case 2: 
            case 3: {
                this.size = this.layoutTripleTier();
                break;
            }
            default: {
                this.size = new Dimension(1, 1);
            }
        }
    }

    private Dimension layoutSingleTier() {
        int n;
        int n2;
        int n3;
        int n4;
        LayoutNode[] layoutNodeArray = (LayoutNode[])this.layoutModel.getTierNodes(0);
        int n5 = this.calculateSizes(layoutNodeArray, true);
        int n6 = Math.max(10, 4 + (this.layoutModel.hasArrowheads ? 7 : 0) + (this.layoutModel.hasEdgeBadges || this.layoutModel.hasSelectableEdges ? 7 : 0));
        LayoutEdge[][] layoutEdgeArrayArray = new LayoutEdge[layoutNodeArray.length][];
        boolean[] blArray = new boolean[layoutNodeArray.length];
        boolean bl = false;
        int n7 = 0;
        while (n7 < layoutNodeArray.length) {
            LayoutNode layoutNode = layoutNodeArray[n7];
            n4 = layoutNode.edges.size();
            layoutEdgeArrayArray[n7] = layoutNode.edges.toArray(new LayoutEdge[n4]);
            Arrays.sort(layoutEdgeArrayArray[n7], new SingleTierEdgeComparator(layoutNode));
            n3 = 0;
            while (n3 < n4) {
                LayoutNode layoutNode2 = layoutEdgeArrayArray[n7][n3].getOtherNode(layoutNode);
                if (layoutNode2.index == layoutNode.index) {
                    bl = true;
                    blArray[n7] = true;
                }
                if (layoutNode2.index >= layoutNode.index) {
                    layoutNode.belowEdgeCount = n4 - n3;
                    break;
                }
                ++n3;
            }
            layoutNode.aboveEdgeCount = n4 - layoutNode.belowEdgeCount;
            ++n7;
        }
        int n8 = 4 + (bl && this.layoutModel.hasSelectableEdges || this.layoutModel.hasEdgeBadges || this.layoutModel.hasArrowheads ? 3 : 0);
        n4 = 5 + (this.layoutModel.hasNodeBadges ? 3 : 0);
        n3 = 3 + (this.layoutModel.hasNodeBadges ? 3 : 0);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < layoutNodeArray.length) {
            n9 = Math.max(n9, layoutNodeArray[n11].imageBounds.width);
            n10 = Math.max(n10, layoutNodeArray[n11].imageBounds.height);
            ++n11;
        }
        int n12 = layoutNodeArray[0].textBounds.width + 5;
        int n13 = 0;
        int n14 = 0;
        while (n14 < layoutNodeArray.length) {
            LayoutNode layoutNode = layoutNodeArray[n14];
            n2 = Math.max(n9, (layoutNode.aboveEdgeCount + 2) * n8);
            n = Math.max(n10, (layoutNode.belowEdgeCount + 2) * n8);
            layoutNode.imageBounds.setLocation(n12 + (n2 - n9) / 2, n13 + (n - n10) / 2);
            layoutNode.textBounds.setLocation(layoutNode.imageBounds.x - 5 - layoutNode.textBounds.width, layoutNode.imageBounds.y + layoutNode.imageBounds.height - layoutNode.textBounds.height);
            n12 += n2 + n4 + (blArray[n14] ? n6 : 0);
            n13 += n + n4;
            ++n14;
        }
        int n15 = n12 - 5;
        n2 = n13 - 5;
        n = 0;
        int n16 = 0;
        while (n16 < layoutNodeArray.length) {
            LayoutNode layoutNode = layoutNodeArray[n16];
            LayoutEdge[] layoutEdgeArray = layoutEdgeArrayArray[n16];
            n12 = layoutNode.imageBounds.x + (layoutNode.imageBounds.width - (layoutNode.aboveEdgeCount - 1) * n8) / 2;
            n13 = layoutNode.imageBounds.y - 3;
            int n17 = 0;
            while (n17 < layoutNode.aboveEdgeCount) {
                if (layoutNode == layoutEdgeArray[n17].source) {
                    layoutEdgeArray[n17].sourcePoint = new Point(n12, n13);
                } else {
                    layoutEdgeArray[n17].destinationPoint = new Point(n12, n13);
                }
                n12 += n8;
                ++n17;
            }
            n12 = Math.max(n12, layoutNode.imageBounds.x + layoutNode.imageBounds.width + n3);
            n13 = layoutNode.imageBounds.y + (layoutNode.imageBounds.height + (layoutNode.belowEdgeCount - 1) * n8) / 2;
            while (n17 < layoutEdgeArray.length) {
                if (layoutNode == layoutEdgeArray[n17].source) {
                    if (layoutNode == layoutEdgeArray[n17].destination) {
                        layoutEdgeArray[n17].sourcePoint = new Point(n12, n13);
                        layoutEdgeArray[n17].destinationPoint = new Point(n12, n13 -= n8);
                        layoutEdgeArray[n17].offset = n6;
                        ++n17;
                        if (n16 == layoutNodeArray.length - 1) {
                            n = 1;
                        }
                    } else {
                        layoutEdgeArray[n17].sourcePoint = new Point(n12, n13);
                    }
                } else {
                    layoutEdgeArray[n17].destinationPoint = new Point(n12, n13);
                }
                n13 -= n8;
                ++n17;
            }
            ++n16;
        }
        if (n != 0) {
            n15 += n3 + n6 + 3;
        }
        return new Dimension(n15, n2);
    }

    private Dimension layoutTripleTier() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        LayoutNode[] layoutNodeArray = (LayoutNode[])this.layoutModel.getTierNodes(0);
        LayoutNode[] layoutNodeArray2 = (LayoutNode[])this.layoutModel.getTierNodes(1);
        LayoutNode[] layoutNodeArray3 = (LayoutNode[])this.layoutModel.getTierNodes(2);
        int n13 = this.calculateSizes(layoutNodeArray, true);
        int n14 = this.calculateSizes(layoutNodeArray2, false);
        int n15 = this.calculateSizes(layoutNodeArray3, true);
        int n16 = Math.max(n13, n15);
        boolean bl = layoutNodeArray.length == 0;
        boolean bl2 = false;
        LayoutEdge[][][] layoutEdgeArrayArray = new LayoutEdge[3][][];
        int n17 = 0;
        while (n17 < 3) {
            LayoutNode[] layoutNodeArray4 = n17 == 0 ? layoutNodeArray : (n17 == 1 ? layoutNodeArray2 : layoutNodeArray3);
            layoutEdgeArrayArray[n17] = new LayoutEdge[layoutNodeArray4.length][];
            n12 = 0;
            while (n12 < layoutNodeArray4.length) {
                LayoutNode layoutNode = layoutNodeArray4[n12];
                n11 = layoutNode.edges.size();
                layoutEdgeArrayArray[n17][n12] = layoutNode.edges.toArray(new LayoutEdge[n11]);
                if (n17 == 0 || n17 == 1 && bl) {
                    Arrays.sort(layoutEdgeArrayArray[n17][n12], new TierOneEdgeComparator(layoutNode));
                } else {
                    Arrays.sort(layoutEdgeArrayArray[n17][n12], new TierThreeEdgeComparator(layoutNode));
                }
                block0 : switch (n17) {
                    case 0: {
                        layoutNode.belowEdgeCount = n11;
                        break;
                    }
                    case 2: {
                        layoutNode.belowEdgeCount = 0;
                        break;
                    }
                    case 1: {
                        if (bl) {
                            layoutNode.belowEdgeCount = n11;
                            break;
                        }
                        n10 = 0;
                        while (n10 < n11) {
                            LayoutNode layoutNode2 = layoutEdgeArrayArray[n17][n12][n10].getOtherNode(layoutNode);
                            if (layoutNode2.tier > layoutNode.tier) {
                                layoutNode.belowEdgeCount = n11 - n10;
                                break block0;
                            }
                            ++n10;
                        }
                        break;
                    }
                }
                layoutNode.aboveEdgeCount = n11 - layoutNode.belowEdgeCount;
                n10 = 0;
                while (n10 < layoutEdgeArrayArray[n17][n12].length) {
                    if (layoutEdgeArrayArray[n17][n12][n10].source == layoutEdgeArrayArray[n17][n12][n10].destination) {
                        bl2 = true;
                    }
                    ++n10;
                }
                ++n12;
            }
            ++n17;
        }
        int n18 = 4 + (bl2 && this.layoutModel.hasSelectableEdges || this.layoutModel.hasEdgeBadges || this.layoutModel.hasArrowheads ? 3 : 0);
        n12 = 5 + (this.layoutModel.hasNodeBadges ? 3 : 0);
        int n19 = this.layoutModel.hasNodeBadges ? 6 : 3;
        n11 = Math.max(10, 4 + (this.layoutModel.hasArrowheads ? 7 : 0) + (this.layoutModel.hasEdgeBadges || this.layoutModel.hasSelectableEdges ? 7 : 0));
        n10 = 0;
        int n20 = 0;
        int n21 = 0;
        while (n21 < layoutNodeArray.length) {
            n10 = Math.max(n10, layoutNodeArray[n21].imageBounds.width);
            ++n21;
        }
        int n22 = n16 - n10;
        int n23 = this.layoutModel.hasEdgeBadges ? 3 : 0;
        int n24 = 0;
        while (n24 < layoutNodeArray.length) {
            LayoutNode layoutNode = layoutNodeArray[n24];
            n20 = layoutNode.imageBounds.height;
            n9 = Math.max(n20, layoutNode.belowEdgeCount * n18 + n11 - n12);
            layoutNode.imageBounds.setLocation(n22, n23 + (n9 - n20) / 2);
            layoutNode.textBounds.setLocation(n22 - 5 - layoutNode.textBounds.width, n23 + (n9 - layoutNode.textBounds.height) / 2);
            n23 += n9 + n12;
            ++n24;
        }
        n10 = 0;
        n20 = 0;
        int n25 = 0;
        while (n25 < layoutNodeArray2.length) {
            n20 = Math.max(n20, layoutNodeArray2[n25].imageBounds.height);
            ++n25;
        }
        n22 = n16 + n19 + n11;
        if (layoutNodeArray.length > 0) {
            n23 = n23 - n12 + n11;
        }
        n9 = 0;
        int n26 = 0;
        while (n26 < layoutNodeArray2.length) {
            n9 = Math.max(n9, layoutNodeArray2[n26].textBounds.height);
            ++n26;
        }
        int n27 = bl ? n23 + (--n9 - 1) + 1 : n23;
        int n28 = n23;
        if (!bl) {
            n28 += n20 + 1;
            if (this.layoutModel.hasNodeBadges) {
                n28 += 3;
            }
        }
        int n29 = 0;
        while (n29 < layoutNodeArray2.length) {
            LayoutNode layoutNode = layoutNodeArray2[n29];
            n10 = layoutNode.imageBounds.width;
            n8 = Math.max(Math.max(layoutNode.aboveEdgeCount, layoutNode.belowEdgeCount) * n18 + n11 - n12, Math.max(n10, layoutNode.textBounds.width));
            layoutNode.textBounds.setLocation(n22 + (n8 - layoutNode.textBounds.width) / 2, n28);
            layoutNode.imageBounds.setLocation(n22 + (n8 - n10) / 2, n27);
            n22 += n8 + n12;
            ++n29;
        }
        int n30 = n22 - 5 + (this.layoutModel.hasEdgeBadges ? 3 : 0);
        n23 += n20 + 1 + n9 + n11;
        n10 = 0;
        n20 = 0;
        n8 = 0;
        while (n8 < layoutNodeArray3.length) {
            n10 = Math.max(n10, layoutNodeArray3[n8].imageBounds.width);
            ++n8;
        }
        n22 = n16 - n10;
        int n31 = 0;
        while (n31 < layoutNodeArray3.length) {
            LayoutNode layoutNode = layoutNodeArray3[n31];
            n20 = layoutNode.imageBounds.height;
            int n32 = Math.max(n20, layoutNode.aboveEdgeCount * n18 + n11 - n12);
            layoutNode.imageBounds.setLocation(n22, n23 + (n32 - n20) / 2);
            layoutNode.textBounds.setLocation(n22 - 5 - layoutNode.textBounds.width, n23 + (n32 - layoutNode.textBounds.height) / 2);
            n23 += n32 + n12;
            ++n31;
        }
        int n33 = layoutNodeArray3.length == 0 ? n23 + 1 : n23 - 5 + (this.layoutModel.hasEdgeBadges ? 3 : 0);
        int[][] nArrayArray = new int[][]{new int[layoutNodeArray.length], new int[layoutNodeArray2.length], new int[layoutNodeArray3.length]};
        int n34 = 0;
        while (n34 < layoutNodeArray.length) {
            LayoutNode layoutNode = layoutNodeArray[n34];
            object = layoutEdgeArrayArray[0][n34];
            n22 = layoutNode.imageBounds.x + layoutNode.imageBounds.width + n19;
            n23 = layoutNode.imageBounds.y + (layoutNode.imageBounds.height + (layoutNode.belowEdgeCount - 1) * n18) / 2;
            int n35 = 0;
            while (n35 < ((LayoutEdge[])object).length && layoutNode == object[n35].source && layoutNode == object[n35].destination) {
                object[n35].sourcePoint = new Point(n22, n23);
                object[n35].destinationPoint = new Point(n22, n23 -= n18);
                n23 -= n18;
                object[n35].offset = n11;
                n35 += 2;
                if (layoutNode.index == 0) continue;
                nArrayArray[0][layoutNode.index - 1] = n11;
            }
            n7 = ((LayoutEdge[])object).length - 1;
            while (n7 >= n35) {
                if (layoutNode == object[n7].source) {
                    object[n7].sourcePoint = new Point(n22, n23);
                } else {
                    object[n7].destinationPoint = new Point(n22, n23);
                }
                n23 -= n18;
                --n7;
            }
            ++n34;
        }
        int n36 = 0;
        while (n36 < layoutNodeArray2.length) {
            object = layoutNodeArray2[n36];
            LayoutEdge[] layoutEdgeArray = layoutEdgeArrayArray[1][n36];
            n22 = object.imageBounds.x + (object.imageBounds.width - (object.aboveEdgeCount - 1) * n18) / 2;
            n23 = Math.min(object.imageBounds.y, object.textBounds.y) - 3 - 1;
            n7 = 0;
            while (n7 < object.aboveEdgeCount) {
                if (object == layoutEdgeArray[n7].source) {
                    if (object == layoutEdgeArray[n7].destination) {
                        layoutEdgeArray[n7].destinationPoint = new Point(n22, n23);
                        layoutEdgeArray[n7].sourcePoint = new Point(n22 += n18, n23);
                        layoutEdgeArray[n7].offset = n11;
                        ++n7;
                    } else {
                        layoutEdgeArray[n7].sourcePoint = new Point(n22, n23);
                    }
                } else {
                    layoutEdgeArray[n7].destinationPoint = new Point(n22, n23);
                }
                n22 += n18;
                ++n7;
            }
            n22 = object.imageBounds.x + (object.imageBounds.width - (object.belowEdgeCount - 1) * n18) / 2;
            n23 = Math.max(object.imageBounds.y + object.imageBounds.height + n19, object.textBounds.y + object.textBounds.height + 3);
            if (!bl) {
                n23 -= 2;
            }
            while (n7 < layoutEdgeArray.length) {
                if (object == layoutEdgeArray[n7].source) {
                    if (object == layoutEdgeArray[n7].destination) {
                        layoutEdgeArray[n7].destinationPoint = new Point(n22, n23);
                        layoutEdgeArray[n7].sourcePoint = new Point(n22 += n18, n23);
                        layoutEdgeArray[n7].offset = n11;
                        ++n7;
                    } else {
                        layoutEdgeArray[n7].sourcePoint = new Point(n22, n23);
                    }
                } else {
                    layoutEdgeArray[n7].destinationPoint = new Point(n22, n23);
                }
                n22 += n18;
                ++n7;
            }
            ++n36;
        }
        int n37 = 0;
        while (n37 < layoutNodeArray3.length) {
            LayoutNode layoutNode = layoutNodeArray3[n37];
            LayoutEdge[] layoutEdgeArray = layoutEdgeArrayArray[2][n37];
            n22 = layoutNode.imageBounds.x + layoutNode.imageBounds.width + n19;
            n23 = layoutNode.imageBounds.y + (layoutNode.imageBounds.height + (layoutNode.aboveEdgeCount - 1) * n18) / 2;
            n6 = layoutEdgeArray.length - 1;
            while (n6 >= 0) {
                if (layoutNode == layoutEdgeArray[n6].source) {
                    if (layoutNode == layoutEdgeArray[n6].destination) {
                        layoutEdgeArray[n6].sourcePoint = new Point(n22, n23);
                        layoutEdgeArray[n6].destinationPoint = new Point(n22, n23 -= n18);
                        layoutEdgeArray[n6].offset = n11;
                        --n6;
                    } else {
                        layoutEdgeArray[n6].sourcePoint = new Point(n22, n23);
                    }
                } else {
                    layoutEdgeArray[n6].destinationPoint = new Point(n22, n23);
                }
                n23 -= n18;
                --n6;
            }
            ++n37;
        }
        LayoutEdge[] layoutEdgeArray = (LayoutEdge[])this.layoutModel.getEdges();
        Arrays.sort(layoutEdgeArray, new WithinTierEdgeComparator());
        int n38 = 0;
        while (n38 < layoutEdgeArray.length) {
            if (WithinTierEdgeComparator.getEdgeLength(layoutEdgeArray[n38]) == Integer.MAX_VALUE) break;
            n6 = layoutEdgeArray[n38].source.tier;
            n5 = layoutEdgeArray[n38].source.index;
            n4 = layoutEdgeArray[n38].destination.index;
            if (n5 > n4) {
                n5 = n4;
                n4 = layoutEdgeArray[n38].source.index;
            }
            n3 = n11 - n18;
            n2 = n5;
            while (n2 < n4) {
                n3 = Math.max(n3, nArrayArray[n6][n2]);
                ++n2;
            }
            layoutEdgeArray[n38].offset = n6 == 1 && bl ? -n3 : (n3 += n18);
            if (n5 == n4) {
                nArrayArray[n6][n5] = Math.max(nArrayArray[n6][n5], n3);
            } else {
                n = n5;
                while (n < n4) {
                    nArrayArray[n6][n] = n3;
                    ++n;
                }
            }
            ++n38;
        }
        n6 = 0;
        n5 = 0;
        n4 = 0;
        while (n4 < nArrayArray[0].length) {
            n6 = Math.max(n6, nArrayArray[0][n4]);
            ++n4;
        }
        n3 = 0;
        while (n3 < nArrayArray[1].length) {
            n5 = Math.max(n5, nArrayArray[1][n3]);
            ++n3;
        }
        n2 = 0;
        while (n2 < nArrayArray[2].length) {
            n6 = Math.max(n6, nArrayArray[2][n2]);
            ++n2;
        }
        int n39 = n = bl ? 0 : n5;
        if (n6 > 0 || n > 0) {
            int n40 = 0;
            while (n40 < layoutNodeArray2.length) {
                layoutNodeArray2[n40].imageBounds.translate(n6, n);
                layoutNodeArray2[n40].textBounds.translate(n6, n);
                ++n40;
            }
        }
        if (n5 > 0) {
            int n41 = 0;
            while (n41 < layoutNodeArray3.length) {
                layoutNodeArray3[n41].imageBounds.translate(0, n5);
                layoutNodeArray3[n41].textBounds.translate(0, n5);
                ++n41;
            }
        }
        if (n5 > 0 || n6 > 0) {
            int n42 = 0;
            while (n42 < layoutEdgeArray.length) {
                switch (layoutEdgeArray[n42].source.tier) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        layoutEdgeArray[n42].sourcePoint.translate(n6, n);
                        break;
                    }
                    case 2: {
                        layoutEdgeArray[n42].sourcePoint.translate(0, n5);
                    }
                }
                switch (layoutEdgeArray[n42].destination.tier) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        layoutEdgeArray[n42].destinationPoint.translate(n6, n);
                        break;
                    }
                    case 2: {
                        layoutEdgeArray[n42].destinationPoint.translate(0, n5);
                    }
                }
                ++n42;
            }
        }
        return new Dimension(n30 + n6, n33 + n5);
    }

    private int calculateSizes(LayoutNode[] layoutNodeArray, boolean bl) {
        int n = 0;
        int n2 = 0;
        while (n2 < layoutNodeArray.length) {
            String string;
            int n3;
            LayoutNode layoutNode = layoutNodeArray[n2];
            Image image = this.getIconImage(layoutNode.getIcon());
            int n4 = image == null ? -1 : image.getWidth(null);
            int n5 = n3 = image == null ? -1 : image.getHeight(null);
            if (n4 == -1) {
                n4 = 8;
            }
            if (n3 == -1) {
                n3 = 8;
            }
            layoutNode.textBounds = this.font.getStringBounds((string = layoutNode.getLabel()) != null ? string : " ", this.fontContext).getBounds();
            layoutNode.imageBounds = new Rectangle(0, 0, n4, n3);
            n = Math.max(n, bl ? layoutNode.textBounds.width + n4 : layoutNode.textBounds.height + n3);
            ++n2;
        }
        return n + (bl ? 5 : 1);
    }

    private void drawTopology(Graphics2D graphics2D) {
        int n;
        LayoutElement[] layoutElementArray;
        graphics2D.setFont(this.getLabelFont());
        graphics2D.setColor(BG_COLOR);
        graphics2D.fillRect(0, 0, this.size.width, this.size.height);
        graphics2D.setColor(FG_COLOR);
        int n2 = 0;
        while (n2 < this.layoutModel.getTierCount()) {
            layoutElementArray = (LayoutNode[])this.layoutModel.getTierNodes(n2);
            n = 0;
            while (n < layoutElementArray.length) {
                this.drawNode(graphics2D, (LayoutNode)layoutElementArray[n]);
                ++n;
            }
            ++n2;
        }
        layoutElementArray = (LayoutEdge[])this.layoutModel.getEdges();
        n = 0;
        while (n < layoutElementArray.length) {
            if (!((LayoutEdge)layoutElementArray[n]).isInFilter()) {
                this.drawEdgeLines(graphics2D, (LayoutEdge)layoutElementArray[n]);
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < layoutElementArray.length) {
            if (!((LayoutEdge)layoutElementArray[n3]).isInFilter()) {
                this.drawEdgeAdornments(graphics2D, (LayoutEdge)layoutElementArray[n3]);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < layoutElementArray.length) {
            if (((LayoutEdge)layoutElementArray[n4]).isInFilter()) {
                this.drawEdgeLines(graphics2D, (LayoutEdge)layoutElementArray[n4]);
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < layoutElementArray.length) {
            if (((LayoutEdge)layoutElementArray[n5]).isInFilter()) {
                this.drawEdgeAdornments(graphics2D, (LayoutEdge)layoutElementArray[n5]);
            }
            ++n5;
        }
    }

    private void drawNode(Graphics2D graphics2D, LayoutNode layoutNode) {
        int n = graphics2D.getFontMetrics().getAscent();
        graphics2D.setColor(layoutNode.isInFilter() ? FG_COLOR : this.FILTER_COLOR);
        graphics2D.setStroke(this.NORMAL_STROKE);
        graphics2D.drawString(layoutNode.getLabel(), layoutNode.textBounds.x, layoutNode.textBounds.y + n);
        Image image = this.getIconImage(layoutNode.getIcon());
        if (!layoutNode.isInFilter()) {
            image = this.getFilteredImage(image);
        }
        if (image == null) {
            return;
        }
        graphics2D.drawImage(image, layoutNode.imageBounds.x, layoutNode.imageBounds.y, null);
        Image image2 = this.getBadgeImage(layoutNode.getBadge());
        if (image2 == null) {
            return;
        }
        if (!layoutNode.isInFilter()) {
            image2 = this.getFilteredImage(image2);
        }
        graphics2D.drawImage(image2, (int)layoutNode.imageBounds.getMaxX() + 3 - image2.getWidth(null), (int)layoutNode.imageBounds.getMaxY() + 3 - image2.getHeight(null), null);
    }

    private final Image getIconImage(int n) {
        return this.iconSet == null ? null : this.iconSet.getImage(n);
    }

    private final Image getBadgeImage(int n) {
        return this.badgeSet == null ? null : this.badgeSet.getImage(n);
    }

    private final Color getBadgeColor(int n) {
        return this.badgeSet == null ? null : this.badgeSet.getColor(n);
    }

    private Image getFilteredImage(Image image) {
        if (image == null) {
            return null;
        }
        Image image2 = (Image)this.filteredImages.get(image);
        if (image2 == null) {
            image2 = DefaultTopologyRenderer.createFilteredImage(image);
            this.filteredImages.put(image, image2);
        }
        return image2;
    }

    private void drawEdgeLines(Graphics2D graphics2D, LayoutEdge layoutEdge) {
        Color color;
        Point[] pointArray = layoutEdge.getPoints();
        int n = pointArray.length;
        if (n < 2) {
            return;
        }
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = pointArray[n2].x;
            nArray2[n2] = pointArray[n2].y;
            ++n2;
        }
        nArray[n] = nArray[n - 2];
        nArray2[n] = nArray2[n - 2];
        graphics2D.setColor(BG_COLOR);
        graphics2D.setStroke(this.EDGE_BORDER_STROKE);
        graphics2D.drawPolyline(nArray, nArray2, n);
        Color color2 = color = !layoutEdge.isInFilter() ? this.FILTER_COLOR : this.getBadgeColor(layoutEdge.getBadge());
        if (color == null) {
            color = FG_COLOR;
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(this.NORMAL_STROKE);
        graphics2D.drawPolyline(nArray, nArray2, n);
    }

    private void drawEdgeAdornments(Graphics2D graphics2D, LayoutEdge layoutEdge) {
        Color color;
        Point[] pointArray = layoutEdge.getPoints();
        boolean bl = layoutEdge.isInFilter();
        boolean bl2 = layoutEdge.source == layoutEdge.destination;
        Image image = this.getBadgeImage(layoutEdge.getBadge());
        if (!layoutEdge.isInFilter()) {
            image = this.getFilteredImage(image);
        }
        Color color2 = color = !bl ? this.FILTER_COLOR : this.getBadgeColor(layoutEdge.getBadge());
        if (color == null) {
            color = FG_COLOR;
        }
        graphics2D.setColor(color);
        boolean bl3 = layoutEdge.getLinkLocation() != null;
        int n = 1;
        while (n < pointArray.length - 1) {
            int n2 = pointArray[n].x;
            int n3 = pointArray[n].y;
            if (image != null && n == layoutEdge.badgePoint) {
                graphics2D.drawImage(image, n2 - image.getWidth(null) / 2, n3 - image.getHeight(null) / 2, null);
            } else if (bl && (!bl2 || n == layoutEdge.badgePoint)) {
                if (bl3) {
                    int n4 = 0;
                    int n5 = 0;
                    if (n3 == pointArray[n - 1].y) {
                        n4 = n3 < pointArray[n + 1].y ? 1 : -1;
                        n5 = n2 < pointArray[n - 1].x ? 1 : -1;
                    } else {
                        n4 = n3 < pointArray[n - 1].y ? 1 : -1;
                        n5 = n2 < pointArray[n + 1].x ? 1 : -1;
                    }
                    int[] nArray = new int[7];
                    int[] nArray2 = new int[7];
                    int n6 = 0;
                    nArray[n6] = n2 -= n5;
                    nArray2[n6++] = n3 -= n4;
                    nArray[n6] = n2 += n5 * 8;
                    nArray2[n6++] = n3;
                    nArray[n6] = n2;
                    nArray2[n6++] = n3 += n4 * 2;
                    nArray[n6] = n2 -= n5 * 3;
                    nArray2[n6++] = n3;
                    nArray[n6] = n2 -= n5 * 3;
                    nArray2[n6++] = n3 += n4 * 3;
                    nArray[n6] = n2;
                    nArray2[n6++] = n3 += n4 * 3;
                    nArray[n6] = n2 -= n5 * 2;
                    nArray2[n6++] = n3;
                    graphics2D.fillPolygon(nArray, nArray2, 7);
                    graphics2D.drawPolygon(nArray, nArray2, 7);
                } else {
                    graphics2D.fillRect(pointArray[n].x - 1, pointArray[n].y - 1, 3, 3);
                }
            }
            ++n;
        }
        if (layoutEdge.isDirected() && pointArray.length > 1) {
            this.drawArrowhead(graphics2D, pointArray[pointArray.length - 2], pointArray[pointArray.length - 1]);
            if (layoutEdge.isBidirectional()) {
                this.drawArrowhead(graphics2D, pointArray[1], pointArray[0]);
            }
        }
    }

    private void drawArrowhead(Graphics2D graphics2D, Point point, Point point2) {
        graphics2D.fillRect(point2.x, point2.y, 1, 1);
        if (point.y == point2.y) {
            int n = point.x > point2.x ? 1 : -1;
            int n2 = n > 0 ? 0 : -1;
            graphics2D.fillRect(point2.x + n2, point2.y, 2, 1);
            graphics2D.fillRect(point2.x + n2 + 2 * n, point2.y - 1, 2, 3);
            graphics2D.fillRect(point2.x + n2 + 4 * n, point2.y - 2, 2, 5);
        } else {
            int n = point.y > point2.y ? 1 : -1;
            int n3 = n > 0 ? 0 : -1;
            graphics2D.fillRect(point2.x, point2.y + n3, 1, 2);
            graphics2D.fillRect(point2.x - 1, point2.y + n3 + 2 * n, 3, 2);
            graphics2D.fillRect(point2.x - 2, point2.y + n3 + 4 * n, 5, 2);
        }
    }

    private static class WithinTierEdgeComparator
    implements Comparator {
        private WithinTierEdgeComparator() {
        }

        public int compare(Object object, Object object2) {
            LayoutEdge layoutEdge = null;
            LayoutEdge layoutEdge2 = null;
            try {
                layoutEdge = (LayoutEdge)object;
                layoutEdge2 = (LayoutEdge)object2;
            }
            catch (ClassCastException classCastException) {
                return 0;
            }
            int n = WithinTierEdgeComparator.getEdgeLength(layoutEdge);
            int n2 = WithinTierEdgeComparator.getEdgeLength(layoutEdge2);
            return n != n2 ? n - n2 : (layoutEdge.source.index != layoutEdge2.source.index ? layoutEdge.source.index - layoutEdge2.source.index : (layoutEdge.destination.index != layoutEdge2.destination.index ? layoutEdge.destination.index - layoutEdge2.destination.index : layoutEdge.hashCode() - layoutEdge2.hashCode()));
        }

        public static int getEdgeLength(LayoutEdge layoutEdge) {
            if (layoutEdge.source.tier != layoutEdge.destination.tier) {
                return Integer.MAX_VALUE;
            }
            return Math.abs(layoutEdge.sourcePoint.x - layoutEdge.destinationPoint.x + layoutEdge.sourcePoint.y - layoutEdge.destinationPoint.y);
        }
    }

    private static class TierThreeEdgeComparator
    implements Comparator {
        public static final int LEFT = 0;
        public static final int ABOVE = 1;
        public static final int RIGHT = 2;
        public static final int BELOW = 3;
        private LayoutNode node;

        public TierThreeEdgeComparator(LayoutNode layoutNode) {
            this.node = layoutNode;
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            if (!(object instanceof LayoutEdge) || !(object2 instanceof LayoutEdge)) {
                return 0;
            }
            LayoutNode layoutNode = ((LayoutEdge)object).getOtherNode(this.node);
            LayoutNode layoutNode2 = ((LayoutEdge)object2).getOtherNode(this.node);
            if (layoutNode == null || layoutNode2 == null) {
                return layoutNode == null ? (layoutNode2 == null ? 0 : -1) : 1;
            }
            int n3 = this.getPosition(layoutNode);
            if (n3 != (n2 = this.getPosition(layoutNode2))) {
                return n3 - n2;
            }
            int n4 = n = n3 == 0 || n3 == 2 ? layoutNode2.index - layoutNode.index : layoutNode.index - layoutNode2.index;
            if (n == 0) {
                n = n3 == 0 || n3 == 1 && this.node.tier == 1 ? object2.hashCode() - object.hashCode() : object.hashCode() - object2.hashCode();
            }
            return n;
        }

        public int getPosition(LayoutNode layoutNode) {
            if (layoutNode.tier == this.node.tier) {
                return layoutNode.index < this.node.index ? 0 : 2;
            }
            return layoutNode.tier < this.node.tier ? 1 : 3;
        }
    }

    private static class TierOneEdgeComparator
    implements Comparator {
        public static final int ABOVE = 0;
        public static final int LEFT = 1;
        public static final int BELOW = 2;
        public static final int RIGHT = 3;
        private LayoutNode node;

        public TierOneEdgeComparator(LayoutNode layoutNode) {
            this.node = layoutNode;
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            if (!(object instanceof LayoutEdge) || !(object2 instanceof LayoutEdge)) {
                return 0;
            }
            LayoutNode layoutNode = ((LayoutEdge)object).getOtherNode(this.node);
            LayoutNode layoutNode2 = ((LayoutEdge)object2).getOtherNode(this.node);
            if (layoutNode == null || layoutNode2 == null) {
                return layoutNode == null ? (layoutNode2 == null ? 0 : -1) : 1;
            }
            int n3 = this.getPosition(layoutNode);
            if (n3 != (n2 = this.getPosition(layoutNode2))) {
                return this.node.tier == 1 ? n3 - n2 : n2 - n3;
            }
            int n4 = n = n3 == 1 || n3 == 3 ? layoutNode.index - layoutNode2.index : layoutNode2.index - layoutNode.index;
            if (this.node.tier == 1) {
                n = -n;
            }
            if (n == 0) {
                n = n3 == 1 || n3 == 0 ? object2.hashCode() - object.hashCode() : object.hashCode() - object2.hashCode();
            }
            return n;
        }

        public int getPosition(LayoutNode layoutNode) {
            if (layoutNode.tier == this.node.tier) {
                return layoutNode.index < this.node.index ? 1 : 3;
            }
            return layoutNode.tier < this.node.tier ? 0 : 2;
        }
    }

    private static final class SingleTierEdgeComparator
    implements Comparator {
        private LayoutNode node;

        public SingleTierEdgeComparator(LayoutNode layoutNode) {
            this.node = layoutNode;
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof LayoutEdge) || !(object2 instanceof LayoutEdge)) {
                return 0;
            }
            LayoutNode layoutNode = ((LayoutEdge)object).getOtherNode(this.node);
            LayoutNode layoutNode2 = ((LayoutEdge)object2).getOtherNode(this.node);
            int n = layoutNode.index - layoutNode2.index;
            if (n == 0) {
                n = object.hashCode() - object2.hashCode();
            }
            if (layoutNode.index < this.node.index && layoutNode2.index < this.node.index && layoutNode.index != layoutNode2.index) {
                n = -n;
            }
            return n;
        }
    }

    private static final class LayoutModel
    implements CCTopologyModelInterface {
        public boolean hasNodeBadges;
        public boolean hasEdgeBadges;
        public boolean hasArrowheads;
        public boolean hasSelectableEdges;
        private final int tierCount;
        private final LayoutNode[][] layoutNodes;
        private final LayoutEdge[] layoutEdges;
        private final Map elementMap = new HashMap();

        LayoutModel(CCTopologyModelInterface cCTopologyModelInterface, CCI18N cCI18N) {
            int n;
            CCTopologyModelInterface.Node[][] nodeArrayArray = new CCTopologyModelInterface.Node[3][];
            int n2 = cCTopologyModelInterface.getTierCount();
            int n3 = 0;
            while (n3 < n2) {
                nodeArrayArray[n3] = cCTopologyModelInterface.getTierNodes(n3);
                ++n3;
            }
            if (n2 == 2) {
                n2 = 3;
                nodeArrayArray[2] = nodeArrayArray[1];
                nodeArrayArray[1] = nodeArrayArray[0];
                nodeArrayArray[0] = new LayoutNode[0];
            }
            this.tierCount = n2;
            this.layoutNodes = new LayoutNode[n2][];
            int n4 = 0;
            while (n4 < n2) {
                this.layoutNodes[n4] = new LayoutNode[nodeArrayArray[n4].length];
                int n5 = 0;
                while (n5 < nodeArrayArray[n4].length) {
                    n = n2 == 1 || n4 != 0 ? n5 : nodeArrayArray[n4].length - 1 - n5;
                    this.layoutNodes[n4][n5] = new LayoutNode(nodeArrayArray[n4][n5], cCI18N, n4, n);
                    this.elementMap.put(nodeArrayArray[n4][n5], this.layoutNodes[n4][n5]);
                    if (!this.hasNodeBadges && nodeArrayArray[n4][n5].getBadge() != 0) {
                        this.hasNodeBadges = true;
                    }
                    ++n5;
                }
                ++n4;
            }
            CCTopologyModelInterface.Edge[] edgeArray = cCTopologyModelInterface.getEdges();
            this.layoutEdges = new LayoutEdge[edgeArray.length];
            n = 0;
            while (n < edgeArray.length) {
                LayoutNode layoutNode = (LayoutNode)this.elementMap.get(edgeArray[n].getSource());
                LayoutNode layoutNode2 = (LayoutNode)this.elementMap.get(edgeArray[n].getDestination());
                this.layoutEdges[n] = new LayoutEdge(edgeArray[n], cCI18N, layoutNode, layoutNode2);
                this.elementMap.put(edgeArray[n], this.layoutEdges[n]);
                layoutNode.edges.add(this.layoutEdges[n]);
                layoutNode2.edges.add(this.layoutEdges[n]);
                if (!this.hasEdgeBadges && edgeArray[n].getBadge() != 0) {
                    this.hasEdgeBadges = true;
                }
                if (!this.hasArrowheads && edgeArray[n].isDirected()) {
                    this.hasArrowheads = true;
                }
                if (!this.hasSelectableEdges && edgeArray[n].getLinkLocation() != null) {
                    this.hasSelectableEdges = true;
                }
                ++n;
            }
        }

        public int getTierCount() {
            return this.tierCount;
        }

        public CCTopologyModelInterface.Node[] getTierNodes(int n) {
            return n >= 0 && n < this.tierCount ? this.layoutNodes[n] : new CCTopologyModelInterface.Node[]{};
        }

        public CCTopologyModelInterface.Edge[] getEdges() {
            return this.layoutEdges;
        }

        public CCTopologyModelInterface.IconSet getIconSet() {
            return null;
        }

        public CCTopologyModelInterface.BadgeSet getBadgeSet() {
            return null;
        }

        public LayoutElement getLayoutElement(Object object) {
            return object == null ? null : (LayoutElement)this.elementMap.get(object);
        }
    }

    private static final class LayoutEdge
    implements LayoutElement,
    CCTopologyModelInterface.Edge {
        protected final CCTopologyModelInterface.Edge edge;
        public Point sourcePoint;
        public Point destinationPoint;
        public int badgePoint = -1;
        public int offset;
        public LayoutNode source;
        public LayoutNode destination;
        private Point[] points;
        private final CCI18N i18n;

        LayoutEdge(CCTopologyModelInterface.Edge edge, CCI18N cCI18N, LayoutNode layoutNode, LayoutNode layoutNode2) {
            this.i18n = cCI18N;
            this.edge = edge;
            this.source = layoutNode;
            this.destination = layoutNode2;
        }

        public CCTopologyModelInterface.Node getSource() {
            return this.source;
        }

        public CCTopologyModelInterface.Node getDestination() {
            return this.destination;
        }

        public boolean isDirected() {
            return this.edge.isDirected();
        }

        public boolean isBidirectional() {
            return this.edge.isBidirectional();
        }

        public Rectangle[] getBounds() {
            Point[] pointArray = this.getPoints();
            Rectangle[] rectangleArray = new Rectangle[pointArray.length - 1];
            int n = 0;
            while (n < rectangleArray.length) {
                int n2 = Math.min(pointArray[n].x, pointArray[n + 1].x);
                int n3 = Math.min(pointArray[n].y, pointArray[n + 1].y);
                int n4 = Math.max(pointArray[n].x, pointArray[n + 1].x);
                int n5 = Math.max(pointArray[n].y, pointArray[n + 1].y);
                rectangleArray[n] = new Rectangle(n2 - 2, n3 - 2, n4 - n2 + 4, n5 - n3 + 4);
                ++n;
            }
            return rectangleArray;
        }

        public String getTooltip() {
            String string = this.edge.getTooltip();
            return this.i18n == null || string == null ? string : this.i18n.getMessage(string);
        }

        public String getLinkLocation() {
            return this.edge.getLinkLocation();
        }

        public boolean isInFilter() {
            return this.edge.isInFilter();
        }

        public int getBadge() {
            return this.edge.getBadge();
        }

        public String getBadgeTooltip() {
            String string = this.edge.getBadgeTooltip();
            return this.i18n == null || string == null ? string : this.i18n.getMessage(string);
        }

        public String getBadgeLinkLocation() {
            return this.edge.getBadgeLinkLocation();
        }

        public LayoutNode getOtherNode(LayoutNode layoutNode) {
            return layoutNode == this.source ? this.destination : this.source;
        }

        public Point[] getPoints() {
            if (this.sourcePoint == null || this.destinationPoint == null) {
                return new Point[0];
            }
            if (this.points != null) {
                return this.points;
            }
            if (this.offset == 0) {
                this.points = new Point[]{this.sourcePoint, this.sourcePoint.x < this.destinationPoint.x ? new Point(this.destinationPoint.x, this.sourcePoint.y) : new Point(this.sourcePoint.x, this.destinationPoint.y), this.destinationPoint};
                this.badgePoint = 1;
            } else {
                boolean bl;
                boolean bl2 = bl = Math.abs(this.sourcePoint.x - this.destinationPoint.x) < Math.abs(this.sourcePoint.y - this.destinationPoint.y);
                if (bl) {
                    Point[] pointArray;
                    Point point = this.sourcePoint.y < this.destinationPoint.y ? this.sourcePoint : this.destinationPoint;
                    Point point2 = point == this.sourcePoint ? this.destinationPoint : this.sourcePoint;
                    Point point3 = new Point(point.x + this.offset, point.y);
                    Point point4 = new Point(point.x + this.offset, point2.y);
                    if (point == this.sourcePoint) {
                        Point[] pointArray2 = new Point[4];
                        pointArray2[0] = point;
                        pointArray2[1] = point3;
                        pointArray2[2] = point4;
                        pointArray = pointArray2;
                        pointArray2[3] = point2;
                    } else {
                        Point[] pointArray3 = new Point[4];
                        pointArray3[0] = point2;
                        pointArray3[1] = point4;
                        pointArray3[2] = point3;
                        pointArray = pointArray3;
                        pointArray3[3] = point;
                    }
                    this.points = pointArray;
                    this.badgePoint = this.points[1].y < this.points[2].y ? 1 : 2;
                } else {
                    Point[] pointArray;
                    Point point = this.sourcePoint.x < this.destinationPoint.x ? this.sourcePoint : this.destinationPoint;
                    Point point5 = point == this.sourcePoint ? this.destinationPoint : this.sourcePoint;
                    Point point6 = new Point(point.x, point.y - this.offset);
                    Point point7 = new Point(point5.x, point.y - this.offset);
                    if (point == this.sourcePoint) {
                        Point[] pointArray4 = new Point[4];
                        pointArray4[0] = point;
                        pointArray4[1] = point6;
                        pointArray4[2] = point7;
                        pointArray = pointArray4;
                        pointArray4[3] = point5;
                    } else {
                        Point[] pointArray5 = new Point[4];
                        pointArray5[0] = point5;
                        pointArray5[1] = point7;
                        pointArray5[2] = point6;
                        pointArray = pointArray5;
                        pointArray5[3] = point;
                    }
                    this.points = pointArray;
                    this.badgePoint = this.points[1].x < this.points[2].x ? 1 : 2;
                }
            }
            return this.points;
        }
    }

    private static final class LayoutNode
    implements LayoutElement,
    CCTopologyModelInterface.Node {
        protected final CCTopologyModelInterface.Node node;
        public int tier;
        public int index;
        public Rectangle imageBounds;
        public Rectangle textBounds;
        public int textOffset;
        public Collection edges = new ArrayList();
        public int aboveEdgeCount;
        public int belowEdgeCount;
        private final CCI18N i18n;

        LayoutNode(CCTopologyModelInterface.Node node, CCI18N cCI18N, int n, int n2) {
            this.i18n = cCI18N;
            this.node = node;
            this.tier = n;
            this.index = n2;
        }

        public Rectangle[] getBounds() {
            if (this.imageBounds == null || this.textBounds == null) {
                return new Rectangle[0];
            }
            return new Rectangle[]{this.imageBounds, this.textBounds};
        }

        public String getLabel() {
            return this.i18n == null ? this.node.getLabel() : this.i18n.getMessage(this.node.getLabel());
        }

        public String getTooltip() {
            String string = this.node.getTooltip();
            return this.i18n == null || string == null ? string : this.i18n.getMessage(string);
        }

        public String getLinkLocation() {
            return this.node.getLinkLocation();
        }

        public boolean isInFilter() {
            return this.node.isInFilter();
        }

        public int getBadge() {
            return this.node.getBadge();
        }

        public String getBadgeTooltip() {
            String string = this.node.getBadgeTooltip();
            return this.i18n == null || string == null ? string : this.i18n.getMessage(string);
        }

        public String getBadgeLinkLocation() {
            return this.node.getBadgeLinkLocation();
        }

        public int getIcon() {
            return this.node.getIcon();
        }
    }

    private static interface LayoutElement {
        public Rectangle[] getBounds();

        public String getTooltip();

        public String getLinkLocation();

        public boolean isInFilter();

        public int getBadge();

        public String getBadgeTooltip();

        public String getBadgeLinkLocation();
    }
}

