/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.iplanet.jato.util.HtmlUtil;
import com.sun.management.services.registration.MgmtAppRegistrationService;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCTopologyModelInterface;
import com.sun.web.ui.servlet.common.TagsServletBase;
import com.sun.web.ui.servlet.topology.DefaultTopologyRenderer;
import com.sun.web.ui.servlet.topology.SessionImageCache;
import com.sun.web.ui.servlet.topology.TopologyImageData;
import com.sun.web.ui.servlet.topology.TopologyRenderer;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class CCTopologyServlet
extends TagsServletBase {
    private static final String IMAGE_ID_PARAM = "image";
    public static final int MIN_IMAGE_AREA_MAX = 10000;
    private static String servletURI = "/tags/topologyImage";
    private static int defaultImageAreaMax = 250000;
    private static String defaultImageFormat = "png";

    public static void setServletURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException("uri == null");
        }
        servletURI = string;
    }

    public static String getServletURI() {
        return servletURI;
    }

    public static void setDefaultImageAreaMaximum(int n) {
        if (n <= 10000) {
            throw new IllegalArgumentException("area <= 10000");
        }
        defaultImageAreaMax = n;
    }

    public static int getDefaultImageAreaMaximum() {
        return defaultImageAreaMax;
    }

    public static void setDefaultImageFormat(String string) {
        if (!CCTopologyServlet.isValidImageFormat(string)) {
            throw new IllegalArgumentException("Unsupported format: " + string);
        }
        defaultImageFormat = string;
    }

    public static String getDefaultImageFormat() {
        return defaultImageFormat;
    }

    public static boolean isValidImageFormat(String string) {
        return string != null && Arrays.asList(ImageIO.getWriterFormatNames()).contains(string);
    }

    public static String getTopologyImageTags(HttpSession httpSession, CCI18N cCI18N, CCTopologyModelInterface cCTopologyModelInterface) {
        return CCTopologyServlet.getTopologyImageTags(httpSession, cCI18N, cCTopologyModelInterface, 0, null);
    }

    public static String getTopologyImageTags(HttpSession httpSession, CCI18N cCI18N, CCTopologyModelInterface cCTopologyModelInterface, int n, String string) {
        if (cCTopologyModelInterface == null) {
            throw new IllegalArgumentException("model == null");
        }
        return CCTopologyServlet.getTopologyImageTags(httpSession, new DefaultTopologyRenderer(cCTopologyModelInterface, cCI18N), n, string);
    }

    public static String getTopologyImageTags(HttpSession httpSession, TopologyRenderer topologyRenderer, int n, String string) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session == null");
        }
        if (topologyRenderer == null) {
            throw new IllegalArgumentException("renderer == null");
        }
        n = n == 0 ? CCTopologyServlet.getDefaultImageAreaMaximum() : Math.max(n, 10000);
        if (!CCTopologyServlet.isValidImageFormat(string)) {
            string = CCTopologyServlet.getDefaultImageFormat();
        }
        int n2 = 1;
        int n3 = 1;
        Rectangle rectangle = new Rectangle(topologyRenderer.getImageSize());
        int n4 = rectangle.width * rectangle.height / n + 1;
        if (n4 > 1) {
            double d = Math.sqrt((double)n4 * rectangle.getWidth() / rectangle.getHeight());
            n2 = (int)Math.ceil(d);
            n3 = (int)Math.ceil((double)n4 / d);
        }
        int n5 = rectangle.width / n2 + 1;
        int n6 = rectangle.height / n3 + 1;
        String[][] stringArray = new String[n3][n2];
        Rectangle[][] rectangleArray = new Rectangle[n3][n2];
        SessionImageCache sessionImageCache = CCTopologyServlet.getSessionImageCache(httpSession);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n<table cellpadding=0 cellspacing=0 border=0>\n");
        int n7 = 0;
        while (n7 < n3) {
            stringBuffer.append("  <tr>\n");
            int n8 = 0;
            while (n8 < n2) {
                rectangleArray[n7][n8] = rectangle.intersection(new Rectangle(n8 * n5, n7 * n6, n5, n6));
                stringArray[n7][n8] = sessionImageCache.cacheImage(topologyRenderer, rectangleArray[n7][n8], string);
                stringBuffer.append("    <td><img src=\"").append(servletURI).append('?').append(IMAGE_ID_PARAM).append('=').append(stringArray[n7][n8]).append("\" width=").append(rectangleArray[n7][n8].width).append(" height=").append(rectangleArray[n7][n8].height).append(" useMap=\"#").append(stringArray[n7][n8]).append("\" border=0>").append("</td>\n");
                ++n8;
            }
            stringBuffer.append("</tr>\n");
            ++n7;
        }
        stringBuffer.append("</table>\n");
        CCTopologyModelInterface cCTopologyModelInterface = topologyRenderer.getModel();
        int n9 = 0;
        while (n9 < n3) {
            int n10 = 0;
            while (n10 < n2) {
                int n11;
                Object[] objectArray;
                Rectangle rectangle2 = rectangleArray[n9][n10];
                stringBuffer.append("<map name=\"");
                stringBuffer.append(stringArray[n9][n10]);
                stringBuffer.append("\">");
                int n12 = 0;
                while (n12 < cCTopologyModelInterface.getTierCount()) {
                    objectArray = cCTopologyModelInterface.getTierNodes(n12);
                    n11 = 0;
                    while (n11 < objectArray.length) {
                        CCTopologyServlet.appendAreaTags(stringBuffer, topologyRenderer, (CCTopologyModelInterface.Node)objectArray[n11], rectangle2);
                        ++n11;
                    }
                    ++n12;
                }
                objectArray = cCTopologyModelInterface.getEdges();
                n11 = 0;
                while (n11 < objectArray.length) {
                    CCTopologyServlet.appendAreaTags(stringBuffer, topologyRenderer, (CCTopologyModelInterface.Edge)objectArray[n11], rectangle2);
                    ++n11;
                }
                stringBuffer.append("\n</map>\n");
                ++n10;
            }
            ++n9;
        }
        return stringBuffer.toString();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        SessionImageCache sessionImageCache = CCTopologyServlet.getSessionImageCache(httpServletRequest.getSession());
        TopologyImageData topologyImageData = sessionImageCache.takeImageData(httpServletRequest.getParameter(IMAGE_ID_PARAM));
        if (CCDebug.isOn()) {
            CCDebug.trace3((String)("imageData for " + httpServletRequest.getParameter(IMAGE_ID_PARAM) + " = " + topologyImageData));
        }
        if (topologyImageData != null) {
            if (CCDebug.isOn()) {
                CCDebug.trace3((String)("type = " + topologyImageData.getImageType() + "\nbytes = " + topologyImageData.getImageBytes()));
                if (topologyImageData.getImageBytes() != null) {
                    CCDebug.trace3((String)("bytes.length = " + topologyImageData.getImageBytes().length));
                }
            }
            httpServletResponse.setContentType(topologyImageData.getImageType());
            servletOutputStream.write(topologyImageData.getImageBytes());
        }
        servletOutputStream.flush();
    }

    private static void appendAreaTags(StringBuffer stringBuffer, TopologyRenderer topologyRenderer, CCTopologyModelInterface.Node node, Rectangle rectangle) {
        if (!node.isInFilter()) {
            return;
        }
        String string = node.getLinkLocation();
        String string2 = node.getTooltip();
        if (string2 != null) {
            string2 = HtmlUtil.escape((String)string2);
        }
        boolean bl = string2 != null || string != null;
        int n = node.getBadge();
        if (n != 0) {
            String string3 = node.getBadgeTooltip();
            if (string3 != null) {
                string3 = HtmlUtil.escape((String)string3);
            }
            String string4 = node.getBadgeLinkLocation();
            if (bl || string3 != null || string4 != null) {
                CCTopologyServlet.appendAreaTags(stringBuffer, topologyRenderer.getBadgeBounds(node, rectangle), string3, string4);
            }
        }
        if (bl) {
            CCTopologyServlet.appendAreaTags(stringBuffer, topologyRenderer.getBounds(node, rectangle), string2, string);
        }
    }

    private static void appendAreaTags(StringBuffer stringBuffer, TopologyRenderer topologyRenderer, CCTopologyModelInterface.Edge edge, Rectangle rectangle) {
        if (!edge.isInFilter()) {
            return;
        }
        String string = edge.getLinkLocation();
        String string2 = edge.getTooltip();
        if (string2 != null) {
            string2 = HtmlUtil.escape((String)string2);
        }
        boolean bl = string2 != null || string != null;
        int n = edge.getBadge();
        if (n != 0) {
            String string3 = edge.getBadgeTooltip();
            if (string3 != null) {
                string3 = HtmlUtil.escape((String)string3);
            }
            String string4 = edge.getBadgeLinkLocation();
            if (bl || string3 != null || string4 != null) {
                CCTopologyServlet.appendAreaTags(stringBuffer, topologyRenderer.getBadgeBounds(edge, rectangle), string3, string4);
            }
        }
        if (bl) {
            CCTopologyServlet.appendAreaTags(stringBuffer, topologyRenderer.getBounds(edge, rectangle), string2, string);
        }
    }

    private static void appendAreaTags(StringBuffer stringBuffer, Rectangle[] rectangleArray, String string, String string2) {
        if (rectangleArray != null) {
            int n = 0;
            while (n < rectangleArray.length) {
                stringBuffer.append("\n  <area shape=\"rect\" coords=\"");
                stringBuffer.append((int)rectangleArray[n].getMinX());
                stringBuffer.append(',');
                stringBuffer.append((int)rectangleArray[n].getMinY());
                stringBuffer.append(',');
                stringBuffer.append((int)rectangleArray[n].getMaxX());
                stringBuffer.append(',');
                stringBuffer.append((int)rectangleArray[n].getMaxY());
                stringBuffer.append('\"');
                if (string2 != null) {
                    stringBuffer.append(" href=\"");
                    stringBuffer.append(string2);
                    stringBuffer.append('\"');
                }
                if (string == null) {
                    string = "";
                }
                stringBuffer.append(" alt=\"");
                stringBuffer.append(string);
                stringBuffer.append("\" title=\"");
                stringBuffer.append(string);
                stringBuffer.append('\"');
                stringBuffer.append('>');
                ++n;
            }
        }
    }

    private static SessionImageCache getSessionImageCache(HttpSession httpSession) {
        try {
            MgmtAppRegistrationService mgmtAppRegistrationService = MgmtAppRegistrationServiceFactory.getRegistrationService();
            HttpSession httpSession2 = mgmtAppRegistrationService.getConsoleSession(httpSession);
            if (httpSession2 != null) {
                return SessionImageCache.getInstance(httpSession2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SessionImageCache.getInstance(httpSession);
    }
}

