/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.util;

import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UtilsWeb {
    private static final Map l10nCache = new HashMap();

    public static void setContentType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws UnsupportedEncodingException {
        Locale locale = Locale.getDefault();
        if (locale.equals(Locale.JAPANESE)) {
            httpServletResponse.setContentType("text/html; charset=eucJP");
        } else if (locale.equals(Locale.CHINESE)) {
            httpServletResponse.setContentType("text/html; charset=gb2312");
        } else {
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setLocale(locale);
        }
        httpServletRequest.setCharacterEncoding(httpServletResponse.getCharacterEncoding());
    }

    public static void includeNamed(ServletContext servletContext, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (servletContext == null) {
            System.err.println("Servlet Context is null");
            return;
        }
        RequestDispatcher requestDispatcher = servletContext.getNamedDispatcher(string);
        if (requestDispatcher == null) {
            httpServletResponse.getWriter().println("Could not get dispatcher for NAMED resource " + string);
            return;
        }
        requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public static void include(ServletContext servletContext, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (servletContext == null) {
            System.err.println("Servlet Context is null");
            return;
        }
        Locale locale = Locale.getDefault();
        String string2 = locale.toString() + string;
        String string3 = (String)l10nCache.get(string2);
        if (string3 != null) {
            try {
                RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(string3);
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                httpServletResponse.getWriter().println("Could not get dispatcher for " + string);
                return;
            }
        }
        int n = string.lastIndexOf(46);
        String string4 = n == -1 ? "" : string.substring(n);
        String string5 = n == -1 ? string : string.substring(0, n);
        string5 = string5 + '_' + locale.toString();
        while (string5 != null) {
            try {
                RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(string5 + string4);
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                l10nCache.put(string2, string5 + string4);
                return;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                n = string5.lastIndexOf(95);
                String string6 = string5 = n == -1 ? (String)null : string5.substring(0, n);
            }
        }
        httpServletResponse.getWriter().println("Could not get dispatcher for " + string);
    }

    public static void forwardNamed(ServletContext servletContext, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (servletContext == null) {
            System.err.println("Servlet Context is null");
            return;
        }
        RequestDispatcher requestDispatcher = servletContext.getNamedDispatcher(string);
        System.err.println("Utils: Forwarding to " + servletContext.getRealPath(string));
        if (requestDispatcher == null) {
            httpServletResponse.getWriter().println("Could not get dispatcher for " + string);
            return;
        }
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public static void redirect(String string, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (string == null || string.equals("")) {
            httpServletResponse.getWriter().println("Target could not be null ");
        }
        httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string));
    }

    public static void redirectWithMasthead(String string, String string2, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (string2 == null || string2.equals("")) {
            httpServletResponse.getWriter().println("Target could not be null ");
        }
        httpServletResponse.setContentType("text/html");
        httpServletResponse.getWriter().println(HTMLTags.getSecondaryPageTags(string, string2));
    }

    public static void printParams(HttpServletRequest httpServletRequest) {
        System.err.println("Utils: request ");
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues(string);
            int n = 0;
            while (n < stringArray.length) {
                System.err.println(string + ":" + stringArray[n]);
                ++n;
            }
        }
        System.err.println("");
    }

    public static void noCacheHeader(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        httpServletResponse.setHeader("Pragma", "no-cache");
    }

    public static void header(HttpServletResponse httpServletResponse) {
    }

    public static void printError(PrintWriter printWriter, String string) {
        printWriter.print("Error");
        printWriter.print("<pre>");
        printWriter.print(string);
        printWriter.print("</pre>");
    }

    public static void printThrowable(PrintWriter printWriter, Throwable throwable) {
        printWriter.print("Error");
        printWriter.print("<pre>");
        throwable.printStackTrace(printWriter);
        printWriter.print("</pre>");
    }
}

