/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.util;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.util.AlignmentConstants;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class HTMLTags
implements AlignmentConstants {
    static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.util.GlobalTags";
    private static final String CIM_BUNDLE = "com.sun.netstorage.mgmt.component.model.domain.resources.CIMLocalization";
    private static final String PAGE_NUMBER = "pageNum";
    private static final int PAGE_NUMBER_DEFAULT = -222;
    private static final String SORT_COLUMN = "sortBy";
    private static final String FIRST_ROW = "tableIndex";
    private static final int FIRST_ROW_DEFAULT = 0;
    private static final String PAGE_SIZE = "tableSize";
    private static final int PAGE_SIZE_DEFAULT = 25;
    private static final int MAX_ACTION_BUTTONS = 3;
    private static final String CANCEL = "cancel";
    public static final String ALARM_NONE = "";
    public static final String ALARM_MINOR = "minor";
    public static final String ALARM_MAJOR = "major";
    public static final String ALARM_CRITICAL = "critical";
    public static final String ALARM_DOWN = "down";
    public static final String GO_BUTTON = "tablePagingGo";
    public static final String ACTIONS_MENU = "actionsMenu";
    public static final String MESSAGE_INFO = "infoMessages";
    public static final String MESSAGE_WARNING = "warningMessages";
    public static final String MESSAGE_ERROR = "errorMessages";
    static final String MESSAGE_EXCEPTION = "exceptionMessages";
    private static final String TIMESTAMPS = "timestamps";
    static final String PROFILING = "profiling";
    private static final String CRUMB_URL = "crumb.url.";
    private static final String CRUMB_TEXT = "crumb.text.";
    public static final String CONTENT_FORM = "contentForm";
    public static final String WRAP_OFF = "off";
    public static final String WRAP_VIRTUAL = "virtual";
    public static final String WRAP_PHYSICAL = "physical";

    public static String getCustomTag(String string, String string2) {
        return Localization.getString(string, string2);
    }

    public static String[] getCustomTags(String string, String[] stringArray) {
        return new String[]{"TODO - Remind Jeff to implement getCustomTags()"};
    }

    public static String getSectionHeaderStartTag(String string) {
        return HTMLTags.getTag("sectionHeaderStart", string);
    }

    public static String getSectionHeaderEndTag() {
        return HTMLTags.getTag("sectionHeaderEnd");
    }

    public static String getBreadCrumbTag(String string) {
        return "deprecated crumb for " + string;
    }

    public static String getExtendedBreadCrumbTag(HttpServletRequest httpServletRequest, String string, String string2) {
        return HTMLTags.getDoubleExtendedBreadCrumbTag(httpServletRequest, string, null, string2);
    }

    public static String getDoubleExtendedBreadCrumbTag(HttpServletRequest httpServletRequest, String string, String string2, String string3) {
        HttpSession httpSession = httpServletRequest.getSession();
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = NSMPages.getPageCrumbList(string);
        String string4 = HTMLTags.getTag("crumbSeparator");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(HTMLTags.getTag("crumbLink", new String[]{HTMLTags.getBreadCrumbURL(httpSession, stringArray[n]), HTMLTags.getBreadCrumbText(httpSession, stringArray[n])}));
            stringBuffer.append(string4);
            ++n;
        }
        if (string2 != null) {
            stringBuffer.append(HTMLTags.getTag("crumbLink", new String[]{HTMLTags.getBreadCrumbURL(httpSession, string2), HTMLTags.getBreadCrumbText(httpSession, string2)}));
            stringBuffer.append(string4);
        }
        stringBuffer.append(string3);
        if (stringArray.length == 0) {
            stringBuffer.append(string4);
        }
        return HTMLTags.getTag("crumb", stringBuffer.toString());
    }

    public static String getBreadCrumbTag(HttpServletRequest httpServletRequest, String string) {
        return HTMLTags.getBreadCrumbTag(httpServletRequest, string, null);
    }

    public static String getBreadCrumbTag(HttpServletRequest httpServletRequest, String string, String string2) {
        return HTMLTags.getBreadCrumbTag(httpServletRequest, string, string2, HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString()));
    }

    public static String getBreadCrumbTag(HttpServletRequest httpServletRequest, String string, String string2, String string3) {
        HttpSession httpSession = httpServletRequest.getSession();
        HTMLTags.setBreadCrumbData(httpSession, string, string3, string2);
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = NSMPages.getPageCrumbList(string);
        String string4 = HTMLTags.getTag("crumbSeparator");
        int n = 0;
        while (n < stringArray.length - 1) {
            stringBuffer.append(HTMLTags.getTag("crumbLink", new String[]{HTMLTags.getBreadCrumbURL(httpSession, stringArray[n]), HTMLTags.getBreadCrumbText(httpSession, stringArray[n])}));
            stringBuffer.append(string4);
            ++n;
        }
        stringBuffer.append(HTMLTags.getBreadCrumbText(httpSession, stringArray[n]));
        if (stringArray.length == 1) {
            stringBuffer.append(string4);
        }
        return HTMLTags.getTag("crumb", stringBuffer.toString());
    }

    public static void setBreadCrumbData(HttpSession httpSession, String string, String string2, String string3) {
        if (string2 != null) {
            httpSession.setAttribute(CRUMB_URL + string, (Object)string2);
        } else {
            httpSession.removeAttribute(CRUMB_URL + string);
        }
        if (string3 != null) {
            httpSession.setAttribute(CRUMB_TEXT + string, (Object)string3);
        } else {
            httpSession.removeAttribute(CRUMB_TEXT + string);
        }
    }

    public static String getBreadCrumbURL(HttpSession httpSession, String string) {
        String string2 = null;
        try {
            string2 = (String)httpSession.getAttribute(CRUMB_URL + string);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = NSMPages.getPageURL(string);
        }
        return string2;
    }

    private static String getBreadCrumbText(HttpSession httpSession, String string) {
        String string2 = null;
        try {
            string2 = (String)httpSession.getAttribute(CRUMB_TEXT + string);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = NSMPages.getPageCrumbName(string);
        }
        return string2;
    }

    public static String getLinkTag(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("<a href=\"");
        stringBuffer.append(string);
        stringBuffer.append("\">");
        stringBuffer.append(string2);
        stringBuffer.append("</a>");
        return stringBuffer.toString();
    }

    public static String getLinkMiniButtonTag(String string, String string2) {
        return HTMLTags.getTag("miniButton", new String[]{string, string2});
    }

    public static String getLinkTargetMiniButtonTag(String string, String string2, String string3) {
        return HTMLTags.getLinkMiniButtonTag(string + "\" target=\"" + string3, string2);
    }

    public static String getLinkButtonTag(String string, String string2) {
        return HTMLTags.getTag("textButton", new String[]{string, string2});
    }

    public static String getLinkTargetButtonTag(String string, String string2, String string3) {
        return HTMLTags.getLinkButtonTag(string + "\" target=\"" + string3, string2);
    }

    public static String getDisabledMiniButtonTag(String string) {
        return HTMLTags.getTag("disabledMiniButton", string);
    }

    public static String getDisabledButtonTag(String string) {
        return HTMLTags.getTag("disabledTextButton", string);
    }

    public static String getFormSubmitter(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("submitcontrol");
        if (ACTIONS_MENU.equals(string)) {
            string = httpServletRequest.getParameter(ACTIONS_MENU);
        }
        return string;
    }

    public static String getCancelButtonTag() {
        return HTMLTags.getCancelButtonTag(1);
    }

    public static String getCancelButtonTag(int n) {
        return HTMLTags.getBackButtonTag(null, n);
    }

    public static String getCancelButtonTag(HttpServletRequest httpServletRequest, String string) {
        return HTMLTags.getLinkButtonTag(HTMLTags.getBreadCrumbURL(httpServletRequest.getSession(), string), HTMLTags.getTag(CANCEL));
    }

    public static String getBackButtonTag(String string, int n) {
        return HTMLTags.getLinkButtonTag("javascript:history.go(-" + n + ")", string != null ? string : HTMLTags.getTag(CANCEL));
    }

    public static String getSubmitMiniButtonTag(String string, String string2) {
        return HTMLTags.getLinkMiniButtonTag(HTMLTags.getTag("submitHREF", new String[]{"'" + HTMLTags.escapeTicks(string) + "'", HTMLTags.trimTags(string2)}), string2);
    }

    public static String getSubmitButtonTag(String string, String string2) {
        return HTMLTags.getLinkButtonTag(HTMLTags.getTag("submitHREF", new String[]{"'" + HTMLTags.escapeTicks(string) + "'", HTMLTags.trimTags(string2)}), string2);
    }

    public static String getResetButtonTag(String string) {
        return HTMLTags.getLinkButtonTag(HTMLTags.getTag("resetHREF"), string);
    }

    public static String getSelectionButtonsTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HTMLTags.getTag("selectionScript"));
        stringBuffer.append(HTMLTags.getTag("selectionButtons", string));
        return stringBuffer.toString();
    }

    public static String getInputFieldTag(String string, String string2, int n, int n2) {
        return HTMLTags.getInputTag("text", string, string2, n, n2, false);
    }

    public static String getInputPasswordTag(String string, String string2, int n, int n2) {
        return HTMLTags.getInputTag("password", string, string2, n, n2, false);
    }

    public static String getInputCheckboxTag(String string, String string2, boolean bl) {
        return HTMLTags.getInputTag("checkbox", string, string2, 0, 0, bl);
    }

    public static String getInputRadioButtonTag(String string, String string2, boolean bl) {
        return HTMLTags.getInputTag("radio", string, string2, 0, 0, bl);
    }

    private static String getInputTag(String string, String string2, String string3, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<input type=\"");
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (string2 != null) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(string2);
            stringBuffer.append('\"');
        }
        if (string3 != null) {
            stringBuffer.append(" value=\"");
            stringBuffer.append(string3);
            stringBuffer.append('\"');
        }
        if (n > 0) {
            stringBuffer.append(" size=\"");
            stringBuffer.append(n);
            stringBuffer.append('\"');
        }
        if (n2 > 0) {
            stringBuffer.append(" maxlength=\"");
            stringBuffer.append(n2);
            stringBuffer.append('\"');
        }
        if (bl) {
            stringBuffer.append(" checked");
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String getTextAreaTag(String string, String string2, int n, int n2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<textarea");
        if (string != null) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
        if (n > 0) {
            stringBuffer.append(" rows=\"");
            stringBuffer.append(n);
            stringBuffer.append('\"');
        }
        if (n2 > 0) {
            stringBuffer.append(" cols=\"");
            stringBuffer.append(n2);
            stringBuffer.append('\"');
        }
        if (string3 != null) {
            stringBuffer.append(" wrap=\"");
            stringBuffer.append(string3);
            stringBuffer.append('\"');
        }
        stringBuffer.append(">");
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("</textarea>\n");
        return stringBuffer.toString();
    }

    public static String getLabeledInputFieldTag(String string, String string2, String string3, int n, int n2) {
        Object[] objectArray = new String[]{string, HTMLTags.getInputFieldTag(string2, string3, n, n2)};
        return Localization.getString(BUNDLE, "labeledInputField", objectArray);
    }

    public static String getInfoBoxTag(String string) {
        return HTMLTags.getInlineAlertTag(MESSAGE_INFO, string, null);
    }

    public static String getWarningBoxTag(String string) {
        return HTMLTags.getInlineAlertTag(MESSAGE_WARNING, string, null);
    }

    public static String getErrorBoxTag(String string) {
        return HTMLTags.getInlineAlertTag(MESSAGE_ERROR, string, null);
    }

    public static String getInlineAlertTag(String string, String string2, String string3) {
        if (string == null || !string.equals(MESSAGE_INFO) && !string.equals(MESSAGE_WARNING) && !string.equals(MESSAGE_ERROR)) {
            string = MESSAGE_INFO;
        }
        return string3 == null ? HTMLTags.getTag("messageBox", new String[]{HTMLTags.getTag(string + ".color"), HTMLTags.getTag(string + ".image"), string2}) : HTMLTags.getTag("messageBox.detail", new String[]{HTMLTags.getTag(string + ".color"), HTMLTags.getTag(string + ".detail.image"), string2, string3});
    }

    public static String getExceptionBoxTag(HttpServletRequest httpServletRequest, String string, Throwable throwable) {
        if (throwable == null) {
            return ALARM_NONE;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = throwable.getMessage();
        if (string2 == null) {
            string2 = "No Message";
        }
        stringBuffer.append(string2);
        if (!string2.endsWith(".")) {
            stringBuffer.append(".");
        }
        String string3 = "/nsm/exception?page=" + string;
        if (httpServletRequest != null) {
            HTMLTags.removePendingMessages(httpServletRequest, MESSAGE_EXCEPTION);
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(HTMLTags.getTag("exceptionMessage", throwable.getMessage()));
            stringBuffer2.append("\n<blockquote><pre>");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
            stringBuffer2.append(byteArrayOutputStream.toString());
            stringBuffer2.append("</pre></blockquote>");
            HTMLTags.addPendingMessage(httpServletRequest, MESSAGE_EXCEPTION, stringBuffer2.toString());
        }
        return HTMLTags.getInlineAlertTag(MESSAGE_ERROR, HTMLTags.getTag("exceptionSummary"), HTMLTags.getTag("exceptionDetail", new String[]{stringBuffer.toString(), string3}));
    }

    public static void addPendingMessage(HttpServletRequest httpServletRequest, String string, String string2) {
        if (string2 == null) {
            return;
        }
        String[] stringArray = HTMLTags.getPendingMessages(httpServletRequest, string);
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string2;
        httpServletRequest.getSession().setAttribute(string, (Object)stringArray2);
    }

    public static String[] removePendingMessages(HttpServletRequest httpServletRequest, String string) {
        String[] stringArray = HTMLTags.getPendingMessages(httpServletRequest, string);
        httpServletRequest.getSession().removeAttribute(string);
        return stringArray;
    }

    public static String[] getPendingMessages(HttpServletRequest httpServletRequest, String string) {
        String[] stringArray = new String[]{};
        Object object = httpServletRequest.getSession().getAttribute(string);
        if (object != null && stringArray.getClass().isAssignableFrom(object.getClass())) {
            return (String[])object;
        }
        return new String[0];
    }

    public static String getPendingMessagesTag(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = HTMLTags.removePendingMessages(httpServletRequest, MESSAGE_ERROR);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(HTMLTags.getErrorBoxTag(stringArray[n]));
            ++n;
        }
        String[] stringArray2 = HTMLTags.removePendingMessages(httpServletRequest, MESSAGE_WARNING);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringBuffer.append(HTMLTags.getWarningBoxTag(stringArray2[n2]));
            ++n2;
        }
        String[] stringArray3 = HTMLTags.removePendingMessages(httpServletRequest, MESSAGE_INFO);
        int n3 = 0;
        while (n3 < stringArray3.length) {
            stringBuffer.append(HTMLTags.getInfoBoxTag(stringArray3[n3]));
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static boolean isProfilingOn(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getParameter(PROFILING) != null || "true".equals(httpServletRequest.getSession().getAttribute(PROFILING));
    }

    public static void addTimestamp(HttpServletRequest httpServletRequest, String string) {
        if (!HTMLTags.isProfilingOn(httpServletRequest)) {
            return;
        }
        Timestamp[] timestampArray = HTMLTags.getTimestamps(httpServletRequest);
        Timestamp[] timestampArray2 = new Timestamp[timestampArray.length + 1];
        System.arraycopy(timestampArray, 0, timestampArray2, 0, timestampArray.length);
        timestampArray2[timestampArray.length] = new Timestamp(string);
        httpServletRequest.setAttribute(TIMESTAMPS, (Object)timestampArray2);
    }

    public static Timestamp[] getTimestamps(HttpServletRequest httpServletRequest) {
        if (!HTMLTags.isProfilingOn(httpServletRequest)) {
            return null;
        }
        Timestamp[] timestampArray = new Timestamp[]{};
        Object object = httpServletRequest.getAttribute(TIMESTAMPS);
        if (object != null && timestampArray.getClass().isAssignableFrom(object.getClass())) {
            return (Timestamp[])object;
        }
        return new Timestamp[0];
    }

    public static Timestamp[] removeTimestamps(HttpServletRequest httpServletRequest) {
        if (!HTMLTags.isProfilingOn(httpServletRequest)) {
            return null;
        }
        Timestamp[] timestampArray = HTMLTags.getTimestamps(httpServletRequest);
        httpServletRequest.removeAttribute(TIMESTAMPS);
        return timestampArray;
    }

    public static String getTimestampTags(HttpServletRequest httpServletRequest) {
        if (!HTMLTags.isProfilingOn(httpServletRequest)) {
            return ALARM_NONE;
        }
        Timestamp[] timestampArray = HTMLTags.removeTimestamps(httpServletRequest);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<br><table>\n");
        long l = 0L;
        Timestamp timestamp = new Timestamp("end");
        int n = 0;
        while (n <= timestampArray.length) {
            Timestamp timestamp2 = n < timestampArray.length ? timestampArray[n] : timestamp;
            stringBuffer.append("<tr><td align=right><font size=-1 color=red>");
            if (l == 0L) {
                stringBuffer.append("Profiling: ");
                stringBuffer.append(DateFormat.getTimeInstance().format(new Date(timestamp2.time)));
            } else {
                stringBuffer.append(timestamp2.time - l);
                stringBuffer.append(" ms");
            }
            stringBuffer.append(" </font></td><td align=left><font size=-1 color=red> ");
            stringBuffer.append(timestamp2.message);
            stringBuffer.append("</font></td></tr>\n");
            l = timestamp2.time;
            ++n;
        }
        if (timestampArray.length > 0) {
            stringBuffer.append("<tr><td align=right><font size=-1 color=red>Total = ");
            stringBuffer.append(timestamp.time - timestampArray[0].time);
            stringBuffer.append(" ms </font></td></tr>");
        }
        stringBuffer.append("</table></font>");
        return stringBuffer.toString();
    }

    public static String getStatusImageTag(String string) {
        return HTMLTags.getAlarmImageTag(HTMLTags.statusToAlarm(string));
    }

    public static String getAlarmImageTag(String string) {
        if (string == null) {
            return ALARM_NONE;
        }
        String string2 = "alarmIcon." + string;
        String string3 = HTMLTags.getTag(string2);
        if (string3 == null || string3.equals(string2)) {
            return ALARM_NONE;
        }
        return string3;
    }

    public static String getAlarmTitle(String string) {
        if (string == null) {
            return ALARM_NONE;
        }
        String string2 = "alarmTitle." + string;
        String string3 = HTMLTags.getTag(string2);
        if (string3 == null || string3.equals(string2)) {
            return ALARM_NONE;
        }
        return string3;
    }

    public static String statusToAlarm(String string) {
        if (string != null) {
            if (string.equals(Localization.getString(CIM_BUNDLE, "Error")) || string.equals(Localization.getString(CIM_BUNDLE, "NonRecover"))) {
                return ALARM_DOWN;
            }
            if (string.equals(Localization.getString(CIM_BUNDLE, "Lost Comm"))) {
                return ALARM_MINOR;
            }
            if (string.equals(Localization.getString(CIM_BUNDLE, "Degraded")) || string.equals(Localization.getString(CIM_BUNDLE, "Pred Fail")) || string.equals(Localization.getString(CIM_BUNDLE, "No Contact"))) {
                return ALARM_MAJOR;
            }
            if (string.equals(Localization.getString(CIM_BUNDLE, "Stressed")) || string.equals(Localization.getString(CIM_BUNDLE, "Stopped")) || string.equals(Localization.getString(CIM_BUNDLE, "Stopping")) || string.equals(Localization.getString(CIM_BUNDLE, "Starting")) || string.equals(Localization.getString(CIM_BUNDLE, "Service"))) {
                return ALARM_MINOR;
            }
        }
        return ALARM_NONE;
    }

    public static String getImageTag(String string, String string2) {
        String string3 = Localization.getString(string, string2 + ".url");
        if (string3.endsWith(".url")) {
            return HTMLTags.getImageTag(ALARM_NONE, 0, 0, string2);
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(Localization.getString(string, string2 + ".width"));
            n2 = Integer.parseInt(Localization.getString(string, string2 + ".height"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string4 = Localization.getString(string, string2 + ".text");
        if (string4.endsWith(".text")) {
            string4 = null;
        }
        return HTMLTags.getImageTag(string3, n, n2, string4);
    }

    private static String getImageTag(String string, int n, int n2, String string2) {
        StringBuffer stringBuffer = new StringBuffer("<img src=\"");
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (n > 0 && n2 > 0) {
            stringBuffer.append(" width=\"");
            stringBuffer.append(n);
            stringBuffer.append("\" height=\"");
            stringBuffer.append(n2);
            stringBuffer.append('\"');
        }
        if (string2 != null) {
            stringBuffer.append(" alt=\"");
            stringBuffer.append(string2);
            stringBuffer.append('\"');
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String getListTag(String[] stringArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(bl ? "<ol>" : "<ul>");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("\n  <li>");
                stringBuffer.append(stringArray[n]);
                ++n;
            }
        }
        stringBuffer.append(bl ? "\n</ol>\n" : "\n</ul>\n");
        return stringBuffer.toString();
    }

    public static String getTableTitleTag(String string) {
        return HTMLTags.getTag("tableTitle", string);
    }

    public static String getTableTitleTag(String string, int n, int n2, int n3) {
        if (n == 0 && n2 <= n3 && n3 <= 25) {
            return HTMLTags.getTableTitleTag(string);
        }
        return HTMLTags.getTag("tableTitle", HTMLTags.getTag("tablePagingTitle", new String[]{string, Integer.toString(n + 1), Integer.toString(Math.min(n + n3, n2)), Integer.toString(n2)}));
    }

    public static String toNonBreakingString(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " <>", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("<".equals(string2)) {
                ++n;
            } else if (">".equals(string2)) {
                n = Math.max(n - 1, 0);
            } else if (" ".equals(string2) && n == 0) {
                string2 = "&nbsp;";
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String getTableTag(String string, TableColumn[] tableColumnArray, String[][] stringArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table><tr><td>");
        stringBuffer.append(HTMLTags.getTag("tableStart"));
        if (tableColumnArray != null) {
            boolean bl = false;
            stringBuffer.append(HTMLTags.getTag("tableHeaderRow"));
            n7 = 0;
            while (n7 < tableColumnArray.length) {
                stringBuffer.append(HTMLTags.getTag("tableHeader", new String[]{HTMLTags.toNonBreakingString(tableColumnArray[n7].title), tableColumnArray[n7].alignment}));
                if (tableColumnArray[n7].sortable) {
                    bl = true;
                }
                ++n7;
            }
            stringBuffer.append("</tr>");
            if (bl && stringArray != null && stringArray.length > 1) {
                stringBuffer.append(HTMLTags.getTag("tableSortRow"));
                int n8 = 0;
                while (n8 < tableColumnArray.length) {
                    if (tableColumnArray[n8].sortable) {
                        n6 = n8 + 1;
                        stringBuffer.append(HTMLTags.getTag("tableSort", new String[]{tableColumnArray[n8].alignment, n == n6 ? HTMLTags.getTag("sortAscendSelect") : HTMLTags.getTag("sortAscend", HTMLTags.getTableURL(string, n6, n2, n4)), n == -n6 ? HTMLTags.getTag("sortDescendSelect") : HTMLTags.getTag("sortDescend", HTMLTags.getTableURL(string, -n6, n2, n4))}));
                    } else {
                        stringBuffer.append(HTMLTags.getTag("tableSortEmpty"));
                    }
                    ++n8;
                }
                stringBuffer.append("</tr>");
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            String string2 = HTMLTags.getTag("tableDataRow");
            n7 = tableColumnArray != null ? tableColumnArray.length : (stringArray[0] != null ? stringArray[0].length : 1);
            String string3 = HTMLTags.getTag("tableDataRowDivider", Integer.toString(n7));
            n6 = 0;
            while (n6 < stringArray.length) {
                if (n6 > 0) {
                    stringBuffer.append(string3);
                }
                stringBuffer.append(string2);
                int n9 = 0;
                while (n9 < stringArray[n6].length) {
                    String string4;
                    String string5 = "\"left\"";
                    if (tableColumnArray != null && n9 < tableColumnArray.length) {
                        string5 = tableColumnArray[n9].alignment;
                        if (tableColumnArray[n9].isScope) {
                            string5 = string5 + " scope=\"row\"";
                        }
                    }
                    if ((string4 = stringArray[n6][n9]) == null) {
                        string4 = "&nbsp;";
                    } else {
                        String string6;
                        String string7 = HTMLTags.trimTags(string4).trim();
                        if ((string7.length() == 0 || string7.equals("null")) && (string6 = string4.toLowerCase()).indexOf("<img") == -1 && string6.indexOf("<input") == -1 && string6.indexOf("<select") == -1 && string6.indexOf("<textarea") == -1) {
                            string4 = string4 + "&nbsp;";
                        }
                    }
                    stringBuffer.append(HTMLTags.getTag("tableData", new String[]{string4, string5}));
                    ++n9;
                }
                while (n9 < n7) {
                    stringBuffer.append("<td>&nbsp;</td>");
                    ++n9;
                }
                stringBuffer.append("</tr>\n");
                ++n6;
            }
        } else if (tableColumnArray != null && tableColumnArray.length > 0) {
            stringBuffer.append(HTMLTags.getTag("tableEmptyRow", Integer.toString(tableColumnArray.length)));
        }
        stringBuffer.append(HTMLTags.getTag("tableEnd"));
        stringBuffer.append("</td></tr><tr><td align=center>");
        if (n4 < 1) {
            n4 = 25;
        }
        int n10 = n2 == 0 ? 0 : (n2 - 1) / n4 + 1;
        int n11 = n7 = n2 == 0 && n3 == n4 ? 1 : 0;
        if (n7 != 0) {
            n4 = 25;
        }
        if ((n5 = n10 + (int)Math.ceil((double)(n3 - n2) / (double)n4)) > 1) {
            stringBuffer.append("<input type=hidden name=");
            stringBuffer.append(SORT_COLUMN);
            stringBuffer.append(" value=");
            stringBuffer.append(n);
            stringBuffer.append(">\n");
            stringBuffer.append("<input type=hidden name=");
            stringBuffer.append(FIRST_ROW);
            stringBuffer.append(" value=");
            stringBuffer.append(n2);
            stringBuffer.append(">\n");
            stringBuffer.append("<input type=hidden name=");
            stringBuffer.append(PAGE_SIZE);
            stringBuffer.append(" value=");
            stringBuffer.append(n4);
            stringBuffer.append(">\n");
            stringBuffer.append(HTMLTags.getTag("tablePaging", new String[]{n10 == 0 ? HTMLTags.getTag("firstPageDisabled") : HTMLTags.getTag("firstPage", HTMLTags.getTableURL(string, n, 0, n4)), n10 == 0 ? HTMLTags.getTag("prevPageDisabled") : HTMLTags.getTag("prevPage", HTMLTags.getTableURL(string, n, Math.max(n2 - n4, 0), n4)), Integer.toString(n10 + 1), Integer.toString(n5), HTMLTags.getSubmitMiniButtonTag(GO_BUTTON, HTMLTags.getTag(GO_BUTTON)), n10 + 1 < n5 && n7 == 0 ? HTMLTags.getTag("nextPage", HTMLTags.getTableURL(string, n, n2 + n4, n4)) : HTMLTags.getTag("nextPageDisabled"), n10 + 1 < n5 && n7 == 0 ? HTMLTags.getTag("lastPage", HTMLTags.getTableURL(string, n, n2 + n4 * (n5 - (n10 + 1)), n4)) : HTMLTags.getTag("lastPageDisabled"), n7 != 0 ? HTMLTags.getDisabledMiniButtonTag(HTMLTags.getTag("tablePagingShowAllRows")) : HTMLTags.getLinkMiniButtonTag(HTMLTags.getTableURL(string, n, 0, n3), HTMLTags.getTag("tablePagingShowAllRows")), Integer.toString(Integer.toString(n5).length())}));
        }
        stringBuffer.append("</td></tr></table>");
        return stringBuffer.toString();
    }

    public static String getTableURL(String string, int n, int n2, int n3) {
        String string2 = HTMLTags.modifyURLParameter(string, SORT_COLUMN, Integer.toString(n));
        string2 = HTMLTags.modifyURLParameter(string2, FIRST_ROW, Integer.toString(n2));
        string2 = HTMLTags.modifyURLParameter(string2, PAGE_SIZE, Integer.toString(n3));
        return string2;
    }

    public static TableInfo getTableInfo(HttpServletRequest httpServletRequest, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n6 = HTMLTags.stringToInt(httpServletRequest.getParameter(SORT_COLUMN), n)) == 0) {
            n6 = n;
        }
        if ((n5 = HTMLTags.stringToInt(httpServletRequest.getParameter(FIRST_ROW), 0)) <= 0 || n5 > n2) {
            n5 = 0;
        }
        if ((n4 = HTMLTags.stringToInt(httpServletRequest.getParameter(PAGE_SIZE), 25)) <= 0) {
            n4 = 25;
        }
        if (GO_BUTTON.equals(HTMLTags.getFormSubmitter(httpServletRequest)) && (n3 = HTMLTags.stringToInt(httpServletRequest.getParameter(PAGE_NUMBER), -222)) != -222) {
            int n7 = (n3 - 1) * n4 + n5 % n4;
            return new TableInfo(n6, n7 < 0 || n7 >= n2 ? 0 : n7, n4);
        }
        return new TableInfo(n6, n5, n4);
    }

    public static int getTableSortColumn(HttpServletRequest httpServletRequest, int n) {
        return HTMLTags.stringToInt(httpServletRequest.getParameter(SORT_COLUMN), n);
    }

    public static String getContentStartTags(String string) {
        string = HTMLTags.modifyURLParameter(string, SORT_COLUMN, null);
        string = HTMLTags.modifyURLParameter(string, FIRST_ROW, null);
        string = HTMLTags.modifyURLParameter(string, PAGE_SIZE, null);
        return HTMLTags.getTag("contentStart", new String[]{string, HTMLTags.getTag("formScripts")});
    }

    public static String getContentSubSectionTags(String string) {
        return HTMLTags.getTag("contentSeparator", string);
    }

    public static String getContentSubSectionTags(String string, int n) {
        return HTMLTags.getTag("contentSeparatorWithSpace", new String[]{string, Integer.toString(n)});
    }

    public static String getContentEndTags() {
        return HTMLTags.getTag("contentEnd");
    }

    public static String getMenuTag(String string, String string2, String[] stringArray, String string3) {
        return HTMLTags.getMenuTag(string, string2, stringArray, string3, false);
    }

    public static String getActionButtonsTag(String string, String string2, String[] stringArray) {
        return HTMLTags.getActionButtonsTag(string, string2, stringArray, null);
    }

    public static String getActionButtonsTag(String string, String string2, String[] stringArray, boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Localization.getString(BUNDLE, "actionTagsStart"));
        int n = stringArray.length <= 3 ? stringArray.length : 2;
        int n2 = 0;
        while (n2 < n) {
            boolean bl = blArray != null && n2 < blArray.length && !blArray[n2];
            String string3 = string == null ? stringArray[n2] : Localization.getString(string, stringArray[n2]);
            stringBuffer.append(Localization.getString(BUNDLE, "actionItem", bl ? HTMLTags.getDisabledMiniButtonTag(string3) : HTMLTags.getSubmitMiniButtonTag(stringArray[n2], string3)));
            ++n2;
        }
        if (n2 < stringArray.length) {
            String[] stringArray2 = new String[stringArray.length - n2 + 1];
            stringArray2[0] = string == null ? string2 : Localization.getString(string, string2);
            System.arraycopy(stringArray, n2, stringArray2, 1, stringArray.length - n2);
            stringBuffer.append(Localization.getString(BUNDLE, "actionItem", HTMLTags.getSubmitMenuTag(string, ACTIONS_MENU, stringArray2, string2)));
        }
        stringBuffer.append(Localization.getString(BUNDLE, "actionTagsEnd"));
        return stringBuffer.toString();
    }

    public static String getPageActionsTag(String string, String string2, String[] stringArray) {
        if (stringArray.length == 1) {
            String string3 = string == null ? stringArray[0] : Localization.getString(string, stringArray[0]);
            return HTMLTags.getSubmitButtonTag(stringArray[0], string3);
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string == null ? string2 : Localization.getString(string, string2);
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return HTMLTags.getSubmitMenuTag(string, ACTIONS_MENU, stringArray2, string2);
    }

    public static String getActionButtonsTag(String string, String string2, String[] stringArray, boolean bl) {
        return HTMLTags.getActionButtonsTag(string, string2, stringArray);
    }

    public static String getSubmitMenuTag(String string, String string2, String[] stringArray, String string3) {
        return HTMLTags.getMenuTag(string, string2, stringArray, string3, true);
    }

    public static String getMenuTag(String string, String string2, String[] stringArray, String string3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<select name=\"");
        stringBuffer.append(string2);
        stringBuffer.append('\"');
        if (bl) {
            stringBuffer.append(" onChange=\"document.contentForm.submitcontrol.value = '" + HTMLTags.escapeTicks(string2) + "';");
            stringBuffer.append(" document.contentForm.submit();\"");
        }
        stringBuffer.append(">\n");
        int n = 0;
        while (n < stringArray.length) {
            String string4 = stringArray[n] != null ? stringArray[n] : ALARM_NONE;
            stringBuffer.append("  <option value=\"");
            stringBuffer.append(string4);
            if (string4.equals(string3) && string4.length() > 0) {
                stringBuffer.append("\" selected>");
            } else {
                stringBuffer.append("\">");
            }
            if (string4.length() == 0 || string == null) {
                stringBuffer.append(string4);
            } else {
                stringBuffer.append(Localization.getString(string, string4));
            }
            stringBuffer.append("</option>\n");
            ++n;
        }
        stringBuffer.append("</select>\n");
        return stringBuffer.toString();
    }

    public static String createURL(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string2 != null) {
            stringBuffer.append('?');
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String modifyURLParameter(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "?&");
        String string4 = stringTokenizer.nextToken();
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (string5.startsWith(string2 + "=")) continue;
            stringBuffer.append('&');
            stringBuffer.append(string5);
        }
        if (string3 != null) {
            stringBuffer.append('&');
            stringBuffer.append(string2);
            stringBuffer.append('=');
            stringBuffer.append(URLEncoder.encode(string3));
        }
        return stringBuffer.length() == 0 ? string4 : HTMLTags.createURL(string4, stringBuffer.substring(1));
    }

    public static String getSubmitFormJavascriptTag() {
        return HTMLTags.getTag("formScripts");
    }

    public static String getLaunchApplicationURL() {
        return NSMPages.getPageURL(NSMPages.LAUNCH_PAGE);
    }

    public static String getLaunchApplicationTag(String string, String string2, boolean bl) {
        String string3 = bl ? String.valueOf(Math.abs(string2.hashCode())) : string2;
        return "<script language='JavaScript'>\n<!--\nwindow1=window.open( '" + HTMLTags.escapeTicks(string) + "', '" + HTMLTags.escapeTicks(string3) + "' );\n" + "//-->\n" + "</script>\n";
    }

    public static String getLaunchApplicationTag(String string, String string2) {
        return HTMLTags.getLaunchApplicationTag(string, string2, true);
    }

    public static String getSecondaryPageTags(String string, String string2) {
        String string3 = string != null ? string : HTMLTags.getTag("defaultSecondaryPageTitle");
        return HTMLTags.getTag("secondaryPage", new String[]{string3, string2});
    }

    private static String getTag(String string) {
        return Localization.getString(BUNDLE, string);
    }

    private static String getTag(String string, Object object) {
        return Localization.getString(BUNDLE, string, object);
    }

    private static String getTag(String string, Object[] objectArray) {
        return Localization.getString(BUNDLE, string, objectArray);
    }

    public static int stringToInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static String trimTags(String string) {
        if (string == null) {
            return ALARM_NONE;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>&;", true);
        boolean bl = false;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("<".equals(string2)) {
                ++n;
                continue;
            }
            if (">".equals(string2)) {
                n = Math.max(n - 1, 0);
                continue;
            }
            if (n == 0) {
                if ("&".equals(string2)) {
                    bl = true;
                    continue;
                }
                if (";".equals(string2) && bl) {
                    bl = false;
                    continue;
                }
            }
            if (n != 0 || bl) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String escapeTicks(String string) {
        StringBuffer stringBuffer = new StringBuffer(ALARM_NONE);
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\'') {
                stringBuffer.append("\\'");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final class Timestamp {
        public final String message;
        public final long time;

        private Timestamp(String string) {
            this.message = string;
            this.time = System.currentTimeMillis();
        }
    }

    public static final class TableInfo {
        public static final int NO_SORT_COLUMN = 0;
        public final int firstRow;
        public final int pageSize;
        public final int sortColumn;

        TableInfo(int n, int n2, int n3) {
            this.firstRow = n2;
            this.pageSize = n3;
            this.sortColumn = n;
        }
    }
}

