/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.Zone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public final class TopologyDetailCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.topology.Localization";
    private static final TableColumn[] COLUMNS = new TableColumn[6];
    public static final int SWITCH_COLUMN = 0;
    public static final int FPORT_COLUMN = 1;
    public static final int CONNECTS_TO_COLUMN = 2;
    public static final int DEVICE_COLUMN = 4;
    public static final int DEVICE_PORT_COLUMN = 3;
    public static final int DEVICE_TYPE_COLUMN = 5;
    public static final int DEFAULT_SORT_COL = 1;
    private final TopologyGraph topology;
    private final FabricTopology fabric;
    private final Zone zone;
    private final boolean htmlOk;
    private String[][] zoneData;

    public static TableColumn[] getColumns() {
        if (COLUMNS[0] == null) {
            TopologyDetailCommand.COLUMNS[0] = new TableColumn(Localization.getString(BUNDLE, "switchColumn"), true, "\"left\"");
            TopologyDetailCommand.COLUMNS[1] = new TableColumn(Localization.getString(BUNDLE, "fportColumn"), false, "\"right\"");
            TopologyDetailCommand.COLUMNS[2] = new TableColumn(Localization.getString(BUNDLE, "connectsToColumn"), false, "\"center\"");
            TopologyDetailCommand.COLUMNS[4] = new TableColumn(Localization.getString(BUNDLE, "deviceColumn"), true, "\"left\"");
            TopologyDetailCommand.COLUMNS[5] = new TableColumn(Localization.getString(BUNDLE, "deviceTypeColumn"), true, "\"left\"");
            TopologyDetailCommand.COLUMNS[3] = new TableColumn(Localization.getString(BUNDLE, "devicePortColumn"), true, "\"right\"");
        }
        return COLUMNS;
    }

    public TopologyDetailCommand(TopologyGraph topologyGraph, FabricTopology fabricTopology, Zone zone, boolean bl) {
        if (topologyGraph == null) {
            throw new IllegalArgumentException("topology == null");
        }
        this.topology = topologyGraph;
        this.fabric = fabricTopology;
        this.zone = zone;
        this.htmlOk = bl;
    }

    public boolean run() throws DataRetrievalException {
        try {
            String string = this.htmlOk ? Localization.getString(BUNDLE, "htmlZoneMarker") : Localization.getString(BUNDLE, "zoneMarker");
            HashSet hashSet = this.fabric == null ? new HashSet() : new HashSet<TSTopologyNode>(Arrays.asList(this.fabric.getPhysicalTopology().getNodes()));
            TSTopologyNode[] tSTopologyNodeArray = this.topology.getNodesByType("com.sun.netstorage.mgmt.component.model.domain.Switch");
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                if (this.fabric == null || hashSet.contains(tSTopologyNodeArray[n])) {
                    String string2 = this.getSwitchData(tSTopologyNodeArray[n]);
                    TSTopologyNode[] tSTopologyNodeArray2 = tSTopologyNodeArray[n].getChildren();
                    int n2 = 0;
                    while (n2 < tSTopologyNodeArray2.length) {
                        Object object;
                        boolean bl = this.zone != null && this.zone.contains(tSTopologyNodeArray2[n2]);
                        String string3 = TopologyDetailCommand.getPortData(tSTopologyNodeArray2[n2], this.htmlOk);
                        TSTopologyNode[] tSTopologyNodeArray3 = this.topology.getPeers(tSTopologyNodeArray2[n2]);
                        if (tSTopologyNodeArray3.length > 0) {
                            int n3 = 0;
                            while (n3 < tSTopologyNodeArray3.length) {
                                if (this.zone == null || bl || this.zone.contains(tSTopologyNodeArray3[n3])) {
                                    String[] stringArray = new String[COLUMNS.length];
                                    stringArray[0] = string2;
                                    stringArray[1] = string3;
                                    stringArray[2] = this.htmlOk ? "&lt;-&gt;" : "<->";
                                    object = tSTopologyNodeArray3[n3].getImmediateParent();
                                    stringArray[4] = TopologyDetailCommand.getDeviceData(object, this.htmlOk);
                                    stringArray[5] = TopologyDetailCommand.getDeviceTypeData(object, this.htmlOk);
                                    stringArray[3] = TopologyDetailCommand.getPortData(tSTopologyNodeArray3[n3], this.htmlOk);
                                    if (this.zone != null) {
                                        int n4 = bl ? 1 : 3;
                                        String string4 = this.htmlOk ? "htmlZoneMarker" : "zoneMarker";
                                        stringArray[n4] = Localization.getString(BUNDLE, string4, stringArray[n4]);
                                    }
                                    arrayList.add(stringArray);
                                }
                                ++n3;
                            }
                        } else if (this.zone == null || bl) {
                            String[] stringArray = new String[COLUMNS.length];
                            stringArray[0] = string2;
                            stringArray[1] = string3;
                            stringArray[2] = "";
                            stringArray[4] = "";
                            stringArray[5] = "";
                            stringArray[3] = "";
                            if (this.zone != null && bl) {
                                int n5 = 1;
                                object = this.htmlOk ? "htmlZoneMarker" : "zoneMarker";
                                stringArray[n5] = Localization.getString(BUNDLE, (String)object, stringArray[n5]);
                            }
                            arrayList.add(stringArray);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            this.zoneData = (String[][])arrayList.toArray((T[])new String[arrayList.size()][0]);
            return true;
        }
        catch (Exception exception) {
            throw new DataRetrievalException(exception);
        }
    }

    private String getSwitchData(TSTopologyNode tSTopologyNode) {
        if (tSTopologyNode == null) {
            return "";
        }
        String string = (String)tSTopologyNode.getProperty("Name");
        if (!this.htmlOk) {
            return string;
        }
        return HTMLTags.getLinkTag(HTMLTags.modifyURLParameter(NSMPages.getPageURL(NSMPages.SWITCH_DETAILS_PAGE), "id", tSTopologyNode.getOid()), string);
    }

    static String getDeviceData(TSTopologyNode tSTopologyNode, boolean bl) {
        String string;
        if (tSTopologyNode == null) {
            return "";
        }
        String string2 = null;
        String string3 = (String)tSTopologyNode.getProperty("Name");
        if (string3 == null) {
            string3 = "";
        }
        if ("com.sun.netstorage.mgmt.component.model.domain.HBA".equals(string = tSTopologyNode.getType())) {
            String string4;
            TSTopologyNode tSTopologyNode2 = tSTopologyNode.getImmediateParent();
            String string5 = string4 = tSTopologyNode2 == null ? "" : (String)tSTopologyNode2.getProperty("Name");
            if (string3.startsWith(string4 + ':')) {
                string3 = string3.substring(string4.length() + 1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(TopologyDetailCommand.getDeviceData(tSTopologyNode2, bl));
            stringBuffer.append(":");
            if (bl) {
                stringBuffer.append(HTMLTags.getLinkTag(HTMLTags.modifyURLParameter(NSMPages.getPageURL(NSMPages.HBA_DETAILS_PAGE), "id", tSTopologyNode.getOid()), string3));
            } else {
                stringBuffer.append(string3);
            }
            return stringBuffer.toString();
        }
        if ("com.sun.netstorage.mgmt.component.model.domain.Switch".equals(string)) {
            string2 = NSMPages.getPageURL(NSMPages.SWITCH_DETAILS_PAGE);
        } else if ("com.sun.netstorage.mgmt.component.model.domain.StorageHost".equals(string)) {
            string2 = NSMPages.getPageURL(NSMPages.HOST_DETAILS_PAGE);
        } else if ("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem".equals(string)) {
            string2 = NSMPages.getPageURL(NSMPages.STORAGE_DETAILS_PAGE);
        }
        if (bl && string2 != null) {
            return HTMLTags.getLinkTag(HTMLTags.modifyURLParameter(string2, "id", tSTopologyNode.getOid()), string3);
        }
        return string3;
    }

    static String getPortData(TSTopologyNode tSTopologyNode, boolean bl) {
        String string;
        if (tSTopologyNode == null) {
            return "";
        }
        String string2 = (String)tSTopologyNode.getProperty("Port Number");
        if (string2 == null) {
            string2 = (String)tSTopologyNode.getProperty("WWN");
        }
        if (string2 == null) {
            string2 = "";
        }
        if (bl && (string = (String)tSTopologyNode.getProperty("Status")) != null) {
            string2 = HTMLTags.getStatusImageTag(string) + "&nbsp;" + string2;
        }
        return string2;
    }

    static String getDeviceTypeData(TSTopologyNode tSTopologyNode, boolean bl) {
        String string;
        if (tSTopologyNode == null) {
            return "";
        }
        String string2 = (String)tSTopologyNode.getProperty("Vendor");
        String string3 = (String)tSTopologyNode.getProperty("Model Number");
        String string4 = string2 != null ? (string3 != null ? string2 + "/" + string3 : string2) : (string = string3 != null ? string3 : "");
        if ("com.sun.netstorage.mgmt.component.model.domain.HBA".equals(tSTopologyNode.getType())) {
            TSTopologyNode tSTopologyNode2 = tSTopologyNode.getImmediateParent();
            string = string.length() == 0 ? TopologyDetailCommand.getDeviceTypeData(tSTopologyNode2, bl) : TopologyDetailCommand.getDeviceTypeData(tSTopologyNode2, bl) + ": " + string;
        }
        return string;
    }

    public int getRowCount() {
        return this.zoneData != null ? this.zoneData.length : 0;
    }

    public String[][] getTableData(HTMLTags.TableInfo tableInfo) {
        int n;
        String[][] stringArray;
        String[][] stringArray2 = stringArray = this.zoneData != null ? this.zoneData : new String[0][0];
        if (tableInfo == null) {
            return stringArray;
        }
        if (tableInfo.sortColumn != 0) {
            n = Math.abs(tableInfo.sortColumn) - 1;
            boolean bl = n != 4 && n != 5;
            Arrays.sort(stringArray, new SmartColumnComparator(tableInfo.sortColumn, bl));
        }
        n = Math.min(tableInfo.pageSize, stringArray.length - tableInfo.firstRow);
        String[][] stringArray3 = new String[n][];
        System.arraycopy(stringArray, tableInfo.firstRow, stringArray3, 0, n);
        return stringArray3;
    }
}

