/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyBaseServlet;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyCommand;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyDetailCommand;
import com.sun.netstorage.mgmt.nsmui.topology.ZoneUtil;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.TopologyServiceImpl;
import com.sun.netstorage.mgmt.services.topology.Zone;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class PathsDetailServlet
extends TopologyBaseServlet {
    private TopologyCommand topoCommand;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.topoCommand = new TopologyCommand();
    }

    private String getParentPageName(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("returnTo");
        return string != null ? string : NSMPages.FABRIC_INVENTORY_PAGE;
    }

    protected PrintWriter writePageStart(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = this.getParentPageName(httpServletRequest);
        HTMLTags.addTimestamp(httpServletRequest, "start");
        Masthead.getMasthead(this.getServletContext()).print(NSMPages.getPageTitle(NSMPages.SHOW_PATHS_DETAIL_PAGE), NSMPages.getPageSection(string), NSMPages.getPageSubsection(string), NSMPages.getPageHelp(NSMPages.SHOW_PATHS_DETAIL_PAGE), httpServletRequest, httpServletResponse);
        httpServletResponse.getWriter().flush();
        HTMLTags.addTimestamp(httpServletRequest, "masthead");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println(HTMLTags.getDoubleExtendedBreadCrumbTag(httpServletRequest, string, NSMPages.SHOW_PATHS_PAGE, NSMPages.getPageCrumbName(NSMPages.SHOW_PATHS_DETAIL_PAGE)));
        String string2 = NSMPages.getPageURL(NSMPages.SHOW_PATHS_DETAIL_PAGE);
        String string3 = httpServletRequest.getParameter("stubDB");
        if (string3 != null) {
            string2 = HTMLTags.modifyURLParameter(string2, "stubDB", string3);
        }
        string2 = HTMLTags.modifyURLParameter(string2, "host", httpServletRequest.getParameter("host"));
        string2 = HTMLTags.modifyURLParameter(string2, "device", httpServletRequest.getParameter("device"));
        string2 = HTMLTags.modifyURLParameter(string2, "fabric", httpServletRequest.getParameter("fabric"));
        string2 = HTMLTags.modifyURLParameter(string2, "zone", httpServletRequest.getParameter("zone"));
        printWriter.println(HTMLTags.getContentStartTags(string2));
        printWriter.println(HTMLTags.getPendingMessagesTag(httpServletRequest));
        printWriter.flush();
        HTMLTags.addTimestamp(httpServletRequest, "breadcrumb");
        return printWriter;
    }

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!this.performSecurityCheck(httpServletRequest, httpServletResponse)) {
            return;
        }
        String string = httpServletRequest.getParameter("host");
        String string2 = httpServletRequest.getParameter("device");
        String string3 = httpServletRequest.getParameter("fabric");
        String string4 = httpServletRequest.getParameter("zone");
        String string5 = httpServletRequest.getParameter("stubDB");
        PrintWriter printWriter = this.writePageStart(httpServletRequest, httpServletResponse);
        try {
            TopologyServiceImpl topologyServiceImpl = TopologyServiceImpl.getInstance();
            SanTopology sanTopology = this.getSanTopology(topologyServiceImpl, httpServletRequest);
            if (sanTopology != null) {
                String string6;
                TSTopologyNode tSTopologyNode;
                String string7;
                HTMLTags.addTimestamp(httpServletRequest, "get topology from model");
                TSTopologyNode tSTopologyNode2 = topologyServiceImpl.findNode((Object)string);
                String string8 = tSTopologyNode2 == null ? TopologyCommand.getAssetName(string, "Host") : (string7 = (String)tSTopologyNode2.getProperty("Name"));
                if (string7 == null) {
                    string7 = string;
                }
                String string9 = (tSTopologyNode = topologyServiceImpl.findNode((Object)string2)) == null ? TopologyCommand.getAssetName(string2, "Storage") : (string6 = (String)tSTopologyNode.getProperty("Name"));
                if (string6 == null) {
                    string6 = string2;
                }
                TopologyGraph topologyGraph = null;
                if (tSTopologyNode2 != null && tSTopologyNode != null) {
                    topologyGraph = sanTopology.getPathsGraph(tSTopologyNode2, tSTopologyNode);
                    HTMLTags.addTimestamp(httpServletRequest, "get SAN paths");
                } else {
                    if (tSTopologyNode2 == null) {
                        printWriter.println(HTMLTags.getInfoBoxTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "hostNotFound", string7)));
                    }
                    if (tSTopologyNode == null) {
                        printWriter.println(HTMLTags.getInfoBoxTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "deviceNotFound", string6)));
                    }
                }
                if (topologyGraph == null) {
                    printWriter.println(HTMLTags.getInfoBoxTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "noSANPathsFound")));
                } else {
                    Object object;
                    TopologyDetailCommand topologyDetailCommand = null;
                    String[][] stringArray = null;
                    HTMLTags.TableInfo tableInfo = null;
                    int n = 0;
                    FabricTopology fabricTopology = null;
                    String string10 = "";
                    Zone zone = null;
                    if (string4 != null) {
                        FabricTopology[] fabricTopologyArray;
                        if (string3 == null) {
                            fabricTopologyArray = sanTopology.getFabrics();
                        } else {
                            FabricTopology[] fabricTopologyArray2 = new FabricTopology[1];
                            fabricTopologyArray = fabricTopologyArray2;
                            fabricTopologyArray2[0] = sanTopology.getFabric(string3);
                        }
                        object = fabricTopologyArray;
                        int n2 = 0;
                        while (zone == null && n2 < ((FabricTopology[])object).length) {
                            if (object[n2] == null) {
                                HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "fabricNotFound"));
                            } else {
                                zone = object[n2].getZone(string4);
                                if (zone != null) {
                                    fabricTopology = object[n2];
                                }
                            }
                            ++n2;
                        }
                        if (zone == null) {
                            HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "zoneNotFound"));
                            tableInfo = HTMLTags.getTableInfo(httpServletRequest, 1, 0);
                        }
                    }
                    if (string3 != null && fabricTopology == null) {
                        fabricTopology = sanTopology.getFabric(string3);
                    }
                    if (fabricTopology != null) {
                        string10 = fabricTopology.getFabricId().getLogicalName();
                    }
                    topologyDetailCommand = new TopologyDetailCommand(topologyGraph, fabricTopology, zone, string5 == null);
                    topologyDetailCommand.run();
                    HTMLTags.addTimestamp(httpServletRequest, "search for zone in model");
                    n = topologyDetailCommand.getRowCount();
                    tableInfo = HTMLTags.getTableInfo(httpServletRequest, 1, n);
                    stringArray = topologyDetailCommand.getTableData(tableInfo);
                    HTMLTags.addTimestamp(httpServletRequest, "get data from model");
                    object = null;
                    object = zone != null ? Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "logicalPathsDetailTitle", new String[]{string7, string6, string10, ZoneUtil.localizeZoneName(string4)}) : (fabricTopology != null ? Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "fabricPathsDetailTitle", new String[]{string7, string6, string10}) : Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "physicalPathsDetailTitle", new String[]{string7, string6}));
                    printWriter.println(HTMLTags.getTableTitleTag((String)object, tableInfo.firstRow, n, tableInfo.pageSize));
                    if (zone != null) {
                        printWriter.println(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Tags", "helpText", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "htmlZoningNote")));
                    }
                    printWriter.println(HTMLTags.getTableTag(HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString()), TopologyDetailCommand.getColumns(), stringArray, tableInfo.sortColumn, tableInfo.firstRow, n, tableInfo.pageSize));
                    HTMLTags.addTimestamp(httpServletRequest, "write table");
                }
            }
        }
        catch (NSMUIException nSMUIException) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.SHOW_PATHS_DETAIL_PAGE, nSMUIException));
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.SHOW_PATHS_DETAIL_PAGE, new DataRetrievalException(throwable)));
        }
        this.writePageEnd(httpServletRequest, printWriter);
    }

    public String getServletInfo() {
        return "NSM Show Paths Detail Servlet";
    }
}

