/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyConstants;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import java.util.Arrays;

public final class DASInventoryCommand
implements TopologyConstants {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.topology.Localization";
    private static final TableColumn[] COLUMNS = new TableColumn[2];
    public static final int HOST_COLUMN = 0;
    public static final int STORAGE_COLUMN = 1;
    static final int DEFAULT_SORT_COL = 1;
    private final SanTopology topology;
    private final boolean htmlOk;
    private String[][] dasData;

    public static TableColumn[] getColumns() {
        if (COLUMNS[0] == null) {
            DASInventoryCommand.COLUMNS[0] = new TableColumn(Localization.getString(BUNDLE, "hostColumn"), true, "\"left\"", true);
            DASInventoryCommand.COLUMNS[1] = new TableColumn(Localization.getString(BUNDLE, "storageColumn"), false, "\"left\"");
        }
        return COLUMNS;
    }

    public DASInventoryCommand(SanTopology sanTopology, boolean bl) {
        this.topology = sanTopology;
        this.htmlOk = bl;
    }

    public boolean run() throws DataRetrievalException {
        if (this.topology == null) {
            return true;
        }
        try {
            TopologyGraph topologyGraph = this.topology.getDasTopology();
            TSTopologyNode[] tSTopologyNodeArray = topologyGraph.getNodesByType("com.sun.netstorage.mgmt.component.model.domain.StorageHost");
            this.dasData = tSTopologyNodeArray != null ? new String[tSTopologyNodeArray.length][2] : new String[0][0];
            int n = 0;
            while (tSTopologyNodeArray != null && n < tSTopologyNodeArray.length) {
                this.dasData[n][0] = this.getHostData(tSTopologyNodeArray[n]);
                this.dasData[n][1] = this.getStorageData(topologyGraph, tSTopologyNodeArray[n]);
                ++n;
            }
            return true;
        }
        catch (Exception exception) {
            throw new DataRetrievalException(exception);
        }
    }

    private String getHostData(TSTopologyNode tSTopologyNode) {
        if (tSTopologyNode == null) {
            return "";
        }
        String string = (String)tSTopologyNode.getProperty("Name");
        if (this.htmlOk) {
            String string2 = NSMPages.getPageURL(NSMPages.DAS_DETAIL_PAGE);
            string2 = HTMLTags.modifyURLParameter(string2, "id", tSTopologyNode.getOid());
            return HTMLTags.getLinkTag(string2, string);
        }
        return string;
    }

    private String getStorageData(TopologyGraph topologyGraph, TSTopologyNode tSTopologyNode) {
        if (tSTopologyNode == null) {
            return "";
        }
        String string = NSMPages.getPageURL(NSMPages.STORAGE_DETAILS_PAGE);
        StringBuffer stringBuffer = new StringBuffer();
        TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            TSTopologyNode[] tSTopologyNodeArray2 = topologyGraph.getPeers(tSTopologyNodeArray[n]);
            int n2 = 0;
            while (n2 < tSTopologyNodeArray2.length) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(Localization.getString(BUNDLE, "itemSeparator"));
                    stringBuffer.append(' ');
                }
                String string2 = (String)tSTopologyNodeArray2[n2].getProperty("Name");
                if (this.htmlOk) {
                    stringBuffer.append(HTMLTags.getLinkTag(HTMLTags.modifyURLParameter(string, "id", tSTopologyNodeArray2[n2].getOid()), string2));
                } else {
                    stringBuffer.append(string2);
                }
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getRowCount() {
        return this.dasData != null ? this.dasData.length : 0;
    }

    public String[][] getTableData(HTMLTags.TableInfo tableInfo) {
        int n;
        String[][] stringArray;
        String[][] stringArray2 = stringArray = this.dasData != null ? this.dasData : new String[0][0];
        if (tableInfo == null) {
            return stringArray;
        }
        if (tableInfo.sortColumn != 0 && (n = Math.abs(tableInfo.sortColumn) - 1) >= 0 && n <= DASInventoryCommand.getColumns().length) {
            Arrays.sort(stringArray, new SmartColumnComparator(tableInfo.sortColumn));
        }
        n = Math.min(tableInfo.pageSize, stringArray.length - tableInfo.firstRow);
        String[][] stringArray3 = new String[n][];
        System.arraycopy(stringArray, tableInfo.firstRow, stringArray3, 0, n);
        return stringArray3;
    }
}

