/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyDetailCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import java.util.ArrayList;
import java.util.Arrays;

public final class DASDetailCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.topology.Localization";
    private static final TableColumn[] COLUMNS = new TableColumn[6];
    public static final int HOST_COLUMN = 0;
    public static final int HOST_PORT_COLUMN = 1;
    public static final int CONNECTS_TO_COLUMN = 2;
    public static final int DEVICE_COLUMN = 4;
    public static final int DEVICE_PORT_COLUMN = 3;
    public static final int DEVICE_TYPE_COLUMN = 5;
    static final int DEFAULT_SORT_COL = 1;
    private final String host;
    private final SanTopology topology;
    private final boolean htmlOk;
    private String[][] dasData;

    public static TableColumn[] getColumns() {
        if (COLUMNS[0] == null) {
            DASDetailCommand.COLUMNS[0] = new TableColumn(Localization.getString(BUNDLE, "hostHbaColumn"), true, "\"left\"", true);
            DASDetailCommand.COLUMNS[1] = new TableColumn(Localization.getString(BUNDLE, "hostPortColumn"), false, "\"right\"");
            DASDetailCommand.COLUMNS[2] = new TableColumn(Localization.getString(BUNDLE, "connectsToColumn"), false, "\"center\"");
            DASDetailCommand.COLUMNS[4] = new TableColumn(Localization.getString(BUNDLE, "storageColumn"), true, "\"left\"");
            DASDetailCommand.COLUMNS[5] = new TableColumn(Localization.getString(BUNDLE, "storageTypeColumn"), true, "\"left\"");
            DASDetailCommand.COLUMNS[3] = new TableColumn(Localization.getString(BUNDLE, "storagePortColumn"), true, "\"right\"");
        }
        return COLUMNS;
    }

    public DASDetailCommand(SanTopology sanTopology, String string, boolean bl) {
        this.topology = sanTopology;
        this.host = string;
        this.htmlOk = bl;
    }

    public boolean run() throws DataRetrievalException {
        if (this.topology == null) {
            return true;
        }
        try {
            TopologyGraph topologyGraph = this.topology.getDasTopology();
            TSTopologyNode[] tSTopologyNodeArray = topologyGraph.getNodesByType("com.sun.netstorage.mgmt.component.model.domain.StorageHost");
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                if (this.host == null || this.host.equals(this.htmlOk ? tSTopologyNodeArray[n].getOid() : (String)tSTopologyNodeArray[n].getProperty("Name"))) {
                    TSTopologyNode[] tSTopologyNodeArray2 = tSTopologyNodeArray[n].getChildren();
                    int n2 = 0;
                    while (n2 < tSTopologyNodeArray2.length) {
                        String string = TopologyDetailCommand.getDeviceData(tSTopologyNodeArray2[n2], this.htmlOk);
                        TSTopologyNode[] tSTopologyNodeArray3 = tSTopologyNodeArray2[n2].getChildren();
                        int n3 = 0;
                        while (n3 < tSTopologyNodeArray3.length) {
                            String string2 = TopologyDetailCommand.getPortData(tSTopologyNodeArray3[n3], this.htmlOk);
                            TSTopologyNode[] tSTopologyNodeArray4 = topologyGraph.getPeers(tSTopologyNodeArray3[n3]);
                            if (tSTopologyNodeArray4.length > 0) {
                                int n4 = 0;
                                while (n4 < tSTopologyNodeArray4.length) {
                                    String[] stringArray = new String[COLUMNS.length];
                                    stringArray[0] = string;
                                    stringArray[1] = string2;
                                    stringArray[2] = this.htmlOk ? "&lt;-&gt;" : "<->";
                                    TSTopologyNode tSTopologyNode = tSTopologyNodeArray4[n4].getImmediateParent();
                                    stringArray[4] = TopologyDetailCommand.getDeviceData(tSTopologyNode, this.htmlOk);
                                    stringArray[5] = TopologyDetailCommand.getDeviceTypeData(tSTopologyNode, this.htmlOk);
                                    stringArray[3] = TopologyDetailCommand.getPortData(tSTopologyNodeArray4[n4], this.htmlOk);
                                    arrayList.add(stringArray);
                                    ++n4;
                                }
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            this.dasData = (String[][])arrayList.toArray((T[])new String[arrayList.size()][0]);
            return true;
        }
        catch (Exception exception) {
            throw new DataRetrievalException(exception);
        }
    }

    public int getRowCount() {
        return this.dasData != null ? this.dasData.length : 0;
    }

    public String[][] getTableData(HTMLTags.TableInfo tableInfo) {
        int n;
        String[][] stringArray;
        String[][] stringArray2 = stringArray = this.dasData != null ? this.dasData : new String[0][0];
        if (tableInfo == null) {
            return stringArray;
        }
        if (tableInfo.sortColumn != 0) {
            n = Math.abs(tableInfo.sortColumn) - 1;
            boolean bl = n != 4 && n != 5;
            Arrays.sort(stringArray, new SmartColumnComparator(tableInfo.sortColumn, bl));
        }
        n = Math.min(tableInfo.pageSize, stringArray.length - tableInfo.firstRow);
        String[][] stringArray3 = new String[n][];
        System.arraycopy(stringArray, tableInfo.firstRow, stringArray3, 0, n);
        return stringArray3;
    }
}

