/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyBaseServlet;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyCommand;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyDetailCommand;
import com.sun.netstorage.mgmt.nsmui.topology.ZoneUtil;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.TopologyServiceImpl;
import com.sun.netstorage.mgmt.services.topology.Zone;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ConnectivityDetailServlet
extends TopologyBaseServlet {
    private TopologyCommand topoCommand;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.topoCommand = new TopologyCommand();
    }

    private String getParentPageName(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("returnTo");
        return string != null ? string : NSMPages.FABRIC_INVENTORY_PAGE;
    }

    protected PrintWriter writePageStart(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = this.getParentPageName(httpServletRequest);
        HTMLTags.addTimestamp(httpServletRequest, "start");
        Masthead.getMasthead(this.getServletContext()).print(NSMPages.getPageTitle(NSMPages.CONNECTIVITY_DETAIL_PAGE), NSMPages.getPageSection(string), NSMPages.getPageSubsection(string), NSMPages.getPageHelp(NSMPages.CONNECTIVITY_DETAIL_PAGE), httpServletRequest, httpServletResponse);
        httpServletResponse.getWriter().flush();
        HTMLTags.addTimestamp(httpServletRequest, "masthead");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println(HTMLTags.getDoubleExtendedBreadCrumbTag(httpServletRequest, string, NSMPages.CONNECTIVITY_PAGE, NSMPages.getPageCrumbName(NSMPages.CONNECTIVITY_DETAIL_PAGE)));
        String string2 = NSMPages.getPageURL(NSMPages.CONNECTIVITY_DETAIL_PAGE);
        String string3 = httpServletRequest.getParameter("stubDB");
        if (string3 != null) {
            string2 = HTMLTags.modifyURLParameter(string2, "stubDB", string3);
        }
        string2 = HTMLTags.modifyURLParameter(string2, "id", httpServletRequest.getParameter("id"));
        string2 = HTMLTags.modifyURLParameter(string2, "zone", httpServletRequest.getParameter("zone"));
        string2 = HTMLTags.modifyURLParameter(string2, "fabric", httpServletRequest.getParameter("fabric"));
        printWriter.println(HTMLTags.getContentStartTags(string2));
        printWriter.println(HTMLTags.getPendingMessagesTag(httpServletRequest));
        printWriter.flush();
        HTMLTags.addTimestamp(httpServletRequest, "breadcrumb");
        return printWriter;
    }

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!this.performSecurityCheck(httpServletRequest, httpServletResponse)) {
            return;
        }
        String string = httpServletRequest.getParameter("stubDB");
        PrintWriter printWriter = this.writePageStart(httpServletRequest, httpServletResponse);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = httpServletRequest.getParameter("id");
        if (string8 != null) {
            string7 = TopologyCommand.getAssetName(string8, "Host");
            if (string7 != null) {
                string6 = NSMPages.HOST_DETAILS_PAGE;
                string3 = string8;
            }
            if (string7 == null) {
                string7 = TopologyCommand.getAssetName(string8, "HBA");
                if (string7 != null) {
                    string6 = NSMPages.HBA_DETAILS_PAGE;
                    string2 = string8;
                }
            }
            if (string7 == null) {
                string7 = TopologyCommand.getAssetName(string8, "Storage");
                if (string7 != null) {
                    string6 = NSMPages.STORAGE_DETAILS_PAGE;
                    string5 = string8;
                }
            }
            if (string7 == null) {
                string7 = TopologyCommand.getAssetName(string8, "Switch");
                if (string7 != null) {
                    string6 = NSMPages.SWITCH_DETAILS_PAGE;
                    string4 = string8;
                }
            }
        }
        if (string3 == null && string5 == null && string4 == null && string2 == null) {
            HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "invalidID", string8));
            this.writePageEnd(httpServletRequest, printWriter);
            return;
        }
        try {
            TopologyServiceImpl topologyServiceImpl = TopologyServiceImpl.getInstance();
            SanTopology sanTopology = this.getSanTopology(topologyServiceImpl, httpServletRequest);
            if (sanTopology != null) {
                TopologyGraph topologyGraph;
                HTMLTags.addTimestamp(httpServletRequest, "get topology from model");
                TSTopologyNode tSTopologyNode = topologyServiceImpl.findNode((Object)string8);
                HTMLTags.addTimestamp(httpServletRequest, "find node in topology");
                FabricTopology fabricTopology = null;
                String string9 = "";
                String string10 = httpServletRequest.getParameter("zone");
                String string11 = httpServletRequest.getParameter("fabric");
                Zone zone = null;
                if (string10 != null) {
                    TopologyGraph topologyGraph2;
                    if (string11 != null) {
                        topologyGraph2 = sanTopology.getFabrics();
                    } else {
                        FabricTopology[] fabricTopologyArray = new FabricTopology[1];
                        topologyGraph2 = fabricTopologyArray;
                        fabricTopologyArray[0] = sanTopology.getFabric(string11);
                    }
                    topologyGraph = topologyGraph2;
                    int n = 0;
                    while (zone == null && n < ((TopologyGraph)topologyGraph).length) {
                        if (topologyGraph[n] == null) {
                            HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "fabricNotFound"));
                        } else {
                            zone = topologyGraph[n].getZone(string10);
                            if (zone != null) {
                                fabricTopology = topologyGraph[n];
                            }
                        }
                        ++n;
                    }
                    if (zone == null) {
                        HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "zoneNotFound"));
                    }
                }
                if (string11 != null && fabricTopology == null) {
                    fabricTopology = sanTopology.getFabric(string11);
                }
                if (fabricTopology != null) {
                    string9 = fabricTopology.getFabricId().getLogicalName();
                }
                HTMLTags.addTimestamp(httpServletRequest, "search for zone in model");
                topologyGraph = sanTopology.getConnectivityGraph(tSTopologyNode, true);
                HTMLTags.addTimestamp(httpServletRequest, "get SAN connectivity graph");
                if (topologyGraph == null) {
                    printWriter.println(HTMLTags.getInfoBoxTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "noSANConnectivityFound")));
                } else {
                    TopologyDetailCommand topologyDetailCommand = null;
                    String[][] stringArray = null;
                    HTMLTags.TableInfo tableInfo = null;
                    int n = 0;
                    topologyDetailCommand = new TopologyDetailCommand(topologyGraph, fabricTopology, zone, string == null);
                    topologyDetailCommand.run();
                    n = topologyDetailCommand.getRowCount();
                    tableInfo = HTMLTags.getTableInfo(httpServletRequest, 1, n);
                    stringArray = topologyDetailCommand.getTableData(tableInfo);
                    HTMLTags.addTimestamp(httpServletRequest, "get data from model");
                    String string12 = null;
                    string12 = zone != null ? Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "logicalConnectivityDetailTitle", new String[]{string7, string9, ZoneUtil.localizeZoneName(string10)}) : (fabricTopology != null ? Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "fabricConnectivityDetailTitle", new String[]{string7, string9}) : Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "physicalConnectivityDetailTitle", new String[]{string7}));
                    printWriter.println(HTMLTags.getTableTitleTag(string12, tableInfo.firstRow, n, tableInfo.pageSize));
                    if (zone != null) {
                        printWriter.println(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Tags", "helpText", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "htmlZoningNote")));
                    }
                    printWriter.println(HTMLTags.getTableTag(HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString()), TopologyDetailCommand.getColumns(), stringArray, tableInfo.sortColumn, tableInfo.firstRow, n, tableInfo.pageSize));
                    HTMLTags.addTimestamp(httpServletRequest, "write table");
                }
            }
        }
        catch (NSMUIException nSMUIException) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.CONNECTIVITY_DETAIL_PAGE, nSMUIException));
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.CONNECTIVITY_DETAIL_PAGE, new DataRetrievalException(throwable)));
        }
        this.writePageEnd(httpServletRequest, printWriter);
    }

    public String getServletInfo() {
        return "NSM Connectivity Detail Servlet";
    }
}

