/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.switches;

import com.sun.netstorage.mgmt.common.datamodel.Asset;
import com.sun.netstorage.mgmt.common.datamodel.AssetStorage;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.SwitchAsset;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.switches.SwitchConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class SwitchInventoryCommand {
    private static final boolean debug = false;
    AssetStorage pm;
    private Asset[] assets;
    private String[] sortBy;
    private boolean[] sortOrder;
    private String find = null;

    public SwitchInventoryCommand(String string, boolean bl, String string2) {
        if (string == null) {
            this.sortBy = new String[0];
            this.sortOrder = new boolean[0];
        } else {
            this.sortBy = new String[]{string};
            this.sortOrder = new boolean[]{bl};
        }
        this.find = string2;
    }

    public void removeDevice(String string) {
    }

    public void run() throws DataRetrievalException {
        this.assets = null;
        try {
            this.assets = Utils.getAssetStorage().getAssets("Switch", this.find, this.sortBy, this.sortOrder);
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
    }

    public String[][] getValues() throws PersistenceException {
        if (this.assets == null || this.assets.length == 0) {
            return null;
        }
        String[][] stringArray = new String[this.assets.length][SwitchConstants.COLUMN_NUMBER];
        int n = 0;
        while (n < this.assets.length) {
            Asset asset = this.assets[n];
            if (asset == null) {
                this._fillError("Null Asset", stringArray[n]);
            } else if (!(asset instanceof SwitchAsset)) {
                this._fillError("Asset is not of type SwitchAsset", stringArray[n]);
            } else {
                SwitchAsset switchAsset = (SwitchAsset)asset;
                int n2 = 0;
                stringArray[n][n2++] = switchAsset.getKey();
                stringArray[n][n2++] = switchAsset.getName();
                stringArray[n][n2++] = switchAsset.getIPAddress();
                stringArray[n][n2++] = switchAsset.getWWN();
                stringArray[n][n2++] = Utils.getVendorModel(switchAsset.getVendor(), switchAsset.getModel());
                stringArray[n][n2++] = switchAsset.getFirmwareRev();
            }
            ++n;
        }
        return stringArray;
    }

    private void _fillError(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 1) {
            stringArray[1] = string;
        }
    }

    static void main(String[] stringArray) throws Exception {
        SwitchInventoryCommand switchInventoryCommand = new SwitchInventoryCommand(null, false, null);
        switchInventoryCommand.run();
        String[][] stringArray2 = switchInventoryCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n][0]);
            ++n;
        }
    }
}

