/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.switches;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.datamodel.Asset;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.SwitchAsset;
import com.sun.netstorage.mgmt.nsmui.common.DataInterpretationException;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.switches.SwitchConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class SwitchDetailCommand {
    private static final boolean debug = false;
    private SwitchAsset device;
    public static int ROWS = SwitchConstants.DETAIL_ROW_NUMBER;
    private final String deviceId;
    private String newAnnot;
    boolean remove = false;

    public SwitchDetailCommand(String string, String string2, boolean bl) throws NSMUIException {
        if (string == null || string.equals("")) {
            throw new NSMUIException("deviceid==null", null);
        }
        this.deviceId = string;
        this.newAnnot = string2;
        this.remove = bl;
    }

    public void run() throws DataRetrievalException, DataInterpretationException {
        this.device = null;
        try {
            Asset asset = Utils.getAssetStorage().getAsset(this.deviceId);
            if (asset != null) {
                this.device = (SwitchAsset)Utils.getAssetStorage().getAsset(this.deviceId);
                if (this.remove) {
                    this.device.delete();
                    this.device = null;
                } else if (this.newAnnot != null) {
                    this.device.setAnnotation(this.newAnnot);
                }
            }
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
        catch (Exception exception) {
            throw new DataInterpretationException("Error with asset's model object", exception);
        }
    }

    public boolean isStale() {
        return this.device == null ? false : this.device.isStale();
    }

    public String getIp() {
        return this.device == null ? null : this.device.getIPAddress();
    }

    public String getWWN() {
        return this.device == null ? null : this.device.getWWN();
    }

    public String getVendorModel() {
        if (this.device == null) {
            return null;
        }
        return Utils.getVendorModel(this.device.getVendor(), this.device.getModel());
    }

    public String getKey() {
        return this.device == null ? Localization.getString("com.sun.netstorage.mgmt.nsmui.switches.Localization", "wrong_asset") : this.device.getKey();
    }

    public String[] getValues() throws PersistenceException {
        if (this.device == null) {
            return null;
        }
        String[] stringArray = new String[ROWS];
        int n = 0;
        stringArray[n++] = this.device.getIPAddress();
        stringArray[n++] = this.device.getWWN();
        stringArray[n++] = Utils.getVendorModel(this.device.getVendor(), this.device.getModel());
        stringArray[n++] = this.device.getFirmwareRev();
        stringArray[n++] = this.device.getDomainID();
        stringArray[n++] = this.device.getAnnotation();
        return stringArray;
    }

    public String getDeviceKey() {
        return this.device == null ? null : this.device.getKey();
    }

    public String getDeviceName() {
        return this.device == null ? null : this.device.getName();
    }

    static void main(String[] stringArray) throws Exception {
        SwitchDetailCommand switchDetailCommand = new SwitchDetailCommand("sydney.central", null, false);
        switchDetailCommand.run();
        String[] stringArray2 = switchDetailCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n]);
            ++n;
        }
    }
}

