/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.storage;

import com.sun.netstorage.mgmt.common.datamodel.AssetStorage;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.StorageAsset;
import com.sun.netstorage.mgmt.component.model.api.gui.StoragePort;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.storage.StorageConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class StoragePortsCommand {
    private static final boolean debug = false;
    AssetStorage pm;
    private StoragePort[] ports;
    private String key;
    private String[] sortBy;
    private boolean[] sortOrder;
    private String find = null;
    private StorageAsset asset;

    public StoragePortsCommand(String string, boolean bl, String string2) {
        if (string == null) {
            this.sortBy = new String[0];
            this.sortOrder = new boolean[0];
        } else {
            this.sortBy = new String[]{string};
            this.sortOrder = new boolean[]{bl};
        }
        this.find = string2;
    }

    public void run() throws DataRetrievalException {
        this.ports = null;
        try {
            this.asset = (StorageAsset)Utils.getAssetStorage().getAsset(this.find);
            if (this.asset == null) {
                return;
            }
            this.ports = this.asset.getPorts(this.sortBy, this.sortOrder);
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
    }

    public String getDeviceName() {
        return this.asset == null ? null : this.asset.getName();
    }

    public String[][] getValues() throws PersistenceException {
        if (this.ports == null || this.ports.length == 0) {
            return null;
        }
        String[][] stringArray = new String[this.ports.length][StorageConstants.PORTS_COLUMN_NUMBER];
        int n = 0;
        while (n < this.ports.length) {
            StoragePort storagePort = this.ports[n];
            int n2 = 0;
            stringArray[n][n2++] = storagePort.getKey();
            stringArray[n][n2++] = storagePort.getState();
            stringArray[n][n2++] = storagePort.getAddressIdentifier();
            stringArray[n][n2++] = storagePort.getWWN();
            stringArray[n][n2++] = storagePort.getPortType();
            stringArray[n][n2++] = storagePort.getDevice() == null ? "" : Utils.createDuplet(storagePort.getDevice().getKey(), storagePort.getDevice().getName());
            ++n;
        }
        return stringArray;
    }

    private void _fillError(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 1) {
            stringArray[1] = string;
        }
    }

    static void main(String[] stringArray) throws Exception {
        StoragePortsCommand storagePortsCommand = new StoragePortsCommand(null, false, null);
        storagePortsCommand.run();
        String[][] stringArray2 = storagePortsCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n][0]);
            ++n;
        }
    }
}

