/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.storage;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.datamodel.Asset;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.StorageAsset;
import com.sun.netstorage.mgmt.component.model.api.gui.StoragePort;
import com.sun.netstorage.mgmt.nsmui.common.DataInterpretationException;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.storage.StorageConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class StorageDetailCommand {
    private static final boolean debug = false;
    private StorageAsset device;
    public static int ROWS = StorageConstants.DETAIL_ROW_NUMBER;
    private final String deviceId;
    private String newAnnot;
    private String ipAddress;
    boolean remove = false;

    public StorageDetailCommand(String string, String string2, String string3, boolean bl) throws NSMUIException {
        if (string == null || string.equals("")) {
            throw new NSMUIException("deviceid==null", null);
        }
        this.deviceId = string;
        this.newAnnot = string2;
        this.ipAddress = string3;
        this.remove = bl;
    }

    public void run() throws DataRetrievalException, DataInterpretationException {
        this.device = null;
        try {
            Asset asset = Utils.getAssetStorage().getAsset(this.deviceId);
            if (asset != null) {
                this.device = (StorageAsset)Utils.getAssetStorage().getAsset(this.deviceId);
                if (this.remove) {
                    this.device.delete();
                    this.device = null;
                } else {
                    if (this.newAnnot != null) {
                        this.device.setAnnotation(this.newAnnot);
                    }
                    if (this.ipAddress != null) {
                        this.device.setIPAddress(this.ipAddress);
                    }
                }
            }
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
        catch (Exception exception) {
            throw new DataInterpretationException("Error with asset's model object", exception);
        }
    }

    public boolean isStale() {
        return this.device == null ? false : this.device.isStale();
    }

    public String getKey() {
        return this.device == null ? Localization.getString("com.sun.netstorage.mgmt.nsmui.storage.Localization", "wrong_asset") : this.device.getKey();
    }

    public String[] getValues() throws PersistenceException {
        if (this.device == null) {
            return null;
        }
        String[] stringArray = new String[ROWS];
        int n = 0;
        stringArray[n++] = this.device.getStatus();
        stringArray[n++] = this.device.getIPAddress();
        stringArray[n++] = Utils.getVendorModel(this.device.getVendor(), this.device.getModel());
        stringArray[n++] = this.device.getFirmwareRev();
        stringArray[n++] = this.device.getAnnotation();
        return stringArray;
    }

    public String getDeviceKey() {
        return this.device == null ? null : this.device.getKey();
    }

    public String getDeviceName() {
        return this.device == null ? null : this.device.getName();
    }

    public String getPortWWN() throws Exception {
        if (this.device == null) {
            return null;
        }
        try {
            StoragePort[] storagePortArray = this.device.getPorts(null, null);
            if (storagePortArray == null || storagePortArray.length == 0 || storagePortArray[0] == null) {
                return null;
            }
            return storagePortArray[0].getWWN();
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
    }

    public boolean getIPEditable() throws Exception {
        return this.device == null ? false : this.device.getIPEditable();
    }

    public String getIPAddress() throws Exception {
        return this.device == null ? null : this.device.getIPAddress();
    }

    public String getVendorModel() {
        return this.device == null ? null : Utils.getVendorModel(this.device.getVendor(), this.device.getModel());
    }

    static void main(String[] stringArray) throws Exception {
        StorageDetailCommand storageDetailCommand = new StorageDetailCommand("sydney.central", null, null, false);
        storageDetailCommand.run();
        String[] stringArray2 = storageDetailCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n]);
            ++n;
        }
    }
}

