/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.status;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.admin.AdminCommand;
import com.sun.netstorage.mgmt.nsmui.admin.AttributeCommand;
import com.sun.netstorage.mgmt.nsmui.alarms.AlarmsCommand;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.launch.LaunchImpl;
import com.sun.netstorage.mgmt.nsmui.launch.LaunchSanBoxManager;
import com.sun.netstorage.mgmt.nsmui.launch.LaunchSanSurfer;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Status
extends HttpServlet {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.status.Localization";
    private static final String ADMIN_BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private static final String ALARM_TYPE = "alarmtype";
    private static final TableColumn[] COLUMNS = new TableColumn[]{new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.status.Localization", "quantity"), false, "\"right\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.status.Localization", "severity"), false, "\"left\"", true)};
    public static final int COLUMN_NUMBER = COLUMNS.length;
    private static final int COUNT_COLUMN = 0;
    private static final int LEVEL_COLUMN = 1;
    private static final TableColumn[] APP_COLUMNS = new TableColumn[]{new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.status.Localization", "application"), false, "\"left\"", true), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.status.Localization", "status"), false, "\"left\"")};
    public static final int APP_COLUMN_NUMBER = APP_COLUMNS.length;
    private static final int APP_COLUMN = 0;
    private static final int STATUS_COLUMN = 1;
    private AlarmsCommand alarmsCommand = null;
    private AdminCommand adminCommand;
    private AttributeCommand attributeCommand;
    private String breadcrumbTitle = NSMPages.STATUS_PAGE;
    private String tableTitle;
    private String noAlarmsText;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String PAGE_URL;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.STATUS_PAGE));
            if (object == null) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        this.PAGE_URL = httpServletRequest.getRequestURI();
        try {
            UtilsWeb.noCacheHeader(httpServletResponse);
            this.alarmsCommand = new AlarmsCommand();
            this.alarmsCommand.run();
            this.adminCommand = new AdminCommand();
            this.adminCommand.run();
            this.attributeCommand = new AttributeCommand();
            this.attributeCommand.run();
            this.displayMasthead();
            this.out.println(HTMLTags.getContentStartTags(this.PAGE_URL));
            String string = null;
            try {
                this.attributeCommand.run();
                string = this.attributeCommand.getAttribute("sade");
                if (string != null && string.length() != 0) {
                    string = string + Localization.getString("com.sun.netstorage.mgmt.nsmui.launch.Localization", "sadeAlarmJSP");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.out.println(HTMLTags.getContentSubSectionTags("\"right\""));
            if (string == null || string.equals("")) {
                this.out.println(HTMLTags.getDisabledButtonTag(Localization.getString(BUNDLE, "healthButton")));
            } else {
                this.out.println(HTMLTags.getLinkTargetButtonTag(string, Localization.getString(BUNDLE, "healthButton"), "sade"));
            }
            this.out.println(HTMLTags.getContentSubSectionTags("\"left\""));
            this.out.println("<table><tr><td>");
            this.out.println(this.getAlarmsTable());
            this.out.println("</td></tr></table>");
            this.out.println("<table><tr><td>");
            this.out.println("<TD><IMG border=\"0\" height=\"1\" src=\"/nsm/images/general/dot.gif\" width=\"20\"></TD>");
            this.out.println("</td></tr></table>");
            this.out.println("<table><tr><td>");
            this.out.println(this.getInstalledApplicationsTable());
            this.out.println("</td></tr></table>");
            this.out.println(HTMLTags.getContentEndTags());
            this.out.close();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            if (throwable instanceof NSMUIException) {
                throwable.printStackTrace();
                object = (NSMUIException)throwable;
            }
            throwable.printStackTrace();
            object = new NSMUIException("", throwable);
        }
        if (object != null) {
            this.displayMasthead();
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.STATUS_PAGE, (Throwable)object));
            this.out.flush();
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Status", "Status", null, NSMPages.getPageHelp(NSMPages.STATUS_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.STATUS_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    public String getAlarmsTable() {
        StringBuffer stringBuffer = new StringBuffer();
        String[][] stringArray = new String[4][COLUMN_NUMBER];
        stringArray[0][0] = String.valueOf(this.alarmsCommand.getNumberOfAlarms("down"));
        stringArray[0][1] = HTMLTags.getLinkTag(NSMPages.getPageURL(NSMPages.ALARMS_PAGE) + "?alarmtype=down", this.getLevel("down"));
        stringArray[1][0] = String.valueOf(this.alarmsCommand.getNumberOfAlarms("critical"));
        stringArray[1][1] = HTMLTags.getLinkTag(NSMPages.getPageURL(NSMPages.ALARMS_PAGE) + "?alarmtype=critical", this.getLevel("critical"));
        stringArray[2][0] = String.valueOf(this.alarmsCommand.getNumberOfAlarms("major"));
        stringArray[2][1] = HTMLTags.getLinkTag(NSMPages.getPageURL(NSMPages.ALARMS_PAGE) + "?alarmtype=major", this.getLevel("major"));
        stringArray[3][0] = String.valueOf(this.alarmsCommand.getNumberOfAlarms("minor"));
        stringArray[3][1] = HTMLTags.getLinkTag(NSMPages.getPageURL(NSMPages.ALARMS_PAGE) + "?alarmtype=minor", this.getLevel("minor"));
        int n = stringArray.length;
        HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(this.request, 1, n);
        int n2 = tableInfo.sortColumn;
        int n3 = tableInfo.firstRow;
        int n4 = tableInfo.pageSize;
        stringBuffer.append(HTMLTags.getTableTitleTag(Localization.getString(BUNDLE, "alarms_table_title")));
        stringBuffer.append(HTMLTags.getTableTag(this.PAGE_URL, COLUMNS, stringArray, n2, n3, n, n4));
        return stringBuffer.toString();
    }

    public String getInstalledApplicationsTable() throws NSMUIException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(ADMIN_BUNDLE, "available_applications"), " ");
        String string = Localization.getString(BUNDLE, "notInstalled");
        String string2 = Localization.getString(BUNDLE, "available");
        String string3 = Localization.getString(BUNDLE, "availableOnSolaris");
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            LaunchImpl launchImpl;
            String string4 = (String)stringTokenizer.nextElement();
            object2 = null;
            object = Localization.getString(ADMIN_BUNDLE, string4 + ".name");
            object2 = string4.equals("sscs") ? this.checkURLApp(string4) : (string4.equals("hicommand") ? this.checkURLApp(string4) : (string4.equals("sansurfer") ? (Utils.isRunningOnSolaris() ? ((launchImpl = new LaunchSanSurfer()).isPackageInstalled() ? string2 : string) : string3) : (string4.equals("sanboxmanager") ? (Utils.isRunningOnSolaris() ? ((launchImpl = new LaunchSanBoxManager()).isPackageInstalled() ? string2 : string) : string3) : (string4.equals("efcm") ? this.checkUnixApp(string4) : (string4.equals("sade") ? this.checkURLApp(string4) : (string4.equals("inrange") ? this.checkURLApp(string4) : Localization.getString(ADMIN_BUNDLE, string4 + ".info")))))));
            if (object2 == null) continue;
            arrayList.add(new String[]{object, object2});
        }
        int n2 = arrayList.size();
        object2 = new String[arrayList.size()][2];
        n = 0;
        while (n < arrayList.size()) {
            object2[n] = (String[])arrayList.get(n);
            ++n;
        }
        Arrays.sort(object2, new SmartColumnComparator(1));
        object = HTMLTags.getTableInfo(this.request, 1, n2);
        int n3 = ((HTMLTags.TableInfo)object).sortColumn;
        int n4 = ((HTMLTags.TableInfo)object).firstRow;
        int n5 = ((HTMLTags.TableInfo)object).pageSize;
        stringBuffer.append(HTMLTags.getTableTitleTag(Localization.getString(BUNDLE, "applications_title")));
        stringBuffer.append(HTMLTags.getTableTag(this.PAGE_URL, APP_COLUMNS, object2, n3, n4, n2, n5));
        return stringBuffer.toString();
    }

    private String checkURLApp(String string) throws NSMUIException {
        String string2 = null;
        String string3 = this.attributeCommand.getAttribute(string);
        string2 = string3 == null || string3.length() == 0 ? Localization.getString(BUNDLE, "notRegistered") : (AdminCommand.checkURLConnection(string3) ? HTMLTags.getCustomTag(BUNDLE, "available") : Localization.getString(BUNDLE, "unavailable"));
        return string2;
    }

    private String checkUnixApp(String string) throws NSMUIException {
        String string2 = null;
        String string3 = this.attributeCommand.getAttribute(string);
        string2 = !Utils.isRunningOnSolaris() ? Localization.getString(BUNDLE, "availableOnSolaris") : (string3 == null || string3.length() == 0 ? Localization.getString(BUNDLE, "notRegistered") : (new File(string3).exists() ? HTMLTags.getCustomTag(BUNDLE, "available") : Localization.getString(BUNDLE, "unavailable")));
        return string2;
    }

    private String getLevel(String string) {
        return "<IMG src=\"/nsm/images/icons/" + Localization.getString(BUNDLE, "level_icon_14_" + string) + "\" width=\"14\" height=\"14\" border=\"0\" alt=\"" + Localization.getString(BUNDLE, "level_icon_text_" + string) + "\"> " + Localization.getString(BUNDLE, "severity_level_" + string);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "The page for displaying Status.";
    }
}

